/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.LittleEndian;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.SortField;
import inform.agent.db.SortingField;
import inform.agent.scripts.sql.QueryNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class QuerySortFieldList {
    private final ArrayList<SortField> list = new ArrayList();
    public final ArrayList<QuerySortField> querySortFields = new ArrayList();

    public QuerySortFieldList() {
    }

    public QuerySortFieldList(Iterable<SortingField> sorting) {
        this.addFrom(sorting);
    }

    public ArrayList<SortField> fields() {
        return this.list;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void addFrom(Iterable<SortingField> sorting) {
        for (SortingField sf : sorting) {
            SortField field = new SortField();
            sf.transferTo(field);
            this.list.add(field);
        }
    }

    public boolean contains(int fieldId) {
        for (QuerySortField sf : this.querySortFields) {
            if (sf.fieldId != fieldId) continue;
            return true;
        }
        return false;
    }

    void addFromStream(int nextTag, TaggedReader reader) throws IOException, TaggedReaderException {
        byte[] data = new byte[reader.getCurrentTagSize()];
        reader.getRaw(data, data.length);
        int fieldId = LittleEndian.getInt(data, 0);
        int ascending = LittleEndian.getInt(data, 4);
        int path = LittleEndian.getInt(data, 8);
        SortField sortField = new SortField(ascending != 0);
        sortField.addField(fieldId);
        if (path != 0) {
            int tag = reader.getNextTag();
            assert (tag == nextTag);
            byte[] pathData = new byte[reader.getCurrentTagSize()];
            reader.getRaw(pathData, pathData.length);
            LittleEndianDataInputStream pathStream = new LittleEndianDataInputStream(new ByteArrayInputStream(pathData));
            while (pathStream.available() > 0 && pathStream.available() >= 8) {
                double pathTableId = pathStream.readDouble();
                if (pathStream.available() < 4) break;
                int pathFieldId = pathStream.readInt();
                sortField.addField(pathTableId, pathFieldId);
            }
        }
        this.list.add(sortField);
    }

    public static class QuerySortField {
        public int fieldId;
        public QueryNode node;
        public boolean ascending;
        public int fieldPosition = -1;
        public String fieldSql = null;
    }
}

