/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr;

import inform.agent.expr.ConditionBlockTerm;
import inform.agent.expr.Expression;
import inform.agent.expr.OperationTerm;
import inform.agent.expr.Term;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.Condition;
import inform.agent.scripts.sql.expr.cnd.BinaryOperation;
import inform.agent.scripts.sql.expr.cnd.BraceEvaluator;
import inform.agent.scripts.sql.expr.cnd.CompareOperation;
import inform.agent.scripts.sql.expr.cnd.LogicalOperation;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryNullEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryValueEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryValueEvaluatorArray;
import java.util.ArrayList;

public class FilterCondition
extends Condition {
    public FilterCondition(Query query, boolean rootExpr) {
        super(query, rootExpr);
    }

    @Override
    protected QueryEvaluator compileCompare(Expression.Parser it) {
        if (it.current instanceof ConditionBlockTerm) {
            ConditionBlockTerm block = (ConditionBlockTerm)it.current;
            it.next();
            return (QueryEvaluator)block.createEvaluator();
        }
        return (QueryEvaluator)super.compileCompare(it);
    }

    @Override
    public QueryEvaluator createEvaluator(Term term, QueryEvaluator left, QueryEvaluator right) {
        switch (term.getToken()) {
            case notEqual: 
            case notLike: {
                if (right.hasNull()) {
                    return super.createEvaluator(term, left, right);
                }
                CompareOperation compareOperation = new CompareOperation((OperationTerm)term, left, right);
                OperationTerm nullTerm = new OperationTerm(9, this);
                CompareOperation isNullOperation = new CompareOperation(nullTerm, left, QueryNullEvaluator.Null);
                OperationTerm orTerm = new OperationTerm(11, this);
                LogicalOperation orOp = new LogicalOperation(orTerm, compareOperation, isNullOperation);
                return new BraceEvaluator(new OperationTerm(this), orOp);
            }
            case fastFilter: {
                if (right instanceof QueryValueEvaluatorArray) {
                    BinaryOperation evaluator = null;
                    ArrayList<QueryValueEvaluator> values = new ArrayList<QueryValueEvaluator>();
                    ((QueryValueEvaluatorArray)((Object)right)).getArray(values, true);
                    OperationTerm andTerm = new OperationTerm(10, this);
                    OperationTerm likeTerm = new OperationTerm(14, this);
                    likeTerm.setRangeId(5);
                    for (QueryEvaluator queryEvaluator : values) {
                        CompareOperation like = new CompareOperation(likeTerm, left, queryEvaluator);
                        if (evaluator == null) {
                            evaluator = like;
                            continue;
                        }
                        evaluator = new LogicalOperation(andTerm, evaluator, like);
                    }
                    if (evaluator != null) {
                        return evaluator;
                    }
                }
                return super.createEvaluator(term, left, right);
            }
        }
        return super.createEvaluator(term, left, right);
    }
}

