/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.cnd;

import inform.agent.expr.OperationTerm;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QuerySubjectEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryValueEvaluator;

public class BinaryOperation
extends QueryEvaluator {
    protected final QueryEvaluator left;
    protected final QueryEvaluator right;

    public BinaryOperation(OperationTerm term, QueryEvaluator left, QueryEvaluator right) {
        super(term);
        this.left = left;
        this.right = right;
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        if (this.isIgnored()) {
            return;
        }
        this.left.generate(sql, query);
        switch (this.term.getToken()) {
            case add: {
                if (this.isStringType()) {
                    sql.append(query.getDatabaseCaps().concatOperator);
                    break;
                }
                sql.append('+');
                break;
            }
            case sub: {
                sql.append('-');
                break;
            }
            case mul: {
                sql.append('*');
                break;
            }
            case div: {
                sql.append('/');
                break;
            }
            case mod: {
                sql.append('%');
                break;
            }
            case and: {
                sql.append(" AND ");
                break;
            }
            case or: {
                sql.append(" OR ");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.right.generate(sql, query);
    }

    @Override
    public QueryValueEvaluator getValue() {
        return null;
    }

    @Override
    public void getDatasourceUsage(DatasourceUsage usage) {
        if (this.isIgnored()) {
            return;
        }
        this.left.getDatasourceUsage(usage);
        this.right.getDatasourceUsage(usage);
    }

    @Override
    public boolean isAggregative() {
        if (this.isIgnored()) {
            return false;
        }
        return this.left.isAggregative() || this.right.isAggregative();
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.left.isIgnored() || this.right.isIgnored();
    }

    @Override
    public boolean isStringType() throws Exception {
        return this.left.isStringType() || this.right.isStringType();
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public boolean isMultipleValue() {
        return false;
    }

    @Override
    public QuerySubjectEvaluator getSubject() {
        return null;
    }
}

