/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.stat;

import inform.adt.collections.IntegerHash;
import inform.agent.scripts.stat.DataNodeProfile;
import inform.agent.scripts.stat.ProfileItem;

public class DatasourceProfile
extends ProfileItem
implements IntegerHash.Entry {
    private final int uid;
    private final double nodeId;
    private final double filterId;
    private final DataNodeProfile nodeStat;

    public DatasourceProfile(int uid, DataNodeProfile nodeStat, double filterId) {
        this.uid = uid;
        this.nodeId = nodeStat.getNodeId();
        this.filterId = filterId;
        this.nodeStat = nodeStat;
    }

    @Override
    public int key() {
        return this.uid;
    }

    @Override
    public void getProfile(StringBuilder profile) {
        profile.append("      Datasource (id: ").append(this.uid).append(", nodeId: ").append((long)this.nodeId);
        if (this.filterId != 0.0) {
            profile.append(", filterId: ").append((long)this.filterId);
        }
        profile.append("):\n");
        super.getProfile(profile);
    }

    @Override
    public void addAccessCount() {
        super.addAccessCount();
        this.nodeStat.addAccessCount();
    }

    @Override
    public void addRecordCount(int recordCount) {
        super.addRecordCount(recordCount);
        this.nodeStat.addRecordCount(recordCount);
    }

    @Override
    public void addRequestCount() {
        super.addRequestCount();
        this.nodeStat.addRequestCount();
    }

    @Override
    public void addRequestTime(long requestTime) {
        super.addRequestTime(requestTime);
        this.nodeStat.addRequestTime(requestTime);
    }

    @Override
    public void incRecordCount() {
        super.incRecordCount();
        this.nodeStat.incRecordCount();
    }
}

