/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textdocuments.odt;

import inform.adt.InformException;
import inform.agent.scripts.textdocuments.odt.OdtDocument;
import inform.agent.scripts.textdocuments.odt.OdtFont;
import inform.common.SmartScriptableObject;
import java.util.HashMap;
import java.util.Map;

public class OdtStyle
extends SmartScriptableObject {
    private final OdtDocument odtDocument;
    private OdtFont odtFont;
    private final Map<String, String> propertiesStyle;

    public OdtStyle(OdtDocument odtDocument) {
        this.setParentScope(odtDocument);
        this.odtDocument = odtDocument;
        this.propertiesStyle = new HashMap<String, String>();
    }

    public OdtStyle(OdtDocument odtDocument, OdtStyle style) {
        this.setParentScope(odtDocument);
        this.odtDocument = odtDocument;
        this.propertiesStyle = new HashMap<String, String>();
        if (style != null) {
            this.propertiesStyle.putAll(style.getPropertiesStyle());
        }
        if (style != null && style.getFont() != null) {
            this.setFont(style.getFont());
        }
    }

    @Override
    public String getClassName() {
        return "OdtStyle";
    }

    @SmartScriptableObject.PropertyTag
    public int getParagraphAlignment() {
        String align;
        switch (align = this.propertiesStyle.get("fo:text-align")) {
            case "left": {
                return 11;
            }
            case "center": {
                return 2;
            }
            case "right": {
                return 12;
            }
            case "justify": {
                return 4;
            }
        }
        return 0;
    }

    @SmartScriptableObject.FunctionTag
    public void setParagraphAlignment(Object value) {
        switch (Integer.parseInt(String.valueOf(value))) {
            case 11: {
                this.propertiesStyle.put("fo:text-align", "left");
                break;
            }
            case 2: {
                this.propertiesStyle.put("fo:text-align", "center");
                break;
            }
            case 12: {
                this.propertiesStyle.put("fo:text-align", "right");
                break;
            }
            case 4: {
                this.propertiesStyle.put("fo:text-align", "justify");
                break;
            }
            default: {
                throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442");
            }
        }
    }

    @SmartScriptableObject.PropertyTag
    public int getIndentationLeft() {
        return Integer.parseInt(this.propertiesStyle.get("fo:margin-left"));
    }

    @SmartScriptableObject.FunctionTag
    public void setIndentationLeft(int value) {
        this.propertiesStyle.put("fo:margin-left", Integer.toString(value));
    }

    @SmartScriptableObject.PropertyTag
    public int getIndentationRight() {
        return Integer.parseInt(this.propertiesStyle.get("fo:margin-right"));
    }

    @SmartScriptableObject.FunctionTag
    public void setIndentationRight(int value) {
        this.propertiesStyle.put("fo:margin-right", Integer.toString(value));
    }

    @SmartScriptableObject.PropertyTag
    public double getSpacingBetween() {
        return Double.parseDouble(this.propertiesStyle.get("fo:line-height"));
    }

    @SmartScriptableObject.FunctionTag
    public void setSpacingBetween(double value) {
        this.propertiesStyle.put("fo:line-height", Double.toString(value));
    }

    @SmartScriptableObject.PropertyTag
    public int getSpacingBefore() {
        return Integer.parseInt(this.propertiesStyle.get("fo:margin-top"));
    }

    @SmartScriptableObject.FunctionTag
    public void setSpacingBefore(int value) {
        this.propertiesStyle.put("fo:margin-top", Integer.toString(value));
    }

    @SmartScriptableObject.PropertyTag
    public int getSpacingAfter() {
        return Integer.parseInt(this.propertiesStyle.get("fo:margin-bottom"));
    }

    @SmartScriptableObject.FunctionTag
    public void setSpacingAfter(int value) {
        this.propertiesStyle.put("fo:margin-bottom", Integer.toString(value));
    }

    @SmartScriptableObject.FunctionTag
    public void setFont(OdtFont font) {
        this.odtFont = font;
    }

    @SmartScriptableObject.PropertyTag
    public OdtFont getFont() {
        return this.odtFont;
    }

    public Map<String, String> getPropertiesStyle() {
        return this.propertiesStyle;
    }
}

