/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.util;

import inform.agent.db.Row;
import inform.agent.replication.SelectableDataset;
import inform.agent.scripts.ComponentList;
import inform.agent.scripts.CursorParents;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.ScriptableValue;
import inform.agent.scripts.Task;

public class Binding
implements ScriptableValue {
    private Object value = null;
    private int datasourceId = 0;
    private int fieldId = 0;

    public Binding(int datasourceId) {
        this.datasourceId = datasourceId;
    }

    public int getDatasourceId() {
        return this.datasourceId;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(int fieldId) {
        this.fieldId = fieldId;
    }

    @Override
    public Object getRawValue() {
        return this.value;
    }

    @Override
    public boolean getIsIgnored() {
        return false;
    }

    public void apply(Task task, CursorParents parents) throws Exception {
        this.value = null;
        if (this.datasourceId != 0 && this.fieldId != 0) {
            ComponentList components = task.getComponents();
            SelectableDataset datasource = components.findDatasource(this.datasourceId);
            if (datasource == null) {
                return;
            }
            if (parents != null) {
                if ((datasource = parents.getSelectedDataset(datasource)) == null) {
                    return;
                }
            } else {
                if (!datasource.isSelected()) {
                    datasource.executeSelect();
                    datasource.next();
                }
                if (!datasource.isCurrentRowAvailable()) {
                    return;
                }
            }
            Row row = datasource.getCurrentRow();
            if (this.fieldId == -1) {
                this.value = row.getId();
            } else {
                DatasetField field = datasource.findfieldById(this.fieldId);
                if (field == null) {
                    return;
                }
                this.value = field.getValue();
            }
        }
    }
}

