/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.util;

import inform.adt.InformException;
import inform.adt.ObjectSizer;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.Rowset;
import inform.agent.db.SortDirection;
import inform.agent.db.SortingField;
import inform.agent.db.filters.Range;
import inform.agent.db.filters.RowFilter;
import inform.agent.scripts.ComponentList;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.Task;
import java.io.IOException;
import java.util.ArrayList;

public class DatasourceRelation {
    private final Datasource datasource;
    private final ArrayList<Item> relation = new ArrayList();
    private boolean isChecked = false;
    private static final int TAG_MASTER_FIELD = 1;
    private static final int TAG_DATASOURCE = 2;
    private static final int TAG_FIELD = 3;

    public DatasourceRelation(Datasource datasource) {
        this.datasource = datasource;
    }

    public boolean isEmpty() {
        return this.relation.isEmpty();
    }

    public ArrayList<SortingField> createSortKey(ArrayList<SortingField> sorting) throws InformException {
        ArrayList<SortingField> s = new ArrayList<SortingField>();
        for (Item item : this.relation) {
            s.add(new SortingField(item.field.getDescriptor(), SortDirection.ASCENDING, this.datasource.table().getDatabaseDescriptor().getDatabaseType().caps(), this.datasource.getNullSortKind()));
        }
        for (SortingField sortingField : sorting) {
            boolean append = true;
            for (Item item : this.relation) {
                if (item.linkFieldId != sortingField.getField().getId()) continue;
                append = false;
                break;
            }
            if (!append) continue;
            s.add(sortingField);
        }
        return s;
    }

    public void createFilter(Rowset rows) throws Exception {
        if (!this.isChecked) {
            this.check();
        }
        for (Item item : this.relation) {
            if (!item.linkDatasource.isLoaded()) {
                item.linkDatasource.executeSelect();
                item.linkDatasource.reset();
                item.linkDatasource.next();
            }
            if (item.linkDatasource.isLoaded() && item.linkDatasource.isCurrentRowAvailable()) continue;
            rows.filter(new RowFilter.Window(Range.EMPTY));
            return;
        }
        for (Item item : this.relation) {
            Object value = item.linkFieldId == -1 ? Double.valueOf(item.linkDatasource.getRecordID()) : item.linkField.getValue();
            rows.filter(RowFilter.create(rows, this.datasource.getNullSortKind(), item.field.getDescriptor(), value, value, true));
        }
    }

    public int size() {
        return this.relation.size();
    }

    public Datasource getParent(int index) {
        return this.relation.get((int)index).linkDatasource;
    }

    public void load(TaggedReader in) throws IOException, TaggedReaderException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    Item item = new Item();
                    item.fieldId = in.getInt(1);
                    item.linkDatasourceId = in.getInt(2);
                    item.linkFieldId = in.getInt(3);
                    this.relation.add(item);
                }
            }
        }
    }

    public void afterLoad(Task task) throws InformException {
        ComponentList components = task.getComponents();
        for (Item item : this.relation) {
            item.field = this.datasource.findfieldById(item.fieldId);
            if (item.field == null && item.linkField == null) {
                throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435 \u0432 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c.").detail(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435 %d \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043aa %s \u0432 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c", item.fieldId, this.datasource.toString()));
            }
            item.linkDatasource = components.findDatasource(item.linkDatasourceId);
            if (item.linkDatasource == null) {
                throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0432 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c.").detail(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a %d \u0432 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c %s", item.linkDatasourceId, this.datasource.toString()));
            }
            if (this.datasource.getId() == item.linkDatasource.getId()) {
                throw new InformException("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u0441\u0430\u043c \u043d\u0430 \u0441\u0435\u0431\u044f \u0432 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c.").detail(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a %s", this.datasource.toString()));
            }
            if (item.linkFieldId == -1) continue;
            item.linkField = item.linkDatasource.findfieldById(item.linkFieldId);
            if (item.linkField != null) continue;
            throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435 \u0432 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c.").detail(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435 %d \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043aa %s \u0432 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c %s", item.linkFieldId, item.linkDatasource.toString(), this.datasource.toString()));
        }
    }

    public void generateRelationsData(TaggedWriter out) throws IOException {
        for (Item i : this.relation) {
            out.putInt32(10, i.fieldId);
            if (i.linkFieldId == -1) {
                out.putDouble(11, i.linkDatasource.getRecordID());
                continue;
            }
            LinkDescriptor.generateRelationFieldValue(out, i.linkField);
        }
    }

    private void check(Datasource checkingDatasource, ArrayList<Datasource> checkedDatasources) throws InformException {
        for (Datasource d : checkedDatasources) {
            if (d.getId() != this.datasource.getId()) continue;
            return;
        }
        for (Item item : this.relation) {
            if (item.linkDatasource.getId() == checkingDatasource.getId()) {
                throw new InformException("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438 \u0441\u0441\u044b\u043b\u0430\u044e\u0442\u0441\u044f \u0434\u0440\u0443\u0433 \u043d\u0430 \u0434\u0440\u0443\u0433\u0430 \u0432 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c").detail(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438 '%s' \u0438 '%s'", checkingDatasource.toString(), item.linkDatasource.toString()));
            }
            checkedDatasources.add(item.linkDatasource);
            DatasourceRelation r = item.linkDatasource.getRelation();
            if (r == null || r.isEmpty()) continue;
            r.check(checkingDatasource, checkedDatasources);
        }
    }

    private void check() throws InformException {
        if (this.isChecked) {
            return;
        }
        ArrayList<Datasource> checkedDatasources = new ArrayList<Datasource>();
        this.check(this.datasource, checkedDatasources);
        this.isChecked = true;
    }

    private static class Item {
        int fieldId;
        int linkDatasourceId;
        int linkFieldId;
        @ObjectSizer.HintShared
        DatasourceField field;
        @ObjectSizer.HintShared
        Datasource linkDatasource;
        @ObjectSizer.HintShared
        DatasourceField linkField;

        private Item() {
        }
    }
}

