/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.util;

import inform.agent.db.DataRow;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Rowset;
import inform.agent.db.VirtualRowset;
import inform.agent.db.connect.ResultSet;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.ServerSideRecord;
import inform.agent.scripts.sql.ExtraField;
import inform.agent.scripts.sql.Query;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class PostProcessRecord
extends ServerSideRecord {
    private ResultSet resultSet = null;
    private FieldDescriptor[] columnsMap = null;
    private boolean visible = true;
    private boolean hasPrimaryKey = false;
    private FieldDescriptor recordIdField = null;

    PostProcessRecord(ServerSideExecutable task, int nullSortKind) {
        super(task, nullSortKind);
        this.defineProperty("visible", this.getClass(), 0);
    }

    public void setQuery(Query query) {
        this.metadata = query.getResultMetadata().getDescriptor();
        for (FieldDescriptor fd : this.metadata.getFields()) {
            DatasourceField field = DatasourceField.createInstance(this.task.ssContext, this, fd, this.task, this);
            if (field == null) continue;
            this.fields.put(field);
        }
        if (query.hasExtraFields()) {
            int index = this.metadata.getFields().size();
            for (ExtraField ef : query.getExtraFields()) {
                FieldDescriptor fieldDescriptor = new FieldDescriptor(ef, ++index);
                DatasourceField field = DatasourceField.createInstance(this.task.ssContext, this, fieldDescriptor, this.task, this);
                if (field == null) continue;
                this.fields.put(field);
            }
        }
        this.rowset = new VirtualRowset(this.task.ssContext, this.task.getDBManager(), this.metadata, this.blobReceiving);
        PostProcessRecord.putConstProperty(this, "fields", this.fields.values().toArray());
    }

    public void setResultSet(ResultSet resultSet, boolean hasPrimaryKey) throws SQLException {
        this.resultSet = resultSet;
        ResultSetMetaData metadata = resultSet.getMetaData();
        this.columnsMap = Rowset.getColumnsMap(metadata, this.metadata);
        this.hasPrimaryKey = false;
        this.recordIdField = this.metadata.getRecordIdField();
        if (this.recordIdField != null && hasPrimaryKey) {
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                String columnName = metadata.getColumnLabel(i);
                if (!this.recordIdField.getRawName().equalsIgnoreCase(columnName)) continue;
                this.hasPrimaryKey = true;
                break;
            }
        }
        this.rowset.setHasRecordIdField(this.hasPrimaryKey);
    }

    public DataRow next() throws IOException, SQLException {
        this.visible = true;
        DataRow row = new DataRow(this.rowset, this.metadata, this.resultSet, this.columnsMap);
        this.rowset.clear();
        this.rowset.add(row);
        this.rowset.setRecord(row);
        return row;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public String getClassName() {
        return "PostProcessRecord";
    }

    public FieldDescriptor getRecordIdField() {
        return this.recordIdField;
    }
}

