/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.spell.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.spell.SpellChecker;

public class SpellSuggestRequest
extends Request {
    private static final int TAG_SUGGEST_WORD = 1;
    private static final int TAG_SUGGEST_WORD_RESULT = 2;
    private static final int TAG_SUGGEST_WORD_EMPTY = 3;

    public SpellSuggestRequest(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    String word = in.getAnsi();
                    String res = SpellChecker.getInstance().suggest(word);
                    out.putAnsi(1, word);
                    if (res != null) {
                        out.putAnsi(2, res);
                        break;
                    }
                    out.putEmpty(3);
                }
            }
        }
        out.flush();
        this.sendResult(data.internalBuffer(), data.size());
    }
}

