/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Security;
import inform.agent.web.JSON;
import inform.agent.web.Session;
import inform.common.Exceptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AsmoServlet
extends GenericServlet {
    protected final Type type;

    public AsmoServlet(Type type) {
        this.type = type;
    }

    public AsmoServlet() {
        this(Type.RAW);
    }

    public final void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            this.execute(req, res);
        }
        catch (ClientRequestErrorException e) {
            Core.logger.error(((Object)((Object)this)).getClass().getSimpleName(), e);
            try {
                this.type.sendClientError(res, e);
            }
            catch (Throwable t) {
                Core.logger.error("send-error", t);
            }
        }
        catch (Throwable e) {
            Core.logger.error(((Object)((Object)this)).getClass().getSimpleName(), e);
            try {
                this.type.sendServerError(res, e);
            }
            catch (Throwable t) {
                Core.logger.error("send-error", t);
            }
        }
    }

    protected abstract void execute(HttpServletRequest var1, HttpServletResponse var2) throws Throwable;

    protected String root() {
        return "";
    }

    protected static class ClientRequestErrorException
    extends InformException {
        public ClientRequestErrorException(String message) {
            super(message);
        }
    }

    public static abstract class WithSession
    extends AsmoServlet {
        public WithSession(Type type) {
            super(type);
        }

        @Override
        protected void execute(HttpServletRequest request, HttpServletResponse response) throws Throwable {
            Session session = (Session)request.getSession(true);
            Session.User user = null;
            try {
                user = session.processAuthentification(request, response);
            }
            catch (InsufficientPrivilegiesException e) {
                Core.logger.error(null, e);
                this.type.sendInsufficientPrivilegies(request, response, session, this.root());
            }
            catch (ClientRequestErrorException e) {
                Core.logger.error("Client request error: ", e);
                this.type.sendClientError(response, e);
                return;
            }
            if (user == null) {
                this.type.sendInsufficientPrivilegies(request, response, session, this.root());
                return;
            }
            user.revalidateNode();
            try {
                this.execute(request, response, session);
            }
            catch (InsufficientPrivilegiesException e) {
                Core.logger.error(null, e);
                this.type.sendInsufficientPrivilegies(request, response, session, this.root());
            }
            catch (ClientRequestErrorException e) {
                Core.logger.error("Client request error: ", e);
                this.type.sendClientError(response, e);
            }
        }

        protected static boolean isAccessDenied(Node node, int permissions, AccountNode account) {
            int mask = Security.calculateAccessMask(node, account, account.effectiveGroups());
            return (mask & permissions) != permissions;
        }

        protected abstract void execute(HttpServletRequest var1, HttpServletResponse var2, Session var3) throws Throwable;

        protected static class InsufficientPrivilegiesException
        extends InformException {
            public InsufficientPrivilegiesException() {
                super((String)null);
            }
        }
    }

    protected static enum Type {
        RAW{

            @Override
            void sendServerError(HttpServletResponse resp, Throwable e) throws Throwable {
                resp.setStatus(500);
                resp.setHeader("Content-disposition", "");
                resp.setContentType("text/plain");
                resp.setCharacterEncoding("WINDOWS-1251");
                PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding()), true);
                e.printStackTrace(out);
                out.flush();
            }

            @Override
            void sendClientError(HttpServletResponse resp, Throwable e) throws Throwable {
                resp.setStatus(404);
                resp.setHeader("Content-disposition", "");
                resp.setContentType("text/plain");
                resp.setCharacterEncoding("WINDOWS-1251");
                PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding()), true);
                out.flush();
            }

            @Override
            void sendInsufficientPrivilegies(HttpServletRequest request, HttpServletResponse response, Session session, String root) throws Throwable {
                response.setStatus(403);
            }
        }
        ,
        HTML{

            @Override
            void sendServerError(HttpServletResponse resp, Throwable e) throws Throwable {
                resp.setStatus(500);
                resp.setHeader("Content-disposition", "");
                resp.setContentType("text/html");
                resp.setCharacterEncoding("WINDOWS-1251");
                PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding()), true);
                out.println("<!DOCTYPE html><html><head><meta charset=\"windows-1251\"><title>" + Ini.AgentName + " | \u041e\u0448\u0438\u0431\u043a\u0430</title></head>");
                out.println("<body><pre style='color:maroon'>");
                out.println("Agent: " + Ini.AgentName);
                StringWriter tmp = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)tmp, true));
                out.append(tmp.toString().replaceAll("<", "&lt;"));
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                out.println("</pre><script>alert('\u041e\u0448\u0438\u0431\u043a\u0430:\\n" + msg + "')</script></body></html>");
                out.flush();
            }

            @Override
            void sendClientError(HttpServletResponse resp, Throwable e) throws Throwable {
                resp.setStatus(404);
                resp.setHeader("Content-disposition", "");
                resp.setContentType("text/html");
                resp.setCharacterEncoding("WINDOWS-1251");
                PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding()), true);
                out.println("<!DOCTYPE html><html><head><meta charset=\"windows-1251\"><title>\u041e\u0448\u0438\u0431\u043a\u0430</title></head>");
                out.println("<body><pre style='color:maroon'>");
                out.println("Agent: " + Ini.AgentName);
                String msg = e.getMessage();
                if (msg != null) {
                    out.print(msg);
                }
                out.println("</pre></body></html>");
                out.flush();
            }

            @Override
            void sendInsufficientPrivilegies(HttpServletRequest request, HttpServletResponse response, Session session, String root) throws Throwable {
                session.requestAuthentification(request, response, false, root);
            }
        }
        ,
        JSON{

            @Override
            void sendServerError(HttpServletResponse resp, Throwable e) throws Throwable {
                resp.setStatus(500);
                resp.setContentType("application/json");
                resp.setCharacterEncoding("WINDOWS-1251");
                StringBuilder detailing = new StringBuilder();
                StringBuilder callstack = new StringBuilder();
                String message = Exceptions.toString(e, detailing, callstack);
                PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding()), true);
                out.append("{\"message\":").append(inform.agent.web.JSON.toString(message));
                detailing.append('\n').append((CharSequence)callstack);
                out.append(",\"debug\":").append(inform.agent.web.JSON.toString(detailing.toString())).append('}');
                out.flush();
            }

            @Override
            void sendClientError(HttpServletResponse resp, Throwable e) throws Throwable {
                resp.setStatus(404);
                resp.setContentType("application/json");
                resp.setCharacterEncoding("WINDOWS-1251");
                StringBuilder detailing = new StringBuilder();
                StringBuilder callstack = new StringBuilder();
                String message = Exceptions.toString(e, detailing, callstack);
                PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding()), true);
                out.append("{\"message\":").append(inform.agent.web.JSON.toString(message));
                out.append(",\"debug\":").append(inform.agent.web.JSON.toString(detailing.toString())).append('}');
                out.flush();
            }

            @Override
            void sendInsufficientPrivilegies(HttpServletRequest request, HttpServletResponse response, Session session, String root) throws Throwable {
                response.setStatus(403);
            }
        }
        ,
        SOAP{

            @Override
            void sendServerError(HttpServletResponse resp, Throwable e) throws Throwable {
                if (resp.getStatus() < 400) {
                    resp.setStatus(500);
                }
                throw e;
            }

            @Override
            void sendClientError(HttpServletResponse resp, Throwable e) throws Throwable {
                if (resp.getStatus() >= 500) {
                    resp.setStatus(400);
                }
                throw e;
            }

            @Override
            void sendInsufficientPrivilegies(HttpServletRequest request, HttpServletResponse response, Session session, String root) throws Throwable {
                response.setStatus(403);
            }
        };


        abstract void sendServerError(HttpServletResponse var1, Throwable var2) throws Throwable;

        abstract void sendClientError(HttpServletResponse var1, Throwable var2) throws Throwable;

        abstract void sendInsufficientPrivilegies(HttpServletRequest var1, HttpServletResponse var2, Session var3, String var4) throws Throwable;
    }
}

