/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.adt.collections.IntegerHash;
import inform.agent.AgentJARVersion;
import inform.agent.web.AsmoServlet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.image4j.codec.ico.ICODecoder;

public class IconServlet
extends AsmoServlet {
    static final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final IntegerHash<CacheEntry> CACHE = new IntegerHash();

    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        response.setDateHeader("Last-Modified", AgentJARVersion.BUILD_DATE);
        if (AgentJARVersion.BUILD_DATE <= request.getDateHeader("If-Modified-Since") + 1000L) {
            response.setStatus(304);
            return;
        }
        int id = 0;
        int size = 0;
        try {
            String[] spath = request.getPathInfo().substring(1).split("/");
            size = Integer.parseInt(spath[0]);
            id = Integer.parseInt(spath[1]);
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
            response.setStatus(404);
            return;
        }
        response.setHeader("Cache-Control", "public, max-age=86400");
        try {
            int i;
            CacheEntry.Bytes[] imgs = IconServlet.image(id);
            for (i = 1; i < imgs.length && imgs[i].size >= size; ++i) {
            }
            response.setStatus(200);
            response.getOutputStream().write(imgs[i - 1].data);
        }
        catch (FileNotFoundException e) {
            response.setStatus(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheEntry.Bytes[] image(int id) throws IOException {
        String fname;
        InputStream in;
        CacheEntry.Bytes[] result;
        CacheEntry entry;
        IntegerHash<CacheEntry> integerHash = CACHE;
        synchronized (integerHash) {
            entry = CACHE.get(id);
        }
        if (entry != null && (result = (CacheEntry.Bytes[])entry.get()) != null) {
            return result;
        }
        entry = (CacheEntry)queue.poll();
        if (entry != null) {
            IntegerHash<CacheEntry> integerHash2 = CACHE;
            synchronized (integerHash2) {
                do {
                    CACHE.remove(entry.id);
                } while ((entry = (CacheEntry)queue.poll()) != null);
            }
        }
        if ((in = IconServlet.class.getResourceAsStream("/WEB-ROOT" + (fname = "/images/icons/img" + id + ".ico"))) == null) {
            throw new FileNotFoundException(fname);
        }
        try {
            List images = ICODecoder.read((InputStream)in);
            result = new CacheEntry.Bytes[images.size()];
            int idx = 0;
            for (BufferedImage img : images) {
                if (img.getWidth() != img.getHeight()) {
                    throw new InformException("width != height");
                }
                if (img.getWidth() % 8 != 0) {
                    throw new InformException("width%8 != 0");
                }
                ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "png", tmp);
                result[idx++] = new CacheEntry.Bytes(img.getWidth(), tmp.toByteArray());
            }
            Arrays.sort(result, new Comparator<CacheEntry.Bytes>(){

                @Override
                public int compare(CacheEntry.Bytes a, CacheEntry.Bytes b) {
                    return b.size < a.size ? -1 : (b.size == a.size ? 0 : 1);
                }
            });
        }
        finally {
            in.close();
        }
        IntegerHash<CacheEntry> integerHash3 = CACHE;
        synchronized (integerHash3) {
            CACHE.add(new CacheEntry(id, result));
        }
        return result;
    }

    public static class CacheEntry
    extends SoftReference<Bytes[]>
    implements IntegerHash.Entry {
        final int id;

        CacheEntry(int id, Bytes[] bytes) {
            super(bytes, queue);
            this.id = id;
        }

        @Override
        public int key() {
            return this.id;
        }

        public static class Bytes {
            public final int size;
            public final byte[] data;

            Bytes(int size, byte[] data) {
                this.size = size;
                this.data = data;
            }
        }
    }
}

