/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.web.HttpServer;
import inform.agent.web.Session;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.LocatorAdapter;
import io.jsonwebtoken.ProtectedHeader;
import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Parser;
import io.jsonwebtoken.jackson.io.JacksonDeserializer;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.MalformedKeyException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class JWT {
    public static final String DEFAULT_TRUSTED_ORIGIN = "^__DEFAULT_TRUSTED_ORIGIN__^";
    public static final String DEFAULT_UNTRUSTED_ORIGIN = "^__UNKNOWN-IMPOSSIBLE-ORIGIN__^";
    public static final String COOKIE_NAME = "ASMOJWT";
    public static final String HEADER_NAME = "X-Asmo-JWT";
    public static final String HEADER_ERROR_NAME = "X-Asmo-JWT-Error";
    private static final String OTT_PARAMETER_NAME = "jwtott";
    private static final Map<String, List<JWTSource>> trustedSources;
    private static final Map<String, Key> kidKeyMap;
    private static final int MAX_JWT_LIFETIME_MILLISECONDS = 60000;
    private static final int MAX_JWT_DESYNC_TIME_THRESHOLD_MILLISECONDS = 10000;
    private static final Pattern PATTERN_HTTPS;
    private static final Pattern PATTERN_PEM_X509_PKCS8_BASE64_EXTRACTOR;
    public final String username;
    public final Date issuedAt;
    public final Date expireAt;

    public JWT(String encodedJWT, String origin) throws JwtException {
        Jws jws = Jwts.parser().keyLocator((Locator)new CustomKeyLocator(origin, encodedJWT)).build().parseSignedClaims((CharSequence)encodedJWT);
        JwsHeader header = (JwsHeader)jws.getHeader();
        Claims payload = (Claims)jws.getPayload();
        String iss = payload.getIssuer();
        if (Strings.isVoid(iss)) {
            throw new JwtException("empty Issuer is not allowed");
        }
        if (!DEFAULT_TRUSTED_ORIGIN.equals(origin) && !iss.startsWith(origin)) {
            throw new JwtException("JWT origin (" + origin + ") is not the issuer (" + iss + ") therefore not trusted");
        }
        String sub = payload.getSubject();
        if (Strings.isVoid(sub)) {
            throw new JwtException("empty JWT subject is not allowed ");
        }
        this.issuedAt = payload.getIssuedAt();
        if (null == this.issuedAt) {
            throw new JwtException("JWT must have iat field");
        }
        Date now = new Date();
        long delta = now.getTime() - this.issuedAt.getTime();
        if (delta > 60000L) {
            throw new JwtException("JWT is too old (" + (delta - 60000L) + "ms after expiration, iat: " + this.issuedAt + " )");
        }
        if (delta < -10000L) {
            throw new JwtException("JWT issued in future (+" + -delta + "ms) cannot be accepted)");
        }
        Date expire = payload.getExpiration();
        if (null == expire) {
            expire = new Date(now.getTime() + 60000L);
        }
        this.expireAt = expire;
        this.username = ((Claims)jws.getPayload()).getSubject();
    }

    public boolean isExpired() {
        Date now = new Date();
        return this.expireAt.before(now);
    }

    public long secondsToLive() {
        Date now = new Date();
        long secondsLeft = (this.expireAt.getTime() - now.getTime()) / 1000L;
        return secondsLeft <= 0L ? 0L : secondsLeft;
    }

    public static void addSource(String origin, String json, Path keysDirPath) {
        List<Object> authorities;
        JWTSource source = null;
        try {
            source = new JWTSource(json, keysDirPath);
        }
        catch (DeserializationException e) {
            Core.logger.error("bad jwt_source {}: {}", origin, e.getMessage());
            return;
        }
        if (trustedSources.containsKey(origin)) {
            trustedSources.get(origin).add(source);
        } else {
            authorities = new ArrayList<JWTSource>();
            ((ArrayList)authorities).add(source);
            trustedSources.put(origin, authorities);
        }
        if (Strings.isVoid(source.kid)) {
            authorities = trustedSources.get(origin);
            source.kid = origin + "_" + authorities.size();
        }
        if (kidKeyMap.containsKey(source.kid)) {
            Core.logger.error("bad jwt_source {} config: duplicated key with id: {}, won't be accessible by kid", origin, source.kid);
        } else {
            kidKeyMap.put(source.kid, source.key);
        }
    }

    public static boolean isSourceTrusted(String origin) {
        return DEFAULT_TRUSTED_ORIGIN.equals(origin) || trustedSources.containsKey(PATTERN_HTTPS.matcher(origin).replaceFirst(""));
    }

    public static String getEncodedJwtOrNullFrom(HttpServletRequest request) {
        if (Strings.isVoid(Ini.jwtKeysDir)) {
            return null;
        }
        String jwt = null;
        String ott = request.getParameter(OTT_PARAMETER_NAME);
        if (!Strings.isVoid(ott)) {
            try {
                String authSessionId = new String(Base64.getUrlDecoder().decode(ott));
                jwt = HttpServer.popJwtFromSession(authSessionId);
            }
            catch (IllegalArgumentException e) {
                Core.logger.warn("trying to auth with bad ott {}", (Object)ott);
                return null;
            }
        }
        if (!Strings.isVoid(jwt)) {
            Session session = (Session)request.getSession(true);
            session.setAttribute("__asmo_encoded_jwt", jwt);
            return jwt;
        }
        Cookie[] cookies = request.getCookies();
        Optional<Cookie> jwtCookie = cookies == null ? Optional.empty() : Arrays.stream(cookies).filter(cookie -> COOKIE_NAME.equals(cookie.getName())).findFirst();
        jwt = jwtCookie.map(Cookie::getValue).orElse(null);
        if (null == jwt && null == (jwt = request.getHeader(HEADER_NAME))) {
            String auth = request.getHeader("Authorization");
            String auth_prefix = "Bearer ";
            if (null != auth && auth.startsWith(auth_prefix)) {
                jwt = auth.substring(auth_prefix.length());
            }
        }
        if (null == jwt) {
            Session session = (Session)request.getSession(true);
            jwt = (String)session.getAttribute("__asmo_encoded_jwt");
        }
        return jwt;
    }

    public static void initTrustedSources(String[] authoritiesConfs, String keysDir) {
        if (null == authoritiesConfs || authoritiesConfs.length == 0) {
            return;
        }
        Path keysDirPath = Path.of(keysDir, new String[0]);
        if (!keysDirPath.toFile().isDirectory()) {
            Core.logger.error("Found {} trusted jwt keys in config, but no directory for them found ({})", keysDir, authoritiesConfs.length);
            return;
        }
        for (String conf : authoritiesConfs) {
            int separatorIndex = conf.indexOf(61);
            if (-1 == separatorIndex || separatorIndex == conf.length() - 1) {
                Core.logger.error("bad jwt source configuration {}", conf);
                continue;
            }
            String origin = conf.substring(0, separatorIndex);
            String jsonConf = conf.substring(separatorIndex + 1);
            JWT.addSource(origin, jsonConf, keysDirPath);
        }
    }

    private static Key getVerificationKeyBy(String kid) {
        if (Strings.isVoid(kid) || !kidKeyMap.containsKey(kid)) {
            return null;
        }
        return kidKeyMap.get(kid);
    }

    private static Key getVerificationKeyBy(String origin, String kid) {
        if (DEFAULT_TRUSTED_ORIGIN.equals(origin)) {
            return JWT.getVerificationKeyBy(kid);
        }
        if (!trustedSources.containsKey(origin = PATTERN_HTTPS.matcher(origin).replaceFirst(""))) {
            return null;
        }
        if (null == kid) {
            return JWT.trustedSources.get((Object)origin).get((int)0).key;
        }
        Key possibleKey = null;
        for (JWTSource source : trustedSources.get(origin)) {
            if (Strings.isVoid(source.kid)) {
                possibleKey = source.key;
                continue;
            }
            if (!source.kid.equals(kid)) continue;
            return source.key;
        }
        return possibleKey;
    }

    static {
        PATTERN_HTTPS = Pattern.compile("^https://");
        PATTERN_PEM_X509_PKCS8_BASE64_EXTRACTOR = Pattern.compile("(-+(BEGIN|END) PUBLIC KEY-+|\n|\r)");
        trustedSources = new HashMap<String, List<JWTSource>>();
        kidKeyMap = new HashMap<String, Key>();
    }

    private static class JWTSource {
        public String iss;
        public String kid;
        public Key key;

        public JWTSource(String json, Path keysDir) throws DeserializationException {
            JacksonDeserializer des = new JacksonDeserializer();
            Map sourceConfig = (Map)des.deserialize(json.getBytes());
            this.iss = (String)sourceConfig.get("iss");
            this.kid = (String)sourceConfig.get("kid");
            String key_file = (String)sourceConfig.get("key_file");
            if (null == key_file) {
                throw new DeserializationException("jwt key parameter key_file must be present");
            }
            Path keyFilePath = Path.of(keysDir.toString(), key_file);
            if (!keyFilePath.toFile().isFile()) {
                throw new DeserializationException("Couldn't read jwt source key " + keyFilePath);
            }
            if (key_file.endsWith(".json") || keyFilePath.endsWith(".jwk")) {
                String keyJson;
                try {
                    keyJson = Files.readString(keyFilePath);
                }
                catch (IOException e) {
                    throw new DeserializationException("Couldn't read trusted jwt key file " + keyFilePath);
                }
                try {
                    Jwk jwk = (Jwk)((Parser)Jwks.parser().build()).parse((CharSequence)keyJson);
                    String keyAlgorithm = jwk.getAlgorithm();
                    if (!(keyAlgorithm.startsWith("RS") || keyAlgorithm.startsWith("ES") || keyAlgorithm.startsWith("PS"))) {
                        throw new DeserializationException("JWT verification with algorithm " + keyAlgorithm + " is prohibited");
                    }
                    this.key = jwk.toKey();
                }
                catch (MalformedKeyException e) {
                    throw new DeserializationException("Bad jwk content " + key_file + ": " + e.getMessage());
                }
            }
            String keyPem = null;
            try {
                keyPem = Files.readString(keyFilePath);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (null != keyPem) {
                    this.key = JWTSource.readPublicKeyPEM_X509(keyPem, (String)sourceConfig.get("kty"));
                } else {
                    byte[] keyContent = Files.readAllBytes(keyFilePath);
                    this.key = JWTSource.readPublicKeyDER_X509(keyContent, (String)sourceConfig.get("kty"));
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new DeserializationException("Unknown key algorithm " + (String)sourceConfig.get("kty") + "for key " + keyFilePath);
            }
            catch (InvalidKeySpecException e) {
                throw new DeserializationException("Unknown key format " + keyFilePath);
            }
            catch (IOException e) {
                throw new DeserializationException("Error while reading key " + keyFilePath);
            }
            catch (IllegalArgumentException e) {
                throw new DeserializationException("Not valid PEM encoded key " + keyFilePath);
            }
        }

        private static Key readPublicKeyPEM_X509(String pemKey, String kty) throws NoSuchAlgorithmException, InvalidKeySpecException, IllegalArgumentException {
            String encodedKey = PATTERN_PEM_X509_PKCS8_BASE64_EXTRACTOR.matcher(pemKey).replaceAll("");
            return JWTSource.readPublicKeyDER_X509(Base64.getDecoder().decode(encodedKey), kty);
        }

        private static Key readPublicKeyDER_X509(byte[] keyContent, String kty) throws NoSuchAlgorithmException, InvalidKeySpecException, IllegalArgumentException {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyContent);
            KeyFactory kf = KeyFactory.getInstance(kty);
            return kf.generatePublic(keySpec);
        }

        private static Key readPrivateKeyPEM_PKCS8(String pemKey, String kty) throws NoSuchAlgorithmException, InvalidKeySpecException, IllegalArgumentException {
            String encodedKey = PATTERN_PEM_X509_PKCS8_BASE64_EXTRACTOR.matcher(pemKey).replaceAll("");
            return JWTSource.readPrivateKeyDER_PKCS8(Base64.getDecoder().decode(encodedKey), kty);
        }

        private static Key readPrivateKeyDER_PKCS8(byte[] keyContent, String kty) throws NoSuchAlgorithmException, InvalidKeySpecException {
            assert (keyContent != null);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyContent);
            KeyFactory kf = KeyFactory.getInstance(kty);
            return kf.generatePublic(keySpec);
        }
    }

    private static final class CustomKeyLocator
    extends LocatorAdapter<Key> {
        private final String origin;

        public CustomKeyLocator(String origin, String encodedJWT) {
            this.origin = JWT.DEFAULT_TRUSTED_ORIGIN.equals(origin) ? CustomKeyLocator.getUntrustedOrigin(encodedJWT) : origin;
        }

        public static String getUntrustedOrigin(String encodedJWT) {
            int signatureStartIndex = encodedJWT.lastIndexOf(46);
            if (signatureStartIndex == -1) {
                throw new JwtException("JWT without signatures is not allowed");
            }
            int headerStartIndex = encodedJWT.indexOf(46);
            if (headerStartIndex == signatureStartIndex) {
                throw new JwtException("JWT without signatures is not allowed");
            }
            String untrustedJWTBase64 = encodedJWT.substring(headerStartIndex + 1, signatureStartIndex);
            String untrustedJWTJson = null;
            try {
                untrustedJWTJson = new String(Base64.getUrlDecoder().decode(untrustedJWTBase64), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException ignored) {
                return JWT.DEFAULT_UNTRUSTED_ORIGIN;
            }
            JacksonDeserializer des = new JacksonDeserializer();
            String untrustedIss = null;
            try {
                untrustedIss = (String)((Map)des.deserialize(untrustedJWTJson.getBytes())).get("iss");
            }
            catch (DeserializationException ignored) {
                return JWT.DEFAULT_UNTRUSTED_ORIGIN;
            }
            String untrustedOrigin = PATTERN_HTTPS.matcher(untrustedIss).replaceFirst("");
            int pathIndex = untrustedOrigin.indexOf(47);
            if (-1 != pathIndex) {
                untrustedOrigin = untrustedOrigin.substring(0, pathIndex);
            }
            return untrustedOrigin;
        }

        public Key locate(ProtectedHeader header) {
            String keyId = header.getKeyId();
            return JWT.getVerificationKeyBy(this.origin, keyId);
        }
    }
}

