/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.web.ConfigurationNode;
import inform.agent.web.JSON;
import inform.agent.web.Resource;
import inform.agent.web.Session;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ParametersForm {
    private static final String CONF_NAME = ".\u0434\u0438\u0430\u043b\u043e\u0433 \u0432\u0432\u043e\u0434\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432";
    private static final String TOPIC_NAME = "Params";

    public static boolean processParameters(Session.User user, HttpServletRequest rq, HttpServletResponse resp, ParametersList parameters, String title, double nodeId, Constants constants, Force force, String root) throws InformException, ParseException, IOException, SQLException {
        boolean oneSetted = false;
        boolean needStoreParams = false;
        Enumeration i = rq.getParameterNames();
        while (i.hasMoreElements()) {
            String string = (String)i.nextElement();
            if ("@store_params".equals(string)) {
                needStoreParams = true;
                continue;
            }
            String v = rq.getParameter(string);
            Parameter p = parameters.get(string);
            if (p != null) {
                p.setWebValue(v);
                oneSetted = true;
                continue;
            }
            if (!string.startsWith("@")) continue;
            String string2 = string.substring(1);
            p = parameters.get(string2);
            if (p == null) {
                try {
                    p = parameters.get(Integer.parseInt(string2));
                }
                catch (NumberFormatException e) {
                    Core.logger.error(null, e);
                }
            }
            if (p == null) continue;
            p.setAsmoWebValue(v);
            oneSetted = true;
        }
        String vis_params = rq.getParameter("$vis_params");
        if (vis_params != null) {
            for (Parameter p : parameters.values()) {
                p.hidden(true);
            }
            for (String pid : vis_params.split(",")) {
                Parameter p = parameters.get(Integer.parseInt(pid));
                if (p == null) continue;
                p.hidden(false);
            }
        }
        switch (force) {
            case NONE: {
                boolean bl;
                boolean bl2 = false;
                for (Parameter p : parameters.values()) {
                    if (p.hidden() || (!p.notNull() || !p.getIsIgnored()) && oneSetted) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
            }
            case REQUEST: {
                ParametersForm.generate(user, resp, parameters, title, nodeId, constants, root);
                return false;
            }
        }
        if (needStoreParams && !user.anonymous() && nodeId != 0.0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(byteArrayOutputStream);
            parameters.store(writer);
            writer.flush();
            ConfigurationNode conf = ConfigurationNode.load(user.id(), CONF_NAME);
            conf.folder(nodeId, TOPIC_NAME).content(0.0, byteArrayOutputStream.toByteArray());
            ConfigurationNode.store(conf, user.id(), CONF_NAME);
        }
        return true;
    }

    private static void generate(Session.User user, HttpServletResponse resp, ParametersList parameters, String title, double nodeId, Constants constants, String root) throws IOException, InformException, SQLException {
        ConfigurationNode conf;
        byte[] td;
        if (!user.anonymous() && nodeId != 0.0 && (td = (conf = ConfigurationNode.load(user.id(), CONF_NAME)).folder(nodeId, TOPIC_NAME).content(0.0)) != null && td.length != 0) {
            ParametersList plist = new ParametersList();
            plist.load(constants, new TaggedReader(td), Core.serverTimeZoneHost);
            for (Parameter p : plist.values()) {
                Parameter pp = parameters.get(p.getId());
                if (pp == null || pp.isModified()) continue;
                pp.assignParameter(p);
                if (p.getIsIgnored()) {
                    pp.setIgnore();
                }
                pp.clearModified();
            }
        }
        resp.setCharacterEncoding("WINDOWS-1251");
        resp.setHeader("Content-Type", "text/html");
        Class<ParametersForm> cls = ParametersForm.class;
        String html = Resource.asString(cls, cls.getSimpleName() + ".html", root);
        StringBuilder prms = new StringBuilder();
        boolean nc = false;
        for (Parameter p : parameters.values()) {
            if (p.hidden()) continue;
            if (nc) {
                prms.append(',');
            }
            prms.append("\n\tnew P.P(");
            double t = p.refTableId();
            if (t != 0.0) {
                prms.append("new P.DIR(").append(t).append(',').append(p.fieldAssoc()).append(',').append(p.selectedField()).append(',').append(p.getDataType().getTypeId()).append(',').append(NumberConverter.doubleToString(nodeId)).append(')');
            } else {
                switch (p.getDataType()) {
                    case INTEGER: {
                        prms.append("P.INT");
                        break;
                    }
                    case FLOAT: {
                        prms.append("P.FLT");
                        break;
                    }
                    case BOOLEAN: {
                        prms.append("P.BLN");
                        break;
                    }
                    case DATE_TIME: {
                        prms.append("new P.DTM(").append(p.getFormatId()).append(')');
                        break;
                    }
                    case METATREE_NODE: {
                        prms.append("new P.MTN(").append(JSON.toString(p.metadataFilter())).append(')');
                        break;
                    }
                    default: {
                        prms.append("P.STR");
                    }
                }
            }
            prms.append(",'").append(p.getCaption()).append("','@").append(p.getId()).append("',").append(p.notNull()).append(",").append(!p.oneValue());
            if (!p.getIsIgnored()) {
                Object v = p.getRawValue();
                prms.append(',').append(JSON.toString(v));
            }
            prms.append(')');
            nc = true;
        }
        html = html.replace("/*{$PARAMS}*/", prms.toString());
        html = html.replaceAll("\\{\\$TITLE}", title);
        resp.getOutputStream().write(html.getBytes(resp.getCharacterEncoding()));
    }

    public static enum Force {
        NONE,
        REQUEST,
        PROCESS;

    }
}

