/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ActiveDirectory;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.DBLogin;
import inform.agent.mtd.Acl;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.net.LdapUser;
import inform.agent.net.Security;
import inform.agent.web.AsmoServlet;
import inform.agent.web.HttpServer;
import inform.agent.web.JSON;
import inform.agent.web.JWT;
import inform.common.Base64BinString;
import inform.common.SmartScriptableObject;
import io.jsonwebtoken.JwtException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.HashedSession;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;

public class Session
extends HashedSession {
    private static Pattern wasmRunNodePattern = Pattern.compile("run(new|client)?node", 2);
    public static final String SKEY_AD = "__asmo_active_directory";
    public static final String SKEY_WASM = "__asmo_wasm";
    public static final String SKEY_JWT = "__asmo_encoded_jwt";
    public static final String SKEY_PersistentSession = "__asmo_persistent_session";
    public static final String PERSISTENT_SESSION_COOKIE = "ASMOPERS";
    private static final Pattern RG_NETCLR = Pattern.compile(";\\s+\\.NET\\s+CLR\\s+\\d+\\.\\d+\\.\\d+");
    private static final Random RANDOM = new SecureRandom();
    private static final AtomicInteger IDGEN = new AtomicInteger();
    private static final AtomicInteger REQUEST_NO = new AtomicInteger();
    private final int id = IDGEN.incrementAndGet();
    private final Store store = new Store();
    private final String remoteHost;
    private final String remoteUser;
    private volatile User user;
    private String nonce;
    private double auditId;
    private String ip;
    protected final String userAgent;

    private Session(HashSessionManager manager, HttpServletRequest request) {
        super(manager, request);
        this.remoteHost = request.getRemoteHost();
        this.remoteUser = request.getRemoteUser();
        String ua = request.getHeader("User-Agent");
        if (ua != null) {
            ua = RG_NETCLR.matcher(ua).replaceAll("");
        }
        this.userAgent = ua;
    }

    private Session(HashSessionManager manager, long created, long accessed, String clusterId) {
        super(manager, created, accessed, clusterId);
        this.userAgent = null;
        this.remoteUser = null;
        this.remoteHost = null;
    }

    public int newRequestNo() {
        return REQUEST_NO.incrementAndGet();
    }

    public int getSessionId() {
        return this.id;
    }

    public double getUserId() {
        if (this.user != null && this.user.user != null) {
            return this.user.user.getId();
        }
        return 0.0;
    }

    public void clearAttributes() {
        if (this.auditId != 0.0) {
            AuditJournal journal = new AuditJournal(AuditJournal.Journal.LOGIN);
            if (journal.isEnabled()) {
                AuditJournal.LoginParams params = new AuditJournal.LoginParams();
                params.code = 2;
                params.auditId = this.auditId;
                params.userId = this.user.id();
                params.time = System.currentTimeMillis();
                params.ip = this.ip;
                journal.registrateLogin(params);
                this.auditId = params.auditId;
            }
            this.auditId = 0.0;
        }
        this.nonce = null;
        this.user = null;
        ActiveDirectory activeDirectory = (ActiveDirectory)this.getAttribute(SKEY_AD);
        super.clearAttributes();
        if (activeDirectory != null) {
            activeDirectory.close();
        }
    }

    public Store store() {
        return this.store;
    }

    public User user() throws InformException {
        double wu;
        if (this.user == null && (wu = MtdEngine.serverNode().descriptor().webUser) != 0.0) {
            UserNode node = MtdEngine.getUserNode(wu);
            if (node == null) {
                throw new IllegalStateException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c [" + (long)wu + "]");
            }
            if (node.checkPassword("")) {
                this.user = new User(node, true);
            }
        }
        return this.user;
    }

    public User getCurrentUser() {
        return this.user;
    }

    public User anonWasmUser(String nodeId) throws InformException {
        if (this.user == null && !Strings.isVoid(nodeId)) {
            double wu = MtdEngine.serverNode().descriptor().webUser;
            if (wu != 0.0) {
                Node n;
                UserNode node = MtdEngine.getUserNode(wu);
                if (node == null) {
                    throw new IllegalStateException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c [" + (long)wu + "]");
                }
                Node node2 = n = Character.isDigit(nodeId.charAt(0)) ? MtdEngine.getNode(Long.parseLong(nodeId)) : MtdEngine.getNodeByIdent(nodeId);
                if (n == null) {
                    throw new AsmoServlet.ClientRequestErrorException("\u0423\u0437\u0435\u043b [" + nodeId + "] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                if (HttpServer.isAnonHttpNode(n.getId())) {
                    return new User(node, true);
                }
            }
        } else if (this.user != null && this.user.anonymous) {
            if (!Strings.isVoid(nodeId)) {
                Node n;
                Node node = n = Character.isDigit(nodeId.charAt(0)) ? MtdEngine.getNode(Long.parseLong(nodeId)) : MtdEngine.getNodeByIdent(nodeId);
                if (n == null) {
                    throw new AsmoServlet.ClientRequestErrorException("\u0423\u0437\u0435\u043b [" + nodeId + "] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                if (HttpServer.isAnonHttpNode(n.getId())) {
                    return this.user;
                }
            }
            return null;
        }
        return this.user;
    }

    public User anonWebUser(String pathInfo) throws InformException {
        if (pathInfo == null) {
            return null;
        }
        if (this.user == null) {
            double wu = MtdEngine.serverNode().descriptor().webUser;
            if (wu != 0.0) {
                UserNode node = MtdEngine.getUserNode(wu);
                if (node == null) {
                    throw new IllegalStateException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c [" + (long)wu + "]");
                }
                String[] path = pathInfo.split("/");
                if (path.length > 1 && !path[1].isEmpty()) {
                    String pathId = path[1];
                    if (path.length > 2 && wasmRunNodePattern.matcher(pathId).matches()) {
                        pathId = path[2];
                    }
                    Node n = null;
                    if (Character.isDigit(pathId.charAt(0))) {
                        try {
                            n = MtdEngine.getNode(Long.parseLong(pathId));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        n = MtdEngine.getNodeByIdent(pathId);
                    }
                    if (n == null) {
                        throw new AsmoServlet.ClientRequestErrorException("\u0423\u0437\u0435\u043b [" + pathId + "] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                    }
                    if (HttpServer.isAnonHttpNode(n.getId())) {
                        return new User(node, true);
                    }
                }
            }
        } else if (this.user.anonymous) {
            String[] path = pathInfo.split("/");
            if (path.length > 1 && !path[1].isEmpty()) {
                Node n;
                String pathId = path[1];
                if (path.length > 2 && wasmRunNodePattern.matcher(pathId).matches()) {
                    pathId = path[2];
                }
                Node node = n = Character.isDigit(pathId.charAt(0)) ? MtdEngine.getNode(Long.parseLong(pathId)) : MtdEngine.getNodeByIdent(pathId);
                if (n == null) {
                    throw new AsmoServlet.ClientRequestErrorException("\u0423\u0437\u0435\u043b [" + pathId + "] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                if (HttpServer.isAnonHttpNode(n.getId())) {
                    return this.user;
                }
            }
            throw new AsmoServlet.WithSession.InsufficientPrivilegiesException();
        }
        return this.user;
    }

    public User anonSoapUser(String pathInfo) throws InformException {
        if (pathInfo == null) {
            return null;
        }
        if (this.user == null) {
            double wu = MtdEngine.serverNode().descriptor().soapUser;
            if (wu != 0.0) {
                UserNode node = MtdEngine.getUserNode(wu);
                if (node == null) {
                    throw new IllegalStateException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c [" + (long)wu + "]");
                }
                String[] path = pathInfo.split("/");
                if (path.length > 1 && !path[1].isEmpty()) {
                    Node n;
                    String pathId = path[1];
                    Node node2 = n = Character.isDigit(pathId.charAt(0)) ? MtdEngine.getNode(Long.parseLong(pathId)) : MtdEngine.getNodeByIdent(pathId);
                    if (n == null) {
                        throw new AsmoServlet.ClientRequestErrorException("\u0423\u0437\u0435\u043b [" + pathId + "] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                    }
                    if (HttpServer.isAnonHttpNode(n.getId())) {
                        return new User(node, true);
                    }
                }
            }
        } else if (this.user.anonymous) {
            String[] path = pathInfo.split("/");
            if (path.length > 1 && !path[1].isEmpty()) {
                Node n;
                String pathId = path[1];
                Node node = n = Character.isDigit(pathId.charAt(0)) ? MtdEngine.getNode(Long.parseLong(pathId)) : MtdEngine.getNodeByIdent(pathId);
                if (n == null) {
                    throw new AsmoServlet.ClientRequestErrorException("\u0423\u0437\u0435\u043b [" + pathId + "] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                if (HttpServer.isAnonHttpNode(n.getId())) {
                    return this.user;
                }
            }
            throw new AsmoServlet.WithSession.InsufficientPrivilegiesException();
        }
        return this.user;
    }

    public void requestAuthentification(HttpServletRequest request, HttpServletResponse response, boolean stale, String root) throws IOException {
        ServerNode.Descriptor sd = MtdEngine.serverNode().descriptor();
        if (sd.ntlm) {
            ActiveDirectory activeDirectory = (ActiveDirectory)this.getAttribute(SKEY_AD);
            if (activeDirectory == null) {
                activeDirectory = ActiveDirectory.createInstance(1);
                this.setAttribute(SKEY_AD, activeDirectory);
                response.setHeader("WWW-Authenticate", Ini.WWW_AUTHORIZATION_TYPE);
                response.sendError(401);
            }
        } else if (sd.realm == null) {
            UserNode webUserNode;
            URLCodec codec = new URLCodec();
            StringBuilder to = new StringBuilder(root);
            to.append("/login?$redirect=").append(request.getRequestURI());
            Enumeration i = request.getParameterNames();
            while (i.hasMoreElements()) {
                String n = (String)i.nextElement();
                String v = request.getParameter(n);
                try {
                    to.append('&').append(codec.encode(n)).append('=').append(codec.encode(v));
                }
                catch (EncoderException e) {
                    String msg = "Omitting bad http parameter while redirect (" + n + "=" + v + ")";
                    Core.logger.error(msg, e);
                }
            }
            if (this.user == null && sd.webUser != 0.0 && null != (webUserNode = MtdEngine.getUserNode(sd.webUser))) {
                to.append("&$user=").append(webUserNode.getName());
            }
            response.sendRedirect(to.toString());
        } else {
            String realm = sd.realm + Strings.dup(' ', 8 - sd.realm.length());
            byte[] tmp = new byte[24];
            Session.random(tmp);
            this.nonce = new String(B64Code.encode((byte[])tmp));
            response.setHeader("WWW-Authenticate", "Digest" + (String)(Strings.isVoid(realm) ? "" : " realm=\"" + realm + "\"") + ", nonce=\"" + this.nonce + "\", algorithm=MD5, qop=\"auth\", stale=" + stale);
            response.sendError(401);
        }
    }

    private User processJWT(HttpServletRequest request, HttpServletResponse response, String encodedJWT) {
        if (encodedJWT.isEmpty()) {
            return null;
        }
        JWT jwt = null;
        try {
            jwt = new JWT(encodedJWT, "^__DEFAULT_TRUSTED_ORIGIN__^");
        }
        catch (JwtException e) {
            String errorMsg = e.getMessage();
            response.setHeader("X-Asmo-JWT-Error", URLEncoder.encode(errorMsg, StandardCharsets.UTF_8));
            Core.logger.warn("JWT login: {}, JWT:\n{}", (Object)errorMsg, (Object)encodedJWT);
            return null;
        }
        UserNode node = MtdEngine.getUserNodeByName(jwt.username);
        if (null == node || node.isActiveDirectoryAuthorization()) {
            String errorMsg = null == node ? "no such user" : "It is prohibited to authorize ActiveDirectory users with JWT";
            response.setHeader("X-Asmo-JWT-Error", URLEncoder.encode(errorMsg, StandardCharsets.UTF_8));
            Core.logger.warn("JWT login: {}, JWT:\n{}", (Object)errorMsg, (Object)encodedJWT);
            return null;
        }
        this.removeAttribute(SKEY_AD);
        Core.logger.info("JWT login: auth as: " + node);
        return this.authAs(node, request.getRemoteAddr());
    }

    private User processNTLM(HttpServletRequest request, HttpServletResponse response, ActiveDirectory activeDirectory) {
        try {
            String hha = request.getHeader("Authorization");
            if (hha == null) {
                throw new InformException("WAD: no Authorization header");
            }
            if (!hha.startsWith(Ini.WWW_AUTHORIZATION_TYPE)) {
                throw new InformException("NTLM expected, but found:" + hha);
            }
            byte[] data = Base64BinString.Decode(hha.substring(Ini.WWW_AUTHORIZATION_TYPE.length() + 1).trim());
            data = activeDirectory.processRaw(data);
            if (activeDirectory.isSuccessful()) {
                String uname = activeDirectory.getUserName();
                if (uname == null) {
                    throw new InformException("WAD: login failed: no ad-user(1)");
                }
                ServerNode.Descriptor serverNodeDescriptor = MtdEngine.serverNode().descriptor();
                boolean isLdapIntegration = LdapUser.useLDAP(serverNodeDescriptor);
                LdapUser.Info ldapInfo = null;
                boolean needLaunchScript = false;
                boolean needUpdateEndDate = false;
                UserNode node = MtdEngine.getAcitiveDirectoryUserNodes(uname);
                if (node == null) {
                    if (isLdapIntegration) {
                        ldapInfo = LdapUser.queryUserInfo(uname, serverNodeDescriptor);
                        node = LdapUser.createUserNode(ldapInfo, serverNodeDescriptor);
                        needLaunchScript = true;
                    }
                    if (node == null) {
                        throw new UserNotFoundException("WAD: login failed: no ad-user(2)");
                    }
                } else if (node instanceof VirtualUser && isLdapIntegration) {
                    VirtualUser user = (VirtualUser)node;
                    double serverManagedEndDate = user.props().getServerManagedEndDate();
                    needLaunchScript = serverManagedEndDate < DateTime.currentDateTime();
                    needUpdateEndDate = needLaunchScript;
                }
                this.removeAttribute(SKEY_AD);
                activeDirectory.close();
                Core.logger.info("login WAD: auth as: " + node);
                if (isLdapIntegration && needLaunchScript) {
                    if (ldapInfo == null) {
                        ldapInfo = LdapUser.queryUserInfo(uname, serverNodeDescriptor);
                    }
                    LdapUser.updateUserNode(node.getId(), ldapInfo, serverNodeDescriptor, needUpdateEndDate);
                }
                return this.authAs(node, request.getRemoteAddr());
            }
            response.setHeader("WWW-Authenticate", "NTLM " + Base64BinString.Encode(data));
            response.sendError(401);
        }
        catch (Throwable e) {
            if (e instanceof ActiveDirectory.Error) {
                Core.logger.warn("WAD", e);
            } else {
                Core.logger.warn("WAD: {}", (Object)e.toString());
            }
            this.removeAttribute(SKEY_AD);
            activeDirectory.close();
            if (e instanceof InformException) {
                throw (InformException)e;
            }
            throw InformException.wrap(e);
        }
        return null;
    }

    public User processAuthentification(HttpServletRequest request, HttpServletResponse response) throws InformException {
        return this.processAuthentification(request, response, false);
    }

    public User processSoapAuthentification(HttpServletRequest request, HttpServletResponse response) throws InformException {
        return this.processAuthentification(request, response, true);
    }

    private User processAuthentification(HttpServletRequest request, HttpServletResponse response, boolean soap) throws InformException {
        ActiveDirectory activeDirectory = (ActiveDirectory)this.getAttribute(SKEY_AD);
        if (activeDirectory != null) {
            return this.processNTLM(request, response, activeDirectory);
        }
        String nonc = this.nonce;
        if (nonc == null) {
            String jwt = JWT.getEncodedJwtOrNullFrom(request);
            if (null != jwt) {
                return this.processJWT(request, response, jwt);
            }
            String pathInfo = request.getPathInfo();
            User webUser = null;
            if (soap) {
                webUser = this.anonSoapUser(pathInfo);
            }
            if (webUser == null) {
                webUser = this.anonWebUser(pathInfo);
            }
            if (webUser != null) {
                return webUser;
            }
            return this.user();
        }
        this.nonce = null;
        String auth = request.getHeader("Authorization");
        if (auth == null) {
            Core.logger.info("HTTP: \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \"Authorization\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u0410\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u044e \u043a\u0430\u043a WWW");
            return null;
        }
        int sp = auth.indexOf(32);
        String usr = null;
        String realm = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String resp = null;
        QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(auth.substring(sp + 1), "=, ", true, false);
        String name = null;
        String last = null;
        block7: while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            char c = token.length() == 1 ? token.charAt(0) : (char)'\u0000';
            switch (c) {
                case '=': {
                    name = last;
                    last = token;
                    continue block7;
                }
                case ',': {
                    name = null;
                    continue block7;
                }
                case ' ': {
                    continue block7;
                }
            }
            last = token;
            if (name == null) continue;
            if ("username".equalsIgnoreCase(name)) {
                usr = token;
            } else if ("realm".equalsIgnoreCase(name)) {
                realm = token;
            } else if ("nc".equalsIgnoreCase(name)) {
                nc = token;
            } else if ("cnonce".equalsIgnoreCase(name)) {
                cnonce = token;
            } else if ("qop".equalsIgnoreCase(name)) {
                qop = token;
            } else if ("uri".equalsIgnoreCase(name)) {
                uri = token;
            } else if ("response".equalsIgnoreCase(name)) {
                resp = token;
            }
            name = null;
        }
        UserNode node = MtdEngine.getUserNodeByName(usr);
        if (node == null) {
            Core.logger.info("HTTP: \u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + usr + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u0410\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u044e \u043a\u0430\u043a WWW");
            return null;
        }
        String ur = new String(node.getSecuritySalt(), TaggedWriter.ANSI);
        if (!ur.equals(realm)) {
            throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438").detail("\u0414\u0430\u043d\u043d\u044b\u0435 \u043e \u043f\u0430\u0440\u043e\u043b\u0435 \u043d\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0442 \u043a \u0442\u0435\u043a\u0443\u0449\u0438\u043c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0430. \u041f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c.");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(request.getMethod().getBytes(StringUtil.__ISO_8859_1_CHARSET));
            md.update((byte)58);
            md.update(uri.getBytes(StringUtil.__ISO_8859_1_CHARSET));
            byte[] ha1 = node.getSecurityHash();
            byte[] ha2 = md.digest();
            md.update(TypeUtil.toString((byte[])ha1, (int)16).getBytes(StringUtil.__ISO_8859_1_CHARSET));
            md.update((byte)58);
            md.update(nonc.toString().getBytes(StringUtil.__ISO_8859_1_CHARSET));
            md.update((byte)58);
            md.update(nc.getBytes(StringUtil.__ISO_8859_1_CHARSET));
            md.update((byte)58);
            md.update(cnonce.getBytes(StringUtil.__ISO_8859_1_CHARSET));
            md.update((byte)58);
            md.update(qop.getBytes(StringUtil.__ISO_8859_1_CHARSET));
            md.update((byte)58);
            md.update(TypeUtil.toString((byte[])ha2, (int)16).getBytes(StringUtil.__ISO_8859_1_CHARSET));
            byte[] digest = md.digest();
            String hh = TypeUtil.toString((byte[])digest, (int)16);
            if (!hh.equalsIgnoreCase(resp)) {
                Core.logger.info("HTTP: \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043b\u044f \"" + usr + "\"");
                return null;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw InformException.wrap(e);
        }
        ServerNode.Descriptor sd = MtdEngine.serverNode().descriptor();
        if (!sd.webAllowEmptyPasswords && node.checkPassword("")) {
            Core.logger.info("HTTP: \u0437\u0430\u043f\u0440\u0435\u0442 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043b\u044f \"" + usr + "\"");
            return null;
        }
        return this.authAs(node, request.getRemoteAddr());
    }

    public User processAuthentification(double userId, HttpServletRequest request, HttpServletResponse response) throws InformException {
        ActiveDirectory activeDirectory = (ActiveDirectory)this.getAttribute(SKEY_AD);
        if (activeDirectory != null) {
            return this.processNTLM(request, response, activeDirectory);
        }
        UserNode node = MtdEngine.getUserNode(userId);
        if (node == null) {
            Core.logger.info("HTTP: \u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c c ID \"" + userId + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
            return null;
        }
        return this.authAs(node, request.getRemoteAddr());
    }

    User authAs(UserNode node, String clientIP) {
        AuditJournal journal;
        if ((this.user == null || this.user.id() != node.getId()) && (journal = new AuditJournal(AuditJournal.Journal.LOGIN)).isEnabled()) {
            AuditJournal.LoginParams params;
            if (this.auditId != 0.0) {
                params = new AuditJournal.LoginParams();
                params.code = 2;
                params.auditId = this.auditId;
                params.userId = this.user.id();
                params.time = System.currentTimeMillis();
                params.ip = clientIP;
                journal.registrateLogin(params);
                this.auditId = 0.0;
            }
            params = new AuditJournal.LoginParams();
            params.code = 1;
            params.auditId = this.auditId;
            params.userId = node.getId();
            params.time = System.currentTimeMillis();
            params.ip = this.ip = clientIP;
            journal.registrateLogin(params);
            this.auditId = params.auditId;
        }
        this.user = new User(node, false);
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void random(byte[] out) {
        Random random = RANDOM;
        synchronized (random) {
            RANDOM.nextBytes(out);
        }
    }

    public static class Store {
        private final AtomicInteger idGen = new AtomicInteger();
        private final Map<String, Future<?>> map = new HashMap();

        public String generateId() {
            return Integer.toHexString(this.idGen.incrementAndGet());
        }

        public synchronized <T> Future<T> get(String key, Class<T> clazz) {
            return this.map.get(key);
        }

        public synchronized void put(String key, Future<?> value) {
            this.map.put(key, value);
        }
    }

    static class Manager
    extends HashSessionManager {
        static final int DEFAULT_INACTIVE_TIMEOUT = 7200;

        public Manager() throws InformException {
            int sto = MtdEngine.serverNode().descriptor().webSessionTimeout;
            if (sto == 0) {
                sto = 7200;
            }
            this.setMaxInactiveInterval(sto);
        }

        protected AbstractSession newSession(HttpServletRequest request) {
            return new Session(this, request);
        }

        protected AbstractSession newSession(long created, long accessed, String clusterId) {
            return new Session(this, created, accessed, clusterId);
        }

        boolean isTicketValid(String ticket) {
            for (HashedSession s : this._sessions.values()) {
                String t;
                Object obj = s.getAttribute(Session.SKEY_WASM);
                if (obj == null || !(obj instanceof String) || Strings.isVoid(t = (String)obj) || !t.equals(ticket)) continue;
                return true;
            }
            return false;
        }

        void webUsersInfoRequest(TaggedWriter w) throws IOException, InformException {
            for (HashedSession s : this._sessions.values()) {
                w.putEmpty(1);
                w.putEmpty(14);
                w.putInt32(4, 0);
                if (s instanceof Session) {
                    Session ss = (Session)s;
                    User u = ss.user();
                    if (u != null) {
                        w.putAnsi(3, u.name());
                        w.putDouble(7, u.id());
                    }
                    w.putInt32(16, ss.id);
                    w.putAnsiIf(6, ss.remoteUser);
                    w.putAnsiIf(5, ss.remoteHost);
                    w.putAnsi(12, ss.userAgent);
                }
                w.putEmpty(2);
                w.putDate(13, new Date(s.getCreationTime()));
            }
        }
    }

    public static class User
    extends SmartScriptableObject
    implements JSON.Serializable {
        private final boolean anonymous;
        private UserNode user;

        public User(UserNode user, boolean anonymous) {
            this.user = user;
            this.anonymous = anonymous;
        }

        public UserNode node() {
            return this.user;
        }

        public int accessMask(Acl acl) throws InformException {
            return Security.calculateAccessMask(acl, this.user.getId(), this.user.effectiveGroups());
        }

        @JSON.Serializable.Serialize
        @SmartScriptableObject.PropertyTag
        public String name() {
            return this.user.getName();
        }

        @JSON.Serializable.Serialize
        @SmartScriptableObject.PropertyTag
        public String fio() {
            UserNode.Props props = this.user.props();
            return props == null ? null : props.getFio();
        }

        @JSON.Serializable.Serialize
        @SmartScriptableObject.PropertyTag
        public double id() {
            return this.user.getId();
        }

        @JSON.Serializable.Serialize
        public boolean anonymous() {
            return this.anonymous;
        }

        public Collection<DBLogin> dbLogins() {
            return this.user.getDbLogins();
        }

        @JSON.Serializable.Serialize
        public double rootNodeId() {
            return this.user.getActualRootNodeId();
        }

        void revalidateNode() {
            UserNode u = MtdEngine.getUserNode(this.user.getId());
            if (u != null) {
                this.user = u;
            }
        }
    }

    public static class UserNotFoundException
    extends InformException {
        public UserNotFoundException(String message) {
            super(message);
        }
    }
}

