/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Security;
import inform.agent.web.AsmoServlet;
import inform.agent.web.ParametersForm;
import inform.agent.web.SOAPTask;
import inform.agent.web.Session;
import inform.agent.web.WebServerSideHost;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.Request;

public class SoapServlet
extends AsmoServlet.WithSession {
    public SoapServlet() {
        super(AsmoServlet.Type.SOAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp, Session session) throws Throwable {
        Acl acl;
        String id = null;
        Node nod = null;
        try {
            String[] path = req.getPathInfo().split("/");
            id = path[1];
            nod = Character.isDigit(id.charAt(0)) ? MtdEngine.getNode(Long.parseLong(id)) : MtdEngine.getNodeByIdent(id);
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
            throw new InformException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043a \u0443\u0437\u043b\u0443");
        }
        if (nod == null) {
            throw new InformException("\u0423\u0437\u0435\u043b [" + id + "] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        double nodeId = nod.getId();
        BasicNode node = nod.getRealNode();
        Session.User user = session.anonSoapUser(req.getPathInfo());
        if (user == null) {
            user = session.user();
        }
        if ((user.accessMask(acl = Security.acl(node)) & 0x8000000) == 0) {
            throw new AsmoServlet.WithSession.InsufficientPrivilegiesException();
        }
        switch (node.getType()) {
            case 60: {
                try (WebServerSideHost.WithScriptable host = new WebServerSideHost.WithScriptable(node.getId(), user, (AbstractConnection)((Request)req).getConnection()){

                    @Override
                    public void writeLog(String msg) throws Exception {
                        Core.logger.info(msg);
                    }

                    @Override
                    public void appendToLog(String msg) throws Exception {
                        Core.logger.info(msg);
                    }

                    @Override
                    public void writeLogLine(String msg) throws Exception {
                        Core.logger.info(msg);
                    }
                };){
                    host.setConstants(task.getConstants());
                    try (SOAPTask task = new SOAPTask(host, node, req, resp, user, this.root());){
                        if (ParametersForm.processParameters(user, req, resp, task.getParameters(), node.getName(), nodeId, task.getConstants(), ParametersForm.Force.PROCESS, this.root())) {
                            task.execute();
                        }
                        break;
                    }
                }
            }
            default: {
                throw new InformException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f SOAP-\u0437\u0430\u043f\u0440\u043e\u0441 [" + id + "] \u0442\u0438\u043f \u0443\u0437\u043b\u0430 (" + node.getType() + ")");
            }
        }
    }

    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Session session = (Session)request.getSession(true);
        Session.User user = session.processSoapAuthentification(request, response);
        if (user == null) {
            this.type.sendInsufficientPrivilegies(request, response, session, this.root());
            return;
        }
        user.revalidateNode();
        try {
            this.execute(request, response, session);
        }
        catch (AsmoServlet.WithSession.InsufficientPrivilegiesException e) {
            Core.logger.error(null, e);
            this.type.sendInsufficientPrivilegies(request, response, session, this.root());
        }
    }
}

