/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.collections.DoubleHash;
import inform.agent.Ini;
import inform.agent.db.ClosableResult;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Security;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import inform.agent.web.Resource;
import inform.agent.web.Session;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TestServlet
extends AsmoServlet.WithSession {
    public TestServlet() {
        super(AsmoServlet.Type.HTML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp, Session session) throws Throwable {
        resp.setHeader("Cache-Control", "no-cache, no-store, max-age=0");
        Session.User user = session.user();
        if (req.getParameter("nodes") != null) {
            resp.setHeader("Content-Type", "application/json; charset=windows-1251");
            resp.setCharacterEncoding("WINDOWS-1251");
            try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connect(null, "TestServlet");
                 ClosableResult crs = MetadataNodeReader.getResultSetForTypedNode(null, new int[]{14, 56, 60, 45, 2}, connection, false);){
                ResultSet rs = crs.getResultSet();
                int idxId = rs.findColumn("ID");
                DoubleHash<Node> hnodes = new DoubleHash<Node>();
                MtdCache mtdCache = MtdEngine.getMtdCache();
                double userRoot = user.rootNodeId();
                block9: while (rs.next()) {
                    Node n = MtdEngine.getNode(rs.getDouble(idxId));
                    if (n == null || !n.isChildOf(userRoot, mtdCache)) continue;
                    n = n.getRealNode();
                    switch (n.getType()) {
                        case 14: 
                        case 45: 
                        case 56: 
                        case 60: {
                            break;
                        }
                        default: {
                            continue block9;
                        }
                    }
                    hnodes.add(n);
                }
                Node[] fnodes = new Node[hnodes.size()];
                int idx = 0;
                for (Node n : hnodes) {
                    fnodes[idx++] = n;
                }
                Arrays.sort(fnodes, new Comparator<Node>(){

                    @Override
                    public int compare(Node o1, Node o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                PrintWriter w = resp.getWriter();
                w.append('[');
                boolean nc = false;
                for (Node n : fnodes) {
                    Acl acl = Security.acl((BasicNode)(n = n.getRealNode()));
                    if ((user.accessMask(acl) & 0x8000000) == 0) continue;
                    if (nc) {
                        w.append(',');
                    }
                    nc = true;
                    w.append("{\"id\":").format("%.0f", n.getId()).append(",\"name\":").append(JSON.toString(n.getName())).append('}');
                }
                w.append(']');
            }
            return;
        }
        double startupNode = user.node().webStartNodeId();
        if (startupNode == 0.0) {
            startupNode = MtdEngine.serverNode().descriptor().webDefaultNode;
        }
        if (startupNode != 0.0) {
            resp.sendRedirect(this.root() + "/node/" + (long)startupNode);
            return;
        }
        resp.setHeader("Content-Type", "text/html; charset=windows-1251");
        resp.setHeader("X-UA-Compatible", "IE=edge,chrome=1");
        resp.setCharacterEncoding("WINDOWS-1251");
        String html = Resource.asString(TestServlet.class, TestServlet.class.getSimpleName() + ".html", this.root());
        Object title = Ini.AgentName;
        if (!((String)title).isEmpty()) {
            title = (String)title + " - ";
        }
        title = (String)title + "\u0414\u0435\u0440\u0435\u0432\u043e \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445";
        html = html.replace("{{TITLE}}", (CharSequence)title);
        html = html.replace("\"{TITLE}\"", JSON.toString(title));
        html = html.replace("\"{MT_FILTER}\"", JSON.toString(new int[]{14, 18, 54, 56, 60, 45, 42}));
        PrintWriter w = resp.getWriter();
        w.append(html);
    }
}

