/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.expr;

import inform.agent.expr.ConstantTerm;
import inform.agent.expr.Expression;
import inform.agent.expr.ParameterTerm;
import inform.agent.expr.Term;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.Task;
import inform.agent.web.data.Datamodel;
import inform.agent.web.expr.WebFieldTerm;
import inform.agent.web.expr.eval.WebBraceEvaluator;
import inform.agent.web.expr.eval.WebEvaluator;
import inform.agent.web.expr.eval.WebFieldEvaluator;
import inform.agent.web.expr.eval.WebIgnoredEvaluator;
import inform.agent.web.expr.eval.WebValueEvaluator;
import inform.agent.web.expr.eval.func.WebAbsEvaluator;
import inform.agent.web.expr.eval.func.WebCaseEvaluator;
import inform.agent.web.expr.eval.func.WebMaxEvaluator;
import inform.agent.web.expr.eval.func.WebMinEvaluator;
import inform.agent.web.expr.eval.func.WebRoundToEvaluator;
import inform.agent.web.expr.eval.func.WebTrimEvaluator;
import inform.agent.web.expr.eval.func.WebWhenEvaluator;
import inform.agent.web.expr.eval.op.WebAddEvaluator;
import inform.agent.web.expr.eval.op.WebCompareEvaluator;
import inform.agent.web.expr.eval.op.WebDivEvaluator;
import inform.agent.web.expr.eval.op.WebLogicalEvaluator;
import inform.agent.web.expr.eval.op.WebModEvaluator;
import inform.agent.web.expr.eval.op.WebMulEvaluator;
import inform.agent.web.expr.eval.op.WebNegEvaluator;
import inform.agent.web.expr.eval.op.WebSubEvaluator;
import inform.agent.web.utils.TypedValue;
import org.mozilla.javascript.Scriptable;

public class WebExpression
extends Expression<WebEvaluator> {
    private final Task task;

    public WebExpression(Scriptable scope, Task task) {
        super(scope);
        this.task = task;
    }

    public Task getTask() {
        return this.task;
    }

    public WebExpression createClone(Scriptable scope, Task task) {
        WebExpression expression = new WebExpression(scope, task);
        for (Term term : this.expr) {
            Term t = term.createClone(expression);
            expression.expr.add(t);
        }
        return expression;
    }

    @Override
    public Constants getConstants() {
        return this.task.getConstants();
    }

    @Override
    public ParametersList getParameters() {
        return this.task.getParameters();
    }

    @Override
    public WebEvaluator createIgnored() {
        return new WebIgnoredEvaluator(null);
    }

    @Override
    public WebEvaluator createNOP(WebEvaluator left, WebEvaluator right) {
        throw new IllegalStateException();
    }

    @Override
    public WebEvaluator createEvaluator(Term term) {
        switch (term.getToken()) {
            case field: {
                return new WebFieldEvaluator((WebFieldTerm)term);
            }
            case globalConst: {
                return new WebValueEvaluator((ConstantTerm)term);
            }
            case param: {
                return new WebValueEvaluator((ParameterTerm)term);
            }
            case value: {
                return new WebValueEvaluator((ValueTerm)term);
            }
            case functionRoundTo: {
                return new WebRoundToEvaluator(term);
            }
            case functionAbs: {
                return new WebAbsEvaluator(term);
            }
            case functionMin: {
                return new WebMinEvaluator(term);
            }
            case functionMax: {
                return new WebMaxEvaluator(term);
            }
            case functionTrim: {
                return new WebTrimEvaluator(term);
            }
            case functionCase: {
                return new WebCaseEvaluator(term);
            }
            case functionWhen: {
                return new WebWhenEvaluator(term);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public WebEvaluator createEvaluator(Term term, WebEvaluator arg) {
        switch (term.getToken()) {
            case sub: {
                return new WebNegEvaluator(term, arg);
            }
            case openBrace: {
                return new WebBraceEvaluator(term, arg);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public WebEvaluator createEvaluator(Term term, WebEvaluator left, WebEvaluator right) {
        switch (term.getToken()) {
            case add: {
                return new WebAddEvaluator(term, left, right);
            }
            case sub: {
                return new WebSubEvaluator(term, left, right);
            }
            case mul: {
                return new WebMulEvaluator(term, left, right);
            }
            case div: {
                return new WebDivEvaluator(term, left, right);
            }
            case mod: {
                return new WebModEvaluator(term, left, right);
            }
            case equal: 
            case notEqual: 
            case less: 
            case lessEqual: 
            case greater: 
            case greaterEqual: 
            case like: 
            case notLike: {
                return new WebCompareEvaluator(term, left, right);
            }
            case or: 
            case and: {
                return new WebLogicalEvaluator(term, left, right);
            }
        }
        throw new IllegalStateException();
    }

    public TypedValue evaluate() throws Exception {
        WebEvaluator evaluator = (WebEvaluator)this.compile();
        if (evaluator == null) {
            return null;
        }
        return evaluator.evaluate();
    }

    public void setupDatamodel(Datamodel datamodel) {
        for (Term term : this.expr) {
            if (!(term instanceof WebFieldTerm)) continue;
            ((WebFieldTerm)term).setupDatamodel(datamodel);
        }
    }

    public void select() throws Exception {
        for (Term term : this.expr) {
            if (!(term instanceof WebFieldTerm)) continue;
            ((WebFieldTerm)term).select();
        }
    }

    @Override
    protected Term createObjectArg(Term term, Object arg) throws Exception {
        if (arg instanceof DatasourceField) {
            DatasourceField field = (DatasourceField)arg;
            WebFieldTerm fieldTerm = new WebFieldTerm(this.task, this);
            fieldTerm.setField((Dataset)field.getRowsetAccessor(), field);
            int index = this.expr.indexOf(term);
            this.expr.add(index, fieldTerm);
            return fieldTerm;
        }
        return super.createObjectArg(term, arg);
    }

    @Override
    protected Term createTerm(int id) {
        switch (id) {
            case 1: {
                return new WebFieldTerm(this.task, this);
            }
        }
        return super.createTerm(id);
    }
}

