/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.expr.eval.op;

import inform.agent.expr.Term;
import inform.agent.web.expr.eval.WebEvaluator;
import inform.agent.web.utils.TypedValue;

public abstract class WebBinaryEvaluator
extends WebEvaluator {
    final WebEvaluator left;
    final WebEvaluator right;

    public WebBinaryEvaluator(Term term, WebEvaluator left, WebEvaluator right) {
        super(term);
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.left.isIgnored() || this.right.isIgnored();
    }

    @Override
    public TypedValue evaluate() throws Exception {
        if (this.left == null || this.right == null) {
            return null;
        }
        TypedValue l = this.left.evaluate();
        TypedValue r = this.right.evaluate();
        if (l == null || r == null) {
            return null;
        }
        return this.calc(l, r);
    }

    @Override
    public boolean isStringType() throws Exception {
        return this.left.isStringType() || this.right.isStringType();
    }

    protected TypedValue calc(TypedValue left, TypedValue right) {
        return this.calcNumber(WebBinaryEvaluator.toNumberSilent(left.getValue()), WebBinaryEvaluator.toNumberSilent(right.getValue()));
    }

    protected abstract TypedValue calcNumber(double var1, double var3);
}

