/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.expr.eval.op;

import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.expr.Expression;
import inform.agent.expr.Term;
import inform.agent.web.expr.eval.WebEvaluator;
import inform.agent.web.expr.eval.op.WebBinaryEvaluator;
import inform.agent.web.utils.TypedValue;

public class WebCompareEvaluator
extends WebBinaryEvaluator {
    public WebCompareEvaluator(Term term, WebEvaluator left, WebEvaluator right) {
        super(term, left, right);
    }

    @Override
    protected TypedValue calc(TypedValue left, TypedValue right) {
        boolean value = WebCompareEvaluator.isStringable(left.getType()) || this.term.getToken() == Expression.Token.like || this.term.getToken() == Expression.Token.notLike ? this.evaluateString(ValueCaster.toString(left.getValue()), ValueCaster.toString(right.getValue())) : this.evaluateNumber(WebCompareEvaluator.toNumberSilent(left.getValue()), WebCompareEvaluator.toNumberSilent(right.getValue()));
        return new TypedValue(DataType.BOOLEAN, value);
    }

    @Override
    protected TypedValue calcNumber(double left, double right) {
        return null;
    }

    boolean evaluateString(String left, String right) {
        int code = left.compareTo(right);
        switch (this.term.getToken()) {
            case equal: {
                return code == 0;
            }
            case notEqual: {
                return code != 0;
            }
            case less: {
                return code < 0;
            }
            case lessEqual: {
                return code <= 0;
            }
            case greater: {
                return code > 0;
            }
            case greaterEqual: {
                return code >= 0;
            }
            case like: {
                return left.contains(right) || right.contains(left);
            }
            case notLike: {
                return !left.contains(right) && !right.contains(left);
            }
        }
        return false;
    }

    boolean evaluateNumber(double left, double right) {
        switch (this.term.getToken()) {
            case equal: {
                return left == right;
            }
            case notEqual: {
                return left != right;
            }
            case less: {
                return left < right;
            }
            case lessEqual: {
                return left <= right;
            }
            case greater: {
                return left > right;
            }
            case greaterEqual: {
                return left >= right;
            }
        }
        return false;
    }
}

