/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.expr.eval.op;

import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.expr.Expression;
import inform.agent.expr.Term;
import inform.agent.web.expr.eval.WebEvaluator;
import inform.agent.web.utils.TypedValue;

public class WebLogicalEvaluator
extends WebEvaluator {
    private static final TypedValue falseValue = new TypedValue(DataType.BOOLEAN, false);
    private static final TypedValue trueValue = new TypedValue(DataType.BOOLEAN, true);
    final WebEvaluator left;
    final WebEvaluator right;

    public WebLogicalEvaluator(Term term, WebEvaluator left, WebEvaluator right) {
        super(term);
        this.left = left;
        this.right = right;
    }

    @Override
    public TypedValue evaluate() throws Exception {
        if (this.left == null) {
            if (this.right == null || this.term.getToken() == Expression.Token.and) {
                return falseValue;
            }
            TypedValue typedValue = this.right.evaluate();
            if (typedValue == null) {
                return falseValue;
            }
            if (ValueCaster.toBoolean(typedValue.getValue()).booleanValue()) {
                return trueValue;
            }
            return falseValue;
        }
        if (this.right == null) {
            if (this.term.getToken() == Expression.Token.and) {
                return falseValue;
            }
            TypedValue typedValue = this.left.evaluate();
            if (typedValue == null) {
                return falseValue;
            }
            if (ValueCaster.toBoolean(typedValue.getValue()).booleanValue()) {
                return trueValue;
            }
            return falseValue;
        }
        if (this.left.isIgnored()) {
            if (this.right.isIgnored()) {
                return trueValue;
            }
            return this.right.evaluate();
        }
        if (this.right.isIgnored()) {
            return this.left.evaluate();
        }
        TypedValue typedValue = this.left.evaluate();
        switch (this.term.getToken()) {
            case or: {
                if (typedValue == null || !ValueCaster.toBoolean(typedValue.getValue()).booleanValue()) break;
                return trueValue;
            }
            case and: {
                if (typedValue != null && ValueCaster.toBoolean(typedValue.getValue()).booleanValue()) break;
                return falseValue;
            }
            default: {
                return falseValue;
            }
        }
        if ((typedValue = this.right.evaluate()) == null || !ValueCaster.toBoolean(typedValue.getValue()).booleanValue()) {
            return falseValue;
        }
        return trueValue;
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.left.isIgnored() && this.right.isIgnored();
    }

    @Override
    public boolean isStringType() throws Exception {
        return false;
    }
}

