/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.Cache;
import inform.adt.InformException;
import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebButton;
import inform.agent.web.forms.WebCheckbox;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebDiagram;
import inform.agent.web.forms.WebDocument;
import inform.agent.web.forms.WebEdit;
import inform.agent.web.forms.WebFrame;
import inform.agent.web.forms.WebGrid;
import inform.agent.web.forms.WebImage;
import inform.agent.web.forms.WebLabel;
import inform.agent.web.forms.WebPages;
import inform.agent.web.forms.WebPanel;
import inform.agent.web.forms.WebRadio;
import inform.agent.web.forms.WebScheme;
import inform.agent.web.forms.WebToolbar;
import inform.agent.web.forms.WebTree;
import inform.agent.web.forms.WebUnknownControl;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;

public class WebControlContainer
extends WebControl {
    private static final int TAG_WEB_CONTROL_ID = 1;
    private static final int TAG_WEB_CONTROL_TYPE = 2;
    private static final int TAG_WEB_CONTROL_OPTIONS = 3;
    private static final int TAG_WEB_INT_HORZ_ALIGN = 14;
    private static final int TAG_WEB_INT_VERT_ALIGN = 15;
    private static final int WF_TEXT = 101;
    private static final int WF_IMAGE = 102;
    private static final int WF_BUTTON = 103;
    private static final int WF_PANEL = 104;
    private static final int WF_EDIT = 105;
    private static final int WF_GRID = 106;
    private static final int WF_PAGES = 107;
    private static final int WF_TOOLBAR = 108;
    private static final int WF_FRAME = 109;
    private static final int WF_RADIOBUTTON = 110;
    private static final int WF_CHECKBUTTON = 111;
    private static final int WF_TREE = 112;
    private static final int WF_DOCUMENT = 113;
    private static final int WF_SCHEME = 114;
    private static final int WF_DIAGRAM = 115;
    protected final Collection<WebControl> controls = new ArrayList<WebControl>();
    protected WebControl.HorzAlign alignInternalHorz = WebControl.HorzAlign.DEFAULT;
    protected WebControl.VertAlign alignInternalVert = WebControl.VertAlign.DEFAULT;
    private static final Cache<Class<? extends WebControlContainer>, ContainsChildrenClass> CACHE_CC = new Cache();

    public WebControlContainer(int id, WebControlContainer parent, boolean isSubControl) {
        super(id, parent, isSubControl);
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        for (WebControl c : this.controls) {
            c.generate(writer, resolver);
        }
    }

    @Override
    protected boolean invalidateEffectiveFont() {
        if (!super.invalidateEffectiveFont()) {
            return false;
        }
        for (WebControl c : this.controls) {
            c.invalidateEffectiveFont();
        }
        return true;
    }

    private void correctAlign() {
        for (WebControl c : this.controls) {
            if (c.getHAlign() != WebControl.HorzAlign.DEFAULT && c.getHAlign() != WebControl.HorzAlign.JUSTIFY) continue;
            c.setHAlign(WebControl.HorzAlign.LEFT);
        }
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 1: {
                int id = reader.getInt();
                int type = reader.getInt();
                int options = reader.getInt();
                WebControl c = this.createTypedControl(type, id, options);
                c.load(reader.getSubStreamReader());
                this.correctAlign();
                this.controls.add(c);
                break;
            }
            case 14: {
                this.alignInternalHorz = WebControl.HorzAlign.values()[reader.getInt()];
                break;
            }
            case 15: {
                this.alignInternalVert = WebControl.VertAlign.values()[reader.getInt()];
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebControl createTypedControl(int type, int id, int options) {
        ContainsChildrenClass cc;
        switch (type) {
            case 101: {
                return new WebLabel(id, options, this);
            }
            case 102: {
                return new WebImage(id, options, this);
            }
            case 103: {
                return new WebButton(id, options, this);
            }
            case 104: {
                return new WebPanel(id, options, this);
            }
            case 105: {
                return new WebEdit(id, options, this);
            }
            case 106: {
                return new WebGrid(id, options, this);
            }
            case 107: {
                return new WebPages(id, options, this);
            }
            case 108: {
                return new WebToolbar(id, options, this);
            }
            case 109: {
                return new WebFrame(id, options, this);
            }
            case 110: {
                return new WebRadio(id, options, this);
            }
            case 111: {
                return new WebCheckbox(id, options, this);
            }
            case 112: {
                return new WebTree(id, options, this);
            }
            case 113: {
                return new WebDocument(id, options, this);
            }
            case 114: {
                return new WebScheme(id, options, this);
            }
            case 115: {
                return new WebDiagram(id, options, this);
            }
        }
        Class<?> cls = this.getClass();
        Cache<Class<? extends WebControlContainer>, ContainsChildrenClass> cache = CACHE_CC;
        synchronized (cache) {
            cc = CACHE_CC.get(cls);
            if (cc == null) {
                cc = new ContainsChildrenClass(cls);
                CACHE_CC.put(cls, cc);
            }
        }
        ContainsChildrenEntry ce = (ContainsChildrenEntry)cc.get(type);
        if (ce != null) {
            try {
                return ce.constructor.newInstance(id, this);
            }
            catch (Exception ex) {
                throw InformException.wrap(ex);
            }
        }
        return new WebUnknownControl(id, options, this, type);
    }

    private static class ContainsChildrenClass
    extends IntegerHash<ContainsChildrenEntry> {
        final Class<? extends WebControlContainer> cls;

        ContainsChildrenClass(Class<? extends WebControlContainer> cls) {
            this.cls = cls;
            while (true) {
                for (Annotation a : cls.getAnnotations()) {
                    if (!(a instanceof ContainsChildren)) continue;
                    this.add(new ContainsChildrenEntry((ContainsChildren)a));
                }
                if (cls == WebControlContainer.class) break;
                cls = cls.getSuperclass();
            }
        }
    }

    private static class ContainsChildrenEntry
    implements IntegerHash.Entry {
        final int type;
        final Constructor<? extends WebControl> constructor;

        ContainsChildrenEntry(ContainsChildren annotation) {
            this.type = annotation.type();
            try {
                this.constructor = annotation.cls().getConstructor(Integer.TYPE, WebControlContainer.class);
            }
            catch (NoSuchMethodException e) {
                throw InformException.wrap(e);
            }
        }

        @Override
        public int key() {
            return this.type;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ContainsChildren {
        public int type();

        public Class<? extends WebControl> cls();
    }
}

