/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import java.io.IOException;

@JSRequire(value={"WebDocument"})
public class WebDocument
extends WebControl
implements DatasourceUsage {
    private static final int TAG_WEB_DOCUMENT_NODEID = 40;
    private static final int TAG_WEB_DOCUMENT_DATASOURCE = 41;
    private static final int TAG_WEB_DOCUMENT_FIELD = 42;
    private static final int TAG_WEB_DOCUMENT_READONLY = 43;
    private double node;
    private int dsid;
    private int[] fpath;
    private boolean readonly = true;

    public WebDocument(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 40: {
                this.node = reader.getNodeID();
                break;
            }
            case 41: {
                this.dsid = reader.getInt();
                break;
            }
            case 42: {
                this.fpath = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 43: {
                this.readonly = reader.getBoolean();
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        writer.tag("div").attr("class", "doc").attr("id", this.id);
        if (!this.readonly) {
            writer.attr("contenteditable", "true");
        }
        writer.attr("name", "edit" + this.id);
        writer.attr("id", "edit" + this.id);
        if (this.width != 0.0) {
            writer.style("width", this.width, "mm");
        }
        if (this.height != 0.0) {
            writer.style("height", this.height, "mm");
        }
        if (this.node != 0.0) {
            writer.attr("data-node", (long)this.node);
        } else {
            this.appendDataBindingsTo(writer, this.dsid, this.fpath);
        }
        writer.end();
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) {
        out.append((Object)this, this.dsid, this.fpath);
    }
}

