/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.AbstractScriptableTask;
import inform.agent.scripts.ComponentsFactory;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.web.JSON;
import inform.agent.web.Session;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebBand;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebScript;
import inform.agent.web.forms.components.WebComponent;
import inform.agent.web.forms.components.WebComponentContainer;
import inform.agent.web.forms.components.WebDatasource;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

@JSRequire(value={"css!WebForm", "WebButton"})
public class WebForm
extends WebComponentContainer {
    private static final int TAG_WEB_FORM_SCRIPT = 11;
    private static final int TAG_WEB_COMPONENTS = 12;
    private static final int TAG_WEB_ON_INITILIZE = 13;
    private static final int TAG_WEB_BAND = 14;
    private static final int TAG_WEB_FORM_SERVER_SCRIPT = 17;
    private static final int TAG_WEB_FORM_ICON = 18;
    private final BasicNode node;
    private final WebBand band = new WebBand();
    private byte[] parameters;
    private byte[] componentsData;
    private String script;
    private String scriptS;
    private String onInitialize;
    private int icon;

    public static WebForm load(BasicNode node) throws IOException {
        WebForm f = new WebForm(node);
        f.load(new TaggedReader(node.getContent()));
        return f;
    }

    public WebForm(BasicNode node) {
        super(0, null, true);
        this.node = node;
    }

    @Override
    public double getOwnerId() {
        if (this.node != null) {
            return this.node.getId();
        }
        return 0.0;
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        block0 : switch (reader.getCurrentTag()) {
            case 152: {
                TaggedReader r = reader.getSubStreamReader();
                while (r.next()) {
                    if (r.getCurrentTag() != 153) continue;
                    this.parameters = r.getSubStreamData();
                    break block0;
                }
                break;
            }
            case 11: {
                this.script = reader.getString();
                break;
            }
            case 12: {
                this.componentsData = reader.getSubStreamData();
                super.load(new TaggedReader(this.componentsData));
                break;
            }
            case 13: {
                this.onInitialize = reader.getAnsi();
                break;
            }
            case 14: {
                this.band.load(reader.getSubStreamReader());
                break;
            }
            case 17: {
                this.scriptS = reader.getString();
                break;
            }
            case 18: {
                this.icon = reader.getInt();
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    public Task.Arg createTaskArg(double userId) throws IOException {
        Constants constants = new Constants(userId);
        ParametersList params = new ParametersList();
        if (this.parameters != null) {
            params.load(constants, new TaggedReader(this.parameters), Core.serverTimeZoneHost);
        }
        return new Task.Arg(constants, params);
    }

    public Task createTask(Task.Arg arg, ServerSideHost ssHost, Session.User user, boolean inline, String root) throws IOException {
        return new Task(arg, ssHost, this, user, inline, root);
    }

    public DatasourceUsage.Scanner scan() throws IOException {
        ParametersList plist = new ParametersList();
        if (this.parameters != null) {
            plist.load(DEFAULT_CONSTANTS, new TaggedReader(this.parameters), Core.serverTimeZoneHost);
        }
        final DatasourceUsage.Scanner result = new DatasourceUsage.Scanner(plist);
        final IntegerHash dsmap = new IntegerHash();
        WebForm.walkComponents(this, new Visitor<WebComponent, RuntimeException>(){

            @Override
            public void visit(WebComponent o) {
                if (o instanceof WebDatasource) {
                    dsmap.add((WebDatasource)o);
                }
            }
        });
        for (WebDatasource ds : dsmap) {
            result.dsmap.put(ds.id, ds.table());
        }
        Visitor<Object, IOException> ud = new Visitor<Object, IOException>(){

            @Override
            public void visit(Object o) throws IOException {
                if (o instanceof DatasourceUsage) {
                    ((DatasourceUsage)o).appendUsedDirectoriesTo(result);
                }
            }
        };
        WebForm.walkControls(this.band, ud);
        WebForm.walkComponents(this, ud);
        return result;
    }

    @Override
    public void generate(final Appendable writer, String pad, final Task task) throws IOException {
        int ico;
        if (this.scriptS != null) {
            task.execute();
        }
        LinkedHashMap<String, String> requiresJs = new LinkedHashMap<String, String>();
        LinkedHashSet<String> requiresCss = new LinkedHashSet<String>();
        requiresJs.put("inform.agent.web.forms.WebForm", "WF");
        requiresJs.put("inform.agent.web.forms.Datamodel", "DM");
        Requirer requirer = new Requirer(requiresCss, requiresJs);
        WebForm.walkComponents(this, requirer);
        WebForm.walkControls(this.band, requirer);
        if (this.band.toolbar != null) {
            WebForm.walkControls(this.band.toolbar, requirer);
        }
        WebScript.required(this.script, requiresJs);
        int n = ico = this.icon != 0 ? this.icon : 45;
        if (!task.inline) {
            for (String r : requiresCss) {
                writer.append("<link rel='stylesheet' type='text/css' href='").append(task.root).append("/module/").append(r).append("'/>\n");
            }
            writer.append("<link rel='shortcut icon' href='").append(task.root).append("/static/images/icons/img").append(Integer.toString(ico)).append(".ico'/>\n");
            writer.append("<script type='text/javascript' src='").append(task.root).append("/static/core.js'></script>\n");
            writer.append("<script type='text/javascript' src='").append(task.root).append("/module/static.jquery.jquery'></script>\n");
            writer.append("</head>\n");
        }
        final IntegerHash componentsHash = new IntegerHash();
        final IntegerHash controlsHash = new IntegerHash();
        WebDatasource.ResolveGenerator dsgen = new WebDatasource.ResolveGenerator(this.scan());
        WebForm.walkComponents(this, new Visitor<WebComponent, RuntimeException>(){

            @Override
            public void visit(WebComponent o) {
                componentsHash.add(o);
            }
        });
        WebForm.walkControls(this.band, new Visitor<WebControl, RuntimeException>(){

            @Override
            public void visit(WebControl o) {
                controlsHash.add(o);
            }
        });
        Resolver resolver = new Resolver(task){

            @Override
            public ParametersList parameters() {
                return task.getParameters();
            }

            @Override
            public Constants constants() {
                return task.getConstants();
            }

            @Override
            public WebComponent resolveComponent(int id) {
                return (WebComponent)componentsHash.get(id);
            }

            @Override
            public WebControl resolveControl(int id) {
                return (WebControl)controlsHash.get(id);
            }
        };
        if (this.script != null) {
            resolver.hasFormScript = requirer.needFormScript;
        }
        writer.append(task.inline ? "<div" : "<body class='wcl-root wcl-cloak'");
        writer.append(" style='overflow:hidden;").append(WebControl.WebFont.DEFAULT.toCss());
        writer.append(task.inline ? "'" : ";width:100%'");
        writer.append(">\n");
        StringBuilder bandjson = new StringBuilder();
        this.band.generate(new HtmlWriter(writer), new JsonWriter(bandjson, 2), resolver);
        StringBuilder require = new StringBuilder();
        StringBuilder require_args = new StringBuilder();
        boolean nc = false;
        for (Map.Entry e : requiresJs.entrySet()) {
            if (nc) {
                require.append(',');
                require_args.append(", ");
            }
            nc = true;
            require.append("\n\t\t").append(JSON.toString(e.getKey()));
            require_args.append((String)e.getValue());
        }
        writer.append("<script type='text/javascript'>\n");
        String funcName = "form" + Long.toString((long)this.node.getId());
        writer.append("function ").append(funcName).append("(args){\n");
        if (task.inline) {
            StringBuilder require_css = new StringBuilder();
            nc = false;
            for (String string : requiresCss) {
                if (nc) {
                    require_css.append(',');
                }
                nc = true;
                require_css.append("\n\t\t").append(JSON.toString(string));
            }
            writer.append("\trequire([" + require_css + "\n\t]);\n");
        }
        writer.append("\treturn require([" + require + "\n\t], function( " + require_args + " ) {\n\t\tvar components = {};\n\t\tvar datamodel = components[0] = components.datamodel = new (CLASS({constructor:function(){\n\t\t\tDM.Datamodel.constructor.call( this, args.datamodel );\n\t\t\tvar datasources = this._datasources;\n\t\t\tfor ( var i in args.dsmappings )\n\t\t\t\tdatasources[i] = components[i] = args.dsmappings[i];\n");
        StringBuilder pvalues = new StringBuilder();
        WebForm.generateParametersBindingsTo(pvalues, task.getParameters(), "datasources", "\n\t\t\t\t", true, null);
        writer.append("\t\t\tvar pvalues = {").append(pvalues).append("};\n\t\t\tif ( args.parameters )\n\t\t\t\tpvalues = function(pp){return args.parameters(pp, pvalues);};\n\t\t\tvar parameters = this._parameters = datasources[-1] = components[-1] = new DM.Parameters({");
        StringBuilder params = new StringBuilder();
        WebForm.generateParametersTo(this.getOwnerId(), params, task.getParameters(), "\n\t\t\t\t\t");
        writer.append(params).append("\n\t\t\t\t},pvalues\n\t\t\t);\n");
        for (DatasourceUsage.Scanner.Fields.Dir dir : dsgen.scanner.directories) {
            WebDatasource.generateDirectory(this.getOwnerId(), dir.id, writer, dir.fields);
        }
        dsgen.generate(writer, resolver);
        if (task.locator != null && !task.locator.steps.isEmpty()) {
            writer.append("\t\t\tthis._locates = {");
            boolean bl = false;
            for (Task.Locator.Step s : task.locator.steps) {
                boolean bl2;
                if (bl2) {
                    writer.append(',');
                }
                bl2 = true;
                writer.append("\n\t\t\t\t").append(Integer.toString(s.dsid)).append(":[").append(JSON.toString(s.fields)).append(',').append(JSON.toString(s.values)).append(']');
            }
            writer.append("\n\t\t\t};\n");
        }
        writer.append("\t\t}},DM.Datamodel))();\n");
        writer.append("\t\tif(args.mform)\n");
        writer.append("\t\targs.mform.onBeforeUserChange = function(){var ua = datamodel._action(2); return !ua || confirm('\u0412\u0441\u0435 \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0431\u0443\u0434\u0443\u0442 \u043f\u043e\u0442\u0435\u0440\u044f\u043d\u044b.\\n\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?');};\n");
        WebForm.walkComponents(this, new Visitor<WebComponent, IOException>(){

            @Override
            public void visit(WebComponent o) throws IOException {
                if (o != WebForm.this) {
                    o.generate(writer, "\t\t", task);
                }
            }
        });
        writer.append("\t\tfunction cbi(id){var r=args.root.find('#'+id)[0];if(!r)throw '!'+id;return r;};\n");
        WebForm.walkControls(this.band, new Visitor<WebControl, IOException>(){

            @Override
            public void visit(WebControl o) throws IOException {
                if (o instanceof WebControl.JSGenerator) {
                    ((WebControl.JSGenerator)((Object)o)).generate(writer, "\t\t", task);
                }
            }
        });
        if (this.script != null && requirer.needFormScript) {
            int n2;
            int n3;
            String pn;
            boolean bl;
            writer.append("var __scriptNames = {};");
            writer.append("\nfunction _formScript(){");
            if (requirer.modules != null) {
                for (WebScript.ScriptModule scriptModule : requirer.modules) {
                    String text = scriptModule.getScriptModuleText();
                    if (Strings.isVoid(text)) {
                        writer.append("\n\t").append(scriptModule.getScriptModuleName()).append("={}");
                        continue;
                    }
                    writer.append("\n\tvar ").append(scriptModule.getScriptModuleName()).append("=function(){");
                    writer.append("\n\t\tvar exports={};");
                    writer.append("\n").append(text);
                    writer.append("\n\t\treturn exports");
                    writer.append("\n\t}();");
                }
            }
            writer.append("\n\tvar parameters={");
            int n4 = 32;
            boolean bl3 = false;
            for (Parameter p : task.getParameters().values()) {
                bl = true;
                pn = p.getName();
                if (Strings.isVoid(pn)) continue;
                writer.append("\n\t\t").append((char)n3).append(pn).append(": null");
                n3 = 44;
            }
            writer.append("\n\t\t").append((char)n3).append("apply:function() { datamodel._parameters._touch(); }");
            writer.append("\n\t}");
            if (requirer.scriptNames != null) {
                for (String scriptName : requirer.scriptNames) {
                    writer.append("\n\tvar ").append(scriptName).append("=null;");
                }
            }
            writer.append("\n");
            writer.append(this.script);
            writer.append("\n\t return {");
            int n5 = 32;
            if (requirer.scriptEvents != null) {
                for (String event : requirer.scriptEvents) {
                    writer.append("\n\t\t").append((char)n2).append(event).append(": ").append(event);
                    n2 = 44;
                }
            }
            writer.append("\n\t\t").append((char)n2).append("_reg_component: function(sn, so) { __scriptNames[sn] = so; }");
            writer.append("\n\t\t,").append("init: function() {");
            if (bl) {
                for (Parameter p : task.getParameters().values()) {
                    pn = p.getName();
                    if (Strings.isVoid(pn)) continue;
                    writer.append("\n\t\t\tparameters.").append(pn).append("=datamodel._make_param_so(datamodel._parameters, datamodel._parameters._fbyname['").append(pn).append("']);");
                }
            }
            if (requirer.scriptNames != null) {
                for (String scriptName : requirer.scriptNames) {
                    writer.append("\n\t\t\t").append(scriptName).append("=__scriptNames['").append(scriptName).append("'];");
                }
            }
            writer.append("\n\t\t\t__scriptNames=null;");
            writer.append("\n\t\t}");
            writer.append("\n\t}\n}");
            writer.append("\n\t\tvar formScript = _formScript();\n");
        }
        writer.append("\t\tfunction cact(c, i){\n\t\t\tvar ll = [], executing = false;\n\t\t\tfunction update(){\n\t\t\t\tvar v = r();\n\t\t\t\tfor(var j=0;j<ll.length;j++)\n\t\t\t\t\tll[j](v);\n\t\t\t}\n\t\t\tfunction always(){executing=false;update();}\n\t\t\tvar r = function(){var a=c._action(i);return !a?null:function(e){\n\t\t\t\texecuting=true;\n\t\t\t\tupdate();\n\t\t\t\tAsyncs.when(a({event:e||window.event})).then(always,always);\n\t\t\t}};\n\t\t\tr._listen = function(l){ll.push(l);};\n\t\t\tc._listen(update);\n\t\t\treturn r;\n\t\t}\n");
        writer.append("\t\targs.mitem.appendItem(").append(bandjson).append(");\n");
        if (!task.inline) {
            writer.append("\t\targs.toolbar.addButton({icon:112,caption:'\u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c',onclick:cact(datamodel,1)});\n\t\targs.toolbar.addButton({icon:109,caption:'\u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c',onclick:cact(datamodel,2)});\n\t\targs.toolbar.addButton({icon:2204,caption:'\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c',onclick:cact(datamodel,3)});\n");
            for (Parameter parameter : task.getParameters().values()) {
                if (parameter.hidden()) continue;
                writer.append("\t\targs.toolbar.addButton({icon:2155,caption:'\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b',onclick:cact(datamodel,4)});\n");
                break;
            }
        }
        if (this.band.toolbar != null && this.band.toolbar.visible) {
            writer.append("\t\targs.menu.appendItem(");
            this.band.toolbar.generate(null, new JsonWriter(writer, 1), resolver);
            writer.append(");\n");
        }
        if (this.script != null && requirer.needFormScript) {
            writer.append("\t\tformScript.init();\n");
        }
        writer.append("\t\tWF.updateIcons(args.root);\n\t\tWF.autoFocus(args.root);\n\t\tvar postactions = [];\n\t\tfor ( var i = 0; i < arguments.length; i++ ) {\n\t\t\tvar init = arguments[i].initialization;\n\t\t\tif ( (typeof init) !== 'function' )\n\t\t\t\tcontinue;\n\t\t\tvar pa = init( args.root, components, function(name){return eval(name)} );\n\t\t\tpa && postactions.push( pa );\n\t\t}\n\t\tfor ( var i = 0; i < postactions.length; i++ )\n\t\t\tpostactions[i]();\n\t\tfor ( var i in components )\n\t\t\tcomponents[i]._postinit && components[i]._postinit( components );\n\t\treturn {components:components};");
        writer.append("\n\t});\n}\n");
        if (!task.inline) {
            String string = "";
            double d = this.band.formMaxWidth;
            if (d < 0.0) {
                d = 0.0;
            }
            String string2 = string + ",maxw: '" + d + "mm'";
            d = this.band.formMaxHeight;
            if (d < 0.0) {
                d = 0.0;
            }
            String string3 = string2 + ",maxh: '" + d + "mm'";
            d = this.band.formMinWidth;
            if (d < 0.0) {
                d = 0.0;
            }
            String string4 = string3 + ",minw: '" + d + "mm'";
            d = this.band.formMinHeight;
            if (d < 0.0) {
                d = 0.0;
            }
            String string6 = string4 + ",minh: '" + d + "mm'";
            string6 = string6 + ",flowType: " + WebBand.calcFlowType(2, this.band.formHorzAlign, this.band.formVertAlign);
            writer.append("\n$(document).ready(function(){\n\trequire(['inform.agent.web.forms.WebForm','static.wcl.layouts.Flow','static.wcl.Utils'],function(F,Flow,Utils){\n\t\tF.mkMainForm({icon:" + ico + ",caption:" + JSON.toString(this.node.getName()) + string6 + ",onAfterUserChanged:function(){window.location.reload();},item:{_:Utils.Margin(Flow),type:Flow.VERT}}).then(function(f){\n\t\t\t").append(funcName).append("({\n\t\t\t\troot:$(f.element),\n\t\t\t\ttoolbar:f.toolbar,\n\t\t\t\tmform:f,\n\t\t\t\tmitem:f.item,\n\t\t\t\tmenu:f.menu\n\t\t\t}).fail(log.error);\n\t\t});\n\t});\n});");
        }
        writer.append("\n</script>\n");
        writer.append(!task.inline ? "</body>" : "</div>");
    }

    private static <E extends Throwable> void walkComponents(WebComponent root, Visitor<? super WebComponent, E> visitor) throws E {
        visitor.visit(root);
        if (root instanceof WebComponentContainer) {
            for (WebComponent c : ((WebComponentContainer)root).components) {
                WebForm.walkComponents(c, visitor);
            }
        }
    }

    private static <E extends Throwable> void walkControls(WebControl root, Visitor<? super WebControl, E> visitor) throws E {
        visitor.visit(root);
        if (root instanceof WebControlContainer) {
            for (WebControl c : ((WebControlContainer)root).controls) {
                WebForm.walkControls(c, visitor);
            }
        }
    }

    private static interface Visitor<T, E extends Throwable> {
        public void visit(T var1) throws E;
    }

    private static class Requirer
    implements Visitor<Object, RuntimeException> {
        public HashSet<String> scriptEvents = null;
        public ArrayList<String> scriptNames = null;
        public boolean needFormScript = false;
        public ArrayList<WebScript.ScriptModule> modules = null;
        private final Set<String> requiresCss;
        private final Map<String, String> requiresJs;
        private HashSet<String> uniqueNames = new HashSet();

        private Requirer(Set<String> requiresCss, Map<String, String> requiresJs) {
            this.requiresCss = requiresCss;
            this.requiresJs = requiresJs;
        }

        @Override
        public void visit(Object o) throws RuntimeException {
            IntegerHash.Entry wc;
            for (Class<?> cls = o.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
                JSRequire jsr = cls.getAnnotation(JSRequire.class);
                if (jsr == null) continue;
                for (String r : jsr.value()) {
                    if (r.startsWith("css!")) {
                        this.requiresCss.add("css!" + cls.getPackage().getName() + "." + r.substring(4));
                        continue;
                    }
                    if (r.indexOf(46) > 0) {
                        String[] sp = r.split("\\.");
                        this.requiresJs.put(r, sp[sp.length - 1]);
                        continue;
                    }
                    this.requiresJs.put(cls.getPackage().getName() + "." + r, r);
                }
            }
            if (o instanceof WebScript.EventHolder) {
                this.scriptEvents = ((WebScript.EventHolder)o).getScriptEvents(this.scriptEvents);
                if (this.scriptEvents != null) {
                    boolean bl = this.needFormScript = !this.scriptEvents.isEmpty();
                }
            }
            if (o instanceof WebControl) {
                wc = (WebControl)o;
                if (!((WebControl)wc).isSubControl && !Strings.isVoid(((WebControl)wc).name())) {
                    if (!this.uniqueNames.add(((WebControl)wc).name())) {
                        throw new InformException("\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0432\u043e\u0433\u043e \u0438\u043c\u0435\u043d\u0438 " + ((WebControl)wc).name());
                    }
                    if (this.scriptNames == null) {
                        this.scriptNames = new ArrayList();
                    }
                    this.scriptNames.add(((WebControl)wc).name());
                    this.needFormScript = true;
                }
            } else if (o instanceof WebComponent && !((WebComponent)(wc = (WebComponent)o)).isSubComponent() && !Strings.isVoid(((WebComponent)wc).name())) {
                if (!this.uniqueNames.add(((WebComponent)wc).name())) {
                    throw new InformException("\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0432\u043e\u0433\u043e \u0438\u043c\u0435\u043d\u0438 " + ((WebComponent)wc).name());
                }
                if (this.scriptNames == null) {
                    this.scriptNames = new ArrayList();
                }
                if (o instanceof WebScript.ScriptModule && ((WebScript.ScriptModule)o).getScriptType() == WebScript.ScriptType.ST_BROWSER_SIDE) {
                    if (this.modules == null) {
                        this.modules = new ArrayList();
                    }
                    this.modules.add((WebScript.ScriptModule)o);
                } else {
                    this.scriptNames.add(((WebComponent)wc).name());
                }
                this.needFormScript = true;
            }
        }
    }

    public static class Task
    extends AbstractScriptableTask {
        private static final AtomicInteger ID_GEN = new AtomicInteger();
        private final SSContext ssContext = new SSContext.DefaultContext();
        private final WebForm form;
        private final Locator locator;
        public final int generationId = ID_GEN.incrementAndGet();
        public final Session.User user;
        public final boolean inline;
        public final String root;

        private Task(Arg arg, ServerSideHost ssHost, WebForm form, Session.User user, boolean inline, String root) throws IOException {
            super(form.node, null, ssHost, arg.parameters, arg.constants, null);
            ((ScriptableHost)((Object)ssHost)).setTopLevelScope(this);
            ((ScriptableHost)((Object)ssHost)).setConstants(arg.constants);
            this.form = form;
            this.user = user;
            this.inline = inline;
            this.root = root;
            if (form.scriptS == null) {
                this.locator = null;
                return;
            }
            this.locator = new Locator();
            ScriptableObject.putConstProperty(this, "locator", this.locator);
            if (form.componentsData != null) {
                TaggedReader reader = new TaggedReader(form.componentsData);
                while (reader.next()) {
                    ServerSideComponent c;
                    if (reader.getCurrentTag() != 2 || (c = ComponentsFactory.readAndCreateComponent(this.ssContext, this, this, reader)) == null) continue;
                    c.setParentScope(this);
                    this.components.add(c);
                    Task.putConstProperty(this, c.getName(), c);
                }
                this.components.afterLoad();
            }
            WebForm.walkControls(form.band, new Visitor<WebControl, IOException>(){

                @Override
                public void visit(WebControl o) throws RuntimeException {
                    ScriptableObject.putConstProperty(this, o.name(), o);
                }
            });
        }

        private void execute() {
            try {
                this.execute(new AbstractScriptableTask.ExecuteAction<Void>(){

                    @Override
                    public Void execute(Context context) throws Exception {
                        context.evaluateString(this, form.scriptS, form.node.toLogString(), 1, null);
                        if (form.onInitialize != null) {
                            ScriptableObject.callMethod(context, this, form.onInitialize, null);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw InformException.wrap(e);
            }
        }

        private static class Locator
        extends SmartScriptableObject {
            final Collection<Step> steps = new ArrayList<Step>();

            private Locator() {
            }

            @SmartScriptableObject.FunctionTag
            public Locator locateById(Datasource ds, double rid) {
                this.steps.add(new Step(ds.getId(), Step.fids(-1), Step.vals(rid)));
                return this;
            }

            static class Step {
                final int dsid;
                final int[] fields;
                final Object[] values;

                Step(int dsid, int[] fields, Object[] values) {
                    this.dsid = dsid;
                    this.fields = fields;
                    this.values = values;
                }

                static int[] fids(int ... arr) {
                    return arr;
                }

                static Object[] vals(Object ... arr) {
                    return arr;
                }
            }
        }

        public static class Arg {
            public final Constants constants;
            public final ParametersList parameters;

            public Arg(Constants constants, ParametersList parameters) {
                this.constants = constants;
                this.parameters = parameters;
            }
        }
    }

    public static abstract class NodeData<T, E extends Exception> {
        public final double id;
        private T data;
        private long time;

        public NodeData(double nodeId) {
            this.id = nodeId;
        }

        public T fetch() throws E {
            Node n = MtdEngine.getNode(this.id);
            if (n == null) {
                this.data = null;
                return null;
            }
            long mt = n.getModificationContentTime();
            if (mt > this.time) {
                this.data = this.read(n);
                this.time = mt;
            }
            return this.data;
        }

        protected abstract T read(Node var1) throws E;
    }
}

