/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms.components;

import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.WebForm;
import inform.agent.web.forms.components.WebComponent;
import inform.agent.web.forms.components.WebComponentContainer;
import java.io.IOException;

@JSRequire(value={"WebBlobManager"})
public class WebBlobManager
extends WebComponent
implements DatasourceUsage {
    private static final int TAG_WEB_BLOB_DATASOURCE = 41;
    private static final int TAG_WEB_BLOB_FIELD = 42;
    private static final int TAG_WEB_BLOB_CAPTION_FIELD = 43;
    private static final int TAG_WEB_BLOB_EXT_FIELD = 44;
    private int dsid;
    private int[] fieldId;
    private int[] captFieldId;
    private int[] extFieldId;

    public WebBlobManager(int id, int options, WebComponentContainer parent) {
        super(id, parent, false);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 41: {
                this.dsid = reader.getInt();
                break;
            }
            case 42: {
                this.fieldId = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 43: {
                this.captFieldId = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 44: {
                this.extFieldId = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    public void generate(Appendable out, String pad, WebForm.Task task) throws IOException {
        out.append(pad).append("components[").append(Integer.toString(this.id)).append("] = new WebBlobManager({");
        out.append("ownerId:").append(NumberConverter.doubleToString(this.getOwnerId()));
        if (this.dsid != 0) {
            if (this.fieldId != null) {
                out.append("\n\t").append(pad).append(",content:datamodel._datasources[").append(Integer.toString(this.dsid)).append("]._fbyid[").append(Integer.toString(this.fieldId[0])).append(']');
            }
            if (this.captFieldId != null) {
                out.append("\n\t").append(pad).append(",caption:datamodel._datasources[").append(Integer.toString(this.dsid)).append("]._fbyid[").append(Integer.toString(this.captFieldId[0])).append(']');
            }
            if (this.extFieldId != null) {
                out.append("\n\t").append(pad).append(",extension:datamodel._datasources[").append(Integer.toString(this.dsid)).append("]._fbyid[").append(Integer.toString(this.extFieldId[0])).append(']');
            }
        }
        out.append('\n').append(pad).append("});\n");
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        out.append((Object)this, this.dsid, this.fieldId);
        out.append((Object)this, this.dsid, this.captFieldId);
        out.append((Object)this, this.dsid, this.extFieldId);
    }
}

