/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms.components;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.collections.Cursor;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.LinkField;
import inform.agent.db.SortDirection;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.sql.ExtraField;
import inform.agent.web.JSON;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebForm;
import inform.agent.web.forms.components.WebComponentContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class WebDatasource
extends WebComponentContainer
implements DatasourceUsage {
    private static final int TAG_SS_DATASOURCE_TABLE_ID = 40;
    private static final int TAG_SS_DATASOURCE_SEARCH_ID = 41;
    private static final int TAG_SS_DATASOURCE_PARAMS = 42;
    private static final int TAG_SS_DATASOURCE_SORT_ASCENDING = 44;
    private static final int TAG_SS_DATASOURCE_SORT_DESCENDING = 45;
    private static final int TAG_SS_DATASOURCE_SORT_FIELD = 43;
    private static final int TAG_SS_DATASOURCE_SCROLLABLE = 46;
    private static final int TAG_SS_DATASOURCE_KIND = 47;
    private static final int TAG_SS_DATASOURCE_BLOB_RECEIVING = 48;
    private static final int TAG_SS_DATASOURCE_LOCK_RECORDS = 49;
    private static final int TAG_SS_DATASOURCE_RELATIONS = 50;
    private static final int TAG_MASTER_FIELD = 1;
    private static final int TAG_DATASOURCE = 2;
    private static final int TAG_FIELD = 3;
    private static final int TAG_SS_CHILD_DATASOURCE = 51;
    private static final int TAG_SS_SORTING = 52;
    private static final int TAG_SS_SORTING_USER = 1;
    private static final int TAG_SS_DATALINK = 53;
    private static final int TAG_SS_ACTUAL_POINT_VALUE = 54;
    private static final int TAG_SS_ACTUAL_POINT_PARAM = 55;
    private static final int TAG_SS_DSORT = 56;
    private static final int TAG_DSORT_ID = 1;
    private static final int TAG_DSORT_FIELDS = 3;
    private double tableId;
    private WebForm.NodeData<SD, IOException> search;
    private byte[] pbindings;
    private int linkId;
    private final Sorting sorting = new Sorting(1000);
    private final Collection<Sorting> sortings = new ArrayList<Sorting>();
    private final Collection<Relation> relations = new ArrayList<Relation>();
    private final double ownerId;

    public WebDatasource(int id, int options, WebComponentContainer parent) {
        super(id, parent, false);
        this.ownerId = parent != null ? parent.getOwnerId() : 0.0;
        this.sortings.add(this.sorting);
    }

    public double table() {
        return this.tableId;
    }

    @Override
    public void load(TaggedReader reader) throws IOException {
        super.load(reader);
        this.sorting.user = this.sorting.user && this.sorting.fields.size() == 1 && this.sorting.fields.get((int)0).fpath.length == 1;
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 40: {
                reader.skip();
                this.tableId = reader.getDouble();
                break;
            }
            case 41: {
                this.search = new WebForm.NodeData<SD, IOException>(reader.getNodeID()){

                    @Override
                    protected SD read(Node node) throws IOException {
                        SD result = new SD();
                        TaggedReader reader = new TaggedReader(((BasicNode)node).getContent());
                        if (node.getType() == 48) {
                            block4: while (reader.next()) {
                                if (reader.getCurrentTag() != 152) continue;
                                TaggedReader stream = new TaggedReader(reader.getSubStream());
                                while (stream.next()) {
                                    if (stream.getCurrentTag() != 153) continue;
                                    result.parameters = stream.getSubStreamData();
                                    continue block4;
                                }
                            }
                        } else {
                            while (reader.next()) {
                                switch (reader.getCurrentTag()) {
                                    case 153: {
                                        result.parameters = reader.getSubStreamData();
                                        break;
                                    }
                                    case 32: {
                                        result.extraFields.add(new ExtraField(reader.getSubStreamReader()));
                                    }
                                }
                            }
                        }
                        return result;
                    }
                };
                break;
            }
            case 42: {
                reader.skip();
                this.pbindings = reader.getSubStreamData();
                break;
            }
            case 43: {
                int fid = reader.getInt();
                SortDirection dir = SortDirection.ASCENDING;
                switch (reader.getNextTag()) {
                    case 44: {
                        dir = SortDirection.ASCENDING;
                        break;
                    }
                    case 45: {
                        dir = SortDirection.DESCENDING;
                    }
                }
                this.sorting.fields.add(new SortingField(dir, fid));
                break;
            }
            case 50: {
                this.relations.add(new Relation(reader.getSubStreamReader()));
                break;
            }
            case 51: {
                this.components.add(this.loadTypedComponent(reader));
                break;
            }
            case 52: {
                this.sorting.fields.clear();
                this.loadSorting(reader.getSubStreamReader(), this.sorting);
                break;
            }
            case 53: {
                this.linkId = reader.getInt();
                break;
            }
            case 56: {
                TaggedReader stream = reader.getSubStreamReader();
                Sorting s = null;
                while (stream.next()) {
                    switch (stream.getCurrentTag()) {
                        case 1: {
                            s = new Sorting(stream.getInt());
                            this.sortings.add(s);
                            break;
                        }
                        case 3: {
                            this.loadSorting(stream.getSubStreamReader(), s);
                        }
                    }
                }
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    private void loadSorting(TaggedReader reader, Sorting sorting) throws IOException {
        int[] fpath = null;
        SortDirection dir = SortDirection.ASCENDING;
        while (reader.next()) {
            block0 : switch (reader.getCurrentTag()) {
                case 1: {
                    sorting.user = true;
                    break;
                }
                case 43: {
                    fpath = LittleEndian.toIntArray(reader.getRaw());
                    switch (reader.getNextTag()) {
                        case 44: {
                            dir = SortDirection.ASCENDING;
                            break block0;
                        }
                        case 45: {
                            dir = SortDirection.DESCENDING;
                        }
                    }
                }
            }
            if (fpath == null || fpath.length <= 0) continue;
            sorting.fields.add(new SortingField(dir, fpath));
        }
    }

    protected void generate(Appendable out, ResolveGenerator gen, IntegerSet fields, Resolver resolver) throws IOException {
        WebForm.Task arg = resolver.arg;
        double nodeId = this.tableId;
        StringBuilder params = new StringBuilder();
        StringBuilder pbinds = new StringBuilder();
        StringBuilder fbinds = new StringBuilder();
        SD sd = null;
        if (this.search != null) {
            nodeId = this.search.id;
            sd = this.search.fetch();
            ParametersList plist = new ParametersList();
            if (sd.parameters != null) {
                plist.load(arg.getConstants(), new TaggedReader(sd.parameters), Core.serverTimeZoneHost);
            }
            if (this.pbindings != null) {
                plist.loadParametersBindings(arg.getParameters(), arg.getConstants(), new TaggedReader(this.pbindings));
            }
            WebDatasource.generateParametersTo(this.ownerId, params, plist, "\n\t\t\t\t\t");
            IntegerSet deps = new IntegerSet();
            WebDatasource.generateParametersBindingsTo(pbinds, plist, "datasources", "\n\t\t\t\t\t", false, deps);
            for (Cursor.Integer i : deps) {
                gen.generate(i.value, out, resolver);
            }
        }
        boolean nc = false;
        if (this.linkId != 0) {
            WebDatasource pds = (WebDatasource)this.parent;
            TableDescriptor ptd = TableDescriptor.get(pds.tableId);
            LinkDescriptor ld = ptd.getLinkList().getLink(this.linkId);
            for (LinkField lf : ld.getFields()) {
                if (nc) {
                    fbinds.append(',');
                }
                fbinds.append("\n\t\t\t\t\t").append(lf.getFieldId()).append(':');
                block0 : switch (lf.getLinkType()) {
                    case 2: {
                        gen.generate(pds.id, out, resolver);
                        fbinds.append("datasources[").append(pds.id).append("]._fbyid[").append(lf.getLinkField()).append(']');
                        break;
                    }
                    case 3: {
                        gen.generate(pds.id, out, resolver);
                        fbinds.append("datasources[").append(pds.id).append("]._fbyid[-1]");
                        break;
                    }
                    case 1: {
                        switch (lf.getConstType()) {
                            case INTEGER: 
                            case BOOLEAN: 
                            case FLOAT: 
                            case INTERVAL: 
                            case DIRECTORY: 
                            case METATREE_NODE: 
                            case DATE_TIME: {
                                fbinds.append(lf.getNumberValue());
                                break block0;
                            }
                            case STRING: 
                            case BIG_NUMBER: {
                                fbinds.append(JSON.toString(lf.getStringValue()));
                                break block0;
                            }
                        }
                        fbinds.append("null");
                        break;
                    }
                    case 4: {
                        fbinds.append("null");
                    }
                }
                nc = true;
            }
        }
        for (Relation r : this.relations) {
            if (nc) {
                fbinds.append(',');
            }
            fbinds.append("\n\t\t\t\t\t").append(r.fieldId).append(':');
            gen.generate(r.linkDaatsourceId, out, resolver);
            fbinds.append("datasources[").append(r.linkDaatsourceId).append("]._fbyid[").append(r.linkFieldId).append(']');
        }
        out.append("\t\t\tif ( !datasources[").append(Integer.toString(this.id)).append("] )\n");
        out.append("\t\t\tcomponents[").append(Integer.toString(this.id)).append("] = datasources[").append(Integer.toString(this.id)).append("] = new DM.TableDatasource(this,{id:").append(Integer.toString(this.id)).append(",table:").append(Long.toString((long)this.tableId));
        TableDescriptor td = TableDescriptor.get(this.tableId);
        if (td.getKind() != TableDescriptor.Kind.VIRTUAL) {
            out.append(",node:").append(Long.toString((long)nodeId));
        } else {
            if (this.search != null) {
                out.append(",node:").append(Long.toString((long)nodeId));
            }
            out.append(",virtual:true");
        }
        out.append(",ownerId:'").append(NumberConverter.doubleToString(this.ownerId)).append("'");
        WebDatasource.appendFieldsTo(out, td, fields, sd == null ? null : sd.extraFields);
        FieldDescriptor display = null;
        for (FieldDescriptor fd : td.getFields()) {
            if (display != null && fd.calcUsedForParamsPriority() <= display.calcUsedForParamsPriority()) continue;
            display = fd;
        }
        if (display != null) {
            out.append("\n\t\t\t\t,display:").append(Integer.toString(display.getId()));
        }
        if (!this.sorting.fields.isEmpty()) {
            out.append("\n\t\t\t\t,sorting:");
            this.sorting.jsonify(out);
        }
        if (!this.sortings.isEmpty()) {
            nc = false;
            out.append("\n\t\t\t\t,sortings:{");
            for (Sorting s : this.sortings) {
                if (nc) {
                    out.append(',');
                }
                nc = true;
                out.append("\n\t\t\t\t\t").append(Integer.toString(s.id)).append(':');
                s.jsonify(out);
            }
            out.append("\n\t\t\t\t}");
        }
        if (params.length() > 0) {
            out.append("\n\t\t\t\t,parameters:{").append(params).append("\n\t\t\t\t}");
        }
        if (pbinds.length() > 0) {
            out.append("\n\t\t\t\t,p_bindings:{").append(pbinds).append("\n\t\t\t\t}");
        }
        if (fbinds.length() > 0) {
            out.append("\n\t\t\t\t,f_bindings:{").append(fbinds).append("\n\t\t\t\t}");
        }
        out.append("\n\t\t\t});\n");
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        if (this.pbindings != null) {
            out.appendPBindings(this, new TaggedReader(this.pbindings));
        }
        for (SortingField sortingField : this.sorting.fields) {
            out.append((Object)this, this.id, sortingField.fpath);
        }
        for (Sorting sorting : this.sortings) {
            for (SortingField f : sorting.fields) {
                out.append((Object)this, this.id, f.fpath);
            }
        }
        if (this.linkId != 0) {
            WebDatasource pds = (WebDatasource)this.parent;
            TableDescriptor tableDescriptor = TableDescriptor.get(pds.tableId);
            LinkDescriptor ld = tableDescriptor.getLinkList().getLink(this.linkId);
            if (ld != null) {
                for (LinkField lf : ld.getFields()) {
                    out.append((Object)this, this.id, lf.getFieldId());
                    switch (lf.getLinkType()) {
                        case 2: {
                            out.append((Object)this, pds.id, lf.getLinkField());
                            break;
                        }
                        case 3: {
                            out.append((Object)this, pds.id, -1);
                        }
                    }
                }
            }
        }
    }

    public DataType resolveDataType(int ... fpath) throws IOException {
        ExtraField ef;
        if (fpath.length == 1 && this.search != null && (ef = this.search.fetch().extraFields.get(fpath[0])) != null) {
            return ef.dataType;
        }
        if (fpath.length == 1 && fpath[0] == -1) {
            return DataType.PRIMARY_KEY;
        }
        FieldDescriptor fd = this.resolveFieldDescriptor(fpath);
        if (fd != null) {
            return fd.getType();
        }
        return DataType.STRING;
    }

    public FieldDescriptor resolveFieldDescriptor(int ... fpath) throws IOException {
        TableDescriptor td = TableDescriptor.get(this.tableId);
        return WebDatasource.resolveFieldDescriptor(td, fpath);
    }

    public static FieldDescriptor resolveFieldDescriptor(TableDescriptor td, int ... fpath) throws IOException {
        FieldDescriptor fd = null;
        for (int i = 0; i < fpath.length; ++i) {
            fd = td.getFieldDescriptor(fpath[i]);
            if (fd == null) {
                return fd;
            }
            double ref = fd.getReferenceId();
            if (ref == 0.0) break;
            td = TableDescriptor.get(ref);
        }
        return fd;
    }

    public static void generateDirectory(double ownerId, double nodeId, Appendable out, IntegerSet fields) throws IOException {
        TableDescriptor td = TableDescriptor.get(nodeId);
        String _id = Long.toString((long)nodeId);
        out.append("\t\t\tcomponents[").append(_id).append("] = datasources[").append(_id).append("] = new DM.Directory(this,{id:").append(Long.toString((long)nodeId)).append(",node:").append(Long.toString((long)nodeId));
        out.append(",ownerId:'").append(NumberConverter.doubleToString(ownerId)).append("'");
        WebDatasource.appendFieldsTo(out, td, fields, null);
        out.append("});\n");
    }

    private static void appendFieldsTo(Appendable out, TableDescriptor td, IntegerSet fields, IntegerHash<ExtraField> extra) throws IOException {
        out.append("\n\t\t\t\t,fields:{");
        boolean nc = false;
        IntegerSet used = new IntegerSet();
        for (FieldDescriptor fd : td.getPrimaryKeyFields()) {
            if (nc) {
                out.append(',');
            }
            out.append("\n\t\t\t\t\t");
            WebDatasource.appendFieldTo(out, fd, true);
            nc = true;
            used.add(fd.getId());
        }
        for (FieldDescriptor fd : td.getFields()) {
            if (!fields.contains(fd.getId()) || used.contains(fd.getId())) continue;
            if (nc) {
                out.append(',');
            }
            out.append("\n\t\t\t\t\t");
            WebDatasource.appendFieldTo(out, fd, false);
            nc = true;
        }
        if (extra != null) {
            for (ExtraField ef : extra) {
                if (!fields.contains(ef.id)) continue;
                if (nc) {
                    out.append(',');
                }
                out.append("\n\t\t\t\t\t");
                WebDatasource.appendExtraFieldTo(out, ef);
                nc = true;
            }
        }
        out.append("\n\t\t\t\t}");
    }

    private static void appendIntArray(Appendable out, int ... ints) throws IOException {
        out.append('[');
        boolean nc = false;
        for (int i : ints) {
            if (nc) {
                out.append(',');
            }
            nc = true;
            out.append(Integer.toString(i));
        }
        out.append(']');
    }

    private static void appendFieldTo(Appendable out, FieldDescriptor fd, boolean key) throws IOException {
        Iterator<FieldDescriptor.LookupField> mlfi;
        boolean nq;
        boolean bl = nq = fd.getId() < 0;
        if (nq) {
            out.append('\"');
        }
        out.append(Integer.toString(fd.getId()));
        if (nq) {
            out.append('\"');
        }
        out.append(":{type:").append(Integer.toString(fd.getType().getTypeId()));
        out.append(",caption:").append(JSON.toString(fd.getCaption()));
        if (fd.getType() == DataType.DIRECTORY) {
            out.append(",directory:{table:").append(Long.toString((long)fd.getReferenceId())).append(",field:-1,display:").append(Integer.toString(fd.getRefFieldId())).append('}');
        }
        if (key) {
            out.append(",key:true");
        }
        if (fd.getAutoValueGenerator() != FieldDescriptor.AutoValueGenerator.NONE) {
            out.append(",gen:true");
        }
        if ((mlfi = fd.multiLookupFields().iterator()).hasNext()) {
            out.append(",multilookup:[");
            WebDatasource.appendIntArray(out, mlfi.next().path);
            while (mlfi.hasNext()) {
                out.append(',');
                WebDatasource.appendIntArray(out, mlfi.next().path);
            }
            out.append(']');
        }
        out.append('}');
    }

    private static void appendExtraFieldTo(Appendable out, ExtraField ef) throws IOException {
        out.append(Integer.toString(ef.id));
        out.append(":{type:").append(Integer.toString(ef.dataType.getTypeId()));
        out.append(",caption:").append(JSON.toString(ef.caption));
        out.append('}');
    }

    private static class SD {
        byte[] parameters;
        IntegerHash<ExtraField> extraFields = new IntegerHash();

        private SD() {
        }
    }

    private static class Relation {
        final int fieldId;
        final int linkDaatsourceId;
        final int linkFieldId;

        Relation(TaggedReader reader) throws IOException {
            int fid = 0;
            int lds = 0;
            int lfid = 0;
            while (reader.next()) {
                if (reader.getCurrentTag() != 1) continue;
                fid = reader.getInt();
                lds = reader.getInt(2);
                lfid = reader.getInt(3);
            }
            this.fieldId = fid;
            this.linkDaatsourceId = lds;
            this.linkFieldId = lfid;
        }
    }

    private static class Sorting {
        final int id;
        final List<SortingField> fields = new ArrayList<SortingField>(1);
        boolean user;

        Sorting(int id) {
            this.id = id;
        }

        void jsonify(Appendable out) throws IOException {
            out.append("{paths:[");
            boolean nc = false;
            for (SortingField s : this.fields) {
                if (nc) {
                    out.append(',');
                }
                out.append('[').append(Integer.toString(s.direction.ordinal())).append(',').append(Arrays.toString(s.fpath)).append(']');
                nc = true;
            }
            out.append(']');
            if (this.user) {
                out.append(",user:true");
            }
            out.append('}');
        }
    }

    private static class SortingField {
        final SortDirection direction;
        final int[] fpath;

        SortingField(SortDirection direction, int ... fpath) {
            this.direction = direction;
            this.fpath = fpath;
        }
    }

    public static class ResolveGenerator {
        public final DatasourceUsage.Scanner scanner;
        private final IntegerSet generated = new IntegerSet();
        private final IntegerSet inprogress = new IntegerSet();

        public ResolveGenerator(DatasourceUsage.Scanner scanner) {
            this.scanner = scanner;
        }

        void generate(int dsid, Appendable out, Resolver resolver) throws IOException {
            DatasourceUsage.Scanner.Fields.Ds fieldsDs;
            if (dsid == -1) {
                return;
            }
            if (this.generated.contains(dsid)) {
                return;
            }
            if (!this.inprogress.add(dsid)) {
                throw new InformException("Cyclic error");
            }
            WebDatasource ds = (WebDatasource)resolver.resolveComponent(dsid);
            if (ds != null && (fieldsDs = this.scanner.datasources.get(dsid)) != null) {
                ds.generate(out, this, fieldsDs.fields, resolver);
            }
            this.generated.add(dsid);
        }

        public void generate(Appendable out, Resolver resolver) throws IOException {
            for (DatasourceUsage.Scanner.Fields.Ds ds : this.scanner.datasources) {
                if (this.generated.contains(ds.key())) continue;
                this.generate(ds.key(), out, resolver);
            }
        }
    }
}

