/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports;

import inform.adt.InformException;
import inform.adt.collections.IntegerList;
import inform.adt.taggedio.TaggedReader;
import inform.agent.ServerSideHost;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.scripts.AbstractScriptableTask;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.ComponentsFactory;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersDatasource;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.Task;
import inform.agent.web.Session;
import inform.agent.web.WebServerSideHost;
import inform.agent.web.reports.controls.ReportBand;
import inform.agent.web.reports.document.Document;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.mozilla.javascript.Context;

public class ReportTask
extends AbstractScriptableTask {
    public static final int REPORT_OUTPUT_ASYNCFORM = 0;
    public static final int REPORT_OUTPUT_HTML = 1;
    public static final int REPORT_OUTPUT_XLSX = 2;
    public static final int REPORT_OUTPUT_DOCX = 3;
    public static final int REPORT_OUTPUT_TXT = 4;
    public static final int REPORT_OUTPUT_PDF = 5;
    public static final int REPORT_OUTPUT_ODT = 6;
    public static final int REPORT_OUTPUT_ODS = 7;
    private static final int TAG_WEB_FORM_SCRIPT = 11;
    private static final int TAG_WEB_COMPONENTS = 12;
    private static final int TAG_WEB_ON_INITILIZE = 13;
    private static final int TAG_WEB_BAND = 14;
    public static final int TAG_WEB_REPORT_OUTPUT = 15;
    public static final int TAG_WEB_REPORT_OUTPUTS = 16;
    private static final int TAG_WEB_ON_ENDPAGE = 19;
    private final String script;
    private final ReportBand controls;
    private final String onInitialize;
    private final String onEndPage;
    private final int output;
    private final int outputsMask;
    private final boolean isClientReport;
    private final byte[] nodeContent;
    private Document document = null;
    private Context context = null;
    private ArrayList<ArrayList<ArrayList<String>>> pageContent = null;
    private IntegerList beginRows = null;
    private IntegerList endRows = null;

    public ReportTask(ServerSideHost ssHost, BasicNode node, byte[] content, byte[] constants, ParametersList params, boolean isClientReport) throws InformException, IOException {
        super(node, null, ssHost, params != null ? params : new ParametersList(), null, constants);
        this.isClientReport = isClientReport;
        if (isClientReport) {
            this.controls = null;
            this.output = 0;
            this.outputsMask = 0;
            this.script = "";
            this.onInitialize = null;
            this.onEndPage = null;
            this.nodeContent = content;
        } else {
            this.nodeContent = null;
            if (content == null) {
                content = node.getContent();
            }
            this.controls = new ReportBand((Task)this, null, new ComponentHeader(0, 0, 0));
            TaggedReader in = new TaggedReader(content);
            String _script = "";
            String _initCall = null;
            String _endPageCall = null;
            int _out = 0;
            int _outm = 0;
            block10: while (in.next()) {
                block0 : switch (in.getCurrentTag()) {
                    case 152: {
                        if (params != null) break;
                        TaggedReader r = in.getSubStreamReader();
                        while (r.next()) {
                            if (r.getCurrentTag() != 153) continue;
                            this.parameters.load(this.constants, r.getSubStreamReader(), ssHost);
                            break block0;
                        }
                        continue block10;
                    }
                    case 11: {
                        _script = in.getAnsi();
                        break;
                    }
                    case 14: {
                        this.controls.load(in.getSubStreamReader());
                        break;
                    }
                    case 12: {
                        TaggedReader r = in.getSubStreamReader();
                        while (r.next()) {
                            ServerSideComponent c;
                            if (r.getCurrentTag() != 2 || (c = ComponentsFactory.readAndCreateComponent(ssHost.getSSContext(), this, null, r)) == null) continue;
                            String name = c.getName();
                            this.components.add(c);
                        }
                        continue block10;
                    }
                    case 13: {
                        _initCall = in.getAnsi();
                        break;
                    }
                    case 19: {
                        _endPageCall = in.getAnsi();
                        break;
                    }
                    case 15: {
                        _out = in.getInt();
                        break;
                    }
                    case 16: {
                        TaggedReader r = in.getStreamReader();
                        while (r.next()) {
                            if (r.getCurrentTag() != 15) continue;
                            _outm |= 1 << r.getInt();
                        }
                        break;
                    }
                }
            }
            this.output = _out;
            this.outputsMask = _outm;
            this.script = _script;
            this.onInitialize = _initCall;
            this.onEndPage = _endPageCall;
            ParametersDatasource parametersDatasource = new ParametersDatasource((Task)this, null, this.parameters);
            this.components.add(parametersDatasource);
            this.components.afterLoad();
            this.controls.afterLoad();
        }
    }

    public int reportOutput() {
        return this.output;
    }

    public int reportOutputMask() {
        return this.outputsMask;
    }

    public String endPage() {
        String result = "";
        return result;
    }

    public void addTable() {
        if (this.pageContent == null) {
            this.pageContent = new ArrayList();
        }
        this.pageContent.add(new ArrayList());
        if (this.beginRows == null) {
            this.beginRows = new IntegerList(4);
        }
        this.beginRows.add(0);
        if (this.endRows == null) {
            this.endRows = new IntegerList(4);
        }
        this.endRows.add(-1);
    }

    public void setBeginRow(int _table, int val) {
        this.beginRows.set(_table, val);
    }

    public void setEndRow(int _table, int val) {
        this.endRows.set(_table, val);
    }

    public void addRow() {
        ArrayList<ArrayList<String>> table = this.pageContent.get(this.pageContent.size() - 1);
        table.add(new ArrayList());
    }

    public void addCell(String data) {
        ArrayList<ArrayList<String>> table = this.pageContent.get(this.pageContent.size() - 1);
        ArrayList<String> row = table.get(table.size() - 1);
        row.add(data);
    }

    public int tableCount() {
        return this.pageContent == null ? 0 : this.pageContent.size();
    }

    public int rowCount(int _table) {
        if (_table < this.tableCount()) {
            return this.pageContent.get(_table).size();
        }
        return 0;
    }

    public int cellCount(int _table, int _row) {
        if (_row < this.rowCount(_table)) {
            return this.pageContent.get(_table).get(_row).size();
        }
        return 0;
    }

    public String getTableValue(int _table, int _row, int _cell) {
        if (_cell < this.cellCount(_table, _row)) {
            return this.pageContent.get(_table).get(_row).get(_cell);
        }
        return "";
    }

    public int beginRow(int _table) {
        if (_table < this.tableCount()) {
            return this.beginRows.get(_table);
        }
        return -1;
    }

    public int endRow(int _table) {
        if (_table < this.tableCount()) {
            return this.endRows.get(_table);
        }
        return -1;
    }

    public Document generate() throws Exception {
        return this.execute(new AbstractScriptableTask.ExecuteAction<Document>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Document execute(Context context) throws Exception {
                ReportTask task = ReportTask.this;
                ReportTask.this.context = context;
                ReportTask.this.document = new Document(null, context, task);
                try {
                    if (ReportTask.this.isClientReport) {
                        TaggedReader in = new TaggedReader(ReportTask.this.nodeContent);
                        Document cfr_ignored_0 = ReportTask.this.document;
                        ReportTask.this.document.beginProfile(0);
                        ReportTask.this.document.load(in);
                        ReportTask.this.document.finalizeDocument();
                    }
                    Document document = ReportTask.this.document;
                    return document;
                }
                finally {
                    ReportTask.this.document = null;
                }
            }
        });
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public String getClassName() {
        return "Report";
    }

    public void assignParameters(HttpServletRequest rq) throws InformException, ParseException {
        Enumeration i = rq.getParameterNames();
        while (i.hasMoreElements()) {
            String n = (String)i.nextElement();
            String v = rq.getParameter(n);
            Parameter p = this.parameters.get(n);
            if (p != null) {
                p.setWebValue(v);
                continue;
            }
            if (!n.startsWith("@")) continue;
            p = this.parameters.get(n = n.substring(1));
            if (p == null) {
                try {
                    p = this.parameters.get(Integer.parseInt(n));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (p == null) continue;
            p.setAsmoWebValue(v);
        }
    }

    @Override
    public double roundTo(double value, int digits) {
        if (digits <= 0) {
            double shift = Math.pow(10.0, -digits);
            double d = Math.rint(value * shift);
            return d / shift;
        }
        double shift = Math.pow(10.0, digits);
        double d = Math.rint(value / shift);
        return d * shift;
    }

    public static class Async
    implements Callable<Document> {
        private final BasicNode node;
        private final byte[] content;
        private final Session.User user;
        private final ParametersList parameters;
        private final boolean isClientReport;

        public Async(BasicNode node, byte[] content, Session.User user, ParametersList parameters, boolean isClientReport) {
            this.node = node;
            this.content = content;
            this.user = user;
            this.parameters = parameters;
            this.isClientReport = isClientReport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Document call() throws Exception {
            try (WebServerSideHost host = new WebServerSideHost(this.node.getId(), this.user, null);){
                Document document;
                ReportTask task = new ReportTask(host, this.node, this.content, null, this.parameters, this.isClientReport);
                try {
                    document = task.generate();
                }
                catch (Throwable throwable) {
                    task.close();
                    throw throwable;
                }
                task.close();
                return document;
            }
        }
    }
}

