/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.PageFormatLibrary;
import inform.agent.scripts.Task;
import inform.agent.web.reports.controls.BandItem;
import inform.agent.web.reports.controls.PageNumbers;
import inform.agent.web.reports.controls.PageSettings;
import inform.agent.web.reports.controls.ReportControlFactory;
import inform.agent.web.reports.controls.ReportPageOrientation;
import inform.agent.web.reports.controls.ReportParagraph;
import inform.agent.web.reports.controls.ReportTable;
import inform.agent.web.reports.controls.SheetProtection;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.TableMargins;
import java.io.IOException;
import java.io.Writer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ReportBand
extends WebControlContainer<WebControl> {
    public static final int TAG_WEB_BAND_MARGINS = 40;
    public static final int TAG_WEB_REPORT_SIZE = 41;
    public static final int TAG_WEB_REPORT_PAGE_ORIENTATION = 42;
    public static final int TAG_WEB_REPORT_USE_XLS_SCALE = 43;
    public static final int TAG_WEB_REPORT_XLS_SCALE = 44;
    public static final int TAG_WEB_REPORT_MAX_PAGES_PER_WIDTH = 45;
    public static final int TAG_WEB_REPORT_MAX_PAGES_PER_HEIGHT = 46;
    public static final int TAG_WEB_REPORT_DIMENSION = 48;
    public static final int TAG_WEB_REPORT_PAGE_NUMBERS = 49;
    public static final int TAG_WEB_REPORT_PAGE_NUMBER_ENABLED = 1;
    public static final int TAG_WEB_REPORT_PAGE_NUMBER_LOCATION = 2;
    public static final int TAG_WEB_REPORT_PAGE_NUMBER_ALIGN = 3;
    public static final int TAG_WEB_REPORT_PAGE_NUMBER_AT_FIRST_PAGE = 4;
    public static final int TAG_WEB_REPORT_PAGE_NUMBER_MARGIN = 5;
    public static final int TAG_WEB_REPORT_PAGE_NUMBER_FONT = 6;
    public static final int TAG_WEB_REPORT_PAGE_NUMBER_CAPTION = 7;
    public static final int TAG_WEB_REPORT_PAGE_NUMBER_SECTION = 8;
    public static final int TAG_WEB_REPORT_PAGE_CAPTION = 50;
    public static final int TAG_WEB_REPORT_BLACK_N_WHITE = 51;
    public static final int TAG_WEB_REPORT_FIRT_PAGE_PROTECTION = 52;
    public static final int TAG_WEB_REPORT_ALL_PAGE_PROTECTION = 53;
    public static final int TAG_WEB_REPORT_GRID_NOT_SHOW = 54;
    public static final int TAG_WEB_REPORT_HEADER_MARGIN = 55;
    public static final int TAG_WEB_REPORT_FOOTER_MARGIN = 56;
    public static final int TAG_WEB_REPORT_ZOOM = 58;
    private final PageSettings pageSettings;
    private int maxPagesPerWidth = 1;
    private int maxPagesPerHeight = 1;
    private short zoom = (short)100;
    private short scale = (short)100;
    private boolean useXlsScale = false;
    private final PageNumbers pageNumbers;
    private String pageCaption = "";
    private boolean blackNwhite = false;
    private boolean gridNotShow = false;
    private String dimension = "";
    private final SheetProtection firstPageProtection;
    private final SheetProtection allPageProtection;
    private double headerMargin = 12.5;
    private double footerMargin = 12.5;

    public ReportBand(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
        this.pageSettings = new PageSettings(null);
        this.pageNumbers = new PageNumbers(null);
        this.firstPageProtection = new SheetProtection(null);
        this.allPageProtection = new SheetProtection(null);
    }

    @Override
    protected WebControl createElementControl(ComponentHeader header) throws IOException, InformException {
        return ReportControlFactory.createControl(this.task, null, header);
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) {
        return null;
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        switch (tag) {
            case 40: {
                this.pageSettings.pageMargins.load(in.getSubStreamReader());
                break;
            }
            case 42: {
                this.pageSettings.orientation = ReportPageOrientation.create(in.getInt());
                break;
            }
            case 48: {
                this.dimension = in.getAnsi();
                break;
            }
            case 41: {
                byte[] bytes = in.getRaw();
                this.pageSettings.pageWidth = LittleEndian.getDouble(bytes, 0);
                this.pageSettings.pageHeight = LittleEndian.getDouble(bytes, 8);
                break;
            }
            case 43: {
                this.useXlsScale = true;
                break;
            }
            case 44: {
                byte[] _bytes = in.getRaw();
                this.scale = LittleEndian.getShort(_bytes, 0);
                break;
            }
            case 58: {
                byte[] _zoomBytes = in.getRaw();
                this.zoom = LittleEndian.getShort(_zoomBytes, 0);
                break;
            }
            case 45: {
                this.maxPagesPerWidth = in.getInt();
                break;
            }
            case 46: {
                this.maxPagesPerHeight = in.getInt();
                break;
            }
            case 49: {
                this.pageNumbers.load(in.getSubStreamData());
                break;
            }
            case 50: {
                this.pageCaption = in.getString();
                break;
            }
            case 51: {
                this.blackNwhite = true;
                break;
            }
            case 54: {
                this.gridNotShow = true;
                break;
            }
            case 55: {
                this.headerMargin = in.getDouble();
                break;
            }
            case 56: {
                this.footerMargin = in.getDouble();
                break;
            }
            case 52: {
                this.firstPageProtection.load(in.getSubStreamReader());
                break;
            }
            case 53: {
                this.allPageProtection.load(in.getSubStreamReader());
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void print(Writer out) throws IOException {
        for (WebControl c : this.controls) {
            c.print(out);
        }
    }

    @Override
    public String getClassName() {
        return "Band";
    }

    public void generate(Document document) throws Exception {
        this.beforeGenerate();
        if (this.getVisible()) {
            int color = this.getColor();
            Font font = this.getFont();
            if (this.blackNwhite) {
                document.setUseBlackAndWhite(this.blackNwhite);
                color = 0x1FFFFFFF;
                font.setColor(0);
            }
            this.pageSettings.color = color;
            this.pageSettings.font.assign(font);
            this.pageSettings.headerMargin = this.headerMargin;
            this.pageSettings.footerMargin = this.footerMargin;
            document.setRootPageSettings(this.pageSettings);
            document.setDocumentFont(font);
            DocSection section = document.appendSection();
            section.setFont(font);
            section.setColor(color);
            section.setMargins(this.pageSettings.pageMargins);
            section.setPageCaption(this.pageCaption);
            section.setPageNumbers(this.pageNumbers);
            section.setPageWidth(this.pageSettings.pageWidth);
            section.setPageHeight(this.pageSettings.pageHeight);
            section.setMaxPagesPerHeight(this.maxPagesPerHeight);
            section.setMaxPagesPerWidth(this.maxPagesPerWidth);
            section.setUseXlsScale(this.useXlsScale);
            section.setScale(this.scale);
            section.setZoom(this.zoom);
            section.setOrientation(this.pageSettings.orientation);
            section.setDimension(this.dimension);
            section.setBlackAndWhite(this.blackNwhite);
            section.setGridNotShow(this.gridNotShow);
            section.setFirstPageProtection(this.firstPageProtection);
            section.setAllPageProtection(this.allPageProtection);
            section.setHeaderMargin(this.headerMargin);
            section.setFooterMargin(this.footerMargin);
            block4: for (WebControl control : this.controls) {
                if (!control.isGenerated() || !(control instanceof BandItem)) continue;
                BandItem item = (BandItem)((Object)control);
                switch (item.getOutputRegion()) {
                    case 1: {
                        item.generate(document, section.createHeader(item.getOutputRegionPages()));
                        continue block4;
                    }
                    case 2: {
                        item.generate(document, section.createFooter(item.getOutputRegionPages()));
                        continue block4;
                    }
                }
                section = item.generate(document, section);
            }
        }
    }

    public TableMargins getMargins() {
        return this.pageSettings.pageMargins;
    }

    public PageNumbers getPageNumbers() {
        return this.pageNumbers;
    }

    public String getPageCaption() {
        return this.pageCaption;
    }

    public void setPageCaption(String pageCaption) {
        this.pageCaption = pageCaption;
    }

    public static Object createTable(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        ReportBand self = (ReportBand)thisObj;
        if (args.length > 0 && args[0] instanceof ReportTable) {
            ReportTable table = (ReportTable)args[0];
            if ((table = table.createClone(self.task, self)) != null) {
                table.afterLoad();
            }
            return table;
        }
        ReportTable table = new ReportTable(self.task, null, self.task.generateId(), null);
        return table;
    }

    public static Object insertControl(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object insertionObject;
        if (args.length < 0) {
            return null;
        }
        ReportBand self = (ReportBand)thisObj;
        Object control = args[0];
        WebControl insertedControl = null;
        if (control instanceof ReportTable) {
            insertedControl = (WebControl)control;
        } else if (control instanceof ReportParagraph) {
            insertedControl = (WebControl)control;
        }
        if (insertedControl == null || insertedControl.getTask() != self.task) {
            return null;
        }
        int insertionIndex = self.controls.size();
        if (args.length > 1 && (insertionIndex = self.controls.indexOf(insertionObject = args[1])) < 0) {
            return null;
        }
        self.controls.add(insertionIndex, insertedControl);
        return insertedControl;
    }

    public int getPageFormat() {
        return PageFormatLibrary.pageFormat((double)this.pageSettings.pageWidth, (double)this.pageSettings.pageHeight, (boolean)(this.pageSettings.orientation == ReportPageOrientation.LANDSCAPE ? true : false)).id;
    }

    public void setPageFormat(int format) {
        PageFormatLibrary.PageFormat pageFormat = PageFormatLibrary.pageFormat(format);
        if (pageFormat.height > 0.0 && pageFormat.width > 0.0) {
            this.pageSettings.orientation = pageFormat.landscape ? ReportPageOrientation.LANDSCAPE : ReportPageOrientation.PORTRAIT;
            this.pageSettings.pageHeight = pageFormat.height;
            this.pageSettings.pageWidth = pageFormat.width;
        }
    }

    public boolean getBlackAndWhite() {
        return this.blackNwhite;
    }

    public void setBlackAndWhite(boolean blackAnsWhite) {
        this.blackNwhite = blackAnsWhite;
    }

    public boolean getGridNotShow() {
        return this.gridNotShow;
    }

    public void setGridNotShow(boolean gns) {
        this.gridNotShow = gns;
    }

    public double getHeaderMargin() {
        return this.headerMargin;
    }

    public void setHeaderMargin(double hm) {
        this.headerMargin = hm;
    }

    public double getFooterMargin() {
        return this.footerMargin;
    }

    public void setFooterMargin(double fm) {
        this.footerMargin = fm;
    }
}

