/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.MtdEngine;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.Task;
import inform.agent.web.data.Datamodel;
import inform.agent.web.reports.controls.BandItem;
import inform.agent.web.reports.controls.PageSettings;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.IDocumentElement;
import inform.agent.web.utils.ClientFont;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.TableMargins;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.javascript.Scriptable;

public class ReportDocument
extends WebControl
implements BandItem {
    private static final int TAG_WEB_REPORT_DOCUMENT_NODEID = 40;
    private static final int TAG_WEB_REPORT_DOCUMENT_DATASOURCE = 41;
    private static final int TAG_WEB_REPORT_DOCUMENT_FIELD = 42;
    private final HashMap<Integer, TextStyle> textStyles = new HashMap();
    private final HashMap<Integer, ParagraphStyle> paragraphStyles = new HashMap();
    private final HashMap<Integer, ListStyle> listStyles = new HashMap();
    private int datasourceId = 0;
    private int[] fieldIdPath = null;
    private Dataset datasource = null;
    private DatasetField field = null;
    private double nodeId = 0.0;
    int outputRegion = 0;
    int outputRegionPages = 0;
    private boolean isPrgrStarted = false;
    private boolean isTableStarted = false;
    private boolean isMarkerStarted = false;
    DocParagraph paragraph = null;
    DocTable table = null;
    DocCell cell = null;
    DocText markerText = null;

    @Override
    public void beforeGenerate() {
        this.hasBindedData = this.field != null;
    }

    @Override
    public void setupDatamodel(Datamodel datamodel) {
        if (this.field != null) {
            datamodel.add(this.datasource);
        }
    }

    @Override
    public boolean isSubControl() {
        return true;
    }

    @Override
    public DocSection generate(Document document, DocSection section) throws Exception {
        if (section != null && this.getVisible()) {
            byte[] bytes = null;
            if (this.field != null) {
                if (!this.datasource.isSelected()) {
                    this.datasource.executeSelect();
                }
                if (!this.datasource.isCurrentRowAvailable() && !this.datasource.next()) {
                    return section;
                }
                if (!this.field.getIsNull()) {
                    bytes = ValueCaster.toBytes(this.field.getAvailableValue());
                }
            } else if (this.nodeId != 0.0) {
                bytes = MtdEngine.getNodeContent(this.nodeId);
            }
            if (bytes == null) {
                return section;
            }
            section = this.loadFromRawData(document, section, bytes);
        }
        return section;
    }

    public ReportDocument(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
    }

    public ReportDocument(Task task, Scriptable scope, int id, String name) {
        super(task, scope, id, name);
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) {
        assert (scope instanceof WebControlContainer);
        return this.createClone(task, (WebControlContainer)scope);
    }

    public WebControl createClone(Task task, WebControlContainer container) {
        ReportDocument doc = new ReportDocument(task, null, task.generateId(), ReportDocument.cloneName(container, this.getName()));
        doc.assignProps(this);
        doc.datasourceId = this.datasourceId;
        doc.fieldIdPath = this.fieldIdPath;
        doc.nodeId = this.nodeId;
        return doc;
    }

    @Override
    protected void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        switch (tag) {
            case 40: {
                in.skip();
                this.nodeId = in.getDouble(151);
                break;
            }
            case 41: {
                this.datasourceId = in.getInt();
                break;
            }
            case 42: {
                this.fieldIdPath = LittleEndian.toIntArray(in.getRaw());
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void afterLoad() throws InformException {
        this.datasource = null;
        this.field = null;
        if (this.datasourceId != 0 && this.fieldIdPath != null) {
            this.datasource = this.task.getComponents().findDataset(this.datasourceId);
            if (this.datasource != null) {
                this.field = this.datasource.findFieldPath(this.fieldIdPath);
            }
        }
    }

    @Override
    public void print(Writer out) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public String getClassName() {
        return "Document";
    }

    @Override
    public int getOutputRegion() {
        return this.outputRegion;
    }

    @Override
    public int getOutputRegionPages() {
        return this.outputRegionPages;
    }

    private DocSection loadFromRawData(Document document, DocSection section, byte[] bytes) throws Exception {
        TaggedReader reader = new TaggedReader(bytes);
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    section = this.writeDocData(document, section, reader.getSubStreamReader());
                    break;
                }
                case 2: {
                    this.readStyles(reader.getSubStreamReader());
                }
            }
        }
        return section;
    }

    private void readStyles(TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.readTextStyles(reader.getStreamReader());
                    break;
                }
                case 2: {
                    this.readParagraphStyles(reader.getStreamReader());
                    break;
                }
                case 3: {
                    this.readListStyles(reader.getStreamReader());
                }
            }
        }
    }

    private DocSection writeDocData(Document document, DocSection section, TaggedReader reader) throws IOException, TaggedReaderException, InformException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.writeTextItem(document, section, reader.getSubStreamReader());
                    break;
                }
                case 4: {
                    this.writeHypertextItem(document, section, reader.getSubStreamReader());
                    break;
                }
                case 3: {
                    this.writePictureItem(document, section, reader.getSubStreamReader());
                    break;
                }
                case 6: {
                    this.writeTabItem(document, section, reader.getSubStreamReader());
                    break;
                }
                case 8: {
                    section = this.writePageBreakItem(document, section);
                    break;
                }
                case 7: {
                    this.writeMarkerItem(document, section, reader.getSubStreamReader());
                    break;
                }
                case 5: {
                    this.writeTableItem(document, section, reader.getSubStreamReader());
                }
            }
        }
        return section;
    }

    private void readTextStyles(TaggedReader reader) throws IOException, TaggedReaderException {
        TextStyle style = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 4: {
                    if (style != null) {
                        this.textStyles.put(style.id, style);
                    }
                    style = new TextStyle(reader.getInt());
                    break;
                }
                case 1: {
                    style.clientFont.load(reader.getRaw());
                    break;
                }
                case 2: {
                    style.background = reader.getInt();
                    break;
                }
                case 7: {
                    style.jump = true;
                }
            }
        }
        if (style != null) {
            this.textStyles.put(style.id, style);
        }
    }

    private void readParagraphStyles(TaggedReader reader) throws IOException, TaggedReaderException {
        ParagraphStyle style = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 9: {
                    if (style != null) {
                        this.paragraphStyles.put(style.id, style);
                    }
                    style = new ParagraphStyle(reader.getInt());
                    break;
                }
                case 1: {
                    style.align = reader.getInt();
                    break;
                }
                case 2: {
                    style.leftMargin = reader.getInt();
                    break;
                }
                case 3: {
                    style.rightMargin = reader.getInt();
                    break;
                }
                case 4: {
                    style.topMargin = reader.getInt();
                    break;
                }
                case 5: {
                    style.bottomMargin = reader.getInt();
                }
            }
        }
        if (style != null) {
            this.paragraphStyles.put(style.id, style);
        }
    }

    private void readListStyles(TaggedReader reader) throws IOException, TaggedReaderException {
        ListStyle style = null;
        boolean std = false;
        block10: while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    if (style != null) {
                        this.listStyles.put(style.id, style);
                    }
                    style = new ListStyle(reader.getInt());
                    break;
                }
                case 2: {
                    if (style == null) break;
                    style.name = reader.getAnsi();
                    break;
                }
                case 3: {
                    if (style == null) break;
                    TaggedReader subReader = reader.getStreamReader();
                    ListStyleLevel level = null;
                    while (subReader.getNextTag() != 0) {
                        switch (subReader.getCurrentTag()) {
                            case 1: {
                                level = new ListStyleLevel(subReader.getInt());
                                style.levels.add(level);
                                break;
                            }
                            case 2: {
                                if (level == null) break;
                                level.formatString = subReader.getString();
                            }
                        }
                    }
                    continue block10;
                }
                case 4: {
                    std = true;
                }
            }
        }
        if (style != null) {
            this.listStyles.put(style.id, style);
        }
    }

    private void closePrevParagraph() {
        if (this.paragraph != null) {
            this.paragraph.prepareStore();
        }
        this.paragraph = null;
        if (this.isPrgrStarted) {
            this.isPrgrStarted = false;
        }
    }

    private void closePrevParagraphAndStartNew(Document document, DocSection section, int paraNo) {
        if (this.isMarkerStarted) {
            this.isMarkerStarted = false;
            this.markerText = null;
        }
        this.closePrevParagraph();
        ParagraphStyle parStyle = this.paragraphStyles.get(paraNo);
        if (parStyle == null) {
            parStyle = new ParagraphStyle(0);
            this.paragraphStyles.put(0, parStyle);
        }
        this.paragraph = section.appendParagraph();
        switch (parStyle.align) {
            case 1: {
                this.paragraph.align(HorizontalAlign.RIGHT);
                break;
            }
            case 2: {
                this.paragraph.align(HorizontalAlign.CENTER);
                break;
            }
            case 3: {
                this.paragraph.align(HorizontalAlign.WIDTH);
                break;
            }
            default: {
                this.paragraph.align(HorizontalAlign.LEFT);
            }
        }
        this.paragraph.marginBottom(parStyle.bottomMargin);
        this.paragraph.marginTop(parStyle.topMargin);
        this.isPrgrStarted = true;
    }

    private void applyCellStyle(int paraNo) {
    }

    private void writeTableData(Document document, DocSection section, TaggedReader reader, int tBgColor, int tBrColor) throws IOException, TaggedReaderException, InformException {
    }

    private void writeTableItem(Document document, DocSection section, TaggedReader reader) throws IOException, TaggedReaderException, InformException {
        this.closePrevParagraph();
        if (this.isTableStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443");
        }
        int rows = 0;
        int cols = 0;
        int bgColor = 0x1FFFFFFF;
        int brColor = 0;
        int paraNo = 0;
        this.table = section.addTable(null);
        this.isTableStarted = true;
        block13: while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    rows = reader.getInt();
                    for (int r = 0; r < rows; ++r) {
                        this.table.appendRow().setGenerated();
                    }
                    continue block13;
                }
                case 2: {
                    cols = reader.getInt();
                    for (int c = 0; c < cols; ++c) {
                        this.table.appendColumn();
                    }
                    continue block13;
                }
                case 11: {
                    bgColor = reader.getInt();
                    if (bgColor < 0) {
                        bgColor = 0x1FFFFFFF;
                    }
                    this.table.setColor(bgColor);
                    break;
                }
                case 12: {
                    brColor = reader.getInt();
                    if (brColor >= 0) break;
                    brColor = 0;
                    break;
                }
                case 4: {
                    this.writeTableData(document, section, reader.getSubStreamReader(), bgColor, brColor);
                    break;
                }
                case 6: {
                    paraNo = reader.getInt();
                }
            }
        }
        ParagraphStyle parStyle = this.paragraphStyles.get(paraNo);
        if (parStyle == null) {
            parStyle = new ParagraphStyle(0);
            this.paragraphStyles.put(0, parStyle);
        }
        switch (parStyle.align) {
            case 1: {
                this.table.setAlign(HorizontalAlign.RIGHT);
                break;
            }
            case 2: {
                this.table.setAlign(HorizontalAlign.CENTER);
                break;
            }
            case 3: {
                this.table.setAlign(HorizontalAlign.WIDTH);
                break;
            }
            default: {
                this.table.setAlign(HorizontalAlign.LEFT);
            }
        }
        TableMargins cellMargins = new TableMargins();
        cellMargins.update();
        this.table.setCellMargins(cellMargins);
        this.table.bottomMargin(parStyle.bottomMargin);
        this.table.prepareStore();
        this.table = null;
        this.isTableStarted = false;
    }

    private void writeMarkerItem(Document document, DocSection section, TaggedReader reader) throws IOException, TaggedReaderException {
        int styleNo = 0;
        int paraNo = 0;
        int level = 0;
        int start = 1;
        boolean startIsSet = false;
        boolean markerRestart = false;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    styleNo = reader.getInt();
                    break;
                }
                case 5: {
                    paraNo = reader.getInt();
                    break;
                }
                case 2: {
                    level = reader.getInt();
                    break;
                }
                case 3: {
                    start = reader.getInt();
                    startIsSet = true;
                    break;
                }
                case 4: {
                    markerRestart = true;
                }
            }
        }
        IDocumentElement container = this.cell;
        if (!this.isTableStarted) {
            this.closePrevParagraphAndStartNew(document, section, paraNo);
            container = this.paragraph;
        } else {
            this.applyCellStyle(paraNo);
        }
        this.markerText = container.addText();
        Object text = "";
        for (ListStyle ls : this.listStyles.values()) {
            if (ls.id != styleNo || ls.levels.size() <= level) continue;
            ListStyleLevel styleLevel = ls.levels.get(level);
            switch (styleLevel.type) {
                case 0: {
                    text = styleLevel.formatString;
                    break;
                }
                case 3: {
                    styleLevel.start = startIsSet || markerRestart ? start : ++styleLevel.start;
                    text = styleLevel.start + ".";
                }
            }
        }
        this.markerText.setText((String)text);
        this.isMarkerStarted = true;
    }

    private void writeTabItem(Document document, DocSection section, TaggedReader reader) throws IOException, TaggedReaderException {
        DocText documentText;
        int paraNo = -1;
        boolean isLast = false;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 4: {
                    isLast = true;
                    break;
                }
                case 3: {
                    paraNo = reader.getInt();
                }
            }
        }
        if (isLast && !this.isTableStarted) {
            this.closePrevParagraphAndStartNew(document, section, paraNo);
        }
        if (this.isTableStarted) {
            this.applyCellStyle(paraNo);
            documentText = this.cell.addText();
        } else {
            documentText = this.paragraph.addText();
        }
        documentText.setText("\t");
    }

    private DocSection writePageBreakItem(Document document, DocSection section) {
        short scale = section.getScale();
        boolean useScale = section.isUseXlsScale();
        boolean gridNotShow = section.getGridNotShow();
        PageSettings p = document.getRootPageSettings();
        section = document.appendSection();
        section.setPageSettings(p);
        section.setScale(scale);
        section.setUseXlsScale(useScale);
        section.setGridNotShow(gridNotShow);
        return section;
    }

    private void writeTextItem(Document document, DocSection section, TaggedReader reader) throws IOException, TaggedReaderException {
        DocText documentText;
        TextStyle textStyle;
        String text = "";
        int styleNo = 0;
        int paraNo = 0;
        boolean isLast = false;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    text = reader.getString();
                    break;
                }
                case 2: {
                    styleNo = reader.getInt();
                    break;
                }
                case 4: {
                    isLast = true;
                    break;
                }
                case 3: {
                    paraNo = reader.getInt();
                }
            }
        }
        if (text.isEmpty()) {
            if (!this.isMarkerStarted) {
                text = "\n";
            } else {
                return;
            }
        }
        if ((textStyle = this.textStyles.get(styleNo)) == null) {
            textStyle = new TextStyle(0);
            this.textStyles.put(0, textStyle);
        }
        int txtColor = textStyle.background;
        Font txtFont = textStyle.getFont();
        if (document.getUseBlackAndWhite()) {
            txtColor = 0x1FFFFFFF;
            if (txtFont != null) {
                txtFont.setColor(0);
            }
        }
        if (this.isMarkerStarted && this.markerText != null) {
            this.markerText.setFont(txtFont);
            this.markerText.setColor(txtColor);
        }
        if (isLast && !this.isTableStarted) {
            this.closePrevParagraphAndStartNew(document, section, paraNo);
        }
        if (this.isTableStarted) {
            this.applyCellStyle(paraNo);
            documentText = this.cell.addText();
        } else {
            documentText = this.paragraph.addText();
        }
        documentText.setFont(txtFont);
        documentText.setColor(txtColor);
        documentText.setText(text);
    }

    private void writeHypertextItem(Document document, DocSection section, TaggedReader reader) throws IOException, TaggedReaderException, InformException {
        DocText documentText;
        TextStyle textStyle;
        String caption = "";
        int styleNo = 0;
        int paraNo = 0;
        boolean isLast = false;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 4: {
                    caption = reader.getString();
                    break;
                }
                case 7: {
                    isLast = true;
                    break;
                }
                case 6: {
                    paraNo = reader.getInt();
                    break;
                }
                case 8: {
                    styleNo = reader.getInt();
                }
            }
        }
        if (isLast && !this.isTableStarted) {
            this.closePrevParagraphAndStartNew(document, section, paraNo);
        }
        if ((textStyle = this.textStyles.get(styleNo)) == null) {
            textStyle = new TextStyle(0);
            this.textStyles.put(0, textStyle);
        }
        if (this.isTableStarted) {
            this.applyCellStyle(paraNo);
            documentText = this.cell.addText();
        } else {
            documentText = this.paragraph.addText();
        }
        int txtColor = textStyle.background;
        Font txtFont = textStyle.getFont();
        if (document.getUseBlackAndWhite()) {
            txtColor = 0x1FFFFFFF;
            txtFont.setColor(0);
        }
        documentText.setFont(txtFont);
        documentText.setColor(txtColor);
        documentText.setText(caption);
    }

    private void writePictureItem(Document document, DocSection section, TaggedReader reader) throws IOException, TaggedReaderException, InformException {
        DocImage docImage;
        double pictNodeId = 0.0;
        int imageHeight = 0;
        int imageWidth = 0;
        int paraNo = 0;
        boolean isLast = false;
        byte[] imageContent = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 151: {
                    pictNodeId = reader.getDouble();
                    break;
                }
                case 2: {
                    imageHeight = reader.getInt();
                    if (imageHeight <= 2048) break;
                    imageHeight = 2048;
                    break;
                }
                case 3: {
                    imageWidth = reader.getInt();
                    if (imageWidth <= 2048) break;
                    imageWidth = 2048;
                    break;
                }
                case 5: {
                    imageContent = reader.getRaw();
                    break;
                }
                case 7: {
                    isLast = true;
                    break;
                }
                case 6: {
                    paraNo = reader.getInt();
                }
            }
        }
        if (isLast && !this.isTableStarted) {
            this.closePrevParagraphAndStartNew(document, section, paraNo);
        }
        if (this.isTableStarted) {
            this.applyCellStyle(paraNo);
            docImage = this.cell.addImage();
        } else {
            docImage = this.paragraph.addImage();
        }
        docImage.setWidth((double)imageWidth * 25.4 / 96.0);
        docImage.setHeight((double)imageHeight * 25.4 / 96.0);
        if (pictNodeId != 0.0) {
            imageContent = MtdEngine.getNodeContent(pictNodeId);
        }
        docImage.setImageContent(imageContent);
    }

    private static class ListStyle {
        int id;
        String name;
        ArrayList<ListStyleLevel> levels = new ArrayList();

        public ListStyle(int id) {
            this.id = id;
        }
    }

    private static class ListStyleLevel {
        int type;
        String formatString;
        int start = 0;

        public ListStyleLevel(int type) {
            this.type = type;
        }
    }

    private static class ParagraphStyle {
        int id;
        int align = 0;
        int topMargin = 0;
        int bottomMargin = 0;
        int leftMargin = 0;
        int rightMargin = 0;

        public ParagraphStyle(int id) {
            this.id = id;
        }
    }

    private static class TextStyle {
        private Font font = new Font();
        int id;
        ClientFont clientFont = new ClientFont();
        int background = 0x1FFFFFFF;
        boolean jump = false;

        public TextStyle(int id) {
            this.id = id;
        }

        public Font getFont() {
            if (this.font == null) {
                this.font = new Font();
            }
            this.font.setName(this.clientFont.getName());
            this.font.setSize(this.clientFont.getSize());
            int tmpStyle = this.clientFont.getStyle();
            if (this.jump) {
                tmpStyle &= 4;
            }
            this.font.setStyle(tmpStyle);
            this.font.setColor(this.clientFont.getColor());
            return this.font;
        }
    }
}

