/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.agent.web.reports.controls.ReportColumn;
import inform.agent.web.reports.document.DocColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DocColumns {
    final ArrayList<DocColumn> columns = new ArrayList();
    final HashMap<ReportColumn, DocColumn> controls = new HashMap();
    private int changeNo = 0;
    private int lastChangeNo = 0;

    public DocColumn get(int index) {
        return this.columns.get(index);
    }

    public DocColumn get(ReportColumn control) {
        return this.controls.get(control);
    }

    public int indexOf(DocColumn column) {
        if (column == null || column.columns != this) {
            return -1;
        }
        this.update();
        return column.columnIndex;
    }

    public int indexOf(ReportColumn control) {
        if (control == null) {
            return -1;
        }
        return this.indexOf(this.controls.get(control));
    }

    public void add(DocColumn column) {
        column.columns = this;
        ++this.changeNo;
        this.columns.add(column);
        if (column.control != null) {
            this.controls.put(column.control, column);
        }
    }

    public void insert(int index, DocColumn column) {
        assert (column.columns == null);
        column.columns = this;
        ++this.changeNo;
        this.columns.add(index, column);
        if (column.control != null) {
            this.controls.put(column.control, column);
        }
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.columns.size()) {
            return false;
        }
        return this.remove(this.columns.remove(index));
    }

    public boolean remove(DocColumn column) {
        if (column == null || column.columns != this) {
            return false;
        }
        ++this.changeNo;
        this.columns.remove(column);
        if (column.control != null) {
            this.controls.remove(column.control);
        }
        return true;
    }

    public boolean remove(ReportColumn control) {
        return this.remove(this.controls.get(control));
    }

    public int size() {
        return this.columns.size();
    }

    public Collection<DocColumn> values() {
        return this.columns;
    }

    void update() {
        if (this.changeNo == this.lastChangeNo) {
            return;
        }
        int index = -1;
        for (DocColumn column : this.columns) {
            column.columnIndex = ++index;
        }
        this.changeNo = this.lastChangeNo;
    }
}

