/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.Cursor;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.MtdEngine;
import inform.agent.web.reports.controls.PageNumbers;
import inform.agent.web.reports.controls.PageSettings;
import inform.agent.web.reports.controls.ReportPageOrientation;
import inform.agent.web.reports.controls.ReportTable;
import inform.agent.web.reports.controls.SheetProtection;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocElement;
import inform.agent.web.reports.document.DocPageBreak;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.SectionElement;
import inform.agent.web.reports.document.Type;
import inform.agent.web.reports.style.CellStyle;
import inform.agent.web.utils.CellPositions;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.TableMargins;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class DocSection
extends DocComponent {
    private final ArrayList<SectionElement> lines = new ArrayList();
    private final CellPositions positions = new CellPositions();
    private final TableMargins margins;
    private final PageNumbers pageNumbers;
    private final SheetProtection firstPageProtection;
    private final SheetProtection allPageProtection;
    private boolean markAsFinal = false;
    private String password = "";
    private ReportPageOrientation orientation = ReportPageOrientation.PORTRAIT;
    private String dimension = "";
    private double pageWidth = 210.0;
    private double pageHeight = 297.0;
    private boolean useXlsScale = false;
    private short scale = (short)100;
    private short zoom = (short)100;
    private int maxPagesPerWidth = 0;
    private int maxPagesPerHeight = 0;
    private String pageCaption = "";
    private boolean blackNwhite = false;
    private boolean gridNotShow = false;
    private boolean hideSheet = false;
    private int activeSheet = 1;
    private double headerMargin = 12.5;
    private double footerMargin = 12.5;
    private DocSection allPagesHeader = null;
    private DocSection allPagesFooter = null;
    private DocSection firstPageHeader = null;
    private DocSection firstPageFooter = null;
    private DocSection otherPagesHeader = null;
    private DocSection otherPagesFooter = null;
    private boolean pageBreakPreview = false;
    private boolean isBegin;
    private boolean bgOnlyFirstPage = false;
    private double bgImageID = 0.0;
    private double bgLeft = 0.0;
    private double bgTop = 0.0;
    private double bgWidth = 0.0;
    private double bgHeight = 0.0;
    private byte[] bgImageContent = null;
    public final ArrayList<Double> widths = new ArrayList();

    public DocSection(Document document) {
        super(document);
        this.margins = new TableMargins(null);
        this.pageNumbers = new PageNumbers(null);
        this.firstPageProtection = new SheetProtection(null);
        this.allPageProtection = new SheetProtection(null);
    }

    public DocTable addTable(ReportTable control) {
        DocTable table = new DocTable(this, control);
        this.lines.add(table);
        return table;
    }

    public void calculate(CellPositions positions) throws InformException {
        for (Cursor.Double double_ : this.positions.values()) {
            positions.setPosition(double_.value);
        }
    }

    public CellPositions getPositions() {
        return this.positions;
    }

    public TableMargins margins() {
        return this.margins;
    }

    public PageNumbers pageNumbers() {
        return this.pageNumbers;
    }

    DocSection prepareRunningTitle(DocSection rt) {
        if (rt != null) {
            if (rt.isEmpty()) {
                if (this.pageNumbers != null && this.pageNumbers.enabled) {
                    return rt;
                }
                return null;
            }
            rt.prepareStore();
        }
        return rt;
    }

    @Override
    public void prepareStore() {
        super.prepareStore();
        for (SectionElement line : this.lines) {
            line.prepareStore();
        }
        this.pageNumbers.prepareStore(this.document);
        this.allPagesHeader = this.prepareRunningTitle(this.allPagesHeader);
        if (this.allPagesHeader != null) {
            this.firstPageHeader = null;
            this.otherPagesHeader = null;
        } else {
            this.firstPageHeader = this.prepareRunningTitle(this.firstPageHeader);
            this.otherPagesHeader = this.prepareRunningTitle(this.otherPagesHeader);
        }
        this.allPagesFooter = this.prepareRunningTitle(this.allPagesFooter);
        if (this.allPagesFooter != null) {
            this.firstPageFooter = null;
            this.otherPagesFooter = null;
        } else {
            this.firstPageFooter = this.prepareRunningTitle(this.firstPageFooter);
            this.otherPagesFooter = this.prepareRunningTitle(this.otherPagesFooter);
        }
    }

    @Override
    public void finalizeDocument() {
        for (SectionElement line : this.lines) {
            line.calculate(this.positions);
        }
        super.finalizeDocument();
        for (SectionElement line : this.lines) {
            line.finalizeDocument();
        }
        if (this.allPagesHeader != null) {
            this.allPagesHeader.finalizeDocument();
        }
        if (this.firstPageHeader != null) {
            this.firstPageHeader.finalizeDocument();
        }
        if (this.otherPagesHeader != null) {
            this.otherPagesHeader.finalizeDocument();
        }
        if (this.allPagesFooter != null) {
            this.allPagesFooter.finalizeDocument();
        }
        if (this.firstPageFooter != null) {
            this.firstPageFooter.finalizeDocument();
        }
        if (this.otherPagesFooter != null) {
            this.otherPagesFooter.finalizeDocument();
        }
    }

    @Override
    public void store(TaggedWriter out) throws InformException, IOException {
        super.store(out);
        this.positions.storeAs(6, out);
        this.margins.storeAs(40, out);
        this.pageNumbers.stroreAs(41, out);
        out.putString(42, this.pageCaption);
        out.putDouble(43, this.pageWidth);
        out.putDouble(44, this.pageHeight);
        out.putInt32(45, this.orientation.value());
        if (this.firstPageProtection.getEnabled()) {
            this.firstPageProtection.storeAs(47, out);
        }
        if (this.allPageProtection.getEnabled()) {
            this.allPageProtection.storeAs(48, out);
        }
        if (this.blackNwhite) {
            out.putEmpty(46);
        }
        if (this.gridNotShow) {
            out.putEmpty(49);
        }
        out.putDouble(50, this.headerMargin);
        out.putDouble(51, this.footerMargin);
        out.putEmpty(39);
        for (SectionElement line : this.lines) {
            if (!line.isVisible()) continue;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(stream);
            line.store(writer);
            writer.flush();
            out.putInt32(1, line.getType().value());
            out.putRaw(202, stream);
        }
    }

    @Override
    public void beforeLoad() throws InformException, IOException {
        super.beforeLoad();
        this.isBegin = false;
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        switch (tag) {
            case 6: {
                break;
            }
            case 40: {
                this.margins.load(in.getStreamReader());
                break;
            }
            case 41: {
                this.pageNumbers.setFont(this.getFont());
                this.pageNumbers.load(in.getStreamReader());
                break;
            }
            case 42: {
                this.pageCaption = in.getAnsi();
                break;
            }
            case 43: {
                this.pageWidth = in.getDouble();
                break;
            }
            case 44: {
                this.pageHeight = in.getDouble();
                break;
            }
            case 45: {
                int buff = in.getInt();
                this.orientation = ReportPageOrientation.create(buff);
                break;
            }
            case 47: {
                in.skip();
                this.firstPageProtection.load(in.getSubStreamReader());
                break;
            }
            case 48: {
                in.skip();
                this.allPageProtection.load(in.getSubStreamReader());
                break;
            }
            case 63: {
                this.markAsFinal = true;
                break;
            }
            case 61: {
                this.password = in.getAnsi();
                break;
            }
            case 46: {
                this.blackNwhite = true;
                this.document.setUseBlackAndWhite(this.blackNwhite);
                int color = 0x1FFFFFFF;
                Font font = this.getFont();
                font.setColor(0);
                this.setFont(font);
                this.setColor(color);
                break;
            }
            case 49: {
                this.gridNotShow = true;
                break;
            }
            case 50: {
                this.headerMargin = in.getDouble();
                break;
            }
            case 51: {
                this.footerMargin = in.getDouble();
                break;
            }
            case 53: {
                this.useXlsScale = true;
                break;
            }
            case 54: {
                byte[] _bytes = in.getRaw();
                this.scale = LittleEndian.getShort(_bytes, 0);
                break;
            }
            case 58: {
                byte[] _zoomBytes = in.getRaw();
                this.zoom = LittleEndian.getShort(_zoomBytes, 0);
                break;
            }
            case 55: {
                this.maxPagesPerWidth = in.getInt();
                break;
            }
            case 56: {
                this.maxPagesPerHeight = in.getInt();
                break;
            }
            case 57: {
                this.dimension = in.getAnsi();
                break;
            }
            case 59: {
                this.loadBGImageParams(in.getStreamReader());
                break;
            }
            case 60: {
                this.pageBreakPreview = true;
                break;
            }
            case 62: {
                TaggedReader reader = in.getStreamReader();
                while (reader.next()) {
                    switch (reader.getCurrentTag()) {
                        case 1: {
                            double buff = reader.getDouble();
                            this.widths.add(buff);
                        }
                    }
                }
                break;
            }
            case 66: {
                TaggedReader reader = in.getStreamReader();
                CellStyle.load(this.document, reader);
                break;
            }
            case 39: {
                this.isBegin = true;
                break;
            }
            case 1: {
                if (!this.isBegin) break;
                SectionElement element = null;
                Type type = Type.create(in.getInt());
                switch (type) {
                    case PARAGRAPH: {
                        element = this.appendParagraph();
                        break;
                    }
                    case TABLE: {
                        element = this.appendTable();
                        break;
                    }
                    case PageBreak: {
                        this.addPageBreak();
                    }
                }
                if (element == null) break;
                element.load(in.getStreamReader());
                break;
            }
            case 64: {
                this.hideSheet = in.getBooleanDef(false);
                break;
            }
            case 65: {
                this.activeSheet = in.getInt();
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    private void loadBGImageParams(TaggedReader in) throws InformException, IOException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.bgLeft = in.getDouble();
                    break;
                }
                case 2: {
                    this.bgTop = in.getDouble();
                    break;
                }
                case 3: {
                    this.bgWidth = in.getDouble();
                    break;
                }
                case 4: {
                    this.bgHeight = in.getDouble();
                    break;
                }
                case 5: {
                    this.bgImageID = in.getDouble();
                    if (!(this.bgImageID > 0.0)) break;
                    this.bgImageContent = MtdEngine.getNodeContent(this.bgImageID);
                    break;
                }
                case 6: {
                    this.bgOnlyFirstPage = in.getBoolean();
                }
            }
        }
    }

    @Override
    public Type getType() {
        return Type.SECTION;
    }

    @Override
    public DocElement getParent() {
        return this.document;
    }

    public DocParagraph appendParagraph() {
        DocParagraph paragraph = new DocParagraph(this);
        this.lines.add(paragraph);
        return paragraph;
    }

    public DocTable appendTable() {
        DocTable table = new DocTable(this);
        this.lines.add(table);
        return table;
    }

    public DocParagraph createParagraph() {
        return new DocParagraph(this);
    }

    public DocTable createTable() {
        return new DocTable(this);
    }

    public void add(SectionElement line) {
        if (!this.lines.contains(line)) {
            this.lines.add(line);
        }
    }

    public void addPageBreak() {
        DocPageBreak pageBreak = new DocPageBreak(this);
        this.lines.add(pageBreak);
    }

    public boolean getBlackAndWhite() {
        return this.blackNwhite;
    }

    public void setBlackAndWhite(boolean blackAndWhite) {
        this.blackNwhite = blackAndWhite;
    }

    public String getClassName() {
        return "Section";
    }

    public void setMargins(TableMargins margins) {
        this.margins.assign(margins);
    }

    public void setPageNumbers(PageNumbers pn) {
        this.pageNumbers.assign(pn);
    }

    public PageNumbers getPageNumbers() {
        return this.pageNumbers;
    }

    public Iterable<SectionElement> elements() {
        return Collections.unmodifiableCollection(this.lines);
    }

    public int getMaxPagesPerHeight() {
        return this.maxPagesPerHeight;
    }

    public void setMaxPagesPerHeight(int maxPagesPerHeight) {
        this.maxPagesPerHeight = maxPagesPerHeight;
    }

    public int getMaxPagesPerWidth() {
        return this.maxPagesPerWidth;
    }

    public void setMaxPagesPerWidth(int maxPagesPerWidth) {
        this.maxPagesPerWidth = maxPagesPerWidth;
    }

    public ReportPageOrientation getOrientation() {
        return this.orientation;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setOrientation(ReportPageOrientation orientation) {
        this.orientation = orientation;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public double getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(double pageHeight) {
        this.pageHeight = pageHeight;
    }

    public double getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(double pageWidth) {
        this.pageWidth = pageWidth;
    }

    public short getZoom() {
        return this.zoom;
    }

    public void setZoom(short zoom) {
        this.zoom = zoom;
    }

    public short getScale() {
        return this.scale;
    }

    public void setScale(short scale) {
        this.scale = scale;
    }

    public boolean isUseXlsScale() {
        return this.useXlsScale;
    }

    public void setUseXlsScale(boolean useXlsScale) {
        this.useXlsScale = useXlsScale;
    }

    public void setPageSettings(PageSettings p) {
        this.setFont(p.font);
        this.setColor(p.color);
        this.margins.assign(p.pageMargins);
        this.pageWidth = p.pageWidth;
        this.pageHeight = p.pageHeight;
        this.orientation = p.orientation;
        this.headerMargin = p.headerMargin;
        this.footerMargin = p.footerMargin;
    }

    public void setGridNotShow(boolean gns) {
        this.gridNotShow = gns;
    }

    public boolean getGridNotShow() {
        return this.gridNotShow;
    }

    public void setHeaderMargin(double hm) {
        this.headerMargin = hm;
    }

    public double getHeaderMargin() {
        return this.headerMargin;
    }

    public void setFooterMargin(double fm) {
        this.footerMargin = fm;
    }

    public double getFooterMargin() {
        return this.footerMargin;
    }

    public void setFirstPageProtection(SheetProtection sp) {
        this.firstPageProtection.assign(sp);
    }

    public SheetProtection getFirstPageProtection() {
        return this.firstPageProtection;
    }

    public void setAllPageProtection(SheetProtection sp) {
        this.allPageProtection.assign(sp);
    }

    public SheetProtection getAllPageProtection() {
        return this.allPageProtection;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getMarkAsFinal() {
        return this.markAsFinal;
    }

    public String getPageCaption() {
        return this.pageCaption;
    }

    public void setPageCaption(String pageCaption) {
        this.pageCaption = pageCaption;
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public DocSection getAllPagesHeader() {
        return this.allPagesHeader;
    }

    public DocSection getAllPagesFooter() {
        return this.allPagesFooter;
    }

    public DocSection getFirstPageHeader() {
        return this.firstPageHeader;
    }

    public DocSection getFirstPageFooter() {
        return this.firstPageFooter;
    }

    public DocSection getOtherPageHeader() {
        return this.otherPagesHeader;
    }

    public DocSection getOtherPageFooter() {
        return this.otherPagesFooter;
    }

    public DocSection createHeader(int pages) {
        switch (pages) {
            case 1: {
                if (this.firstPageHeader == null) {
                    this.firstPageHeader = new DocSection(this.document);
                }
                return this.firstPageHeader;
            }
            case 2: {
                if (this.otherPagesHeader == null) {
                    this.otherPagesHeader = new DocSection(this.document);
                }
                return this.otherPagesHeader;
            }
        }
        if (this.allPagesHeader == null) {
            this.allPagesHeader = new DocSection(this.document);
        }
        return this.allPagesHeader;
    }

    public DocSection createFooter(int pages) {
        switch (pages) {
            case 1: {
                if (this.firstPageFooter == null) {
                    this.firstPageFooter = new DocSection(this.document);
                }
                return this.firstPageFooter;
            }
            case 2: {
                if (this.otherPagesFooter == null) {
                    this.otherPagesFooter = new DocSection(this.document);
                }
                return this.otherPagesFooter;
            }
        }
        if (this.allPagesFooter == null) {
            this.allPagesFooter = new DocSection(this.document);
        }
        return this.allPagesFooter;
    }

    public double getBGImageID() {
        return this.bgImageID;
    }

    public double getBGLeft() {
        return this.bgLeft;
    }

    public double getBGTop() {
        return this.bgTop;
    }

    public double getBGWidth() {
        return this.bgWidth;
    }

    public double getBGHeight() {
        return this.bgHeight;
    }

    public boolean getBGOnlyFirstPage() {
        return this.bgOnlyFirstPage;
    }

    public byte[] getBGImageContent() {
        return this.bgImageContent;
    }

    public boolean getPageBreakPreview() {
        return this.pageBreakPreview;
    }

    public boolean getHideSheet() {
        return this.hideSheet;
    }

    public int getActiveSheet() {
        return this.activeSheet;
    }
}

