/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.web.reports.document.DocFont;
import inform.agent.web.utils.Font;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class FontCache {
    private final HashMap<Font, DocFont> hash = new HashMap();
    private final AtomicInteger idGenerator = new AtomicInteger(-1);

    public DocFont getFont(Font font) {
        if (font == null) {
            return null;
        }
        DocFont result = this.hash.get(font);
        if (result == null) {
            result = new DocFont(this.idGenerator.incrementAndGet(), font);
            this.hash.put(result, result);
        }
        return result;
    }

    public void store(TaggedWriter out) throws IOException {
        for (Map.Entry<Font, DocFont> entry : this.hash.entrySet()) {
            DocFont font = entry.getValue();
            out.putInt32(1, font.id());
            out.putAnsi(2, font.getName());
            out.putInt32(5, font.getColor());
            out.putInt32(3, font.getSize());
            out.putInt32(4, font.getStyle());
        }
    }

    public void storeAs(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        this.store(writer);
        writer.flush();
        out.putRaw(tag, stream);
    }
}

