/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.generators;

import inform.adt.InformException;
import inform.agent.web.reports.document.DocBorders;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocColumn;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.IDocumentElement;
import inform.agent.web.reports.generators.WebReportGenerator;
import inform.agent.web.utils.CellPositions;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.HtmlUtils;
import inform.agent.web.utils.TableMargins;
import inform.agent.web.utils.VerticalAlign;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class HtmlGenerator
implements WebReportGenerator {
    private final Document doc;

    public HtmlGenerator(Document doc) {
        this.doc = doc;
    }

    private void generateComponents(Iterable<? extends DocComponent> components, StringBuilder out, Css css) throws InformException {
        block6: for (DocComponent docComponent : components) {
            switch (docComponent.getType()) {
                case PARAGRAPH: {
                    DocParagraph p = (DocParagraph)docComponent;
                    out.append("<p class='").append(css.gen(p)).append("'>");
                    this.generateComponents(p.components(), out, css);
                    out.append("</p>");
                    break;
                }
                case TABLE: {
                    DocComponent t = (DocTable)docComponent;
                    HorizontalAlign al = ((DocTable)t).align();
                    if (al != HorizontalAlign.DEFAULT) {
                        out.append("<div align='").append(al.name().toLowerCase()).append("'>\n");
                    }
                    out.append("<table class='").append(css.gen(t)).append("'>\n");
                    for (DocColumn c : ((DocTable)t).getColumns().values()) {
                        if (!c.isVisible()) continue;
                        out.append(String.format(Locale.US, "<col style=\"width:%.2fmm;min-width:%.2fmm\"/>", c.getWidth(), c.getWidth()));
                    }
                    int[] rs = new int[((DocTable)t).getColumns().size()];
                    int rowIndex = 0;
                    for (DocRow r : ((DocTable)t).rows()) {
                        out.append("<tr class='").append(css.gen(r)).append("'>");
                        int cs = 1;
                        int ci = 0;
                        for (DocCell c : r.getCells()) {
                            if (!c.isVisible()) {
                                ++ci;
                                continue;
                            }
                            if (cs > 1) {
                                --cs;
                                ++ci;
                                continue;
                            }
                            if (rs[ci] > 1) {
                                int n = ci++;
                                rs[n] = rs[n] - 1;
                                continue;
                            }
                            if (!c.isGenerated()) {
                                ++ci;
                                continue;
                            }
                            cs = c.colSpan();
                            rs[ci] = c.rowSpan();
                            out.append("<td class='").append(css.gen(c)).append("'");
                            if (cs > 1) {
                                out.append(" colspan='").append(cs).append('\'');
                            }
                            if (rs[ci] > 1) {
                                out.append(" rowspan='").append(rs[ci]).append('\'');
                            }
                            out.append('>');
                            if (!c.isCellValueEmpty()) {
                                out.append(HtmlUtils.htmlEnquote(c.getCellValue().asText()));
                            } else {
                                out.append(HtmlUtils.htmlEnquote(null));
                            }
                            this.generateComponents(c.components(), out, css);
                            out.append("</td>");
                            ++ci;
                        }
                        out.append("</tr>\n");
                        ++rowIndex;
                    }
                    out.append("</table>\n");
                    if (al == HorizontalAlign.DEFAULT) continue block6;
                    out.append("</div>\n");
                    break;
                }
                case TEXT: {
                    DocComponent t = (DocText)docComponent;
                    String text = ((DocText)t).getText();
                    if (!((DocText)t).getHtmlFormatted()) {
                        text = HtmlUtils.htmlEnquote(text);
                    }
                    out.append("<span class='").append(css.gen(t)).append("'>").append(text).append("</span>");
                    break;
                }
                case IMAGE: {
                    DocImage im = (DocImage)docComponent;
                    String baseURL = this.doc.getImageBaseURL();
                    this.doc.addImage(im);
                    if (baseURL.length() == 0) {
                        out.append("<img src=\"files/").append(this.doc.getLastImageId()).append("\" style=\"width:").append("" + im.getWidth()).append("mm;height:").append("" + im.getHeight()).append("mm;\" alt=\"").append(this.doc.getLastImageId()).append("\"/>");
                        break;
                    }
                    out.append("<img src=\"").append(baseURL).append(this.doc.getLastImageId()).append("\" style=\"width:").append("" + im.getWidth()).append("mm;height:").append("" + im.getHeight()).append("mm;\" alt=\"").append(this.doc.getLastImageId()).append("\"/>");
                    break;
                }
            }
        }
    }

    @Override
    public void generateHeaders(HttpServletResponse resp) throws Exception {
        resp.setCharacterEncoding("WINDOWS-1251");
        resp.setContentType("text/html");
    }

    public void generateBody(PrintWriter pw) throws Exception {
        pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//RU\">");
        pw.println("<html>");
        pw.println("<head>");
        pw.append("<title>").append(this.doc.getClassName()).println("</title>");
        this.doc.prepareStore();
        CellPositions positions = new CellPositions();
        for (DocSection s : this.doc.sections()) {
            s.calculate(positions);
        }
        Css css = new Css();
        StringBuilder body = new StringBuilder();
        for (DocSection s : this.doc.sections()) {
            body.append("<body class='").append(css.gen(s)).append("'>");
            this.generateComponents(s.elements(), body, css);
            body.append("</body>");
        }
        pw.println("<style type='text/css'>");
        StringBuilder tmp = new StringBuilder();
        css.generate(tmp);
        pw.println(tmp);
        pw.println("</style>");
        pw.println("</head>");
        pw.println(body);
        pw.println("</html>");
    }

    @Override
    public void generateBody(OutputStream out, String encoding) throws Exception {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out, encoding), true);
        this.generateBody(pw);
    }

    private static class Css {
        private final Map<Entry, String> entries = new HashMap<Entry, String>();
        private final Map<Entry, String> entriesP = new HashMap<Entry, String>();
        private final Map<Entry, String> entriesT = new HashMap<Entry, String>();
        private final Map<Entry, String> entriesR = new HashMap<Entry, String>();
        private final Map<Entry, String> entriesC = new HashMap<Entry, String>();
        private final Map<Entry, String> entriesS = new HashMap<Entry, String>();

        private Css() {
        }

        private String gen(IDocumentElement el) {
            String pfx;
            Entry e;
            Map<Entry, String> m;
            if (el instanceof DocSection) {
                m = this.entriesS;
                e = new EntryS((DocSection)el);
                pfx = "s";
            } else if (el instanceof DocParagraph) {
                m = this.entriesP;
                e = new EntryP((DocParagraph)el);
                pfx = "p";
            } else if (el instanceof DocTable) {
                m = this.entriesT;
                e = new EntryT((DocTable)el);
                pfx = "t";
            } else if (el instanceof DocRow) {
                m = this.entriesR;
                e = new EntryR((DocRow)el);
                pfx = "r";
            } else if (el instanceof DocCell) {
                m = this.entriesC;
                e = new EntryC((DocCell)el);
                pfx = "c";
            } else {
                m = this.entries;
                e = el instanceof DocText ? new EntryTxt((DocText)el) : new Entry(el);
                pfx = "x";
            }
            Object r = m.get(e);
            if (r == null) {
                r = pfx + m.size();
                m.put(e, (String)r);
            }
            return r;
        }

        void generate(StringBuilder out) {
            for (Map.Entry<Entry, String> e : this.entries.entrySet()) {
                out.append('.').append(e.getValue()).append(" {\n");
                e.getKey().generate(out);
                out.append("}\n");
            }
            for (Map.Entry<Entry, String> e : this.entriesP.entrySet()) {
                out.append("p.").append(e.getValue()).append(" {\n");
                e.getKey().generate(out);
                out.append("}\n");
            }
            for (Map.Entry<Entry, String> e : this.entriesS.entrySet()) {
                out.append('.').append(e.getValue()).append(" {\n");
                e.getKey().generate(out);
                out.append("}\n");
            }
            for (Map.Entry<Entry, String> e : this.entriesT.entrySet()) {
                out.append("table.").append(e.getValue()).append(" {\n");
                e.getKey().generate(out);
                out.append("}\n");
            }
            for (Map.Entry<Entry, String> e : this.entriesR.entrySet()) {
                out.append("tr.").append(e.getValue()).append(" {\n");
                e.getKey().generate(out);
                out.append("}\n");
            }
            for (Map.Entry<Entry, String> e : this.entriesC.entrySet()) {
                out.append("td.").append(e.getValue()).append(" {\n");
                e.getKey().generate(out);
                out.append("}\n");
            }
        }

        private static class EntryS
        extends Entry {
            private final TableMargins padding;

            EntryS(DocSection c) {
                super(c);
                this.padding = c.margins();
            }

            @Override
            protected void generate(StringBuilder out) {
                super.generate(out);
                out.append(String.format(Locale.US, "padding:%.2fmm %.2fmm %.2fmm %.2fmm;%n", this.padding.getTop(), this.padding.getRight(), this.padding.getBottom(), this.padding.getLeft()));
                if (this.width != 0.0) {
                    EntryS.appendWidth(this.width, out);
                }
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof EntryS) {
                    EntryS that = (EntryS)obj;
                    return super.equals(obj) && that.padding.equals(this.padding);
                }
                return super.equals(obj);
            }

            @Override
            public int hashCode() {
                int hash = super.hashCode();
                hash = 31 * hash + this.padding.hashCode();
                return hash;
            }
        }

        private static class EntryC
        extends Entry {
            private final HorizontalAlign alignH;
            private final VerticalAlign alignV;
            private final TableMargins padding;
            private final int borders;
            private final Document doc;

            EntryC(DocCell c) {
                super(c);
                this.doc = c.getDocument();
                this.alignH = c.horizontalAlign();
                this.alignV = c.verticalAlign();
                this.padding = c.getCellMargins();
                this.borders = c.borders();
            }

            @Override
            protected void generate(StringBuilder out) {
                super.generate(out);
                EntryC.appendBorders(this.doc, this.borders, out);
                out.append("box-sizing: border-box;\n -moz-box-sizing: border-box;\n");
                out.append(String.format(Locale.US, "padding:%.2fmm %.2fmm %.2fmm %.2fmm;%n", this.padding.getTop(), this.padding.getRight(), this.padding.getBottom(), this.padding.getLeft()));
                if (this.alignH != HorizontalAlign.DEFAULT) {
                    out.append("text-align:").append(this.alignH.name().toLowerCase()).append(";\n");
                }
                if (this.alignV != VerticalAlign.DEFAULT) {
                    out.append("vertical-align:").append(this.alignV.name().toLowerCase()).append(";\n");
                }
                if (this.width != 0.0) {
                    EntryC.appendWidth(this.width, out);
                }
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof EntryC) {
                    EntryC that = (EntryC)obj;
                    return super.equals(obj) && that.alignH == this.alignH && that.alignV == this.alignV && that.padding.equals(this.padding) && that.borders == this.borders;
                }
                return super.equals(obj);
            }

            @Override
            public int hashCode() {
                int hash = super.hashCode();
                hash = 31 * hash + this.alignH.hashCode();
                hash = 31 * hash + this.alignV.hashCode();
                hash = 31 * hash + this.padding.hashCode();
                hash = 31 * hash + this.borders;
                return hash;
            }
        }

        private static class EntryR
        extends Entry {
            private final double height;

            EntryR(DocRow r) {
                super(r);
                this.height = r.height();
            }

            @Override
            protected void generate(StringBuilder out) {
                super.generate(out);
                if (this.height != 0.0) {
                    out.append(String.format(Locale.US, "height:%.2fmm%n", this.height));
                }
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof EntryR) {
                    EntryR that = (EntryR)obj;
                    return super.equals(obj) && that.height == this.height;
                }
                return super.equals(obj);
            }

            @Override
            public int hashCode() {
                int hash = super.hashCode();
                hash = 89 * hash + (int)(Double.doubleToLongBits(this.height) ^ Double.doubleToLongBits(this.height) >>> 32);
                return hash;
            }
        }

        private static class EntryT
        extends Entry {
            private final int borders;
            private final double bottomMargin;
            private final Document doc;

            EntryT(DocTable t) {
                super(t);
                this.doc = t.getDocument();
                this.borders = DocBorders.assign(this.doc, t.effectiveBorders());
                this.bottomMargin = t.bottomMargin();
            }

            @Override
            protected void generate(StringBuilder out) {
                super.generate(out);
                out.append("border-collapse:collapse;\n");
                out.append("table-layout:fixed;\n");
                if (this.font.isParentSize()) {
                    out.append("font-size:").append(this.font.getSize()).append("pt;\n");
                }
                if (this.bottomMargin > 0.0) {
                    out.append(String.format(Locale.US, "margin-bottom:%.2fmm;%n", this.bottomMargin));
                }
                EntryT.appendBorders(this.doc, this.borders, out);
                if (this.width != 0.0) {
                    EntryT.appendWidth(this.width, out);
                }
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof EntryT) {
                    EntryT that = (EntryT)obj;
                    return super.equals(obj) && that.borders == this.borders && that.bottomMargin == this.bottomMargin;
                }
                return super.equals(obj);
            }

            @Override
            public int hashCode() {
                int hash = super.hashCode();
                hash = 97 * hash + this.borders;
                hash = 97 * hash + (int)(Double.doubleToLongBits(this.bottomMargin) ^ Double.doubleToLongBits(this.bottomMargin) >>> 32);
                return hash;
            }
        }

        private static class EntryP
        extends Entry {
            private final HorizontalAlign alignH;
            private final int borders;
            private final Document doc;

            EntryP(DocParagraph p) {
                super(p);
                this.alignH = p.align();
                this.doc = p.getDocument();
                this.borders = DocBorders.assign(this.doc, p.getBorders());
            }

            @Override
            protected void generate(StringBuilder out) {
                super.generate(out);
                out.append("margin:0;\n");
                if (this.alignH != HorizontalAlign.DEFAULT) {
                    out.append("text-align:").append(this.alignH.name().toLowerCase()).append(";\n");
                }
                if (this.width != 0.0) {
                    EntryP.appendWidth(this.width, out);
                }
                EntryP.appendBorders(this.doc, this.borders, out);
                out.append("box-sizing: border-box;\n -moz-box-sizing: border-box;\n");
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof EntryP) {
                    EntryP that = (EntryP)obj;
                    return super.equals(obj) && that.alignH == this.alignH && that.borders == this.borders;
                }
                return false;
            }

            @Override
            public int hashCode() {
                int hash = super.hashCode();
                hash = 53 * hash + this.alignH.hashCode();
                hash = 53 * hash + this.borders;
                return hash;
            }
        }

        private static class EntryTxt
        extends Entry {
            private final boolean inTable;

            public EntryTxt(DocText t) {
                super(t);
                this.inTable = t.getParent() instanceof DocCell;
            }

            @Override
            protected void generate(StringBuilder out) {
                super.generate(out);
                if (this.width > 0.0) {
                    out.append("display:inline-block;");
                    if (this.inTable) {
                        out.append("width:auto;");
                    }
                }
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof EntryTxt) {
                    EntryTxt that = (EntryTxt)obj;
                    return super.equals(obj) && that.inTable == this.inTable;
                }
                return false;
            }

            @Override
            public int hashCode() {
                int hash = super.hashCode();
                hash = 97 * hash + (this.inTable ? 1 : 0);
                return hash;
            }
        }

        private static class Entry {
            private final int background;
            protected final Font font;
            protected final double width;

            Entry(IDocumentElement e) {
                this.background = e.getEffectiveColor();
                this.font = e.getFont();
                this.width = e.getWidth();
            }

            private boolean fontEq(Font f0, Font f1) {
                return f0.getName().equals(f1.getName()) && f0.getStyle() == f1.getStyle() && f0.getSize() == f1.getSize() && f0.getColor() == f1.getColor();
            }

            private int fontHash(Font f) {
                int hash = 7;
                hash = 29 * hash + f.getName().hashCode();
                hash = 29 * hash + f.getSize();
                hash = 29 * hash + f.getStyle();
                hash = 29 * hash + f.getColor();
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj instanceof Entry) {
                    Entry that = (Entry)obj;
                    return that.background == this.background && this.fontEq(that.font, this.font) && that.width == this.width;
                }
                return super.equals(obj);
            }

            public int hashCode() {
                int hash = 7;
                hash = 13 * hash + this.background;
                hash = 13 * hash + this.fontHash(this.font);
                hash = 13 * hash + (int)(Double.doubleToLongBits(this.width) ^ Double.doubleToLongBits(this.width) >>> 32);
                return hash;
            }

            private static String vBorder(int bStyle, int bColor, String name) {
                switch (bStyle) {
                    case 1: {
                        return name + ":1px dashed " + HtmlUtils.vColor(bColor) + ";\n";
                    }
                    case 2: {
                        return name + ":1px solid " + HtmlUtils.vColor(bColor) + ";\n";
                    }
                    case 3: {
                        return name + ":2px solid " + HtmlUtils.vColor(bColor) + ";\n";
                    }
                    case 4: {
                        return name + ":3px solid " + HtmlUtils.vColor(bColor) + ";\n";
                    }
                    case 5: {
                        return name + ":3px double " + HtmlUtils.vColor(bColor) + ";\n";
                    }
                }
                return "";
            }

            protected static void appendBorders(Document doc, int b, StringBuilder out) {
                if (DocBorders.left(b) == DocBorders.top(b) && DocBorders.top(b) == DocBorders.right(b) && DocBorders.right(b) == DocBorders.bottom(b)) {
                    out.append(Entry.vBorder(DocBorders.leftStyle(b), DocBorders.leftColor(doc, b), "border"));
                } else {
                    out.append(Entry.vBorder(DocBorders.leftStyle(b), DocBorders.leftColor(doc, b), "border-left"));
                    out.append(Entry.vBorder(DocBorders.topStyle(b), DocBorders.topColor(doc, b), "border-top"));
                    out.append(Entry.vBorder(DocBorders.rightStyle(b), DocBorders.rightColor(doc, b), "border-right"));
                    out.append(Entry.vBorder(DocBorders.bottomStyle(b), DocBorders.bottomColor(doc, b), "border-bottom"));
                }
            }

            protected static void appendWidth(double width, StringBuilder out) {
                out.append(String.format(Locale.US, "width:%.2fmm;%n", width));
            }

            protected void generate(StringBuilder out) {
                if (this.background != 0xFFFFFF && this.background != 0x1FFFFFFF) {
                    out.append("background-color:").append(HtmlUtils.vColor(this.background)).append(";\n");
                }
                if (!this.font.isParent()) {
                    if (!this.font.isParentName()) {
                        out.append("font-family:").append(this.font.getName()).append(";\n");
                    }
                    if (!this.font.isParentSize()) {
                        out.append("font-size:").append(this.font.getSize()).append("pt;\n");
                    }
                    if (!this.font.isParentStyle()) {
                        int st = this.font.getStyle();
                        out.append("font-weight:").append((this.font.getStyle() & 1) != 0 ? "bold" : "normal").append(";\n");
                        out.append("font-style:").append((this.font.getStyle() & 2) != 0 ? "italic" : "normal").append(";\n");
                        out.append("text-decoration:");
                        if ((st & 0xC) != 0) {
                            if ((st & 4) != 0) {
                                out.append(" underline");
                            }
                            if ((st & 8) != 0) {
                                out.append(" line-through");
                            }
                        } else {
                            out.append("text-decoration:").append("none");
                        }
                        out.append(";\n");
                    }
                }
                if (!this.font.isParentColor()) {
                    out.append("color:").append(HtmlUtils.vColor(this.font.getColor())).append(";\n");
                }
            }

            public String toString() {
                StringBuilder result = new StringBuilder();
                this.generate(result);
                return result.toString();
            }
        }
    }
}

