/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.style;

import inform.adt.collections.AbstractHash;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.style.DocTextStyle;
import inform.agent.web.reports.style.TextStyle;
import inform.agent.web.utils.Font;
import java.util.concurrent.atomic.AtomicInteger;

public class DocTextStyleTable
extends AbstractHash<DocTextStyle> {
    private final AtomicInteger styleId = new AtomicInteger(-1);

    public DocTextStyle get(Font font, int color) {
        DocTextStyle e;
        int m = this.mask;
        int i = DocTextStyle.styleHashCode(font, color) & m;
        while ((e = ((DocTextStyle[])this.data)[i]) != null && !DocTextStyle.styleEquals(e, font, color)) {
            i = i + 1 & m;
        }
        return e;
    }

    public DocTextStyle get(TextStyle style) {
        return this.get(style.getFont(), style.getColor());
    }

    public DocTextStyle add(Document document, Font font, int color) {
        DocTextStyle s = this.get(font, color);
        if (s != null) {
            return s;
        }
        s = new DocTextStyle(document, this.styleId.incrementAndGet(), font, color);
        super.add(s);
        return s;
    }

    public DocTextStyle add(Document document, TextStyle style) {
        DocTextStyle s = this.get(style);
        if (s != null) {
            return s;
        }
        s = new DocTextStyle(document, this.styleId.incrementAndGet(), style);
        super.add(s);
        return s;
    }

    @Override
    protected int hash(DocTextStyle s) {
        assert (s != null);
        return DocTextStyle.styleHashCode(s);
    }

    @Override
    protected boolean equals(DocTextStyle a, DocTextStyle b) {
        assert (a != null && b != null);
        return DocTextStyle.styleEquals(a, b);
    }

    protected DocTextStyle[] allocate(int count) {
        return new DocTextStyle[count];
    }
}

