/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.rq;

import inform.adt.InformException;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.ReplicationData;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditInfo;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.CommitException;
import inform.agent.db.commit.CommitRequest;
import inform.agent.db.commit.DeleteEngine;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.types.ValueCaster;
import inform.agent.db.utils.SqlCommand;
import inform.agent.db.utils.SqlCommandBatch;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.files.BFS;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.net.AlertingEngine;
import inform.agent.net.Security;
import inform.agent.scripts.SSContext;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import inform.agent.web.Session;
import inform.agent.web.WebServerSideHost;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.Request;

public class CommitRecords
extends AsmoServlet.WithSession {
    private static final int ACT_UPDATE = 0;
    private static final int ACT_APPEND = 1;
    private static final int ACT_DELETE = 2;
    private SSContext.WebRequest ssContext = null;

    public CommitRecords() {
        super(AsmoServlet.Type.JSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, Session session) throws Throwable {
        response.setCharacterEncoding("WINDOWS-1251");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Type", "application/json");
        double nodeId = 0.0;
        Object[] mods = (Object[])JSON.parse(request.getReader());
        if (mods != null && mods.length != 0) {
            Object[] mm = (Object[])mods[0];
            Object[] ctx = (Object[])mm[1];
            nodeId = ValueCaster.toDouble(ctx[2]);
        }
        this.ssContext = new SSContext.WebRequest(session.newRequestNo(), 3, session);
        this.ssContext.ownerId = nodeId;
        this.ssContext.nodeId = nodeId;
        Ctx context = new Ctx();
        context.currentOwnerId = nodeId;
        context.ssContext = this.ssContext;
        context.prevContext = this.ssContext;
        Session.User sessionUser = session.user();
        BFS blobfs = null;
        try (WebServerSideHost host = new WebServerSideHost(nodeId, sessionUser, (AbstractConnection)((Request)request).getConnection());){
            host.setSSContext(this.ssContext);
            try (Connections connections = new Connections(this.ssContext, host);){
                SqlCommandBatch modifyCommand = new SqlCommandBatch();
                SqlCommand command = new SqlCommand();
                TableDescriptor tableDescriptor = null;
                Connection currentConnection = null;
                block23: for (Object m : mods) {
                    Object[] mm = (Object[])m;
                    int act = ((Number)mm[0]).intValue();
                    Object[] ctx = (Object[])mm[1];
                    double tableId = ((Number)ctx[0]).doubleValue();
                    context.currentUID = ValueCaster.toInt(ctx[1]);
                    context.currentOwnerId = ValueCaster.toDouble(ctx[2]);
                    Object[] requestKeys = (Object[])mm[2];
                    Object[] requestFields = (Object[])mm[3];
                    if (currentConnection != null && tableDescriptor != null && tableDescriptor.getNodeId() != tableId) {
                        currentConnection.deleter.applyDelete();
                        CommitRequest.flushModify(context.prevContext, currentConnection.connection, modifyCommand);
                    }
                    if ((tableDescriptor == null || tableDescriptor.getNodeId() != tableId) && (tableDescriptor = TableDescriptor.get(tableId)).getKind() == TableDescriptor.Kind.VIRTUAL) {
                        throw new CommitException("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439");
                    }
                    if (currentConnection == null || currentConnection.databaseId != tableDescriptor.getDbId()) {
                        currentConnection = connections.get(tableDescriptor.getDbId());
                        context.deleteEngine = currentConnection.deleter;
                        context.auditWriter = currentConnection.auditWriter;
                    }
                    modifyCommand.setTableDesc(tableDescriptor);
                    ArrayList<CommitField> primaryKey = CommitRecords.parseFields(tableDescriptor, requestKeys);
                    ArrayList<CommitField> fields = CommitRecords.parseFields(tableDescriptor, requestFields);
                    double newRecordId = 0.0;
                    double recordId = 0.0;
                    for (CommitField f : primaryKey) {
                        if (f.field.getId() == -1) {
                            recordId = ValueCaster.toDouble(f.value);
                            break;
                        }
                        if (!f.field.isPrimaryKey() || recordId == 0.0) continue;
                        recordId = ValueCaster.toDouble(f.value);
                    }
                    if (recordId == 0.0 && !primaryKey.isEmpty()) {
                        recordId = ValueCaster.toDouble(primaryKey.get((int)0).value);
                    }
                    command.clear();
                    switch (act) {
                        case 0: {
                            context.updateContex();
                            for (CommitField f : fields) {
                                if (f.field.getId() != -1) continue;
                                newRecordId = ValueCaster.toDouble(f.value);
                                break;
                            }
                            currentConnection.deleter.applyDelete();
                            this.checkModifyTable(sessionUser, tableDescriptor);
                            CommitRecords.generateUpdateSql(currentConnection, blobfs, command, fields, primaryKey, recordId, tableDescriptor, connections.connectionManager);
                            if (command.avoidBatch) {
                                CommitRequest.flushModify(context.prevContext, currentConnection.connection, modifyCommand);
                                command.setTableDescriptor(tableDescriptor);
                                int updatedRowCount = command.executeUpdate(context.dsContext, currentConnection.connection);
                                if (updatedRowCount != 1) {
                                    StringBuilder msg = new StringBuilder();
                                    msg.append("\u041f\u0430\u0440\u0430\u043b\u0435\u043b\u044c\u043d\u043e\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 ").append(" [").append(tableDescriptor.getNodeId()).append("] ").append(tableDescriptor.getCaption()).append(" [row id: ").append((long)recordId).append("] ");
                                    throw new CommitException(msg);
                                }
                            } else {
                                modifyCommand.add(command, currentConnection.connection, context.dsContext);
                            }
                            if (newRecordId == 0.0) {
                                currentConnection.auditWriter.registrateModification(tableDescriptor, recordId, AuditModification.MODIFY);
                            } else {
                                currentConnection.auditWriter.registrateModification(tableDescriptor, newRecordId, AuditModification.MODIFY, recordId);
                            }
                            connections.replications.add(tableId, 0, recordId);
                            continue block23;
                        }
                        case 1: {
                            context.updateContex();
                            currentConnection.deleter.applyDelete();
                            this.checkAddToTable(sessionUser, tableDescriptor);
                            CommitRecords.generateAppendSqlText(currentConnection, blobfs, command, fields, primaryKey, recordId, tableDescriptor, connections.connectionManager);
                            modifyCommand.add(command, currentConnection.connection, context.dsContext);
                            currentConnection.auditWriter.registrateModification(tableDescriptor, recordId, AuditModification.APPEND);
                            connections.replications.add(tableId, 1, recordId);
                            continue block23;
                        }
                        case 2: {
                            context.updateContex();
                            this.checkTableAccess(sessionUser, tableDescriptor, 0x800000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
                            CommitRequest.flushModify(context.prevContext, currentConnection.connection, modifyCommand);
                            if (primaryKey.size() == 1 && recordId != 0.0) {
                                currentConnection.deleter.deleteRow(tableId, recordId);
                                currentConnection.auditWriter.registrateModification(tableDescriptor, recordId, AuditModification.DELETE);
                                connections.replications.add(tableId, 2, recordId);
                                continue block23;
                            }
                            ByteArrayOutputStream inticateKey = new ByteArrayOutputStream();
                            TaggedWriter out = new TaggedWriter(inticateKey);
                            block26: for (CommitField f : primaryKey) {
                                out.putInt32(32, f.field.getId());
                                if (f.value == null) {
                                    out.putEmpty(10);
                                    continue;
                                }
                                switch (f.field.getType().toSqlDataType()) {
                                    case INTEGER: {
                                        out.putInt32(11, ValueCaster.toInt(f.value));
                                        continue block26;
                                    }
                                    case DOUBLE: {
                                        out.putDouble(12, ValueCaster.toDouble(f.value));
                                        continue block26;
                                    }
                                    case STRING: {
                                        out.putAnsi(13, ValueCaster.toString(f.value));
                                        continue block26;
                                    }
                                    case DATE_TIME: 
                                    case TIMESTAMP: {
                                        out.putDouble(14, ValueCaster.toDouble(f.value));
                                        continue block26;
                                    }
                                    case UNICODE: {
                                        out.putUnicode(24, ValueCaster.toString(f.value));
                                        continue block26;
                                    }
                                    case BOOLEAN: {
                                        if (ValueCaster.toBoolean(f.value).booleanValue()) {
                                            out.putInt08(34, (byte)1);
                                            continue block26;
                                        }
                                        out.putInt08(34, (byte)0);
                                        continue block26;
                                    }
                                }
                                throw new IllegalStateException();
                            }
                            out.flush();
                            currentConnection.deleter.deleteRow(tableId, inticateKey.toByteArray());
                        }
                    }
                }
                if (currentConnection != null) {
                    currentConnection.deleter.applyDelete();
                    CommitRequest.flushModify(context.prevContext, currentConnection.connection, modifyCommand);
                    currentConnection.auditWriter.flush();
                }
                connections.connectionManager.commit();
                if (blobfs != null) {
                    blobfs.commit();
                }
                if (!connections.replications.isEmpty()) {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    TaggedWriter stream = new TaggedWriter(bytes);
                    connections.replications.serialize(stream);
                    stream.flush();
                    AlertingEngine.sendChangeNotification(null, bytes.internalBuffer(), bytes.size(), 999L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void generateAppendSqlText(Connection connection, BFS blobfs, SqlCommand command, ArrayList<CommitField> commitFields, ArrayList<CommitField> primaryKey, double recordId, TableDescriptor tableDescriptor, AbstractConnectionManager connectionManager) throws SQLException, IOException, InformException {
        fields = new SqlStringBuilder();
        values = new StringBuilder();
        blobFields = null;
        blobValues = null;
        blobParams = null;
        auditInfo = new AuditInfo(connection.auditWriter, tableDescriptor, recordId, AuditModification.APPEND);
        modifiedFields = new IntegerSet();
        for (CommitField f : commitFields) {
            fieldType = f.field.getType();
            auditInfo.setField(f.field);
            CommitRequest.checkCanModifyField(tableDescriptor, f.field, true);
            modifiedFields.add(f.field.getId());
            switch (1.$SwitchMap$inform$agent$db$types$DataType[fieldType.ordinal()]) {
                case 1: 
                case 2: {
                    throw new IllegalStateException();
                }
                case 3: {
                    if (blobFields == null) {
                        blobFields = new SqlStringBuilder();
                    }
                    blobFields.append(',').append(f.field);
                    break;
                }
                default: {
                    fields.append(',').append(f.field);
                }
            }
            if (f.value == null) {
                switch (1.$SwitchMap$inform$agent$db$types$DataType[fieldType.ordinal()]) {
                    case 1: 
                    case 2: {
                        throw new IllegalStateException();
                    }
                    case 3: {
                        if (blobValues == null) {
                            blobValues = new StringBuilder();
                        }
                        blobValues.append(",NULL");
                    }
                }
                values.append(",NULL");
                auditInfo.setNull();
                continue;
            }
            switch (1.$SwitchMap$inform$agent$db$types$SqlDataType[fieldType.toSqlDataType().ordinal()]) {
                case 1: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    values.append(',').append('?');
                    vInt = ValueCaster.toInt(f.value);
                    param.setInteger(vInt);
                    auditInfo.setNumber(vInt);
                    break;
                }
                case 2: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    values.append(',').append('?');
                    vDbl = ValueCaster.toDouble(f.value);
                    param.setDouble(vDbl);
                    auditInfo.setNumber(vDbl);
                    break;
                }
                case 3: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    values.append(',').append('?');
                    vStr = ValueCaster.toString(f.value);
                    param.setString(vStr);
                    auditInfo.setString(vStr);
                    break;
                }
                case 4: 
                case 5: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    values.append(',').append('?');
                    vDbl = ValueCaster.toDouble(f.value);
                    param.setDateTime(vDbl);
                    auditInfo.setDateTime(vDbl);
                    break;
                }
                case 6: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    values.append(',').append('?');
                    vStr = ValueCaster.toString(f.value);
                    param.setUnicode(vStr);
                    auditInfo.setUnicode(vStr);
                    break;
                }
                case 7: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    values.append(',').append('?');
                    vBool = ValueCaster.toBoolean(f.value);
                    param.setBoolean(vBool);
                    auditInfo.setNumber(vBool != false ? 1.0 : 0.0);
                    break;
                }
                case 8: {
                    if (blobValues == null) {
                        blobValues = new StringBuilder();
                    }
                    if (blobParams == null) {
                        blobParams = new SqlParameterList();
                    }
                    param = new SqlParameter(fieldType.toSqlDataType());
                    blobParams.add(param);
                    blobValues.append(",?");
                    if (!(f.value instanceof Object[]) || ((Object[])f.value).length != 1) {
                        param.setNull();
                        break;
                    }
                    fileName = new File(ValueCaster.toString(((Object[])f.value)[0]));
                    if (!fileName.isFile() || !fileName.exists() || fileName.length() == 0L) ** GOTO lbl141
                    l = fileName.length();
                    dataSize = (int)l;
                    if ((long)dataSize != l) {
                        throw new IllegalArgumentException(fileName.getName());
                    }
                    data = new byte[(int)l];
                    file = new FileInputStream(fileName);
                    try {
                        size = file.read(data);
                        if (size != dataSize) {
                            throw new IllegalStateException(fileName.getName());
                        }
                    }
                    finally {
                        file.close();
                    }
                    param.setBlob(data);
                    auditInfo.setBlob(data);
                    break;
lbl141:
                    // 1 sources

                    param.setNull();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        CommitRequest.generateGeneratedField(null, command, ',', connection.host, tableDescriptor, modifiedFields, fields.getBuilder(), values, connectionManager, true, auditInfo);
        if (blobFields != null) {
            fields.append(blobFields);
        }
        if (blobValues != null) {
            values.append((CharSequence)blobValues);
        }
        if (blobParams != null) {
            command.params.addParameters(blobParams);
        }
        if (fields.length() > 0) {
            fields.getBuilder().setCharAt(0, ' ');
        }
        if (values.length() > 0) {
            values.setCharAt(0, ' ');
        }
        command.sqlText.append("insert into ").appendFull(tableDescriptor).append(" (").append(fields).append(") values (").append(values).append(')');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void generateUpdateSql(Connection connection, BFS blobfs, SqlCommand command, ArrayList<CommitField> commitFields, ArrayList<CommitField> primaryKey, double recordId, TableDescriptor tableDescriptor, AbstractConnectionManager connectionManager) throws InformException, IOException, SQLException {
        commaText = 32;
        addedParam = null;
        auditInfo = new AuditInfo(connection.auditWriter, tableDescriptor, recordId, AuditModification.MODIFY);
        modifiedFields = new IntegerSet();
        blobFields = null;
        blobParams = null;
        hasNonBlobFields = false;
        command.sqlText.append("update ").appendFull(tableDescriptor).append(" set ");
        intricatePK = primaryKey.size() != 1 || recordId == 0.0;
        block28: for (CommitField f : commitFields) {
            fieldType = f.field.getType();
            auditInfo.setField(f.field);
            if (f.field.getId() == -1) {
                command.sqlText.append((char)commaText).append(f.field).append("=");
                commaText = 44;
                hasNonBlobFields = true;
            } else {
                CommitRequest.checkCanModifyField(tableDescriptor, f.field, false);
                modifiedFields.add(f.field.getId());
                switch (1.$SwitchMap$inform$agent$db$types$DataType[fieldType.ordinal()]) {
                    case 1: 
                    case 2: {
                        throw new IllegalStateException();
                    }
                    case 3: {
                        if (blobFields == null) {
                            blobFields = new SqlStringBuilder();
                        } else {
                            blobFields.append(',');
                        }
                        blobFields.append(f.field).append("=");
                        break;
                    }
                    default: {
                        command.sqlText.append((char)commaText).append(f.field).append("=");
                        commaText = 44;
                        hasNonBlobFields = true;
                    }
                }
            }
            if (f.value == null) {
                switch (1.$SwitchMap$inform$agent$db$types$DataType[fieldType.ordinal()]) {
                    case 1: 
                    case 2: {
                        throw new IllegalStateException();
                    }
                    case 3: {
                        if (blobFields == null) {
                            blobFields = new SqlStringBuilder();
                        } else {
                            blobFields.append(',');
                        }
                        blobFields.append("NULL ");
                        continue block28;
                    }
                }
                command.sqlText.append("NULL ");
                auditInfo.setNull();
                continue;
            }
            switch (1.$SwitchMap$inform$agent$db$types$SqlDataType[fieldType.toSqlDataType().ordinal()]) {
                case 1: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    command.sqlText.append('?');
                    vInt = ValueCaster.toInt(f.value);
                    param.setInteger(vInt);
                    auditInfo.setNumber(vInt);
                    break;
                }
                case 2: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    command.sqlText.append('?');
                    vDbl = ValueCaster.toDouble(f.value);
                    param.setDouble(vDbl);
                    auditInfo.setNumber(vDbl);
                    break;
                }
                case 3: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    command.sqlText.append('?');
                    vStr = ValueCaster.toString(f.value);
                    param.setString(vStr);
                    auditInfo.setString(vStr);
                    break;
                }
                case 4: 
                case 5: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    command.sqlText.append('?');
                    vDbl = ValueCaster.toDouble(f.value);
                    param.setDateTime(vDbl);
                    auditInfo.setDateTime(vDbl);
                    break;
                }
                case 6: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    command.sqlText.append('?');
                    vStr = ValueCaster.toString(f.value);
                    param.setUnicode(vStr);
                    auditInfo.setUnicode(vStr);
                    break;
                }
                case 7: {
                    param = new SqlParameter(fieldType.toSqlDataType());
                    command.params.add(param);
                    command.sqlText.append('?');
                    vBool = ValueCaster.toBoolean(f.value);
                    param.setBoolean(vBool);
                    auditInfo.setNumber(vBool != false ? 1.0 : 0.0);
                    break;
                }
                case 8: {
                    if (blobParams == null) {
                        blobParams = new SqlParameterList();
                    }
                    param = new SqlParameter(fieldType.toSqlDataType());
                    blobParams.add(param);
                    blobFields.append('?');
                    if (!(f.value instanceof Object[]) || ((Object[])f.value).length != 1) {
                        param.setNull();
                        break;
                    }
                    fileName = new File(ValueCaster.toString(((Object[])f.value)[0]));
                    if (!fileName.isFile() || !fileName.exists() || fileName.length() == 0L) ** GOTO lbl157
                    l = fileName.length();
                    dataSize = (int)l;
                    if ((long)dataSize != l) {
                        throw new IllegalArgumentException(fileName.getName());
                    }
                    data = new byte[(int)l];
                    file = new FileInputStream(fileName);
                    try {
                        size = file.read(data);
                        if (size != dataSize) {
                            throw new IllegalStateException(fileName.getName());
                        }
                    }
                    finally {
                        file.close();
                    }
                    param.setBlob(data);
                    auditInfo.setBlob(data);
                    break;
lbl157:
                    // 1 sources

                    param.setNull();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (CommitRequest.generateGeneratedField(null, command, ',', connection.host, tableDescriptor, modifiedFields, command.sqlText.getBuilder(), null, connectionManager, false, auditInfo)) {
            hasNonBlobFields = true;
        }
        if (blobFields != null) {
            if (hasNonBlobFields) {
                command.sqlText.append(',');
            }
            command.sqlText.append(blobFields);
            if (blobParams != null) {
                command.params.addParameters(blobParams);
            }
        }
        if ((pkFields = tableDescriptor.getPrimaryKeyFields()).isEmpty()) {
            msg = new StringBuilder();
            msg.append("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e").append("\n\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \"").append(tableDescriptor.getCaption()).append("\" [").append((long)tableDescriptor.getNodeId()).append("] \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447");
            throw new InformException(msg.toString());
        }
        command.sqlText.append(" where ");
        if (!intricatePK && pkFields.size() == 1 && tableDescriptor.getRecordIdField() != null) {
            command.sqlText.append(tableDescriptor.getRecordIdField().getRawName()).append("=?");
            param = new SqlParameter();
            command.params.add(param);
            param.setDouble(recordId);
        } else {
            if (pkFields.size() != primaryKey.size()) {
                msg = new StringBuilder();
                msg.append("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e").append("\n\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \"").append(tableDescriptor.getCaption()).append("\" [").append((long)tableDescriptor.getNodeId()).append("] \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0435 \u043a\u043b\u044e\u0447\u0438");
                throw new InformException(msg.toString());
            }
            and = "";
            block29: for (CommitField f : primaryKey) {
                command.sqlText.append(and).append(f.field);
                and = " AND ";
                if (f.value == null) {
                    command.sqlText.append(" IS NULL");
                    continue;
                }
                param = new SqlParameter(f.field.getType().toSqlDataType());
                command.sqlText.append("=?");
                switch (1.$SwitchMap$inform$agent$db$types$SqlDataType[param.getType().ordinal()]) {
                    case 1: {
                        param.setInteger(ValueCaster.toInt(f.value));
                        continue block29;
                    }
                    case 2: {
                        param.setDouble(ValueCaster.toDouble(f.value));
                        continue block29;
                    }
                    case 3: {
                        param.setString(ValueCaster.toString(f.value));
                        continue block29;
                    }
                    case 4: 
                    case 5: {
                        param.setDateTime(ValueCaster.toDouble(f.value));
                        continue block29;
                    }
                    case 6: {
                        param.setUnicode(ValueCaster.toString(f.value));
                        continue block29;
                    }
                    case 7: {
                        param.setBoolean(ValueCaster.toBoolean(f.value));
                        continue block29;
                    }
                }
                throw new IllegalStateException();
            }
        }
    }

    private void checkTableAccess(Session.User sessUser, TableDescriptor tableInfo, int permission, String message) throws CommitException {
        BasicNode node = MtdEngine.getValidTranslatedNode(tableInfo.getNodeId());
        Acl acl = Security.acl(node);
        if ((sessUser.accessMask(acl) & permission) != permission) {
            StringBuilder msg = new StringBuilder();
            msg.append(message).append(" [").append(tableInfo.getNodeId()).append("] ");
            throw new CommitException(msg.toString());
        }
    }

    private void checkModifyTable(Session.User sessUser, TableDescriptor tableInfo) throws CommitException {
        this.checkTableAccess(sessUser, tableInfo, 0x1000000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
    }

    private void checkAddToTable(Session.User sessUser, TableDescriptor tableInfo) throws CommitException {
        this.checkTableAccess(sessUser, tableInfo, 0x2000000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443");
    }

    private static ArrayList<CommitField> parseFields(TableDescriptor tableDescriptors, Object[] requestFields) {
        ArrayList<CommitField> fields = new ArrayList<CommitField>();
        for (Object obj : requestFields) {
            Object[] ff = (Object[])obj;
            int fieldId = ((Number)ff[0]).intValue();
            Object value = ff[1];
            CommitField field = new CommitField();
            field.field = tableDescriptors.getExistingFieldDescriptor(fieldId);
            field.value = value;
            fields.add(field);
        }
        return fields;
    }

    private static class CommitField {
        FieldDescriptor field;
        Object value;

        private CommitField() {
        }
    }

    private static class Connection
    implements DoubleHash.Entry {
        final double databaseId;
        final ServerSideHost host;
        final DatabaseConnection connection;
        final TableDataAudit auditWriter;
        final DeleteEngine deleter;

        Connection(double databaseId, Connections connections) throws SQLException {
            this.databaseId = databaseId;
            this.host = connections.host;
            this.connection = connections.connectionManager.getConnection(databaseId, "DataReplicationApplyEngine:Connection");
            this.auditWriter = new TableDataAudit(connections.ssContext, this.connection, connections.host.getUserID(), connections.host.getEffectiveUserID(), 0.0, 0.0, connections.host.getSessionID());
            this.auditWriter.setOwnerId(this.host.getNodeID());
            this.auditWriter.setBatchMode(true);
            this.deleter = new DeleteEngine(connections.ssContext, connections.connectionManager, connections.replications, connections.host.getUserID(), connections.host);
            this.deleter.setAuditWriter(this.auditWriter);
        }

        @Override
        public double key() {
            return this.databaseId;
        }
    }

    private static class Connections {
        final ReplicationData replications;
        final AbstractConnectionManager connectionManager;
        final ServerSideHost host;
        final DoubleHash<Connection> connections = new DoubleHash();
        final SSContext ssContext;

        Connections(SSContext ssContext, ServerSideHost host) {
            this.host = host;
            this.replications = new ReplicationData();
            this.connectionManager = new ConnectionManager(ssContext, "rq:CommitRecords");
            this.ssContext = ssContext;
        }

        void rollback() throws SQLException {
            this.connectionManager.rollback();
        }

        void close() {
            this.connectionManager.release();
        }

        Connection get(double databaseId) throws SQLException {
            Connection c = this.connections.get(databaseId);
            if (c == null) {
                c = new Connection(databaseId, this);
                this.connections.add(c);
            }
            return c;
        }
    }

    private static class Ctx {
        TableDataAudit auditWriter = null;
        DeleteEngine deleteEngine = null;
        SSContext ssContext = null;
        SSContext prevContext = null;
        SSContext.CommitDatasource dsContext = null;
        int currentUID = 0;
        double tableNodeId = 0.0;
        double currentOwnerId = 0.0;

        private Ctx() {
        }

        void updateContex() {
            SSContext.CommitDatasource context = this.dsContext;
            this.dsContext = SSContext.CommitDatasource.getContext(this.ssContext, this.currentOwnerId, this.currentUID, this.tableNodeId, this.dsContext);
            if (this.dsContext != context) {
                this.prevContext = this.dsContext;
                this.deleteEngine.setContext(this.dsContext);
                this.auditWriter.setContext(this.dsContext);
            }
        }
    }
}

