/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.LittleEndian;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleList;
import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;

public class CellPositions {
    private double precision = 1.0;
    private final DoubleList values = new DoubleList(1);
    private static final double MIN_PRECISION = 0.1;

    public void setPosition(double p) {
        int index = 0;
        for (Cursor.Double c : this.values) {
            if (this.sameValue(c.value, p)) {
                return;
            }
            if (p < c.value) {
                this.values.add(index, p);
                return;
            }
            ++index;
        }
        this.values.add(p);
    }

    public int findPosition(double p) {
        int result = 0;
        for (Cursor.Double double_ : this.values()) {
            if (this.sameValue(double_.value, p)) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    public double[] getPositions() {
        int N = 0;
        for (Cursor.Double double_ : this.values()) {
            ++N;
        }
        double[] result = new double[N];
        boolean bl = false;
        for (Cursor.Double double_ : this.values()) {
            result[++var3_5] = double_.value;
        }
        return result;
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        if (precision < 0.1) {
            precision = 0.1;
        }
        this.precision = precision;
    }

    public Iterable<? extends Cursor.Double> values() {
        return this.values;
    }

    public void storeAs(int tag, TaggedWriter writer) throws IOException {
        if (this.values.empty()) {
            return;
        }
        double[] widths = new double[this.values.size()];
        double position = 0.0;
        int index = 0;
        for (Cursor.Double c : this.values) {
            double nextPosition = c.value;
            widths[index++] = nextPosition - position;
            position = nextPosition;
        }
        writer.putRaw(tag, LittleEndian.doubleArrayToBinary(widths));
    }

    private boolean sameValue(double v1, double v2) {
        if (v1 > v2) {
            return v1 - v2 <= this.precision;
        }
        return v2 - v1 <= this.precision;
    }
}

