/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.Strings;
import java.io.IOException;

public class HtmlUtils {
    public static String htmlEnquote(String s) {
        if (Strings.isVoid(s)) {
            return " ";
        }
        StringBuilder tmp = new StringBuilder();
        int lc = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    if (lc == 13) break;
                    tmp.append("<br/>");
                    break;
                }
                case '\r': {
                    tmp.append("<br/>");
                    break;
                }
                case '\t': {
                    tmp.append(" ");
                    break;
                }
                case '\"': {
                    tmp.append("&quot;");
                    break;
                }
                case '&': {
                    tmp.append("&amp;");
                    break;
                }
                case '<': {
                    tmp.append("&lt;");
                    break;
                }
                case '>': {
                    tmp.append("&gt;");
                    break;
                }
                default: {
                    tmp.append(c);
                }
            }
            lc = c;
        }
        return tmp.toString();
    }

    public static void enquoteAttribute(String s, char q, Appendable out) throws IOException {
        int lc = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    if (lc == 13) break;
                }
                case '\r': {
                    out.append("\\n");
                    break;
                }
                case '\"': 
                case '\'': {
                    if (c != q) {
                        out.append(c);
                        break;
                    }
                    if (c == '\"') {
                        out.append("&quot;");
                        break;
                    }
                    out.append("&apos;");
                    break;
                }
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            lc = c;
        }
    }

    public static String vColor(int c) {
        if (c == 0) {
            return "black";
        }
        if (c == 0xFFFFFF) {
            return "white";
        }
        if (c < 0) {
            switch (c & 0xFF) {
                case 5: {
                    return "white";
                }
                case 8: {
                    return "black";
                }
            }
        }
        return String.format("#%02X%02X%02X", c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF);
    }
}

