/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.ComponentList;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.Task;
import java.io.IOException;

public class VeerKey {
    private int veerId = 0;
    private int[] veerFieldPath = null;
    private int dataId = 0;
    private int[] dataFieldPath = null;
    private Datasource veer = null;
    private DatasetField veerField = null;
    private Datasource data = null;
    private DatasetField dataField = null;
    private static final int TAG_WEB_VEER_VEER_ID = 1;
    private static final int TAG_WEB_VEER_VEER_FIELD = 2;
    private static final int TAG_WEB_VEER_DATA_ID = 3;
    private static final int TAG_WEB_VEER_DATA_FIELD = 4;

    public VeerKey() {
    }

    public VeerKey(VeerKey key) {
        this.veerId = key.veerId;
        this.veerFieldPath = key.veerFieldPath;
        this.dataId = key.dataId;
        this.dataFieldPath = key.dataFieldPath;
        this.veer = key.veer;
        this.veerField = key.veerField;
        this.data = key.data;
        this.dataField = key.dataField;
    }

    public void selectVeer() throws Exception {
        if (this.veer != null) {
            this.veer.executeSelect();
            this.veer.reset();
        }
    }

    public boolean next() throws Exception, InformException, InterruptedException {
        return this.veer != null && this.veer.next();
    }

    public Object getVeerValue() throws Exception {
        return this.getFieldValue(this.veer, this.veerField, this.veerFieldPath);
    }

    public boolean veerLocate(Object key) throws Exception {
        if (this.veer == null) {
            return true;
        }
        if (!this.veer.isSelected()) {
            this.veer.executeSelect();
        }
        DataType dataType = this.veerFieldPath.length == 1 && this.veerFieldPath[0] == -1 ? DataType.PRIMARY_KEY : this.veerField.getDataType();
        this.veer.reset();
        while (this.veer.next()) {
            if (dataType == DataType.PRIMARY_KEY) {
                if (key == null) {
                    return false;
                }
                if (!key.equals(this.veer.getRecordID())) continue;
                return true;
            }
            Object value = ValueCaster.getCastedValue(dataType, this.veerField.getValue());
            if (!value.equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isDataSelected(Object key) throws Exception {
        if (this.veer == null) {
            return true;
        }
        if (this.dataField == null) {
            return true;
        }
        Object dataKey = this.getFieldValue(this.data, this.dataField, this.dataFieldPath);
        if (key == null) {
            return dataKey == null;
        }
        if (dataKey == null) {
            return key == null;
        }
        DataType dataType = this.veerFieldPath.length == 1 && this.veerFieldPath[0] == -1 ? DataType.FLOAT : this.veerField.getDataType();
        dataKey = ValueCaster.getCastedValue(dataType, dataKey);
        return dataKey.equals(key);
    }

    public void load(TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.next()) {
            this.loadTag(reader);
        }
    }

    protected void loadTag(TaggedReader reader) throws IOException, TaggedReaderException {
        switch (reader.getCurrentTag()) {
            case 1: {
                this.veerId = reader.getInt();
                break;
            }
            case 2: {
                this.veerFieldPath = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 3: {
                this.dataId = reader.getInt();
                break;
            }
            case 4: {
                this.dataFieldPath = LittleEndian.toIntArray(reader.getRaw());
            }
        }
    }

    public boolean isEmpty() {
        return this.isFieldEmpty(this.veer, this.veerField, this.veerFieldPath) || this.isFieldEmpty(this.data, this.dataField, this.dataFieldPath);
    }

    public void adterLoad(Task task) throws InformException {
        ComponentList components = task.getComponents();
        this.veer = components.findDatasource(this.veerId);
        if (this.veer != null) {
            this.veerField = this.veer.findFieldPath(this.veerFieldPath);
        }
        this.data = components.findDatasource(this.dataId);
        if (this.data != null) {
            this.dataField = this.data.findFieldPath(this.dataFieldPath);
        }
    }

    private Object getFieldValue(Datasource ds, DatasetField field, int[] fieldPath) throws Exception {
        if (fieldPath.length == 1 && fieldPath[0] == -1) {
            if (ds == null) {
                return null;
            }
            return ds.getRecordID();
        }
        if (field == null) {
            return null;
        }
        return field.getAvailableValue();
    }

    private boolean isFieldEmpty(Datasource ds, DatasetField field, int[] fieldPath) {
        if (fieldPath != null && fieldPath.length == 1 && fieldPath[0] == -1) {
            return ds == null;
        }
        return field == null;
    }
}

