/*
 * Decompiled with CFR 0.152.
 */
package inform.common;

import inform.common.Empty;
import java.util.Arrays;

public class Base64BinString {
    private static final int EmptyRevMap = 255;
    private static final char[] map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static int[] revMap;

    private static int byteToInt(byte b) {
        return b & 0xFF;
    }

    private static void encode3Block(byte[] data, int index, StringBuilder out) {
        out.append(map[Base64BinString.byteToInt(data[index + 0]) >> 2]);
        out.append(map[(Base64BinString.byteToInt(data[index + 0]) & 3) << 4 | (Base64BinString.byteToInt(data[index + 1]) & 0xF0) >> 4]);
        out.append(map[(Base64BinString.byteToInt(data[index + 1]) & 0xF) << 2 | (Base64BinString.byteToInt(data[index + 2]) & 0xC0) >> 6]);
        out.append(map[Base64BinString.byteToInt(data[index + 2]) & 0x3F]);
    }

    private static void encodeTailBlock(byte[] data, int index, StringBuilder out, int len) {
        assert (len == 1 || len == 2);
        switch (len) {
            case 1: {
                out.append(map[Base64BinString.byteToInt(data[index + 0]) >> 2]);
                out.append(map[(Base64BinString.byteToInt(data[index + 0]) & 3) << 4]);
                out.append('=');
                out.append('=');
                break;
            }
            case 2: {
                out.append(map[Base64BinString.byteToInt(data[index + 0]) >> 2]);
                out.append(map[(Base64BinString.byteToInt(data[index + 0]) & 3) << 4 | (Base64BinString.byteToInt(data[index + 1]) & 0xF0) >> 4]);
                out.append(map[(Base64BinString.byteToInt(data[index + 1]) & 0xF) << 2]);
                out.append('=');
            }
        }
    }

    public static String Encode(byte[] data) {
        if (null == data) {
            return "";
        }
        return Base64BinString.Encode(data, data.length);
    }

    public static String Encode(byte[] data, int length) {
        if (null == data || length <= 0 || data.length < length) {
            return "";
        }
        int inLen = length;
        int tailLen = inLen % 3;
        StringBuilder out = new StringBuilder();
        int index = 0;
        for (int monoBlockLen = inLen / 3; monoBlockLen > 0; --monoBlockLen) {
            Base64BinString.encode3Block(data, index, out);
            index += 3;
        }
        if (tailLen != 0) {
            Base64BinString.encodeTailBlock(data, index, out, tailLen);
        }
        String result = out.toString();
        return result;
    }

    public static byte[] Decode(String str) {
        byte[] result;
        if (str == null) {
            return Empty.byteArray;
        }
        Base64BinString.FillRevMap();
        byte[] data = new byte[(str.length() + 3) / 4 * 3];
        int dataCount = 0;
        int tail = 0;
        int tailBits = 0;
        for (int index = 0; index < str.length(); ++index) {
            int currentBits;
            char currentChar = str.charAt(index);
            if (currentChar >= revMap.length || (currentBits = revMap[currentChar]) == 255) continue;
            tail = (currentBits <<= 2) >> tailBits & 0xFF | currentBits << 16 - tailBits & 0xFF00 | tail;
            if ((tailBits += 6) < 8) continue;
            data[dataCount++] = (byte)tail;
            tail >>= 8;
            tailBits -= 8;
        }
        if (data.length == dataCount) {
            result = data;
        } else {
            result = new byte[dataCount];
            System.arraycopy(data, 0, result, 0, dataCount);
        }
        return result;
    }

    private static void FillRevMap() {
        if (revMap != null) {
            return;
        }
        int[] m = new int[256];
        Arrays.fill(m, 255);
        for (int i = 0; i < map.length; ++i) {
            m[Base64BinString.map[i] & 0xFFFF] = i;
        }
        revMap = m;
    }
}

