/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.util.concurrent.Executor;

public final class DeadLockProofWorker {
    public static final ThreadLocal<Executor> PARENT = new ThreadLocal();

    public static void start(final Executor parent, final Runnable runnable) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        parent.execute(new Runnable(){

            @Override
            public void run() {
                PARENT.set(parent);
                try {
                    runnable.run();
                }
                finally {
                    PARENT.remove();
                }
            }
        });
    }

    private DeadLockProofWorker() {
    }
}

