/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.util.Map;
import java.util.Properties;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public final class SystemPropertyUtil {
    private static final Properties props = new Properties();
    private static final InternalLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        Properties newProps = null;
        try {
            newProps = System.getProperties();
        }
        catch (SecurityException e) {
            logger.warn("Unable to retrieve the system properties; default values will be used.", e);
            newProps = new Properties();
        }
        Properties properties = props;
        synchronized (properties) {
            props.clear();
            props.putAll((Map<?, ?>)newProps);
        }
    }

    public static boolean contains(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return props.containsKey(key);
    }

    public static String get(String key) {
        return SystemPropertyUtil.get(key, null);
    }

    public static String get(String key, String def) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String value = props.getProperty(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean def) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String value = props.getProperty(key);
        if (value == null) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).length() == 0) {
            return true;
        }
        if (value.equals("true") || value.equals("yes") || value.equals("1")) {
            return true;
        }
        if (value.equals("false") || value.equals("no") || value.equals("0")) {
            return false;
        }
        logger.warn("Unable to parse the boolean system property '" + key + "':" + value + " - using the default value: " + def);
        return def;
    }

    public static int getInt(String key, int def) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String value = props.getProperty(key);
        if (value == null) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).matches("-?[0-9]+")) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.warn("Unable to parse the integer system property '" + key + "':" + value + " - using the default value: " + def);
        return def;
    }

    public static long getLong(String key, long def) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String value = props.getProperty(key);
        if (value == null) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).matches("-?[0-9]+")) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.warn("Unable to parse the long integer system property '" + key + "':" + value + " - using the default value: " + def);
        return def;
    }

    private SystemPropertyUtil() {
    }

    static {
        SystemPropertyUtil.refresh();
        logger = InternalLoggerFactory.getInstance(SystemPropertyUtil.class);
    }
}

