define([
    'static.wcl.Core',
    'static.wcl.Theme',
    'inform.agent.web.Styles'
], function(Core, Theme, Styles) {
    Styles.sheet().rules({
        '.wcl-edit': {
            'border': '1px solid #D0D0D0',
            'border-radius': '3px',
            'padding': '2px',
            'line-height': (Theme.LINECONTROL_HEIGHT - 6) + 'px',  
            '::-webkit-inner-spin-button': {
                '-webkit-appearance': 'none'
            },
            '[readonly]': {
                'background': '#F0F0F0'//IE8bug
            }
        }
    });
    return function(parent, container, arg) {
        var element = document.createElement('input');
        element.className = 'wcl-edit';
        Core._modelUpdater(arg.value, function(value) {
            element.value = value;
        });
        if (Core._isModel(arg.value) && (arg.value.set instanceof Function))
            element.onchange = function() {
                arg.value.set(this.value);
            };
        else
            element.setAttribute('readonly', true);
        container.appendChild(element);
        this.calculate = function() {
            var h = Theme.LINECONTROL_HEIGHT;
            return {
                min: {x: 50, y: h},
                max: {x: 9999, y: h}
            };
        };
        var recter = Core._mkRecter(element);
        this.validate = function(arg) {
            recter(arg.rect);
        };
    };
});
