﻿var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", 'FormatsOld', 'FormatsOld', './FormatsCore', './FormatsSpell', '../TaggedIO'], function (require, exports, FormatsOld_1, old, FormatsCore_1, FormatsSpell_1, TaggedIO_1) {
    "use strict";
    exports.DATETIME_DD_MM_YYYY_HH_MM_SS = FormatsOld_1.DATETIME_DD_MM_YYYY_HH_MM_SS;
    function separate_thousands(s) {
        return s.replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
    }
    var ID2CLASS = {};
    var ID2INSTANCE = {};
    function findById(id) {
        var fmt = ID2INSTANCE[id];
        if (fmt === undefined) {
            var cls = ID2CLASS[id];
            if (cls !== undefined)
                ID2INSTANCE[id] = fmt = new cls(id);
        }
        return fmt || old.findById(id);
    }
    exports.findById = findById;
    function byIdAndOption(id, option) {
        if (!option)
            return findById(id);
        var cls = ID2CLASS[id];
        if (!cls)
            return findById(id);
        return new cls(id, option);
    }
    exports.byIdAndOption = byIdAndOption;
    function byTypeAndName(t, name) {
        return findById(old.getIDByTypeAndName(t, name));
    }
    exports.byTypeAndName = byTypeAndName;
    function createFloatFormat(scale, keepTailZero, separateThousand) {
        var fmt = new FloatFormat(601);
        fmt.scale = scale;
        fmt.keep_tail_zero = keepTailZero;
        fmt.with_separator = separateThousand;
        return fmt;
    }
    exports.createFloatFormat = createFloatFormat;
    /*** formats definitions ***/
    var DecPointChar;
    (function (DecPointChar) {
        DecPointChar[DecPointChar["Point"] = 0] = "Point";
        DecPointChar[DecPointChar["Comma"] = 1] = "Comma";
    })(DecPointChar || (DecPointChar = {}));
    var FloatFormat = (function () {
        function FloatFormat(id, option) {
            this.scale = -1;
            this.keep_tail_zero = false;
            this.with_separator = false;
            this.show_part = FormatsCore_1.ShowPart.All;
            this.dec_point = DecPointChar.Point;
            if (option) {
                var show_ints = true, show_frcs = true;
                var r = new TaggedIO_1.TaggedReader(option);
                while (r.next())
                    switch (r.getCurrentTag()) {
                        case 100 /*TAG_DF_SCALE*/:
                            this.scale = r.getInt();
                            break;
                        case 96 /*TAG_DF_WITH_SEPARATOR*/:
                            this.with_separator = true;
                            break;
                        case 97 /*TAG_DF_KEEP_TAIL_ZERO*/:
                            this.keep_tail_zero = true;
                            break;
                        case 50 /*TAG_DF_SHOW_CENTS*/:
                            show_frcs = false;
                            break;
                        case 53 /*TAG_DF_SHOW_INTGS*/:
                            show_ints = false;
                            break;
                        case 91 /*TAG_DF_DECIMAL_POINT*/:
                            this.dec_point = r.getInt();
                            break;
                    }
                if (show_ints && show_frcs)
                    this.show_part = FormatsCore_1.ShowPart.All;
                else if (show_ints)
                    this.show_part = FormatsCore_1.ShowPart.Int;
                else if (show_frcs)
                    this.show_part = FormatsCore_1.ShowPart.Frc;
            }
        }
        FloatFormat.prototype.format = function (value) {
            var r;
            var s = this.scale;
            if (s === -1)
                r = this.fmt_def(value);
            else {
                r = value.toFixed(s);
                if (!this.keep_tail_zero)
                    r = r.replace(/0+$/, '');
            }
            switch (this.show_part) {
                case FormatsCore_1.ShowPart.Int:
                    r = r.replace(/\..*$/, '');
                    break;
                case FormatsCore_1.ShowPart.Frc:
                    r = r.replace(/^.*\./, '');
                    break;
            }
            if (this.with_separator) {
                var ci = r.indexOf('.');
                if (ci === -1)
                    r = separate_thousands(r);
                else
                    r = separate_thousands(r.substr(0, ci)) + r.substr(ci);
            }
            if (this.dec_point === DecPointChar.Comma)
                r = r.replace(/\./, ',');
            return r;
        };
        FloatFormat.prototype.fmt_def = function (value) { return String(value); };
        FloatFormat.prototype.parse = function (str) {
            var v = parseFloat(str);
            if (isNaN(v))
                throw 'not match';
            return v;
        };
        return FloatFormat;
    }());
    ID2CLASS[601] = FloatFormat;
    var MoneyFormat = (function (_super) {
        __extends(MoneyFormat, _super);
        function MoneyFormat(id, option) {
            _super.call(this, id, option);
            this.keep_tail_zero = true;
            this.with_separator = true;
        }
        MoneyFormat.prototype.fmt_def = function (value) {
            try {
                var r = value.toPrecision(15);
                r = r.replace(/(\.\d{2}(?:\d*[^0])?)0+$/, '$1');
                return r;
            }
            catch (e) {
                return null;
            }
        };
        return MoneyFormat;
    }(FloatFormat));
    ID2CLASS[602] = MoneyFormat;
    var BooleanFormat = (function () {
        function BooleanFormat(id, option) {
            this.s_true = '��';
            this.s_false = '���';
            if (option) {
                var r = new TaggedIO_1.TaggedReader(option);
                while (r.next())
                    switch (r.getCurrentTag()) {
                        case 98:
                            this.s_false = r.getAnsi();
                            break;
                        case 99:
                            this.s_true = r.getAnsi();
                            break;
                    }
            }
        }
        BooleanFormat.prototype.format = function (value) {
            return value ? this.s_true : this.s_false;
        };
        BooleanFormat.prototype.parse = function (value) {
            throw Error('not supported yet');
        };
        return BooleanFormat;
    }());
    ID2CLASS[701] = BooleanFormat;
    ID2CLASS[650] = FormatsSpell_1.SpellMoneyFormat;
    ID2CLASS[651] = FormatsSpell_1.SpellFloatFormat;
    ID2CLASS[652] = FormatsSpell_1.SpellMoneyFormat;
});
