define(function () {
    var MS_PER_DAY = 24 * 60 * 60 * 1000;
    var GREG_MS = (new Date( 1899, 11, 30 )).valueOf();
    var DEFAULT_YEAR = 2000;
    function _2( v ) {
        return v < 10 ? '0' + v : v;
    }
    function mkFormat( fd ) {
        var r = {};
        for (var i in fd) {
            if (i === "_parse")
                r.parse = function(s) {
                    return (fd._parse(s).valueOf() - GREG_MS) / MS_PER_DAY;
                };
            else {
                if (i === "_format")
                    r.format = function(v) {
                        return fd._format(new Date(GREG_MS + v * MS_PER_DAY));
                    };
                r[i] = fd[i];
            }
        }
        return r;
    }
    var byid = {};
    var Formats = {
        findById: function( id ) {
            return byid[id];
        },
        getIDByTypeAndName: function( t, name ) {
            var id = null;
            if (name)
                for (var i in FormatNames) {
                    var fn = FormatNames[i];
                    if ((fn.n.toUpperCase() == name.toUpperCase()) && (!t || (t == fn.t)))
                    {    
                        id = fn.id;
                        break;
                    }    
                }
            if (id == null)
                switch(t)
                {
                    case 7:  return 701;
                    case 2:  return 601;
                    case 5:  return 501;
                    case 10: return 1001;
                    case 4:  return 401;
                }
            return id;
        }
    };

    Formats.DATETIME_DD_MM_YYYY = byid[401] = mkFormat( {mask: "99.99.9999", calendar: true,
        _format: function( v ) {
            return Formats.DATETIME_DD_MM._format( v ) + '.' + Formats.DATETIME_YYYY._format( v );
        },
        _parse: function( s ) {
            var m = s.match( /(\d{1,2})\.(\d{1,2})\.(\d{4})/ );
            if ( !m )
                throw "not match";
            var dd = m[1] | 0, mm = m[2] | 0, yy = m[3] | 0;
            if ( (dd >= 1) && (dd <= 31) && (mm >= 1) && (mm <= 12) && yy )
                return new Date( yy, mm - 1, dd );
            throw "out of bounds";
        }
    } );
    Formats.DATETIME_MM_YYYY = byid[402] = mkFormat( {mask: "99.9999", calendar: true,
        _format: function( v ) {
            return _2( v.getMonth() + 1 ) + '.' + Formats.DATETIME_YYYY._format( v );
        },
        _parse: function( s ) {
            var m = s.match( /(\d{1,2})\.(\d{4})/ );
            if ( !m )
                throw "not match";
            var mm = m[1] | 0, yy = m[2] | 0;
            if ( (mm >= 1) && (mm <= 12) && yy )
                return new Date( yy, mm - 1, 1 );
            throw "out of bounds";
        }
    } );
    Formats.DATETIME_YYYY = byid[403] = mkFormat( {mask: "9999", calendar: true,
        _format: function( v ) {
            return v.getFullYear().toString();
        },
        _parse: function( s ) {
            var m = s.match( /(\d{4})/ );
            if ( !m )
                throw "not match";
            var yy = m[1] | 0;
            if ( yy )
                return new Date( yy, 0 );
            throw "out of bounds";
        }
    } );
    Formats.DATETIME_HH_MM = byid[404] = mkFormat( {mask: "99:99",
        _format: function( v ) {
            return Formats.DATETIME_HH._format( v ) + ':' + _2( v.getMinutes() );
        },
        _parse: function( s ) {
            var m = s.match( /(\d{1,2}):(\d{1,2})/ );
            if ( !m )
                throw "not match";
            var hh = m[1] | 0, MM = m[2] | 0;
            if ( (hh >= 0) && (hh <= 23) && (MM >= 0) && (MM <= 59) )
                return new Date( DEFAULT_YEAR, 0, 1, hh, MM );
            throw "out of bounds";
        }
    } );
    Formats.DATETIME_HH_MM_SS = byid[405] = mkFormat( {mask: "99:99:99",
        _format: function( v ) {
            return Formats.DATETIME_HH_MM._format( v ) + ':' + _2( v.getSeconds() );
        },
        _parse: function( s ) {
            var m = s.match( /(\d{1,2}):(\d{1,2}):(\d{1,2})/ );
            if ( !m )
                throw "not match";
            var hh = m[1] | 0, MM = m[2] | 0, ss = m[3] | 0;
            if ( (hh >= 0) && (hh <= 23) && (MM >= 0) && (MM <= 59) && (ss >= 0) && (ss <= 59) )
                return new Date( DEFAULT_YEAR, 0, 1, hh, MM, ss );
            throw "out of bounds";
        }
    } );
    Formats.DATETIME_DD_MM_YYYY_HH_MM = byid[406] = mkFormat( {mask: "99.99.9999 99:99", calendar: true,
        _format: function( v ) {
            return Formats.DATETIME_DD_MM_YYYY._format( v ) + ' ' + Formats.DATETIME_HH_MM._format( v );
        },
        _parse: function( s ) {
            var m = s.match( /(\d{1,2})\.(\d{1,2})\.(\d{4})\s(\d{1,2}):(\d{1,2})/ );
            if ( !m )
                throw "not match";
            var dd = m[1] | 0, mm = m[2] | 0, yy = m[3] | 0;
            var hh = m[4] | 0, MM = m[5] | 0;
            if ( (dd >= 1) && (dd <= 31) && (mm >= 1) && (mm <= 12) && yy )
                if ( (hh >= 0) && (hh <= 23) && (MM >= 0) && (MM <= 59) )
                    return new Date( yy, mm - 1, dd, hh, MM );
            throw "out of bounds";
        }
    } );
    Formats.DATETIME_HH = byid[407] = mkFormat( {mask: "99",
        _format: function( v ) {
            return _2( v.getHours() );
        },
        _parse: function( s ) {
            var m = s.match( /(\d{1,2})/ );
            if ( !m )
                throw "not match";
            var hh = m[1] | 0;
            if ( (hh >= 0) && (hh <= 23) )
                return new Date( DEFAULT_YEAR, 0, 1, hh );
            throw "out of bounds";
        }
    } );
    Formats.DATETIME_DD = byid[408] = mkFormat( {mask: "99", calendar: true,
        _format: function( v ) {
            return _2( v.getDate() );
        },
        _parse: function( s ) {
            var m = s.match( /(\d{1,2})/ );
            if ( !m )
                throw "not match";
            var dd = m[1] | 0;
            if ( (dd >= 1) && (dd <= 31) )
                return new Date( DEFAULT_YEAR, 0, dd );
            throw "out of bounds";
        }
    } );
    Formats.DATETIME_DD_MM = byid[409] = mkFormat( {mask: "99.99", calendar: true,
        _format: function( v ) {
            return Formats.DATETIME_DD._format( v ) + '.' + _2( v.getMonth() + 1 );
        },
        _parse: function( s ) {
            var m = s.match( /(\d{1,2})\.(\d{1,2})/ );
            if ( !m )
                throw "not match";
            var dd = m[1] | 0, mm = m[2] | 0;
            if ( (dd >= 1) && (dd <= 31) && (mm >= 1) && (mm <= 12) )
                return new Date( DEFAULT_YEAR, mm - 1, dd );
            throw "out of bounds";
        }
    } );
    Formats.DATETIME_DD_MM_YYYY_HH_MM_SS = byid[410] = mkFormat( {mask: "99.99.9999 99:99:99", calendar: true,
        _format: function( v ) {
            return Formats.DATETIME_DD_MM_YYYY._format( v ) + ' ' + Formats.DATETIME_HH_MM_SS._format( v );
        },
        _parse: function( s ) {
            var m = s.match( /(\d{1,2})\.(\d{1,2})\.(\d{4})\s(\d{1,2}):(\d{1,2}):(\d{1,2})/ );
            if ( !m )
                throw "not match";
            var dd = m[1] | 0, mm = m[2] | 0, yy = m[3] | 0;
            var hh = m[4] | 0, MM = m[5] | 0, ss = m[6] | 0;
            if ( (dd >= 1) && (dd <= 31) && (mm >= 1) && (mm <= 12) && yy )
                if ( (hh >= 0) && (hh <= 23) && (MM >= 0) && (MM <= 59) && (ss >= 0) && (ss <= 59) )
                    return new Date( yy, mm - 1, dd, hh, MM, ss );
            throw "out of bounds";
        }
    } );
    byid[411] = mkFormat( {calendar: true,
        _format: function( v ) {
            return Formats.DATETIME_QUARTER._format( v ) + ' ' + Formats.DATETIME_YYYY._format( v );
        }
    } );
    byid[451] = mkFormat( {calendar: true,
        _format: function( v ) {
            return Formats.DATETIME_DD_GMONTH._format( v ) + ' ' + Formats.DATETIME_YYYY._format( v );
        }
    } );
    byid[452] = mkFormat( {calendar: true,
        _format: function( v ) {
            return Formats.DATETIME_MONTH._format( v ) + ' ' + Formats.DATETIME_YYYY._format( v );
        }
    } );
    Formats.DATETIME_DD_GMONTH = byid[453] = mkFormat( {calendar: true,
        _format: function( v ) {
            var m = Formats.DATETIME_MONTH._format( v ), lc = m.charAt( m.length - 1 );
            if ( (lc === '') || (lc === '') )
                m = m.substr( 0, m.length - 1 ) + '';
            else
                m += '';
            return Formats.DATETIME_DD._format( v ) + ' ' + m;
        }
    } );
    Formats.DATETIME_MONTH = byid[454] = mkFormat( {calendar: true,
        _format: function( v ) {
            return ["", "", "", "", "", "", "", "", "", "", "", ""][v.getMonth()];
        }
    } );
    byid[455] = mkFormat( {calendar: true,
        _format: function( v ) {
            return Formats.DATETIME_DECADE._format( v ) + ": " + Formats.DATETIME_MONTH._format( v );
        }
    } );
    byid[456] = mkFormat( {calendar: true,
        _format: function( v ) {
            return Formats.DATETIME_HALFYEAR._format(v) + ": " + Formats.DATETIME_MONTH._format( v );
        }
    } );
    Formats.DATETIME_DECADE = byid[457] = mkFormat( {calendar: true,
        _format: function( v ) {
            return Math.min( (((v.getDate() - 1) / 10) | 0) + 1, 3 ) + " ";
        }
    } );
    Formats.DATETIME_QUARTER = byid[458] = mkFormat( {calendar: true,
        _format: function( v ) {
            return ["I", "II", "III", "IV"][(v.getMonth() / 3) | 0] + " .";
        }
    } );
    Formats.DATETIME_HALFYEAR = byid[459] = mkFormat( {calendar: true,
        _format: function( v ) {
            return ((v.getMonth() / 6) | 0 ? "II" : "I") + " ";
        }
    } );
    Formats.FLOAT_DEFAULT = byid[601] = {
        format: function( v ) {
            return v.toString();
        },
        parse: function( s ) {
            var v = parseFloat( s );
            if ( isNaN( v ) )
                throw "not match";
            return v;
        }
    };
    Formats.FAMILY_IO = byid[1001] = {
        format: function( ni ) {
            if ( !ni.fio )
                return ni.name;
            var sp = ni.fio.split( /\s+/ );
            return sp[0] + (sp[1] && (' ' + sp[1][0] + '.') || "") + (sp[2] && (' ' + sp[2][0] + '.') || "");
        }
    };
    Formats.FIO = byid[1002] = {
        format: function( ni ) {
            return ni.fio || ni.name;
        }
    };
    
    var FormatNames = [
        //DATE_TIME
        {t: 4, id: 401, n: ".."},
        {t: 4, id: 402, n: "."},
        {t: 4, id: 403, n: ""},
        {t: 4, id: 404, n: ":"},
        {t: 4, id: 405, n: "::"},
        {t: 4, id: 406, n: ".. :"},
        {t: 4, id: 407, n: ""},
        {t: 4, id: 408, n: ""},
        {t: 4, id: 409, n: "."},
        {t: 4, id: 410, n: ".. ::CC"},
        {t: 4, id: 411, n: "."},
        {t: 4, id: 412, n: ".."},
        {t: 4, id: 451, n: "  "},
        {t: 4, id: 452, n: " "},
        {t: 4, id: 453, n: " "},
        {t: 4, id: 454, n: ""},
        {t: 4, id: 455, n: ":"},
        {t: 4, id: 456, n: ":"},
        {t: 4, id: 457, n: ""},
        {t: 4, id: 458, n: ""},
        {t: 4, id: 459, n: ""},
        //INTERVAL
        {t: 5, id: 501, n: "::"},
        {t: 5, id: 502, n: ":"},
        {t: 5, id: 503, n: ""},
        {t: 5, id: 504, n: ":"},
        {t: 5, id: 505, n: ""},
        {t: 5, id: 506, n: ""},
        {t: 5, id: 507, n: ":::MM:"},
        {t: 5, id: 508, n: "::MM:"},
        {t: 5, id: 509, n: "::MM"},
        {t: 5, id: 510, n: ":"},
        //FLOAT
        {t: 2, id: 601, n: ""},
        {t: 2, id: 602, n: ""},
        {t: 2, id: 650, n: " "},
        {t: 2, id: 651, n: " "},
        {t: 2, id: 652, n: " () "},
        //BOOL
        {t: 7, id: 701, n: ""},
        //METATREENODE
        {t: 10, id: 1001, n: " .."}, 
        {t: 10, id: 1002, n: ""}
    ]
    
    return Formats;
} );
