﻿define(["require", "exports", './FormatsCore', '../TaggedIO', '../utils/Strings'], function (require, exports, FormatsCore_1, TaggedIO_1, Strings_1) {
    "use strict";
    function capitalize(s) {
        return s[0].toUpperCase() + s.substring(1);
    }
    var C100 = ['', '��� ', '������ ', '������ ', '��������� ', '������� ', '�������� ', '������� ', '��������� ', '��������� '];
    var C10 = ['', '������ ', '�������� ', '�������� ', '����� ', '��������� ', '���������� ', '��������� ', '����������� ', '��������� '];
    var C11 = ['', '����������� ', '���������� ', '���������� ', '������������ ', '���������� ', '����������� ', '���������� ', '������������ ', '������������ '];
    var C1F = ['', '���� ', '��� ', '��� ', '������ ', '���� ', '����� ', '���� ', '������ ', '������ '];
    var C1T = ['', '���� ', '��� ', '��� ', '������ ', '���� ', '����� ', '���� ', '������ ', '������ '];
    var C1000_1 = ['', '������ ', '������� ', '�������� ', '�������� ', '����������� ', '����������� '];
    var C1000_2 = ['', '������ ', '�������� ', '��������� ', '��������� ', '������������ ', '������������ '];
    var C1000_5 = ['', '����� ', '��������� ', '���������� ', '���������� ', '������������� ', '������������� '];
    var C1000_S10 = [C1000_5, C1000_1, C1000_2, C1000_2, C1000_2, C1000_5, C1000_5, C1000_5, C1000_5, C1000_5];
    var E100 = ['', 'one hundred ', 'two hundred ', 'three hundred ', 'four hundred ', 'five hundred ', 'six hundred ', 'seven hundred ', 'eight hundred ', 'nine hundred '];
    var E10 = ['', 'ten ', 'twenty ', 'thirty ', 'forty ', 'fifty ', 'sixty ', 'seventy ', 'eighty ', 'ninety '];
    var E10_ = ['', 'ten ', 'twenty-', 'thirty-', 'forty-', 'fifty-', 'sixty-', 'seventy-', 'eighty-', 'ninety-'];
    var E11 = ['', 'eleven ', 'twelve ', 'thirteen ', 'fourteen ', 'fifteen ', 'sixteen ', 'seventeen ', 'eighteen ', 'nineteen '];
    var E1 = ['', 'one ', 'two ', 'three ', 'four ', 'five ', 'six ', 'seven ', 'eight ', 'nine '];
    var E1000 = ['', 'thousand ', 'million ', 'billion ', 'trillion ', 'quadrillion ', 'quintillion '];
    var WMN = [false, true, false, false, false, false, false];
    var SpellLang;
    (function (SpellLang) {
        SpellLang[SpellLang["Ru"] = 0] = "Ru";
        SpellLang[SpellLang["En"] = 1] = "En";
    })(SpellLang || (SpellLang = {}));
    function decimal_to_spell(n, lang) {
        var pad = 3 - n.length % 3;
        if (pad !== 3)
            while (pad--)
                n = '0' + n;
        var r = '';
        for (var i = 0, grc = (n.length / 3) | 0; i !== grc; ++i) {
            var mi = grc - i - 1, o = i * 3;
            var w = WMN[mi];
            var i0 = Number(n[o + 0]), i1 = Number(n[o + 1]), i2 = Number(n[o + 2]);
            r += (lang === SpellLang.Ru ? C100[i0] : E100[i0]);
            if ((i1 === 1) && (i2 > 0))
                r += (lang === SpellLang.Ru ? C11[i2] : E11[i2]);
            else
                r += (lang === SpellLang.Ru ? (C10[i1] + (w ? C1T[i2] : C1F[i2])) : ((i2 === 0 ? E10[i1] : E10_[i1]) + E1[i2]));
            if (i1 === 1)
                r += (lang === SpellLang.Ru ? C1000_5[mi] : E1000[mi]);
            else
                r += (lang === SpellLang.Ru ? C1000_S10[i2][mi] : E1000[mi]);
        }
        if (n[0] === '-')
            r = (lang === SpellLang.Ru ? '����� ' + r : 'minus ' + r);
        return r || (lang === SpellLang.Ru ? '���� ' : 'zero ');
    }
    var CHARCODE_ZERO = '0'.charCodeAt(0), CHARCODE_ONE = '1'.charCodeAt(0);
    var RUB_INTS = ['������', '�����', '�����', '�����', '�����', '������', '������', '������', '������', '������'];
    var RUB_FRCS = ['������', '�������', '�������', '�������', '�������', '������', '������', '������', '������', '������'];
    var ENG_INTS = ['rubles', 'ruble', 'rubles', 'rubles', 'rubles', 'rubles', 'rubles', 'rubles', 'rubles', 'rubles'];
    var ENG_FRCS = ['kopecks', 'kopeck', 'kopecks', 'kopecks', 'kopecks', 'kopecks', 'kopecks', 'kopecks', 'kopecks', 'kopecks'];
    function curr_part(n, parts) {
        if ((n.length > 1) && (n.charCodeAt(n.length - 2) === CHARCODE_ONE))
            return parts[0];
        var lc = n.charCodeAt(n.length - 1);
        return parts[lc - CHARCODE_ZERO];
    }
    var CurrencySpellFormat;
    (function (CurrencySpellFormat) {
        CurrencySpellFormat[CurrencySpellFormat["Default"] = 0] = "Default";
        CurrencySpellFormat[CurrencySpellFormat["TextNumberFull"] = 1] = "TextNumberFull";
        CurrencySpellFormat[CurrencySpellFormat["TextNumberShort"] = 2] = "TextNumberShort";
        CurrencySpellFormat[CurrencySpellFormat["NumberFull"] = 3] = "NumberFull";
        CurrencySpellFormat[CurrencySpellFormat["NumberShort"] = 4] = "NumberShort";
    })(CurrencySpellFormat || (CurrencySpellFormat = {}));
    var SpellMoneyFormat = (function () {
        function SpellMoneyFormat(id, option) {
            this.show_part = FormatsCore_1.ShowPart.All;
            this.csf = CurrencySpellFormat.Default;
            this.show_unit = true;
            this.show_number = true;
            this.template = '';
            this.spellLang = SpellLang.Ru;
            if (Number(id) == 652)
                this.spellLang = SpellLang.En;
            if (option) {
                var show_ints = true, show_frcs = true;
                var r = new TaggedIO_1.TaggedReader(option);
                while (r.next())
                    switch (r.getCurrentTag()) {
                        case 50:
                            show_frcs = false;
                            break;
                        case 53:
                            show_ints = false;
                            break;
                        case 54:
                            this.show_unit = false;
                            break;
                        case 55:
                            this.show_number = false;
                            break;
                        case 59:
                            this.csf = CurrencySpellFormat.TextNumberFull;
                            break;
                        case 60:
                            this.csf = r.getInt();
                            break;
                        case 61:
                            this.template = r.getAnsi();
                            break;
                    }
                if (show_ints && show_frcs)
                    this.show_part = FormatsCore_1.ShowPart.All;
                else if (show_ints)
                    this.show_part = FormatsCore_1.ShowPart.Int;
                else if (show_frcs)
                    this.show_part = FormatsCore_1.ShowPart.Frc;
            }
        }
        SpellMoneyFormat.prototype.format = function (value) {
            var s = Number(value).toFixed(2);
            var i = s.indexOf('.');
            var self = this;
            function fmt_int() {
                var val = i === -1 ? s : s.substring(0, i);
                var tmp = '';
                if (self.show_number)
                    switch (self.csf) {
                        case CurrencySpellFormat.Default:
                            tmp = capitalize(Strings_1.trimAll(decimal_to_spell(val, self.spellLang)));
                            break;
                        case CurrencySpellFormat.TextNumberFull:
                            tmp = val + ' (' + Strings_1.trimAll(decimal_to_spell(val, self.spellLang)) + ')';
                            break;
                        case CurrencySpellFormat.TextNumberShort:
                            tmp = val + ' (' + Strings_1.trimAll(decimal_to_spell(val, self.spellLang)) + ')';
                            break;
                        case CurrencySpellFormat.NumberFull:
                        case CurrencySpellFormat.NumberShort:
                            tmp = val;
                            break;
                        default:
                            throw Error('unsupported CurrencySpellFormat(' + self.csf + ')');
                    }
                if (self.show_unit) {
                    if (tmp)
                        tmp += ' ';
                    switch (self.csf) {
                        case CurrencySpellFormat.Default:
                        case CurrencySpellFormat.TextNumberFull:
                        case CurrencySpellFormat.NumberFull:
                            return tmp + (self.spellLang === SpellLang.Ru ? curr_part(val, RUB_INTS) : curr_part(val, ENG_INTS));
                        case CurrencySpellFormat.TextNumberShort:
                        case CurrencySpellFormat.NumberShort:
                            return tmp + (self.spellLang === SpellLang.Ru ? '���.' : 'rub.');
                        default:
                            throw Error('unsupported CurrencySpellFormat(' + self.csf + ')');
                    }
                }
                return tmp;
            }
            function fmt_frc() {
                var val = i === -1 ? '0' : s.substring(i + 1);
                if (!self.show_unit) {
                    return self.show_number ? val : '';
                }
                var tmp = self.show_number ? (val + ' ') : '';
                switch (self.csf) {
                    case CurrencySpellFormat.Default:
                    case CurrencySpellFormat.TextNumberFull:
                    case CurrencySpellFormat.NumberFull:
                        return tmp + (self.spellLang === SpellLang.Ru ? curr_part(val, RUB_FRCS) : curr_part(val, ENG_FRCS));
                    case CurrencySpellFormat.TextNumberShort:
                    case CurrencySpellFormat.NumberShort:
                        return tmp + (self.spellLang === SpellLang.Ru ? '���.' : 'kop.');
                }
                throw Error('unsupported CurrencySpellFormat(' + self.csf + ')');
            }
            switch (this.show_part) {
                case FormatsCore_1.ShowPart.Int:
                    return fmt_int();
                case FormatsCore_1.ShowPart.Frc:
                    return fmt_frc();
                default:
                    return fmt_int() + ' ' + fmt_frc();
            }
        };
        SpellMoneyFormat.prototype.parse = function (value) {
            throw Error('not supported yet');
        };
        return SpellMoneyFormat;
    }());
    exports.SpellMoneyFormat = SpellMoneyFormat;
    var SpellNumberKind;
    (function (SpellNumberKind) {
        SpellNumberKind[SpellNumberKind["Full"] = 0] = "Full";
        SpellNumberKind[SpellNumberKind["Int"] = 1] = "Int";
        SpellNumberKind[SpellNumberKind["Frac"] = 2] = "Frac";
    })(SpellNumberKind || (SpellNumberKind = {}));
    var SpellFloatFormat = (function () {
        function SpellFloatFormat(id, option) {
            this.spellNumberKind = SpellNumberKind.Full;
            this.scale = 8;
            this.showWholeWord = false;
            if (option) {
                var r = new TaggedIO_1.TaggedReader(option);
                while (r.next())
                    switch (r.getCurrentTag()) {
                        case 57:
                            this.spellNumberKind = r.getInt();
                            break;
                        case 58:
                            this.showWholeWord = true;
                            break;
                        case 56:
                            this.scale = r.getInt();
                            if (this.scale < 0)
                                this.scale = 0;
                            if (this.scale > 8)
                                this.scale = 8;
                            break;
                    }
            }
        }
        SpellFloatFormat.prototype.format = function (value) {
            var FRAC_WORD = ['', '�����', '���', '������', ' �����������', ' ���������', ' ��������', ' ��������������', ' ���������'];
            var INT_WORD = ['�����', '�����', '�����'];
            var FRAC_ENDING = ['��', '��', '��'];
            function wordNo(str) {
                var result = 2;
                if ((str.length > 1) && (str.charAt(str.length - 2) == '1'))
                    result = 2;
                else {
                    switch (str.charAt(str.length - 1)) {
                        case '1':
                            result = 0;
                            break;
                        case '2':
                        case '3':
                        case '4':
                            result = 1;
                            break;
                    }
                }
                ;
                return result;
            }
            var self = this;
            var s = Number(value).toFixed(self.scale);
            var i = s.indexOf('.');
            function fmt_int(intOnly) {
                var val = i === -1 ? s : s.substring(0, i);
                var tmp = '';
                if (!intOnly || self.showWholeWord)
                    tmp = decimal_to_spell(val, SpellLang.Ru) + INT_WORD[wordNo(val)];
                else
                    tmp = decimal_to_spell(val, SpellLang.Ru);
                return tmp;
            }
            function fmt_frc() {
                var val = i === -1 ? '' : s.substring(i + 1);
                if (!val.length)
                    return val;
                val = val.replace(new RegExp('0+$'), '');
                var tmp = '';
                tmp = decimal_to_spell(val, SpellLang.Ru) + FRAC_WORD[val.length - 1] + FRAC_ENDING[wordNo(val)];
                return tmp;
            }
            switch (this.spellNumberKind) {
                case SpellNumberKind.Int:
                    return fmt_int(true);
                case SpellNumberKind.Frac:
                    return fmt_frc();
                default:
                    return fmt_int(false) + ' ' + fmt_frc();
            }
        };
        SpellFloatFormat.prototype.parse = function (value) {
            throw Error('not supported yet');
        };
        return SpellFloatFormat;
    }());
    exports.SpellFloatFormat = SpellFloatFormat;
});
