define( [
    "static.jquery.jquery",
    "static.jquery.jquery-maskedinput",
    "css!inform.agent.web.forms.WebCalendar"
], function( $, $mi ) {
    var MS_PER_DAY = 24 * 60 * 60 * 1000;
    var Dates = {
        dowName: function( dow ) {
            return ["", "", "", "", "", "", ""][dow];
        },
        monthName: function( month ) {
            return ["", "", "", "", "", "", "", "", "", "", "", ""][month];
        },
        date2js: (function() {
            var GREG_MS = (new Date( 1899, 11, 30 )).valueOf();
            return function( v ) {
                return new Date( GREG_MS + v * MS_PER_DAY );
            };
        })(),
        isLeapYear: function( year ) {
            return !(year % 4) && ((year % 100) || !(year % 400));
        },
        daysInMonth: function( year, month ) {
            if ( (month === 1) && Dates.isLeapYear( year ) )
                return 29;
            return [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][month];
        }
    };
    function MonthsCombo( model ) {
        var span = document.createElement( "span" );
        this.element = function() {
            return span;
        };
        span.className = "buttoned monthscombo";
        var bl = document.createElement( "button" );
        bl.innerHTML = "&#9664;";
        bl.type = "button";
        bl.onclick = function() {
            var v = new Date( model().getTime() );
            var d = v.getDate(), m = v.getMonth(), y = v.getFullYear();
            if ( m === 0 )
                v.setFullYear( y = y - 1 );
            m = (m + 11) % 12;
            var dim = Dates.daysInMonth( y, m );
            if ( d > dim )
                v.setDate( dim );
            v.setMonth( m );
            model( v );
            update();
        };
        span.appendChild( bl );
        var select = document.createElement( "select" );
        for ( var i = 0; i < 12; i++ ) {
            var option = document.createElement( "option" );
            option.innerHTML = Dates.monthName( i );
            option.value = i;
            select.appendChild( option );
        }
        select.onchange = function() {
            var d = new Date( model().getTime() );
            d.setMonth( this.selectedIndex );
            model( d );
        };
        span.appendChild( select );
        var br = document.createElement( "button" );
        br.innerHTML = "&#9654;";
        br.type = "button";
        br.onclick = function() {
            var v = new Date( model().getTime() );
            var d = v.getDate(), m = v.getMonth(), y = v.getFullYear();
            if ( m === 11 )
                v.setFullYear( y = y + 1 );
            m = (m + 1) % 12;
            var dim = Dates.daysInMonth( y, m );
            if ( d > dim )
                v.setDate( dim );
            v.setMonth( m );
            model( v );
            update();
        };
        span.appendChild( br );
        function update() {
            select.selectedIndex = model().getMonth();
        }
        model.listen && model.listen( update );
        update();
    }
    function mkList( arg ) {
        var limit = arg.limit || 0xFFFF;
        return limit < arg.count ? function( model ) {
            var a = document.createElement( "a" );
            this.element = function() {
                return a;
            };
            a.className = "datelist";
            a.href = "javascript:";
            a.onclick = function() {
                this.focus();
                var cell = $( a ).find( ".active" )[0];
                model( arg.set( model(), cell.value ) );
                update();
            };
            var table = document.createElement( "table" );
            a.appendChild( table );
            var tbody = document.createElement( "tbody" );
            table.appendChild( tbody );
            var items = [];
            a.onkeydown = function( e ) {
                e = e || window.event;
                var nidx = -1;
                switch ( e.keyCode ) {
                    case 37://left
                        nidx = (lidx + arg.count - arg.limit) % arg.count;
                        break;
                    case 38://up
                        nidx = (lidx + arg.count - 1) % arg.count;
                        break;
                    case 39://right
                        nidx = (lidx + arg.limit) % arg.count;
                        break;
                    case 40://down
                        nidx = (lidx + 1) % arg.count;
                        break;
                }
                if ( nidx >= 0 ) {
                    model( arg.set( model(), items[nidx].value ) );
                    update();
                }
            };
            for ( var i = 0; i < arg.count; i++ ) {
                var row = i < limit ? tbody.insertRow( tbody.rows.length ) : tbody.rows[i % limit];
                var item = row.insertCell( row.cells.length );
                item.innerHTML = arg.display( i );
                item.value = i;
                item.onclick = function() {
                    model( arg.set( model(), this.value ) );
                    update();
                };
                items.push( item );
            }
            var lidx = null;
            function update() {
                items[lidx] && (items[lidx].className = "");
                lidx = arg.get( model() );
                var curr = items[arg.get( new Date() )];
                curr && (curr.className = "current");
                items[lidx] && (items[lidx].className += " active");
            }
            model.listen && model.listen( update );
            update();
        } : function( model ) {
            var a = document.createElement( "a" );
            this.element = function() {
                return a;
            };
            a.className = "datelist";
            a.href = "javascript:";
            a.onclick = function() {
                this.focus();
                var cell = $( a ).find( ".active" )[0];
                model( arg.set( model(), cell.value ) );
                update();
            };
            var items = [];
            a.onkeydown = function( e ) {
                e = e || window.event;
                switch ( e.keyCode ) {
                    case 38://up
                        model( arg.set( model(), items[(lidx + items.length - 1) % items.length].value ) );
                        update();
                        break;
                    case 40://down
                        model( arg.set( model(), items[(lidx + 1) % items.length].value ) );
                        update();
                        break;
                }
            };
            for ( var i = 0; i < arg.count; i++ ) {
                var item = document.createElement( "div" );
                item.innerHTML = arg.display( i );
                item.value = i;
                item.onclick = function() {
                    model( arg.set( model(), this.value ) );
                    update();
                };
                a.appendChild( item );
                items.push( item );
            }
            var lidx = null;
            function update() {
                items[lidx] && (items[lidx].className = "");
                lidx = arg.get( model() );
                var curr = items[arg.get( new Date() )];
                curr && (curr.className = "current");
                items[lidx] && (items[lidx].className += " active");
            }
            model.listen && model.listen( update );
            update();
        };
    }
    var MonthsList = mkList( {
        count: 12,
        limit: 6,
        display: function( i ) {
            return Dates.monthName( i );
        },
        get: function( v ) {
            return v.getMonth();
        },
        set: function( v, i ) {
            v = new Date( v.getTime() );
            v.setMonth( i );
            return v;
        }
    } );
    var QuarterList = mkList( {
        count: 4,
        display: function( i ) {
            return ["I", "II", "III", "IV"][i] + " ";
        },
        get: function( v ) {
            return (v.getMonth() / 3) | 0;
        },
        set: function( v, i ) {
            v = new Date( v.getTime() );
            v.setMonth( i * 3 );
            return v;
        }
    } );
    var DecadeList = mkList( {
        count: 3,
        display: function( i ) {
            return (i + 1) + " ";
        },
        get: function( v ) {
            return Math.min( ((v.getDate() - 1) / 10) | 0, 2 );
        },
        set: function( v, i ) {
            v = new Date( v.getTime() );
            v.setDate( i * 10 + 1 );
            return v;
        }
    } );
    function YearEdit( model ) {
        function set( year ) {
            var v = new Date( model().getTime() );
            var d = v.getDate();
            var dim = Dates.daysInMonth( year, v.getMonth() );
            if ( d > dim )
                v.setDate( dim );
            v.setFullYear( year );
            model( v );
            update();
        }
        var span = document.createElement( "span" );
        this.element = function() {
            return span;
        };
        span.className = "buttoned yearedit";
        var bl = document.createElement( "button" );
        bl.innerHTML = "&#9664;";
        bl.type = "button";
        bl.onclick = function() {
            set( model().getFullYear() - 1 );
        };
        span.appendChild( bl );
        var edit = document.createElement( "input" );
        edit.type = "text";
        edit.onchange = function() {
            var n = this.value | 0;
            if ( n === 0 )
                return;
            set( n );
        };
        span.appendChild( edit );
        var br = document.createElement( "button" );
        br.innerHTML = "&#9654;";
        br.type = "button";
        br.onclick = function() {
            set( model().getFullYear() + 1 );
        };
        span.appendChild( br );
        function update() {
            edit.value = model().getFullYear();
        }
        model.listen && model.listen( update );
        update();
    }
    function TimeEdit( model, secs ) {
        var input = document.createElement( "input" );
        this.element = function() {
            return input;
        };
        input.type = "text";
        input.style.textAlign = "center";
        var mask = secs ? "99:99:99" : "99:99";
        $mi.fn.mask.call( $( input ), mask );
        $( input ).attr( "size", mask.length );
        var rg = /(\d+):(\d+)(:\d+)?/;
        input.onchange = function() {
            var m = this.value.match( rg );
            if ( !m )
                return;
            var v = new Date( model().getTime() );
            v.setHours( m[1] | 0 );
            v.setMinutes( m[2] | 0 );
            v.setSeconds( m[3] | 0 );
            model( v );
            update();
        };
        function update() {
            var v = model();
            function n2s( n ) {
                var r = n.toString();
                return r.length === 1 ? '0' + r : r;
            }
            input.value = n2s( v.getHours() ) + ':' + n2s( v.getMinutes() ) + (secs ? (':' + n2s( v.getSeconds() )) : "");
        }
        model.listen && model.listen( update );
        update();
    }
    function DaysGrid( model ) {
        var a = document.createElement( "a" );
        this.element = function() {
            return a;
        };
        a.className = "daysgrid";
        a.href = "javascript:";
        a.onclick = function() {
            this.focus();
            var cell = $( a ).find( ".active" )[0];
            model( new Date( cell.value ) );
            update();
        };
        a.onkeydown = function( e ) {
            e = e || window.event;
            switch ( e.keyCode ) {
                case 37://left
                    model( new Date( model().getTime() - MS_PER_DAY ) );
                    update();
                    break;
                case 38://up
                    model( new Date( model().getTime() - MS_PER_DAY * 7 ) );
                    update();
                    break;
                case 39://right
                    model( new Date( model().getTime() + MS_PER_DAY ) );
                    update();
                    break;
                case 40://down
                    model( new Date( model().getTime() + MS_PER_DAY * 7 ) );
                    update();
                    break;
            }
        };
        var t = document.createElement( "table" );
        a.appendChild( t );
        var th = document.createElement( "thead" );
        t.appendChild( th );
        var tr = th.insertRow();
        for ( var i = 0; i < 7; i++ ) {
            var td = tr.insertCell( i );
            if ( i > 4 )
                td.style.color = "maroon";
            td.innerHTML = Dates.dowName( i );
        }
        var tb = document.createElement( "tbody" );
        t.appendChild( tb );
        for ( var ir = 0; ir < 6; ir++ ) {
            var tr = tb.insertRow();
            for ( var ic = 0; ic < 7; ic++ )
                tr.insertCell().onclick = function() {
                    model( new Date( this.value ) );
                    update();
                };
        }
        var lastYear = -1, lastMonth = -1, lastActiveCell = {};
        function update() {
            var value = model();
            var year = value.getFullYear(), month = value.getMonth(), date = value.getDate() - 1, dow = (value.getDay() + 6) % 7;
            var moffset = (dow + 7 * 5 - date) % 7;
            if ( (year !== lastYear) || (month !== lastMonth) ) {
                lastYear = year;
                lastMonth = month;
                var dim = Dates.daysInMonth( year, month ), dim_p = Dates.daysInMonth( year, (month + 11) % 12 );
                var base = value.getTime() - date * MS_PER_DAY;
                var curr = (function() {
                    var cd = new Date();
                    if ( cd.getFullYear() !== year )
                        return 0xFFFF;
                    if ( cd.getMonth() !== month )
                        return 0xFFFF;
                    return cd.getDate() - 1;
                })();
                for ( var ir = 0, lr = tb.rows.length; ir < lr; ir++ ) {
                    var r = tb.rows[ir];
                    for ( var ic = 0, lc = r.cells.length; ic < lc; ic++ ) {
                        var c = r.cells[ic];
                        var dn = ic + ir * 7 - moffset;
                        c.value = base + dn * MS_PER_DAY;
                        c.className = dn === date ? "" : "";
                        if ( dn === curr )
                            $( c ).addClass( "current" );
                        if ( dn < 0 ) {
                            dn = dim_p + dn;
                            c.style.color = "gray";
                        } else if ( dn >= dim ) {
                            dn = dn - dim;
                            c.style.color = "gray";
                        } else if ( ic > 4 )
                            c.style.color = "red";
                        else
                            c.style.color = "";
                        var dv = dn + 1;
                        c.innerHTML = dv;
                    }
                }
            }
            $( lastActiveCell ).removeClass( "active" );
            var cno = date + moffset;
            lastActiveCell = tb.rows[(cno / 7) | 0].cells[cno % 7];
            $( lastActiveCell ).addClass( "active" );
        }
        model.listen && model.listen( update );
        update();
    }
    function NowButton( model ) {
        var button = document.createElement( "button" );
        button.innerHTML = "#";
        button.title = " /";
        button.type = "button";
        button.onclick = function() {
            model( new Date() );
        };
        this.element = function() {
            return button;
        };
    }
    function createListCal( fmodel, cls, pfx ) {
        var element = document.createElement( "div" );
        element.className = "cal-container vflow";
        if ( pfx )
            element.appendChild( new pfx( fmodel ).element() );
        var l = null;
        if ( cls )
            element.appendChild( l = new cls( fmodel ).element() );
        var buttons = document.createElement( "div" );
        buttons.className = "cal-buttons";
        buttons.style.textAlign = "right";
        var nb;
        buttons.appendChild( nb = new NowButton( fmodel ).element() );
        nb.className = "now";
        var button = document.createElement( "button" );
        button.innerHTML = "";
        button.className = "sel";
        buttons.appendChild( button );
        element.appendChild( buttons );
        var rr = {
            onselect: null,
            element: function() {
                return element;
            },
            showed: function() {
                l && l.focus();
            }
        };
        button.onclick = function() {
            rr.onselect && rr.onselect();
        };
        l && (l.ondblclick = button.onclick);
        return rr;
    }
    return {
        /*YearEdit: YearEdit,
         MonthsCombo: MonthsCombo,
         DaysGrid: DaysGrid,*/
        createModel: function( v ) {
            var value = v, listeners = [];
            var fm = function() {
                if ( arguments.length === 0 )
                    return value;
                value = arguments[0];
                for ( var i in listeners )
                    listeners[i]();
            };
            fm.listen = function( f ) {
                listeners.push( f );
            };
            return fm;
        },
        createByFormat: function( fmt, fmodel ) {
            switch ( fmt ) {
                case 403:
                    return createListCal( fmodel, null, YearEdit );
                case 402:
                case 452:
                    return createListCal( fmodel, MonthsList, YearEdit );
                case 408:
                    return createListCal( fmodel, DaysGrid );
                case 409:
                case 453:
                    return createListCal( fmodel, DaysGrid, MonthsCombo );
                case 411:
                    return createListCal( fmodel, QuarterList, YearEdit );
                case 455:
                    return createListCal( fmodel, DecadeList, MonthsCombo );
                case 456:
                    return createListCal( fmodel, MonthsList );
                case 457:
                    return createListCal( fmodel, DecadeList );
                case 458:
                    return createListCal( fmodel, QuarterList );
                case 454:
                case 459:
                    return createListCal( fmodel, MonthsList );
                case 406:
                case 410:
                    var result$ = $( "<table class='calendar' cellspacing='3'><tr><td id='mnth'></td><td id='year'></td></tr><tr><td id='days' colspan='2'></td></tr><tr><td id='time' colspan='2'></td></tr><tr><td id='curr'></td><td><button id='btn'></button></td></tr></table>" );
                    result$.find( "#mnth" ).append( new MonthsCombo( fmodel ).element() );
                    result$.find( "#year" ).append( new YearEdit( fmodel ).element() );
                    result$.find( "#time" ).append( new TimeEdit( fmodel, fmt === 410 ).element() ).css( {textAlign: "center"} );
                    var dge = new DaysGrid( fmodel ).element();
                    result$.find( "#days" ).append( $( dge ).css( {width: "100%", boxSizing: "border-box"} ) );
                    result$.find( "#curr" ).append( new NowButton( fmodel ).element() );
                    var rr = {
                        onselect: null,
                        element: function() {
                            return result$[0];
                        },
                        showed: function() {
                            dge.focus();
                        }
                    };
                    dge.ondblclick = result$.find( "#btn" )[0].onclick = function() {
                        rr.onselect && rr.onselect();
                    };;
                    result$.find( "#btn" ).parent().css( {textAlign: "right"} );
                    return rr;
                case 401:
                default:
                    var result$ = $( "<table class='calendar' cellspacing='3'><tr><td id='mnth'></td><td id='year'></td></tr><tr><td id='days' colspan='2'></td></tr><tr><td id='curr'></td><td><button id='btn'></button></td></tr></table>" );
                    result$.find( "#mnth" ).append( new MonthsCombo( fmodel ).element() );
                    result$.find( "#year" ).append( new YearEdit( fmodel ).element() );
                    var dge = new DaysGrid( fmodel ).element();
                    result$.find( "#days" ).append( $( dge ).css( {width: "100%", boxSizing: "border-box"} ) );
                    result$.find( "#curr" ).append( new NowButton( fmodel ).element() );
                    var rr = {
                        onselect: null,
                        element: function() {
                            return result$[0];
                        },
                        showed: function() {
                            dge.focus();
                        }
                    };
                    dge.ondblclick = result$.find( "#btn" )[0].onclick = function() {
                        rr.onselect && rr.onselect();
                    };
                    result$.find( "#btn" ).parent().css( {textAlign: "right"} );
                    return rr;
            }
        }
    };
} );