define( [
    "inform.agent.web.forms.Requests",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.Styles",
    "static.jquery.jquery"
    , 'static.wcl.Core'
    , 'static.wcl.Utils'
    , 'static.wcl.layouts.Flow'
], function(Requests, DM, Styles, $, Wcl, Utils, Flow) {
    Styles.sheet().rules( {
        'div.wcl-frame': {
            border: '1px solid #D0D0D0',
            display: 'inline-block',
            '>.wcl-menubar': {
                'background-color': '#E0E0E0',
                'background-image': ['url(' + asmo.root + '/static/images/btn_normal.png)', 'linear-gradient(top, #FFFFFF, #E0E0E0)'],
                'background-repeat': 'repeat-x',
                'border-bottom': '1px solid #AAAAAA'
            },
            'tr.menubar > td.buttons': {
                paddingLeft: '2px'
            }
        }
    } );
    return function(parent, container, arg) {
        var element = document.createElement('div');
        element.className = 'wcl-root wcl-frame wcl-cloak waiting';
        element.innerHTML = '&nbsp;';
        var item = null, menu = null;
        var TWO_BORDER_WIDTHS = 2, MBAR_BORDER_WIDTH = 1;
        this.calculate = function() {
            if (item === null) {
                var sz = Wcl._measure(element);
                return {min: sz, max: sz};
            }
            var sz = item.calculate();
            var r = {
                min: {x: sz.min.x + TWO_BORDER_WIDTHS, y: sz.min.y + TWO_BORDER_WIDTHS},
                max: {x: sz.max.x + TWO_BORDER_WIDTHS, y: sz.max.y + TWO_BORDER_WIDTHS},
                _ic: sz,
                _mc: menu ? menu.item.calculate() : {min: {x: 0, y: 0}, max: {x: 0, y: 0}}
            };
            if (menu) {
                var mc = r._mc;
                r.min.x = Math.max(r.min.x, mc.min.x);
                r.min.y += mc.min.y + MBAR_BORDER_WIDTH;
                r.max.x = Math.max(r.max.x, mc.max.x);
                r.max.y += mc.min.y + MBAR_BORDER_WIDTH;
            }
            return r;
        };
        var recter = Wcl._mkRecter(element);
        var needremovecloak = false;
        this.validate = function(arg) {
            var r = Wcl.rtrunc(arg.rect);
            recter(r);
            if (item) {
            var mh = arg.calc._mc.min.y;
            if (menu) {
                var mr = {
                    p: {x: 0, y: 0},
                    s: {x: r.s.x - TWO_BORDER_WIDTHS, y: mh + MBAR_BORDER_WIDTH}
                };
                menu.rctr(mr);
                menu.item.validate({
                    rect: {
                        p: mr.p,
                        s: {x: mr.s.x, y: mr.s.y - MBAR_BORDER_WIDTH}
                    },
                    calc: arg.calc._mc
                });
            }
            item.validate({
                rect: {
                    p: {x: 0, y: mh},
                    s: {x: r.s.x - TWO_BORDER_WIDTHS, y: r.s.y - TWO_BORDER_WIDTHS - mh}
                }, calc: arg.calc._ic
            });
            }
            if (needremovecloak) {
                needremovecloak = false;
                Styles.removeClass(element, 'wcl-cloak');
                Styles.removeClass(element, 'waiting');
            }
        };
        this.invalidate = function() {
            parent.invalidate();
        };
        container.appendChild(element);
        var descriptor = arg, self = this;
        setTimeout(function() {
            if (!descriptor.node)
                return;
            var components = arg.cmps;
            DM.CBind.resolve(descriptor.p_bindings, components);
            DM.CBind.resolve(descriptor.paramsyncs, components);
            var wantUpdate = true, lastUrl = "";
            function update() {
                if (!wantUpdate)
                    return;
                var url = "/node/" + descriptor.node + "?$as_inline";
                for (var i in descriptor.paramsyncs) {
                    var p = descriptor.paramsyncs[i];
                    if (p instanceof DM.Datasource.Field) {
                        var ds = p._datasource;
                        var r = ds._row();
                        if (r === null)//not loaded
                            return null;
                        if (r === undefined)//no row
                            return null;
                        p = r[p.index];
                    }
                    url += '&' + i + '=' + encodeURIComponent(JSON.stringify(p));
                }
                for (var i in descriptor.p_bindings) {
                    var p = descriptor.p_bindings[i];
                    if (p instanceof DM.Datasource.Field) {
                        var ds = p._datasource;
                        var r = ds._row();
                        if (r === null)//not loaded
                            return null;
                        if (r === undefined)//no row
                            return null;
                        p = r[p.index];
                    }
                    url += '&@' + i + '=' + encodeURIComponent(JSON.stringify(p));
                }
                if (descriptor.isform)
                    wantUpdate = false;
                if (url === lastUrl)
                    return;
                lastUrl = url;
                Requests.execute({
                    caption: " ",
                    url: url
                }).done(function(response) {
                    var element$ = $(element);
                    element$.html(response);
                    element$.find("td.icon,td.caption").remove();
                    if (!descriptor.isform)
                    {
                        needremovecloak = true;
                        return;
                    }
                    var f = eval("form" + descriptor.node);
                    f({
                        root: element$,
                        mitem: {
                            appendItem: function(arg) {
                                arg._ = Utils.Margin(arg._);
                                item = Wcl._mk(self, element, arg);
                                self.invalidate();
                                return item;
                            }
                        },
                        menu: {
                            appendItem: function(arg) {
                                if (menu === null) {
                                    var me = document.createElement('div');
                                    me.className = 'wcl-menubar';
                                    element.appendChild(me);
                                    menu = {
                                        item: Wcl._mk(self, me, {_: Utils.Margin(Flow, 1), type: Flow.HORZ, halign: Flow.HALIGN.LEFT}),
                                        rctr: Wcl._mkRecter(me)
                                    };
                                }
                                return menu.item.appendItem(arg);
                            }
                        },
                        datamodel: descriptor.cmps.datamodel,
                        parameters: function(parameters, values) {
                            for (var n in descriptor.paramsyncs)
                                for (var i in parameters._fields) {
                                    var f = parameters._fields[i];
                                    if (f._descriptor.name === n) {
                                        values[f.id] = descriptor.paramsyncs[n];
                                        break;
                                    }
                                }
                            for (var i in descriptor.p_bindings)
                                values[i] = descriptor.p_bindings[i];
                            return values;
                        }
                    }).then(function () {
                        needremovecloak = true;
                    });
                });
            }
            for (var i in descriptor.paramsyncs) {
                var p = descriptor.paramsyncs[i];
                if (p instanceof DM.Datasource.Field)
                    p._datasource._listen(update);
            }
            for (var i in descriptor.p_bindings) {
                var p = descriptor.p_bindings[i];
                if (p instanceof DM.Datasource.Field)
                    p._datasource._listen(update);
            }
            update();
        });
    };
} );