define( [
    "inform.agent.web.forms.WebForm",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.Modal",
    "inform.agent.web.Styles",
    , 'static.wcl.Core'
], function(F, DM, Modal, Styles, Wcl) {
    Styles.sheet().rules( {
        'div.image': {
            border: '1px solid #D0D0D0',
            textAlign: 'center',
            fontSize: 0,
            overflow: 'hidden',
            '>img': {
                opacity: 1,
                transition: 'opacity 0.25s linear'
            },
            '.waiting > img, .error > img': {
                opacity: 0,
                visibility: 'hidden'
            }
        },
        '.content > .imgview': {
            backgroundColor: 'gray',
            fontSize: 0,
            textAlign: 'center',
            '>img': {
                verticalAlign: 'middle'
            }
        }
    } );
    function WclControl(parent, container, arg) {
        var element = document.createElement('div');
        element.className = 'image wcl-image waiting';
        var img = document.createElement('img');
        img.className = 'wcl-img';
        var loadedChangeNo = 0, changeNo = 0, doclick = null;
        img.onload = img.onerror = function() {
            loadedChangeNo = changeNo;
            Styles.removeClass(element, 'waiting');
            parent.invalidate();
        };
        
        if((arg.scriptName || arg.scriptclick) && arg.formScript)
        {
            var scriptName = (arg.scriptName == null || arg.scriptName == undefined)? "":arg.scriptName;
            var so = {};
            Object.defineProperty(so, "name", {value: scriptName});
            Object.defineProperty(so, "tag", 
            {
                get: function() 
                { 
                    var res = element.getAttribute("tag");
                    if (!res)
                        res = '';
                    return res; 
                }, 
                set: function(v)
                { 
                    element.setAttribute("tag", typeof(v) === 'string' ? v : '');
                } 
            });
            Object.defineProperty(so, "visible", 
            {
                get: function() 
                { 
                    var style = window.getComputedStyle(element);
                    return (style.display !== 'none')                    
                }, 
                set: function(v)
                { 
                    if (!v)
                        element.style.display = "none";
                    else
                        element.style.display = "";
                } 
            });
            Object.defineProperty(so, "enabled", {get: function() { return !element.disabled; }, set: function(v){ element.disabled = !v;} });
            if(arg.scriptName)
                arg.formScript._reg_component(arg.scriptName, so);
        }
        (arg.enabled !== undefined) && Wcl._modelUpdater(arg.enabled, function(enabled) {
            element.disabled = !enabled;
        });
        Wcl._modelUpdater(arg.tag, function(tag) {
            element.setAttribute("tag", tag || "");
        });        
        
        
        var TWO_BORDER_WIDTHS = 2;
        this.calculate = function() {
            return {
                _is:    Wcl._measure(img),
                min: Wcl.Control.UNBOUND_MIN,
                max: Wcl.Control.UNBOUND_MAX
            };
        };
        var rdiv = Wcl._mkRecter(element), rimg = Wcl._mkRecter(img);
        this.validate = function(arg) {
            rdiv(arg.rect);
            var rsx = arg.rect.s.x - TWO_BORDER_WIDTHS;
            var rsy = arg.rect.s.y - TWO_BORDER_WIDTHS;
            var is = arg.calc._is;
            var sx = is.x, sy = is.y;
            if (sx > rsx) {
                sy = sy / sx * rsx;
                sx = rsx;
            }
            if (sy > rsy) {
                sx = sx / sy * rsy;
                sy = rsy;
            }
            rimg({
                p: {
                    x: (rsx - sx) / 2,
                    y: (rsy - sy) / 2
                },
                s:{x:sx, y:sy}
            });
            if (doclick && ((is.x >= rsx) || (is.y >= rsy))) {
                element.onclick = doclick;
                element.style.cursor = 'pointer';
            } else {
                element.onclick = null;
                element.style.cursor = 'default';
            }
        };
        element.appendChild(img);
        container.appendChild(element);
        if (arg.src_icon) {
            img.setAttribute('data-icon', arg.src_icon);
            F.updateIcons(img);
            return;
        }
        if (arg.src_node) {
            img.src = asmo.root + '/node/' + arg.src_node;
            return;
        }
        if (arg.src_blob) {
            var fpath = arg.src_blob;
            var datasource = fpath[0]._datasource, flast = fpath[fpath.length-1];
            var fldd = flast._datasource._descriptor, tlast = fldd.table || fldd.node;
            fpath = fpath.slice( 0, fpath.length-1 );
            var imgX = null, src = null;
            doclick = function() {
                imgX = document.createElement('img');
                imgX.style.position = 'relative';//IE-magic
                imgX.src = src;
                var md = Modal.show( {
                    caption: " ",
                    content: imgX
                } );
                datasource._scan( function( cs ) {
                    var rcount = cs._rowsCount();
                    function prev() {
                        cs._ridx = (cs._ridx + rcount - 1) % rcount;
                        datasource._touch();
                    }
                    function next() {
                        cs._ridx = (cs._ridx + 1) % rcount;
                        datasource._touch();
                    }
                    md.addButton( "&lt;&lt;", prev, " " );
                    md.addButton( "&gt;&gt;", next, " " );
                } );
                var bg = md.background;
                var w = bg.width() * 0.9, h = bg.height() * 0.9;
                md.content.addClass( "imgview" ).css( {
                    width: w + "px",
                    Height: h + "px",
                    lineHeight: h + "px"
                } );
                imgX.style.maxWidth = w + "px";
                imgX.style.maxHeight = h + "px";
            };
            var oldw = 0, oldh = 0;
            function update() {
                if (!element.clientWidth || !element.clientHeight)
                    return;
                function tryup() {
                    var row = datasource._row();
                    if ( row === null )
                        return false;
                    var key = undefined, pfx = "/rq/blobData/" + tlast + '/' + flast.id + '/';
                    if ( row !== undefined ) {
                        if ( fpath.length ) {
                            key = DM.fetchFPathValue( fpath, row );
                            if ( key === DM.fetchFPathValue.WAIT )
                                return false;
                        } else {
                            key = row[flast.index];
                            if ( key ) {
                                key = encodeURIComponent( JSON.stringify( key ) );
                                pfx = "/rq/blobData/";
                            } else {
                            var fok = false;
                            for ( var i in datasource._keyfields ) {
                                var f = datasource._keyfields[i];
                                key = row[f.index];
                                fok = true;
                                break;
                            }
                            if ( !fok )
                                throw "no key field found";
                            }
                        }
                    }
                    var prvsrc;
                    if (key) {
                        src = asmo.root + pfx + key;
                        imgX && (imgX.src = src);
                        prvsrc = src + "?preview=" + (element.clientWidth + ':' + element.clientHeight);
                        var dd = datasource._descriptor;
                        prvsrc += "&owner="+dd.ownerId+"&uid="+dd.id;
                    } else {
                        prvsrc = "";
                        imgX && (imgX.src = "");
                    }
                    var osrc = String(img.src);
                    img.src = prvsrc;
                    var unchanged = img.src === osrc;
                    if (!unchanged)
                        changeNo++;
                    if (!prvsrc || (unchanged && (loadedChangeNo === changeNo)))
                        img.onload();
                    return loadedChangeNo === changeNo;
                }
                if (!tryup())
                    Styles.addClass(element, 'waiting');
            }
            datasource._listen( update );
            for ( var i in fpath )
                fpath[i]._datasource._listen( update );
            (function timer() {
                if ((oldw < element.clientWidth) || (oldh < element.clientHeight)) {
                    oldw = element.clientWidth;
                    oldh = element.clientHeight;
                    update();
                }
                setTimeout(timer, 1000);
            })();
        }
    }
    return {
        WclControl: WclControl
    };
} );