define( [
    "inform.agent.web.forms.Formats",
    "inform.agent.web.forms.WebForm",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.forms.WebGridCommon",
    "inform.agent.web.utils.Strings",
    "inform.agent.web.Expressions",
    "inform.agent.web.NodeInfo",
    "inform.agent.web.Styles",
    "static.jquery.jquery"
    , 'static.wcl.Core'
    , 'static.wcl.layouts.Flow'
], function(Formats, F, DM, WebGridCommon, Strings, Expressions, NodeInfo, Styles, $, Wcl, Flow) {
    var NodeDescriptor = CLASS( {
        constructor: function( parent, nd, datasources ) {
            this.parent = parent;
            this.children = [];
            this.cells = [];
            var nd$ = $( nd );
            var dsid = nd$.attr( "data-datasource" ) | 0;
            this.datasource = dsid ? datasources[dsid] : null;
            var recu = nd$.attr( "data-recursion" );
            if ( recu ) {
                var recu = recu.split( ':' ), ds = this.datasource, fbyid = ds._fbyid;
                var pid = recu[2];
                this.recursion = pid ? {
                    current: fbyid[recu[0]],
                    parent: fbyid[recu[1]],
                    paparam: pid,
                    original: ds._descriptor.p_bindings[pid]
                } : null;
            } else
                this.recursion = null;
            var exColor = nd$.attr( "data-color-expression" );
            this.exColor = exColor ? Expressions.make( exColor, datasources ) : null;
            var exTextColor = nd$.attr( "data-textcolor-expression" );
            this.exTextColor = exTextColor ? Expressions.make( exTextColor, datasources ) : null;
            var exTextStyle = nd$.attr( "data-textstyle-expression" );
            this.exTextStyle = exTextStyle ? Expressions.make( exTextStyle, datasources ) : null;

            var colMap = new Object();
            for ( var cmi = 0, ch = nd.children, l = ch.length; cmi < l; cmi++ ) {
                var cm = ch[cmi];
                if ( cm.tagName !== "SPAN" )
                    continue;
                var cm$ = $( cm );
                var cellId = cm$.attr( "id" );
                var nodeId = nd$.attr( "id" );
                var key = cellId + ":" + nodeId;
                colMap[key] = {                    
                    colExpr: cm$.attr( "data-expression" ),
                    colExprColor: cm$.attr( "data-color-expression" ),
                    colExprTextColor: cm$.attr( "data-textcolor-expression" ),
                    colExprTextStyle: cm$.attr( "data-textstyle-expression" )
                };
            }        
            
            for ( var i = 0, ch = nd.children, l = ch.length; i < l; i++ ) {
                var c = ch[i];
                if ( c.tagName !== "SPAN" )
                    continue;
                var c$ = $( c );
                var expr = c$.attr( "data-expression" );
                expr = expr ? Expressions.make( expr, datasources, colMap, "data", [] ) : null;                
                var fmt = c$.attr( "data-format" );
                if ( fmt ) {
                    var fmtopt = Elements.attribute(c, 'data-format-option');
                    if (fmtopt)
                        fmtopt = Strings.base64_to_bytestr(fmtopt)
                    fmt = Formats.byIdAndOption(fmt, fmtopt);
                }
                var cell = {
                    expression: expr,
                    fmt: fmt,
                    type: c$.attr( "data-datatype" ) | 0
                };
                var exColor = c$.attr( "data-color-expression" );
                cell.exColor = exColor ? Expressions.make( exColor, datasources, colMap, "color", [] ) : null;                
                var exTextColor = c$.attr( "data-textcolor-expression" );
                cell.exTextColor = exTextColor ? Expressions.make( exTextColor, datasources, colMap, "textColor", [] ) : null;                
                var exTextStyle = c$.attr( "data-textstyle-expression" );
                cell.exTextStyle = exTextStyle ? Expressions.make( exTextStyle, datasources, colMap, "textStyle", [] ) : null;                
                this.cells.push( cell );
            }
        }
    } );
    var Roller = CLASS( {
        Node: CLASS( {
            constructor: function( descriptors, element, roller, crow, ridx ) {
                this.descriptors = descriptors;
                this.element = element;
                this.roller = roller;
                this.crow = crow;
                this.ridx = ridx;
                this.level = roller ? roller.level + 1 : 0;
                this.rollers = [];
                this._opened = false;
                this._loaded = false;
            },
            upload: function() {
                if ( this._loaded )
                    return;
                for ( var i in this.descriptors ) {
                    var r = document.createElement( "div" );
                    r.className = "roller";
                    r.style.display = "none";
                    this.element.appendChild( r );
                    this.rollers.push(new Roller(this.descriptors[i], r, this, this.roller.treedesc));
                }
                this._loaded = true;
            },
            opened: function( opened ) {
                if ( arguments.length ) {
                    this._opened = opened;
                    if ( opened ) {
                        this.roller.node && this.roller.node.opened( true );
                        this.upload();
                        for ( var ir = 0, lr = this.rollers.length; ir < lr; ir++ ) {
                            var r = this.rollers[ir];
                            r.prefetchNodesChildrens();
                            for ( var i = 0, l = r.nodes.length; i < l; i++ )
                                r.nodes[i].upload();
                        }
                    }
                    for ( var i = 0, rr = this.rollers, l = rr.length; i < l; i++ )
                        rr[i].element.style.display = opened ? "" : "none";
                    var self = this;
                    var root = (function() {
                        var c = self.roller;
                        while ( c.node )
                            c = c.node.roller;
                        return c;
                    })();
                    root._needUpdateWidths = true;
                    this.updatePlus();
                } else
                    return this._opened;
            },
            updatePlus: function() {
                var has = false;
                if ( this._loaded ) {
                    for ( var i in this.rollers )
                        if ( !has )
                            for ( var j in this.rollers[i].nodes ) {
                                has = true;
                                break;
                            }
                }
                this.element.firstChild.firstChild.firstChild.innerHTML = !has ? "" : (this._opened ? "&#8895;" : "&#5125;");
            }
        } ),
        constructor: function (descriptor, element, node, treedesc) {
            this.descriptor = descriptor;
            this.element = element;
            this.node = node;
            this.treedesc = treedesc;
            this.level = node ? node.level : 0;
            this.nodes = [];
            var self = this, element$ = $( element ), tmoWait = null, thisCursor = null, thisCursorChNo = 0, thisRecordIdx = -1, _fakeCell = null;
            function fakeCell() {
                if ( _fakeCell === null ) {
                    _fakeCell = document.createElement("div");
                    document.createElement("div").appendChild(_fakeCell);
                    _fakeCell.className = "fake waiting";
                }
                return _fakeCell;
            }
            function scan( f, node ) {
                var roller = node ? node.roller : self;
                function ff( cs, ctx ) {
                    var rdd = roller.descriptor.datasource;
                    if ( !ctx )
                        ctx = DM.createCachedContext();
                    if ( !rdd )
                        return f( cs, ctx );
                    var re = roller.descriptor.recursion;
                    var pbinds = undefined;
                    if ( re ) {
                        pbinds = {};
                        if ( roller.node && (roller.node.roller.descriptor === roller.descriptor) ) {
                            var r = cs._row();
                            if ( !r )
                                return false;
                            pbinds[re.paparam] = r[re.current.index];
                        } else
                            pbinds[re.paparam] = re.original;
                    }
                    var ok = true;
                    return rdd._scan( function( cs ) {
                        if ( node ) {
                            if ( cs._ridx !== node.ridx )
                                cs._ridx = node.ridx;
                            var row = cs._row();
                            if ( !row ) {
                                ok = false;
                                return;
                            }
                            ctx.init( rdd, row );
                        }
                        ok = f( cs, ctx );
                    }, {rower: ctx.rower, p_bindings: pbinds} ) && ok;
                }
                return roller.node ? scan( ff, roller.node ) : ff();
            }
            var dchildren = descriptor.children;
            if ( descriptor.recursion ) {
                dchildren = dchildren.slice();
                dchildren.push( descriptor );
            }
            var root = (function() {
                var c = self;
                while ( c.node )
                    c = c.node.roller;
                return c;
            })();
            if ( !root.currentRoller )
                root.currentRoller = this;
            function fetchOptional( expressions, ctx ) {
                var result = {};
                for ( var i in expressions ) {
                    var e = expressions[i];
                    if ( !e )
                        continue;
                    var v = e.evaluate( ctx );
                    if ( v === Expressions.WAIT )
                        return null;
                    if ( (v !== Expressions.NVAL) && (v !== null) )
                        result[i] = v;
                }
                return result;
            }
            function update() {
                if ( self._removed )
                    return;
                var ok = true;
                if ( !scan( function( cursor, ctx ) {
                    function mknode( nnodes, onclick, crow, ridx ) {
                        var c = document.createElement( "span" );
                        c.className = 'c' + treedesc.columns[0].id + ' n';
                        var plus = document.createElement( "span" );
                        plus.style.marginLeft = (self.level * 16) + "px";
                        plus.className = "plus";
                        c.appendChild( plus );
                        var text = document.createElement( "span" );
                        c.appendChild( text );
                        var ne = document.createElement( "div" );
                        ne.onclick = onclick || null;
                        ne.appendChild( c );
                        var cells = [{d: descriptor.cells[0], t: text, c: c}];
                        for ( var i = 1; i < descriptor.cells.length; i++ ) {
                            var text = document.createElement( "span" );
                            text.className = 'c' + treedesc.columns[i].id;
                            ne.appendChild( text );
                            cells.push( {d: descriptor.cells[i], t: text, c: text} );
                        }
                        var r = document.createElement( "div" );
                        r.className = "waiting";
                        r.appendChild( ne );
                        element.appendChild( r );
                        var n = new self.Node( dchildren, r, self, crow, ridx );
                        n.cells = cells;
                        nnodes.push( plus.node = n );
                        plus.onclick = function( e ) {
                            e = e || window.event;
                            e.stopPropagation ? e.stopPropagation() : (e.cancelBubble = true);
                            this.node.opened( !this.node.opened() );
                        };
                        return n;
                    }
                    function expression( node ) {
                        var v;
                        if ( !(v = fetchOptional( {
                            bc: descriptor.exColor,
                            tc: descriptor.exTextColor,
                            ts: descriptor.exTextStyle
                        }, ctx )) ) {
                            node.element.className = "waiting";
                            return false;
                        }
                        var bc = F.color2hex( v.bc );
                        node.element.style.color = F.color2hex( v.tc );
                        F.assignTextStyle( node.element.style, v.ts );
                        for ( var i = 0; i < node.cells.length; i++ ) {
                            var cell = node.cells[i];
                            var vo;
                            if ( !(vo = fetchOptional( {
                                bc: cell.d.exColor,
                                tc: cell.d.exTextColor,
                                ts: cell.d.exTextStyle
                            }, ctx )) ) {
                                node.element.className = "waiting";
                                return false;
                            }
                            cell.c.style.backgroundColor = F.color2hex( vo.bc ) || bc;
                            cell.t.style.color = F.color2hex( vo.tc );
                            F.assignTextStyle( cell.t.style, vo.ts );
                            if ( !cell.d.expression )
                                continue;
                            var v = cell.d.expression.evaluate( ctx );
                            if ( v === Expressions.WAIT ) {
                                node.element.className = "waiting";
                                return false;
                            }
                            if ( v === Expressions.NVAL )
                                v = undefined;
                            F.formatCellValue( cell.t, v, cell.d.type, cell.d.fmt, cell.d.expression );
                        }
                        node.element.className = "";
                        return true;
                    }
                    clearTimeout( tmoWait );
                    tmoWait = null;
                    root._needUpdateWidths = true;
                    if ( !descriptor.datasource ) {
                        if ( !self.nodes.length ) {
                            var n = mknode( self.nodes );
                            n.upload();
                            n.updatePlus();
                        }
                        if ( !expression( self.nodes[0] ) )
                            ok = false;
                        return true;
                    }
                    var rebuild = !!tmoWait || (thisCursor !== cursor) || (thisCursorChNo !== cursor._changeno);
                    if ( rebuild ) {
                        var rcount = cursor._rowsCount();
                        if ( rcount === DM.fetchFPathValue.WAIT ) {
                            ok = false;
                            return false;
                        }
                        if ( _fakeCell && (_fakeCell.parentNode.parentNode === element) )
                            element.removeChild( _fakeCell.parentNode );
                        var nnodes = [], ds = descriptor.datasource;
                        for ( var i = 0, l = self.nodes.length; i < l; i++ )
                            self.nodes[i].unused = true;
                        for ( cursor._ridx = 0; cursor._ridx < rcount; cursor._ridx++ ) {
                            var found = null, crow = cursor._row(), ridx = cursor._ridx;
                            if ( !crow ) {
                                if ( (crow === undefined) && cursor._lmax ) {
                                    var fc = fakeCell();
                                    fc.style.backgroundColor = "#FFDDDD";
                                    fc.style.marginLeft = (22 + self.level * 16) + "px";
                                    fc.innerHTML = "     ";
                                    element.appendChild( fc.parentNode );
                                    break;
                                }
                                ok = false;
                                continue;
                            }
                            ctx.init( ds, crow );
                            for ( var i = 0, l = self.nodes.length; i < l; i++ ) {
                                var n = self.nodes[i];
                                if ( ds._keyequals( n.crow, crow ) ) {
                                    found = n;
                                    break;
                                }
                            }
                            if ( found ) {
                                found.crow = crow;
                                found.ridx = ridx;
                                nnodes.push( found );
                                element.appendChild( found.element );
                                found.unused = false;
                            } else
                                found = mknode( nnodes, (function( ridx, pbinds ) {
                                    return function() {
                                        var cr = root.currentRoller;
                                        if ( cr !== self ) {
                                            cr.descriptor.datasource && cr.descriptor.datasource._touch();
                                            root.currentRoller = self;
                                        }
                                        cursor._ridx = ridx;
                                        var re = descriptor.recursion;
                                        if ( re ) {
                                            for ( var i in pbinds )
                                                ds._descriptor.p_bindings[i] = pbinds[i];
                                        }
                                        ds._touch();
                                    };
                                })( ridx, ctx.p_bindings ), crow, ridx );
                            if ( !expression( found ) )
                                ok = false;
                        }
                        for ( var i = 0, li = self.nodes.length; i < li; i++ )
                            if ( self.nodes[i].unused ) {
                                var n = self.nodes[i];
                                for ( var j = 0, lj = n.rollers.length; j < lj; j++ )
                                    n.rollers[j]._removed = true;
                                n.element.parentNode.removeChild( n.element );
                            }
                        self.nodes = nnodes;
                    }
                    if ( ok ) {
                        thisCursor = cursor;
                        thisCursorChNo = cursor._changeno;
                        descriptor.datasource && descriptor.datasource._scan( function( cs ) {
                            if ( (cs !== thisCursor) || (self !== root.currentRoller) ) {
                                var tr = self.nodes[thisRecordIdx];
                                tr && (tr.element.className = "");
                                thisRecordIdx = -1;
                            } else if ( cs._ridx !== thisRecordIdx ) {
                                var tr = self.nodes[thisRecordIdx], nr = self.nodes[cs._ridx];
                                tr && (tr.element.className = "");
                                nr && (nr.element.className = "active");
                                thisRecordIdx = cs._ridx;
                            }
                        }, {rower: ctx.rower} );
                        node && node.updatePlus();
                        if ( !node || node._opened ) {
                            self.prefetchNodesChildrens();
                            for ( var i = 0, l = self.nodes.length; i < l; i++ )
                                self.nodes[i].upload();
                        }
                    }
                    return ok;
                } ) || !ok ) {
                    if ( !tmoWait )
                        tmoWait = setTimeout( function() {
                            element$.parent().addClass( "waiting" );
                        }, 250 );
                } else
                    element$.parent().removeClass( "waiting" );
            }
            descriptor.datasource && descriptor.datasource._listen( update );
            for ( var i = 0; i < descriptor.cells.length; i++ ) {
                var c = descriptor.cells[i];
                c.expression && descriptor.cells[i].expression._listen( update );
                (c.type === DM.DataType.METATREE_NODE) && NodeInfo._listen( update );
            }
            update();
        },
        prefetchNodesChildrens: function() {
            var re = this.descriptor.recursion;
            if ( re && re.parent ) {
                var values = [];
                for ( var i = 0, l = this.nodes.length; i < l; i++ )
                    values.push( this.nodes[i].crow[re.current.index] );
                this.descriptor.datasource._cursor( {
                    prefetch: {
                        parent: re.parent.index,
                        parameter: {
                            id: re.paparam,
                            values: values
                        }
                    }
                } );
            }
        }
    } );
    function make( tree, datasources ) {
        function parseRoller( node, pd ) {
            var descr = new NodeDescriptor( pd, node, datasources );
            for ( var i = 0, ch = node.children, l = ch.length; i < l; i++ ) {
                var c = ch[i];
                if ( c.className !== "nd" )
                    continue;
                descr.children.push( parseRoller( c, descr ) );
            }
            return descr;
        }
        var rd = parseRoller(tree.children[1], null);
        var ftrdiv = tree.lastChild.className === 'gfoot' ? tree.lastChild : undefined, ftr;
        if (ftrdiv) {
            var ftrcut = ftrdiv.firstChild;
            var ftrrest = ftrcut.lastChild;
            ftr = ftrrest.lastChild;
        }
        var rn = document.createElement( "div" );
        rn.className = "roller";
        tree.appendChild( rn );
        var uid = Math.abs( (Math.random() * 1E10) | 0 ).toString( 36 ), cls = "tree_" + uid;
        tree.className += ' ' + cls;
        var sheet = Styles.sheet( tree );
        var Column = CLASS({
        }, WebGridCommon.Column);
        var hdr = tree.firstChild;
        var columns = WebGridCommon.initColumns(hdr, sheet, function(th) {
            return new Column(Elements.dataset(th, 'colid'));
        });        
        var root = new Roller(rd, rn, null, {
            columns: columns
        });
        var scrl_rule = sheet.rule('table.grid[id="' + hdr.id + '"]');
        var prev_left = 0;
        rn.onscroll = function() {
            var curr_left = -this.scrollLeft;
            if (curr_left !== prev_left) {
                prev_left = curr_left;
                scrl_rule.style('left', curr_left + 'px');
            }
        };
        var hasflex = false;
        for (var i = 0; i < columns.length; i++) {
            var column = columns[i];
            var rule = column.rule;
            if (i < (columns.length - 1))
                rule.style( "border-right", "1px solid #C0C0C0" );
            var hc = column.header;
            var w = hc.style.width;
            if (w) {
                hc.style.width = '';
                rule.style('width', w);
                hc._fixed = true;
            } else
                hasflex = true;
            if (columns.length === 1)
                rule.style( "padding-bottom", "1px" );
            else
                rule.style( "border-bottom", "1px solid #C0C0C0" );
        }
        if (hasflex)
            Styles.addClass(tree, 'hasflex');
        var hrule = sheet.rule( '.' + cls + ">div.head>span" );
        var cuts_rule = sheet.rule('.' + cls + ' .cutter');
        var minTreeWidth = tree.style.width ? tree.offsetWidth : 50;
        tree._wcl_calculate = function() {
            var widths = new Array(columns.length);
            var mincolswidth = 0;
            Styles.addClass(tree, 'wcl-calculate');
            try {
            for ( var i = 0; i < widths.length; i++ ) {
                var hc = columns[i].header;
                var minw = hc.scrollWidth;
                if (i)
                    minw++;//border
                widths[i] = {
                    rule: columns[i].rule,
                    min: minw,
                    max: hc._fixed ? minw : Wcl.Control.UNBOUND_MAX.x
                };
                mincolswidth += minw;
            }
            } finally {
                Styles.removeClass(tree, 'wcl-calculate');
            }
            return {
                _ww: widths,
                _mc: mincolswidth,
                min: {x: minTreeWidth, y: 50/*magic*/},
                max: Wcl.Control.UNBOUND_MAX
            };
        };
        tree._wcl_validate = function(arg) {
            var cw = (arg.rect.s.x | 0) - 2, ch = (arg.rect.s.y | 0) - 2;
            ch -= hdr.offsetHeight;
            rn.style.width = cw + 'px';
            rn.style.height = ch + 'px';
            var widths = arg.calc._ww;
            var ii = Array(widths.length);
            for (var i = 0; i < widths.length; i++)
                ii[i] = {
                    val: widths[i].min,
                    max: widths[i].max
                };
            var dw = (rn.clientWidth - 2/*two borders*/) - arg.calc._mc;
            if (dw > 0)
                Flow._algorithm(ii, dw);
            for (var i = 0; i < widths.length; i++) {
                var w = ii[i].val - 4/*paddings*/;
                if (i)
                    w--;//border
                widths[i].rule.style('width', w + 'px');
            }
                var hh = 0;
            hrule.style('height', '0');
            for (var i = 0; i < widths.length; i++)
                hh = Math.max(hh, columns[i].header.scrollHeight);
            hrule.style('height', hh + 'px');
        };
        if (ftr)
            WebGridCommon.initFooter(ftr.tFoot, datasources);
        var lastCW = 0, lastCH = 0;
        function validateHeader() {
            var cw = rn.clientWidth, ch = rn.clientHeight;
            if (cw) {//if visible
                if (cw !== lastCW) {
                    lastCW = cw;
                    cuts_rule.style('width', cw + 'px');
                    tree._wcl_invalidate();
                }
                if (ch !== lastCH) {
                    lastCH = ch;
                    if (ftrdiv)
                        ftrdiv.style.bottom = (rn.offsetHeight - ch) + 'px';
                }
            }
            setTimeout(validateHeader, 250);
        }
        validateHeader();
    }
    return {
        initialization: function( root$, components ) {
            root$.find( "div.tree" ).each( function() {
                make( this, components.datamodel._datasources );
            } );
        }
    };
} );