/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.spatial.util.ByteOrder;

public class ByteOrderLittleEndian
extends ByteOrder {
    protected ByteOrderLittleEndian() {
    }

    public void writeDouble(DataOutputStream dataOutputStream, double d) {
        try {
            long l = Double.doubleToLongBits(d);
            dataOutputStream.writeByte((int)(l & 0xFFL));
            dataOutputStream.writeByte((int)((l & 0xFF00L) >> 8));
            dataOutputStream.writeByte((int)((l & 0xFF0000L) >> 16));
            dataOutputStream.writeByte((int)((l & 0xFF000000L) >> 24));
            dataOutputStream.writeByte((int)((l & 0xFF00000000L) >> 32));
            dataOutputStream.writeByte((int)((l & 0xFF0000000000L) >> 40));
            dataOutputStream.writeByte((int)((l & 0xFF000000000000L) >> 48));
            dataOutputStream.writeByte((int)((l & 0xFF00000000000000L) >> 56));
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public double readDouble(DataInputStream dataInputStream) {
        try {
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            long l6;
            long l7;
            long l8 = dataInputStream.readByte();
            if (l8 < 0L) {
                l8 += 256L;
            }
            if ((l7 = (long)dataInputStream.readByte()) < 0L) {
                l7 += 256L;
            }
            if ((l6 = (long)dataInputStream.readByte()) < 0L) {
                l6 += 256L;
            }
            if ((l5 = (long)dataInputStream.readByte()) < 0L) {
                l5 += 256L;
            }
            if ((l4 = (long)dataInputStream.readByte()) < 0L) {
                l4 += 256L;
            }
            if ((l3 = (long)dataInputStream.readByte()) < 0L) {
                l3 += 256L;
            }
            if ((l2 = (long)dataInputStream.readByte()) < 0L) {
                l2 += 256L;
            }
            if ((l = (long)dataInputStream.readByte()) < 0L) {
                l += 256L;
            }
            return Double.longBitsToDouble(l << 56 | l2 << 48 | l3 << 40 | l4 << 32 | l5 << 24 | l6 << 16 | l7 << 8 | l8);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public void writeUInt32(DataOutputStream dataOutputStream, int n) {
        try {
            dataOutputStream.writeByte(n & 0xFF);
            dataOutputStream.writeByte((n & 0xFF00) >> 8);
            dataOutputStream.writeByte((n & 0xFF0000) >> 16);
            dataOutputStream.writeByte((n & 0x7F000000) >> 24);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public int readUInt32(DataInputStream dataInputStream) {
        try {
            int n;
            int n2;
            int n3;
            int n4 = dataInputStream.readByte();
            if (n4 < 0) {
                n4 += 256;
            }
            if ((n3 = dataInputStream.readByte()) < 0) {
                n3 += 256;
            }
            if ((n2 = dataInputStream.readByte()) < 0) {
                n2 += 256;
            }
            if ((n = dataInputStream.readByte()) < 0) {
                n += 256;
            }
            return n << 24 | n2 << 16 | n3 << 8 | n4;
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }
}

