/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JPoint2DD;
import oracle.spatial.geometry.SdoPickler;
import oracle.spatial.topo.CompGeom;
import oracle.spatial.util.RTree;
import oracle.spatial.util.SDODoubleGeneralPath;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class JGeometry
implements Cloneable,
Serializable {
    static final long serialVersionUID = -4792272186565640701L;
    public static final int GTYPE_POINT = 1;
    public static final int GTYPE_CURVE = 2;
    public static final int GTYPE_POLYGON = 3;
    public static final int GTYPE_COLLECTION = 4;
    public static final int GTYPE_MULTIPOINT = 5;
    public static final int GTYPE_MULTICURVE = 6;
    public static final int GTYPE_MULTIPOLYGON = 7;
    protected static final int ETYPE_UNKNOWN = 0;
    protected static final int ETYPE_POINT = 1;
    protected static final int ETYPE_CURVE = 2;
    protected static final int ETYPE_RING = 3;
    protected static final int ETYPE_COMPOUNDCURVE = 4;
    protected static final int ETYPE_COMPOUNDRING = 5;
    protected static final int EITPR_UNKNOWN = 0;
    protected static final int EITPR_LINEAR = 1;
    protected static final int EITPR_ARC = 2;
    protected static final int EITPR_RECTANGLE = 3;
    protected static final int EITPR_CIRCLE = 4;
    protected static final int EITPR_GEODETICMBR = 3;
    protected static final int ETOPO_NA = 0;
    protected static final int ETOPO_UNKNOWN = 0;
    protected static final int ETOPO_EXTERIOR = 1;
    protected static final int ETOPO_INTERIOR = 2;
    protected static StructDescriptor geomDesc = null;
    protected static StructDescriptor pointDesc = null;
    protected static ArrayDescriptor elemInfoDesc = null;
    protected static ArrayDescriptor ordinatesDesc = null;
    protected int gtype = 0;
    protected int linfo = 0;
    protected int srid = 0;
    protected double x = Double.NaN;
    protected double y = Double.NaN;
    protected double z = Double.NaN;
    protected int[] elemInfo = null;
    protected double[] ordinates = null;
    protected double[] mbr = null;
    protected int dim = 2;
    protected LT_transform lttpH;
    protected Gc_trans gtransH;
    private static final double MERCATOR_mdFE = 0.0;
    private static final double MERCATOR_mdFN = 0.0;
    private static final double MERCATOR_a = 6378137.0;
    private static final double MERCATOR_k0 = 1.0;
    private static final double MERCATOR_lon0 = 0.0;
    private static final double MERCATOR_f3785 = 0.0;
    private static final double MERCATOR_f54004 = 0.0033528106647474805;
    private static final double MERCATOR_e3785 = Math.sqrt(0.0);
    private static final double MERCATOR_e54004 = Math.sqrt(0.0066943799901413165);
    private static final double MERCATOR_B = Math.exp(1.0);

    private boolean lltogXYZ(double[] dArray, Gc_trans gc_trans) {
        dArray[0] = dArray[0] * gc_trans.unitfactor;
        dArray[1] = dArray[1] * gc_trans.unitfactor;
        double d = Math.cos(dArray[1]);
        double d2 = Math.sin(dArray[1]);
        double d3 = Math.cos(dArray[0]);
        double d4 = Math.sin(dArray[0]);
        double d5 = gc_trans.smax / Math.sqrt(1.0 - gc_trans.esq * d2 * d2);
        dArray[0] = d * d3 * (d5 + dArray[2]);
        dArray[1] = d * d4 * (d5 + dArray[2]);
        dArray[2] = d2 * ((1.0 - gc_trans.esq) * d5 + dArray[2]);
        return true;
    }

    private boolean gXYZtoll(double[] dArray, Gc_trans gc_trans) {
        double d;
        double d2;
        double d3 = dArray[0] * dArray[0] + dArray[1] * dArray[1];
        double d4 = (1.0 + gc_trans.esq) * dArray[2];
        double d5 = d4 / Math.sqrt(d3 + d4 * d4);
        while (Math.abs((d5 = (d4 = dArray[2] + (d2 = gc_trans.smax / Math.sqrt(1.0 - gc_trans.esq * (d = d5) * d)) * gc_trans.esq * d) / Math.sqrt(d3 + d4 * d4)) - d) > 1.0E-15) {
        }
        d2 = gc_trans.smax / Math.sqrt(1.0 - gc_trans.esq * d5 * d5);
        d4 = dArray[2] + d2 * gc_trans.esq * d5;
        dArray[0] = Math.atan2(dArray[1], dArray[0]);
        dArray[1] = Math.asin(d5);
        dArray[2] = Math.sqrt(d3 + d4 * d4) - d2;
        return true;
    }

    private boolean gxyzgmcenter(double[] dArray, double[] dArray2, Gc_trans gc_trans) {
        for (int i = 0; i < 3; ++i) {
            dArray[i] = (dArray2[i] + dArray2[i + 3]) / 2.0;
        }
        double d = gc_trans.radius / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        for (int i = 0; i < 3; ++i) {
            dArray[i] = dArray[i] * d;
        }
        return this.gXYZtoll(dArray, gc_trans);
    }

    private boolean ltxform(double[] dArray, LT_transform lT_transform) {
        double d = dArray[0] - lT_transform.xc;
        double d2 = dArray[1] - lT_transform.yc;
        double d3 = dArray[2] - lT_transform.zc;
        dArray[0] = lT_transform.xrow[0] * d + lT_transform.xrow[1] * d2 + lT_transform.xrow[2] * d3;
        dArray[1] = lT_transform.yrow[0] * d + lT_transform.yrow[1] * d2 + lT_transform.yrow[2] * d3;
        dArray[2] = 0.0;
        return true;
    }

    private boolean iltxform(double[] dArray, LT_transform lT_transform, Gc_trans gc_trans) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = 0.0;
        d3 = Math.sqrt(gc_trans.radius * gc_trans.radius - d * d - d2 * d2) - gc_trans.radius;
        dArray[0] = lT_transform.xrow[0] * d + lT_transform.yrow[0] * d2 + lT_transform.zrow[0] * d3 + lT_transform.xc;
        dArray[1] = lT_transform.xrow[1] * d + lT_transform.yrow[1] * d2 + lT_transform.zrow[1] * d3 + lT_transform.yc;
        dArray[2] = lT_transform.xrow[2] * d + lT_transform.yrow[2] * d2 + lT_transform.zrow[2] * d3 + lT_transform.zc;
        return true;
    }

    protected JGeometry(int n, int n2) {
        this.gtype = n % 100;
        this.linfo = n % 1000 / 100;
        this.dim = n / 1000 > 0 ? n / 1000 : 2;
        this.srid = n2 <= 0 ? 0 : n2;
    }

    public JGeometry(int n, int n2, double d, double d2, double d3, int[] nArray, double[] dArray) {
        this(n, n2);
        this.x = d;
        this.y = d2;
        this.z = d3;
        if (nArray == null || dArray == null) {
            this.elemInfo = nArray;
            this.ordinates = dArray;
        } else if (JGeometry.etype0_exists(nArray) && !JGeometry.ordOffset0_exists(nArray)) {
            int n3;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            JGeometry.remove_etype0(nArray, dArray, arrayList, arrayList2);
            int[] nArray2 = new int[arrayList.size()];
            double[] dArray2 = new double[arrayList2.size()];
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                nArray2[n3] = (Integer)arrayList.get(n3);
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                dArray2[n3] = (Double)arrayList2.get(n3);
            }
            this.elemInfo = nArray2;
            this.ordinates = dArray2;
        } else {
            this.elemInfo = nArray;
            this.ordinates = dArray;
        }
    }

    public JGeometry(int n, int n2, int[] nArray, double[] dArray) {
        this(n, n2);
        if (nArray == null || dArray == null) {
            this.elemInfo = nArray;
            this.ordinates = dArray;
        } else if (JGeometry.etype0_exists(nArray) && !JGeometry.ordOffset0_exists(nArray)) {
            int n3;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            JGeometry.remove_etype0(nArray, dArray, arrayList, arrayList2);
            int[] nArray2 = new int[arrayList.size()];
            double[] dArray2 = new double[arrayList2.size()];
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                nArray2[n3] = (Integer)arrayList.get(n3);
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                dArray2[n3] = (Double)arrayList2.get(n3);
            }
            this.elemInfo = nArray2;
            this.ordinates = dArray2;
        } else {
            this.elemInfo = nArray;
            this.ordinates = dArray;
        }
    }

    public JGeometry(double d, double d2, int n) {
        this(1, n);
        this.x = d;
        this.y = d2;
    }

    public JGeometry(double d, double d2, double d3, int n) {
        this(3001, n);
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public JGeometry(double d, double d2, double d3, double d4, int n) {
        this(3, n);
        this.elemInfo = new int[3];
        this.elemInfo[0] = 1;
        this.elemInfo[1] = 1003;
        this.elemInfo[2] = 3;
        this.ordinates = new double[4];
        this.ordinates[0] = d;
        this.ordinates[1] = d2;
        this.ordinates[2] = d3;
        this.ordinates[3] = d4;
    }

    public Object clone() {
        try {
            JGeometry jGeometry = (JGeometry)super.clone();
            if (this.elemInfo != null) {
                jGeometry.elemInfo = new int[this.elemInfo.length];
                System.arraycopy(this.elemInfo, 0, jGeometry.elemInfo, 0, this.elemInfo.length);
            }
            if (this.ordinates != null) {
                jGeometry.ordinates = new double[this.ordinates.length];
                System.arraycopy(this.ordinates, 0, jGeometry.ordinates, 0, this.ordinates.length);
            }
            if (this.mbr != null) {
                jGeometry.mbr = new double[this.mbr.length];
                System.arraycopy(this.mbr, 0, jGeometry.mbr, 0, this.mbr.length);
            }
            return jGeometry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static JGeometry createPoint(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(1, n2);
        jGeometry.dim = dArray.length;
        jGeometry.x = dArray[0];
        jGeometry.y = dArray[1];
        if (n == 3) {
            jGeometry.z = dArray[2];
        }
        return jGeometry;
    }

    public static JGeometry createLRSPoint(double[] dArray, int n, int n2) {
        try {
            if (n == 2 && dArray.length == 3) {
                int[] nArray = new int[]{1, 1, 1};
                JGeometry jGeometry = new JGeometry(3301, n2, nArray, dArray);
                return jGeometry;
            }
            if (n == 3 && dArray.length == 4) {
                int[] nArray = new int[]{1, 1, 1};
                JGeometry jGeometry = new JGeometry(4401, n2, nArray, dArray);
                return jGeometry;
            }
            throw new RuntimeException("Unsupported LRS Point type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createCircle(double d, double d2, double d3, int n) {
        return JGeometry.createCircle(d + d3 * Math.cos(0.7853981633974483), d2 + d3 * Math.sin(0.7853981633974483), d + d3 * Math.cos(2.356194490192345), d2 + d3 * Math.sin(2.356194490192345), d + d3 * Math.cos(4.71238898038469), d2 + d3 * Math.sin(4.71238898038469), n);
    }

    public static JGeometry createCircle(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        if (JGeometry.orientation(d, d2, d3, d4, d5, d6) == 0.0) {
            return null;
        }
        JGeometry jGeometry = new JGeometry(3, n);
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 1003;
        jGeometry.elemInfo[2] = 4;
        jGeometry.ordinates = new double[6];
        jGeometry.ordinates[0] = d;
        jGeometry.ordinates[1] = d2;
        jGeometry.ordinates[2] = d3;
        jGeometry.ordinates[3] = d4;
        jGeometry.ordinates[4] = d5;
        jGeometry.ordinates[5] = d6;
        return jGeometry;
    }

    public static JGeometry createArc2d(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(2, n2);
        jGeometry.dim = n;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 2;
        jGeometry.elemInfo[2] = 2;
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLinearLineString(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(2, n2);
        jGeometry.dim = n;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 2;
        jGeometry.elemInfo[2] = 1;
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLRSLinearLineString(double[] dArray, int n, int n2) {
        try {
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearLineString(dArray, 3, n2);
                jGeometry.setType(3302);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearLineString(dArray, 4, n2);
                jGeometry.setType(4402);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            throw new RuntimeException("Unsupported LRS Line type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createLinearMultiLineString(Object[] objectArray, int n, int n2) {
        if (objectArray.length == 1) {
            return JGeometry.createLinearLineString((double[])objectArray[0], n, n2);
        }
        JGeometry jGeometry = new JGeometry(6, n2);
        jGeometry.dim = n;
        int n3 = objectArray.length;
        int n4 = 1;
        jGeometry.elemInfo = new int[n3 * 3];
        for (int i = 0; i < n3; ++i) {
            jGeometry.elemInfo[i * 3 + 0] = n4;
            jGeometry.elemInfo[i * 3 + 1] = 2;
            jGeometry.elemInfo[i * 3 + 2] = 1;
            n4 += ((double[])objectArray[i]).length;
        }
        double[] dArray = new double[n4 - 1];
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            double[] dArray2 = (double[])objectArray[i];
            System.arraycopy(dArray2, 0, dArray, n5, dArray2.length);
            n5 += dArray2.length;
        }
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLRSLinearMultiLineString(Object[] objectArray, int n, int n2) {
        try {
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearMultiLineString(objectArray, 3, n2);
                jGeometry.setType(3306);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearMultiLineString(objectArray, 4, n2);
                jGeometry.setType(4406);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            throw new RuntimeException("Unsupported LRS MultiLine type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createMultiPoint(Object[] objectArray, int n, int n2) {
        if (objectArray.length == 1) {
            return JGeometry.createPoint((double[])objectArray[0], n, n2);
        }
        JGeometry jGeometry = new JGeometry(5, n2);
        jGeometry.dim = n;
        int n3 = objectArray.length;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 1;
        jGeometry.elemInfo[2] = n3;
        double[] dArray = new double[n3 * n];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            double[] dArray2 = (double[])objectArray[i];
            System.arraycopy(dArray2, 0, dArray, n4, n);
            n4 += n;
        }
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLinearPolygon(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(3, n2);
        jGeometry.dim = n;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 1003;
        jGeometry.elemInfo[2] = 1;
        jGeometry.ordinates = JGeometry.closeCoords(dArray, n);
        return jGeometry;
    }

    public static JGeometry createLinearPolygon(Object[] objectArray, int n, int n2) {
        int n3;
        if (objectArray.length == 1) {
            return JGeometry.createLinearPolygon((double[])objectArray[0], n, n2);
        }
        JGeometry jGeometry = new JGeometry(3, n2);
        jGeometry.dim = n;
        int n4 = objectArray.length;
        Object[] objectArray2 = new Object[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray2[n3] = JGeometry.closeCoords((double[])objectArray[n3], n);
        }
        n3 = 1;
        jGeometry.elemInfo = new int[n4 * 3];
        for (int i = 0; i < n4; ++i) {
            jGeometry.elemInfo[i * 3 + 0] = n3;
            jGeometry.elemInfo[i * 3 + 1] = i == 0 ? 1003 : 2003;
            jGeometry.elemInfo[i * 3 + 2] = 1;
            n3 += ((double[])objectArray2[i]).length;
        }
        double[] dArray = new double[n3 - 1];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            double[] dArray2 = (double[])objectArray2[i];
            System.arraycopy(dArray2, 0, dArray, n5, dArray2.length);
            n5 += dArray2.length;
        }
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLRSLinearPolygon(double[] dArray, int n, int n2) {
        try {
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearPolygon(dArray, 3, n2);
                jGeometry.setType(3303);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearPolygon(dArray, 4, n2);
                jGeometry.setType(4403);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            throw new RuntimeException("Unsupported LRS Polygon type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createLRSLinearPolygon(Object[] objectArray, int n, int n2) {
        try {
            if (objectArray instanceof double[][]) {
                for (int i = 0; i < objectArray.length; ++i) {
                    double[] dArray = ((double[][])objectArray)[i];
                    if (JGeometry.monoMeasure(dArray, n + 1) != 0) continue;
                    System.out.println("Inconsistent LRS Measure Values");
                    return null;
                }
            }
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearPolygon(objectArray, 3, n2);
                jGeometry.setType(3303);
                return jGeometry;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearPolygon(objectArray, 4, n2);
                jGeometry.setType(4403);
                return jGeometry;
            }
            throw new RuntimeException("Unsupported LRS Polygon type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static int monoMeasure(double[] dArray, int n) {
        int n2;
        double d = Double.NaN;
        int n3 = 0;
        int n4 = 0;
        double d2 = Double.NaN;
        for (n2 = n - 1; n2 < dArray.length; n2 += n) {
            d = dArray[n2];
            if (Double.isNaN(d)) continue;
            n3 = n2;
            break;
        }
        n4 = dArray[n3] == dArray[dArray.length - 1] && dArray[n3 - (n - 2)] == dArray[dArray.length - (n - 1)] && dArray[n3 - (n - 1)] == dArray[dArray.length - n] ? dArray.length - n : dArray.length;
        if (Double.isNaN(d)) {
            return 1;
        }
        int n5 = 0;
        double d3 = d;
        for (n2 = n3 + n; n2 < n4; n2 += n) {
            d2 = dArray[n2];
            if (Double.isNaN(d2)) continue;
            double d4 = d2 - d3;
            if (n5 == 0) {
                n5 = d4 > 0.0 ? 1 : (d4 < 0.0 ? -1 : 0);
            } else if (d4 * (double)n5 < 0.0) {
                return 0;
            }
            d3 = d2;
        }
        if (n5 == 0) {
            return 1;
        }
        return n5;
    }

    public int getType() {
        return this.gtype;
    }

    public void setType(int n) {
        this.gtype = n % 100;
        this.linfo = n % 1000 / 100;
        if (n / 1000 > 0) {
            this.dim = n / 1000;
        }
    }

    public int getLRMDimension() {
        return this.linfo;
    }

    public void setLRMDimension(int n) {
        this.linfo = n;
    }

    public int getSRID() {
        return this.srid;
    }

    public void setSRID(int n) {
        this.srid = n;
    }

    public Point2D getLabelPoint() {
        if (Double.isNaN(this.x) || Double.isNaN(this.y)) {
            return null;
        }
        return new Point2D.Double(this.x, this.y);
    }

    public double[] getLabelPointXYZ() {
        return new double[]{this.x, this.y, this.z};
    }

    public double[] getPoint() {
        if (this.gtype != 1) {
            return null;
        }
        double[] dArray = new double[this.dim];
        if ((Double.isNaN(this.x) || Double.isNaN(this.y)) && (this.elemInfo == null || this.elemInfo.length == 0)) {
            return null;
        }
        if (this.elemInfo == null && !Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.dim > 2) {
                dArray[2] = this.z;
            }
            return dArray;
        }
        if (this.elemInfo.length == 3) {
            for (int i = 0; i < this.dim; ++i) {
                dArray[i] = this.ordinates[i];
            }
            return dArray;
        }
        if (this.elemInfo.length == 6 && this.elemInfo[4] == 1 && this.elemInfo[5] == 0) {
            dArray[0] = this.ordinates[0];
            dArray[1] = this.ordinates[1];
            if (this.dim > 2) {
                dArray[2] = this.ordinates[2];
            }
            return dArray;
        }
        double[] dArray2 = this.getMBR();
        if (dArray2 == null) {
            return null;
        }
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        return dArray;
    }

    public Point2D getJavaPoint() {
        if (this.gtype != 1) {
            return null;
        }
        if (!Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            return new Point2D.Double(this.x, this.y);
        }
        if (this.elemInfo.length == 3) {
            return new Point2D.Double(this.ordinates[0], this.ordinates[1]);
        }
        if (this.elemInfo.length == 6 && this.elemInfo[4] == 1 && this.elemInfo[5] == 0) {
            return new Point2D.Double(this.ordinates[0], this.ordinates[1]);
        }
        double[] dArray = this.getMBR();
        if (dArray != null) {
            return new Point2D.Double(dArray[0], dArray[1]);
        }
        return null;
    }

    public Point2D[] getJavaPoints() {
        int n;
        int n2 = this.elemInfo[1] % 10;
        int n3 = this.elemInfo[2];
        if (this.isOrientedMultiPoint()) {
            n3 = this.elemInfo.length / 6;
        } else if (this.isMultiPoint()) {
            n3 = 0;
            for (n = 0; n < this.elemInfo.length; n += 3) {
                n3 += this.elemInfo[n + 2];
            }
        }
        n = n3;
        if (this.gtype != 5 || n2 != 1) {
            return null;
        }
        Point2D[] point2DArray = new Point2D[n];
        int n4 = 0;
        if (this.isOrientedMultiPoint()) {
            n4 = this.getOrientMultiPointOffset();
        }
        for (int i = 0; i < n; ++i) {
            point2DArray[i] = new Point2D.Double(this.ordinates[i * (this.dim + n4)], this.ordinates[i * (this.dim + n4) + 1]);
        }
        return point2DArray;
    }

    public final boolean isPoint() {
        return this.gtype == 1;
    }

    public final boolean isOrientedPoint() {
        if (this.elemInfo == null || this.ordinates == null) {
            return false;
        }
        return this.isPoint() && this.elemInfo.length == 6 && this.elemInfo[4] == 1 && this.elemInfo[5] == 0;
    }

    public final boolean isMultiPoint() {
        return this.gtype == 5;
    }

    public final boolean isOrientedMultiPoint() {
        if (this.elemInfo == null || this.ordinates == null) {
            return false;
        }
        return this.isMultiPoint() && this.elemInfo.length > 3 && this.elemInfo[4] == 1 && this.elemInfo[5] == 0;
    }

    public final boolean isRectangle() {
        if (this.elemInfo == null) {
            return false;
        }
        return this.gtype == 3 && this.elemInfo[1] % 100 == 3 && this.elemInfo[2] == 3 && this.elemInfo.length == 3;
    }

    public final boolean isCircle() {
        if (this.elemInfo == null) {
            return false;
        }
        return this.gtype == 3 && this.elemInfo[1] % 100 == 3 && this.elemInfo[2] == 4 && this.elemInfo.length == 3;
    }

    public final boolean isGeodeticMBR() {
        if (this.elemInfo == null) {
            return false;
        }
        return this.gtype == 3 && this.elemInfo[1] % 100 == 3 && this.elemInfo[2] == 5 && this.elemInfo.length == 3;
    }

    public final boolean isLRSGeometry() {
        return this.dim <= 2 || this.linfo == 0 ? false : (this.dim == 3 ? this.linfo == 3 : (this.dim == 4 ? this.linfo == 3 || this.linfo == 4 : false));
    }

    public final boolean hasCircularArcs() {
        if (this.elemInfo != null) {
            for (int i = 1; i < this.elemInfo.length; i += 3) {
                int n = this.elemInfo[i];
                int n2 = this.elemInfo[i + 1];
                if ((n2 != 2 || n != 2 && n != 2003 && n != 3 && n != 1003) && n != 4 && n != 5 && n != 2005 && n != 1005) continue;
                return true;
            }
        }
        return false;
    }

    public int getDimensions() {
        return this.dim;
    }

    public double[] getOrdinatesArray() {
        return this.ordinates;
    }

    public int[] getElemInfo() {
        return this.elemInfo;
    }

    public final int getNumPoints() {
        if (this.gtype == 1) {
            return 1;
        }
        if (this.isOrientedMultiPoint()) {
            int n = this.getOrientMultiPointOffset();
            return this.ordinates.length / (this.dim + n);
        }
        return this.ordinates.length / this.dim;
    }

    public double[] getFirstPoint() {
        double[] dArray = new double[this.dim];
        if (this.gtype == 1 && !Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.dim > 2) {
                dArray[2] = this.z;
            }
            return dArray;
        }
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.ordinates[i];
        }
        return dArray;
    }

    public double[] getLastPoint() {
        double[] dArray = new double[this.dim];
        if (this.gtype == 1 && !Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.dim > 2) {
                dArray[2] = this.z;
            }
            return dArray;
        }
        if (this.isOrientedPoint()) {
            for (int i = 0; i < this.dim; ++i) {
                dArray[i] = this.ordinates[i];
            }
            return dArray;
        }
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        int n2 = this.ordinates.length - this.dim - n;
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.ordinates[n2 + i];
        }
        return dArray;
    }

    public double[] getMBR() {
        if (this.mbr != null) {
            return this.mbr;
        }
        if (this.getDimensions() == 3 && this.linfo == 0) {
            int n;
            this.mbr = new double[6];
            if (this.isOptimizedPoint()) {
                this.mbr[0] = this.x;
                this.mbr[1] = this.y;
                this.mbr[2] = this.z;
                this.mbr[3] = this.x;
                this.mbr[4] = this.y;
                this.mbr[5] = this.z;
                return this.mbr;
            }
            if (this.isPoint() && this.elemInfo.length == 3 || this.isOrientedPoint()) {
                this.mbr[0] = this.ordinates[0];
                this.mbr[1] = this.ordinates[1];
                this.mbr[2] = this.ordinates[2];
                this.mbr[3] = this.ordinates[0];
                this.mbr[4] = this.ordinates[1];
                this.mbr[5] = this.ordinates[2];
                return this.mbr;
            }
            this.mbr[0] = Double.POSITIVE_INFINITY;
            this.mbr[1] = Double.POSITIVE_INFINITY;
            this.mbr[2] = Double.POSITIVE_INFINITY;
            this.mbr[3] = Double.NEGATIVE_INFINITY;
            this.mbr[4] = Double.NEGATIVE_INFINITY;
            this.mbr[5] = Double.NEGATIVE_INFINITY;
            if (this.isOrientedMultiPoint()) {
                int n2 = this.ordinates.length / (2 * this.dim);
                int n3 = this.getOrientMultiPointOffset();
                for (int i = 0; i < n2; ++i) {
                    JGeometry.expandMBR(this.mbr, this.ordinates[i * (this.dim + n3)], this.ordinates[i * (this.dim + n3) + 1], this.ordinates[i * (this.dim + n3) + 2]);
                }
                return this.mbr;
            }
            int[] nArray = new int[this.elemInfo.length];
            double[] dArray = new double[this.ordinates.length];
            for (n = 0; n < this.ordinates.length; ++n) {
                dArray[n] = this.ordinates[n];
            }
            for (n = 0; n < this.elemInfo.length; ++n) {
                nArray[n] = this.elemInfo[n];
            }
            J3D_Geometry j3D_Geometry = new J3D_Geometry(this.gtype, this.srid, nArray, dArray);
            double[][] dArray2 = new double[3][2];
            dArray2 = J3D_Geometry.getMBH(j3D_Geometry);
            for (int i = 0; i < 3; ++i) {
                this.mbr[i] = dArray2[i][0];
                this.mbr[i + 3] = dArray2[i][1];
            }
            return this.mbr;
        }
        this.mbr = new double[4];
        if (this.isOptimizedPoint()) {
            this.mbr[0] = this.x;
            this.mbr[1] = this.y;
            this.mbr[2] = this.x;
            this.mbr[3] = this.y;
            return this.mbr;
        }
        if (this.isPoint() && this.elemInfo.length == 3 || this.isOrientedPoint()) {
            this.mbr[0] = this.ordinates[0];
            this.mbr[1] = this.ordinates[1];
            this.mbr[2] = this.ordinates[0];
            this.mbr[3] = this.ordinates[1];
            return this.mbr;
        }
        if (this.isRectangle() || this.isGeodeticMBR()) {
            this.mbr[0] = Math.min(this.ordinates[0], this.ordinates[2]);
            this.mbr[1] = Math.min(this.ordinates[1], this.ordinates[3]);
            this.mbr[2] = Math.max(this.ordinates[0], this.ordinates[2]);
            this.mbr[3] = Math.max(this.ordinates[1], this.ordinates[3]);
            return this.mbr;
        }
        this.mbr[0] = Double.POSITIVE_INFINITY;
        this.mbr[1] = Double.POSITIVE_INFINITY;
        this.mbr[2] = Double.NEGATIVE_INFINITY;
        this.mbr[3] = Double.NEGATIVE_INFINITY;
        if (this.isMultiPoint() && this.elemInfo.length == 3) {
            int n = this.elemInfo[2];
            for (int i = 0; i < n; ++i) {
                JGeometry.expandMBR(this.mbr, this.ordinates[i * this.dim], this.ordinates[i * this.dim + 1]);
            }
            return this.mbr;
        }
        if (this.isOrientedMultiPoint()) {
            int n = this.ordinates.length / (2 * this.dim);
            int n4 = this.getOrientMultiPointOffset();
            for (int i = 0; i < n; ++i) {
                JGeometry.expandMBR(this.mbr, this.ordinates[i * (this.dim + n4)], this.ordinates[i * (this.dim + n4) + 1]);
            }
            return this.mbr;
        }
        ElementIterator elementIterator = new ElementIterator(this);
        block6: while (elementIterator.next()) {
            int n = elementIterator.ord_offset;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                double[] dArray;
                if (elementIterator.eitpr == 2) {
                    if (n + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n + i * this.dim >= elementIterator.next_ord_offset - this.dim || i >= elementIterator.nCoord - 1) continue block6;
                    dArray = JGeometry.computeArcMBR(this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1], this.ordinates[n + (i + 1) * this.dim], this.ordinates[n + (i + 1) * this.dim + 1], this.ordinates[n + (i + 2) * this.dim], this.ordinates[n + (i + 2) * this.dim + 1]);
                    this.expandMBR(this.mbr, dArray, 2);
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr == 4) {
                    if (n + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block6;
                    dArray = JGeometry.computeArc(this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1], this.ordinates[n + (i + 1) * this.dim], this.ordinates[n + (i + 1) * this.dim + 1], this.ordinates[n + (i + 2) * this.dim], this.ordinates[n + (i + 2) * this.dim + 1]);
                    double[] dArray3 = new double[]{dArray[0] - dArray[2], dArray[1] - dArray[2], dArray[0] + dArray[2], dArray[1] + dArray[2]};
                    this.expandMBR(this.mbr, dArray3, 2);
                    i += 2;
                    continue;
                }
                JGeometry.expandMBR(this.mbr, this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1]);
            }
        }
        return this.mbr;
    }

    public Object[] getOrdinatesOfElements() {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        ElementIterator elementIterator = new ElementIterator(this);
        while (elementIterator.next()) {
            int n2 = elementIterator.ord_offset;
            double[] dArray = new double[elementIterator.nCoord * this.dim];
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                for (int j = 0; j < this.dim; ++j) {
                    dArray[i * this.dim + j] = this.ordinates[n2 + i * (this.dim + n) + j];
                }
            }
            arrayList.add(dArray);
        }
        return arrayList.toArray();
    }

    protected double[] getOrdinatesOfElement(int n, int n2) {
        double[] dArray = new double[n2 - n];
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            dArray[n3] = this.ordinates[i];
            ++n3;
        }
        return dArray;
    }

    protected int[] getElemInfoOfElement(int n, int n2) {
        int[] nArray = new int[n2 - n];
        int n3 = 0;
        int n4 = this.elemInfo[n] - 1;
        for (int i = n; i < n2; i += 3) {
            nArray[n3] = this.elemInfo[i] - n4;
            nArray[n3 + 1] = this.elemInfo[i + 1];
            nArray[n3 + 2] = this.elemInfo[i + 2];
            n3 += 3;
        }
        return nArray;
    }

    protected JGeometry makeElementGeometry(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[n3 - n2];
        nArray = this.getElemInfoOfElement(n2, n3);
        double[] dArray = new double[n5 - n4];
        dArray = this.getOrdinatesOfElement(n4, n5);
        JGeometry jGeometry = new JGeometry(n, this.srid, nArray, dArray);
        return jGeometry;
    }

    public JGeometry getElementAt(int n) {
        if (n >= 1) {
            JGeometry[] jGeometryArray = this.getElements(n);
            if (jGeometryArray != null) {
                return jGeometryArray[0];
            }
            return null;
        }
        return null;
    }

    public JGeometry[] getElements() {
        JGeometry[] jGeometryArray = this.getElements(-1);
        return jGeometryArray;
    }

    protected JGeometry[] getElements(int n) {
        ArrayList<JGeometry> arrayList = new ArrayList<JGeometry>();
        JGeometry jGeometry = null;
        int n2 = 0;
        if (this.gtype == 1 || this.gtype == 2 || this.gtype == 3) {
            arrayList.add(this);
            ++n2;
        } else if (this.gtype == 6 || this.gtype == 7 || this.gtype == 4 || this.gtype == 5) {
            if (this.elemInfo == null || this.ordinates == null) {
                return null;
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < this.elemInfo.length; i += 3) {
                int n7;
                boolean bl;
                int n8;
                int n9;
                if (this.elemInfo[i + 1] == 2) {
                    if (++n2 == n || n == -1) {
                        n9 = 2;
                        n4 = this.elemInfo[i] - 1;
                        n6 = i + 3 < this.elemInfo.length ? this.elemInfo[i + 3] - 1 : this.ordinates.length;
                        jGeometry = this.makeElementGeometry(n9, i, i + 3, n4, n6);
                        jGeometry.dim = this.dim;
                        jGeometry.linfo = this.linfo;
                        arrayList.add(jGeometry);
                    }
                    if (n2 != n) continue;
                    i = this.elemInfo.length;
                    continue;
                }
                if (this.elemInfo[i + 1] == 4) {
                    n9 = this.elemInfo[i + 2];
                    if (++n2 == n || n == -1) {
                        n8 = 2;
                        n3 = i;
                        n4 = this.elemInfo[i] - 1;
                        if (i + 3 + 3 * n9 < this.elemInfo.length) {
                            n6 = this.elemInfo[i + 3 + 3 * n9] - 1;
                            n5 = i + 3 + 3 * n9;
                        } else {
                            n6 = this.ordinates.length;
                            n5 = this.elemInfo.length;
                        }
                        jGeometry = this.makeElementGeometry(n8, n3, n5, n4, n6);
                        jGeometry.dim = this.dim;
                        jGeometry.linfo = this.linfo;
                        arrayList.add(jGeometry);
                    }
                    if (n2 == n) {
                        i = this.elemInfo.length;
                        continue;
                    }
                    i += 3 * n9;
                    continue;
                }
                if (this.elemInfo[i + 1] == 1003 || this.elemInfo[i + 1] == 1005 || this.elemInfo[i + 1] == 3 || this.elemInfo[i + 1] == 5) {
                    ++n2;
                    n9 = 3;
                    n8 = this.elemInfo[i + 1];
                    n3 = i;
                    n4 = this.elemInfo[i] - 1;
                    bl = false;
                    if ((n8 == 1003 || n8 == 3) && i + 3 < this.elemInfo.length) {
                        n6 = this.elemInfo[i + 3] - 1;
                        n5 = i + 3;
                        bl = true;
                    } else if ((n8 == 1005 || n8 == 5) && i + 3 + 3 * this.elemInfo[i + 2] < this.elemInfo.length) {
                        n7 = this.elemInfo[i + 2];
                        n6 = this.elemInfo[i + 3 + 3 * n7] - 1;
                        n5 = i + 3 + 3 * n7;
                        i += 3 * n7;
                        bl = true;
                    } else {
                        n6 = this.ordinates.length;
                        n5 = this.elemInfo.length;
                    }
                    n7 = 1;
                    while (bl && n7 != 0) {
                        if (i + 3 + 1 < this.elemInfo.length) {
                            int n10 = this.elemInfo[i + 3 + 1];
                            if (n10 == 2003) {
                                if ((i += 3) + 3 + 1 > this.elemInfo.length) {
                                    n6 = this.ordinates.length;
                                    n5 = this.elemInfo.length;
                                    n7 = 0;
                                    continue;
                                }
                                n6 = this.elemInfo[i + 3] - 1;
                                n5 = i + 3;
                                n7 = 1;
                                continue;
                            }
                            if (n10 == 2005) {
                                int n11;
                                if ((i += 3) + 3 + 3 * (n11 = this.elemInfo[i + 2]) < this.elemInfo.length) {
                                    n6 = this.elemInfo[i + 3 + 3 * n11] - 1;
                                    n5 = i + 3 + 3 * n11;
                                    n7 = 1;
                                } else {
                                    n6 = this.ordinates.length;
                                    n5 = this.elemInfo.length;
                                    n7 = 0;
                                }
                                i += 3 * n11;
                                continue;
                            }
                            n7 = 0;
                            continue;
                        }
                        bl = false;
                    }
                    if (n2 == n || n == -1) {
                        jGeometry = this.makeElementGeometry(n9, n3, n5, n4, n6);
                        jGeometry.dim = this.dim;
                        arrayList.add(jGeometry);
                    }
                    if (n2 != n) continue;
                    i = this.elemInfo.length;
                    continue;
                }
                if (this.elemInfo[i + 1] == 1) {
                    n9 = this.elemInfo[i + 2];
                    n8 = 1;
                    n4 = this.elemInfo[i] - 1;
                    bl = false;
                    if (n9 >= 1) {
                        if (i + 3 < this.elemInfo.length) {
                            if (n9 == 1 && this.elemInfo[i + 4] == 1 && this.elemInfo[i + 5] == 0) {
                                bl = true;
                            }
                            if (bl && i + 6 < this.elemInfo.length) {
                                n6 = this.elemInfo[i + 6] - 1;
                            } else if (bl) {
                                n6 = this.ordinates.length;
                            }
                        }
                        for (n7 = 0; n7 < n9; ++n7) {
                            ++n2;
                            if (this.dim == 2 && !bl) {
                                if (n2 == n || n == -1) {
                                    jGeometry = new JGeometry(this.ordinates[n4], this.ordinates[n4 + 1], this.srid);
                                    arrayList.add(jGeometry);
                                }
                                if (n2 == n) {
                                    n7 = n9;
                                    i = this.elemInfo.length;
                                    continue;
                                }
                                n4 += 2;
                                continue;
                            }
                            if (this.dim == 3 && !bl) {
                                if (n2 == n || n == -1) {
                                    jGeometry = new JGeometry(this.ordinates[n4], this.ordinates[n4 + 1], this.ordinates[n4 + 2], this.srid);
                                    arrayList.add(jGeometry);
                                }
                                if (n2 == n) {
                                    n7 = n9;
                                    i = this.elemInfo.length;
                                    continue;
                                }
                                n4 += 3;
                                continue;
                            }
                            if (!bl) {
                                if (n2 == n || n == -1) {
                                    int[] nArray = new int[]{1, 1, 1};
                                    double[] dArray = new double[this.dim];
                                    dArray = this.getOrdinatesOfElement(n4, n4 + this.dim);
                                    jGeometry = new JGeometry(n8, this.srid, nArray, dArray);
                                    jGeometry.dim = this.dim;
                                    arrayList.add(jGeometry);
                                }
                                if (n2 == n) {
                                    n7 = n9;
                                    i = this.elemInfo.length;
                                    continue;
                                }
                                n4 += this.dim;
                                continue;
                            }
                            if (!bl) continue;
                            if (n2 == n || n == -1) {
                                jGeometry = this.makeElementGeometry(n8, i, i + 6, n4, n6);
                                jGeometry.dim = this.dim;
                                arrayList.add(jGeometry);
                            }
                            if (n2 == n) {
                                n7 = n9;
                                i = this.elemInfo.length;
                                continue;
                            }
                            i += 3;
                        }
                        continue;
                    }
                    return null;
                }
                i += 3;
            }
        }
        if (n > n2 || n2 == 0) {
            return null;
        }
        JGeometry[] jGeometryArray = new JGeometry[arrayList.size()];
        return arrayList.toArray(jGeometryArray);
    }

    public int getOrientMultiPointOffset() {
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.dim == 2 || this.dim == 3 && this.linfo == 3 ? 2 : 3;
        }
        return n;
    }

    public final Shape createShape() {
        GeneralPath generalPath = null;
        if (this.isRectangle() || this.isGeodeticMBR()) {
            float f = (float)this.ordinates[0];
            float f2 = (float)this.ordinates[1];
            float f3 = (float)this.ordinates[2];
            float f4 = (float)this.ordinates[3];
            return new Rectangle2D.Double(f, Math.min(f2, f4), f3 - f, Math.abs(f4 - f2));
        }
        if (this.isCircle()) {
            double[] dArray = JGeometry.computeArc(this.ordinates[0], this.ordinates[1], this.ordinates[this.dim], this.ordinates[this.dim + 1], this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            Ellipse2D.Double double_ = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
            return double_;
        }
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        ElementIterator elementIterator = new ElementIterator(this);
        block0: while (elementIterator.next()) {
            if (generalPath == null) {
                generalPath = new GeneralPath();
            }
            int n2 = elementIterator.ord_offset;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                Object object;
                double[] dArray;
                if (elementIterator.etype != 1 && elementIterator.eitpr == 1) {
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        generalPath.moveTo((float)this.ordinates[n2 + i * (this.dim + n)], (float)this.ordinates[n2 + i * (this.dim + n) + 1]);
                    } else {
                        generalPath.lineTo((float)this.ordinates[n2 + i * (this.dim + n)], (float)this.ordinates[n2 + i * (this.dim + n) + 1]);
                    }
                    if (i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3) continue;
                    generalPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (elementIterator.etype == 1) {
                        return null;
                    }
                    if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n2 + i * this.dim)) / this.dim < 2) continue block0;
                    dArray = new double[]{this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]};
                    object = JGeometry.reFormulateArc(dArray);
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        generalPath.moveTo((float)this.ordinates[n2 + i * this.dim], (float)this.ordinates[n2 + i * this.dim + 1]);
                    } else {
                        generalPath.lineTo((float)this.ordinates[n2 + i * this.dim], (float)this.ordinates[n2 + i * this.dim + 1]);
                    }
                    Arc2D.Double double_ = new Arc2D.Double((double)(object[0] - object[2]), (double)(object[1] - object[2]), (double)(object[2] * 2.0), (double)(object[2] * 2.0), (double)(object[3] / Math.PI * 180.0), (double)((object[5] - object[3]) / Math.PI * 180.0), 0);
                    generalPath.append(double_, true);
                    if (++i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3 && elementIterator.top_etype != 5) continue;
                    generalPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 3) {
                    float f = (float)this.ordinates[n2 + 0];
                    float f5 = (float)this.ordinates[n2 + 1];
                    float f6 = (float)this.ordinates[n2 + this.dim];
                    float f7 = (float)this.ordinates[n2 + this.dim + 1];
                    if (elementIterator.original_etype < 2000) {
                        generalPath.moveTo(f, f5);
                        generalPath.lineTo(f6, f5);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f, f7);
                        generalPath.closePath();
                    } else {
                        generalPath.moveTo(f, f5);
                        generalPath.lineTo(f, f7);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f6, f5);
                        generalPath.closePath();
                    }
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block0;
                dArray = JGeometry.computeArc(this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]);
                object = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
                generalPath.append((Shape)object, false);
                if (elementIterator.original_etype > 2000) {
                    generalPath.setWindingRule(0);
                }
                i += 2;
            }
        }
        return generalPath;
    }

    public final Shape createShape(AffineTransform affineTransform) {
        return this.createShape(affineTransform, false);
    }

    public final Shape createShape(AffineTransform affineTransform, boolean bl) {
        if (affineTransform == null) {
            return this.createShape();
        }
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        GeneralPath generalPath = null;
        if (this.isRectangle() || this.isGeodeticMBR()) {
            ((Point2D)double_).setLocation(this.ordinates[0], this.ordinates[1]);
            affineTransform.transform(double_, double_2);
            float f = (float)((Point2D)double_2).getX();
            float f2 = (float)((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[2], this.ordinates[3]);
            affineTransform.transform(double_, double_2);
            float f3 = (float)((Point2D)double_2).getX();
            float f4 = (float)((Point2D)double_2).getY();
            return new Rectangle2D.Double(f, Math.min(f2, f4), f3 - f, Math.abs(f4 - f2));
        }
        if (this.isCircle()) {
            ((Point2D)double_).setLocation(this.ordinates[0], this.ordinates[1]);
            affineTransform.transform(double_, double_2);
            double d = ((Point2D)double_2).getX();
            double d2 = ((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[this.dim], this.ordinates[this.dim + 1]);
            affineTransform.transform(double_, double_2);
            double d3 = ((Point2D)double_2).getX();
            double d4 = ((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            affineTransform.transform(double_, double_2);
            double d5 = ((Point2D)double_2).getX();
            double d6 = ((Point2D)double_2).getY();
            double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
            return double_3;
        }
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        double d = 0.0;
        double d7 = 0.0;
        ElementIterator elementIterator = new ElementIterator(this);
        block0: while (elementIterator.next()) {
            if (generalPath == null) {
                generalPath = new GeneralPath();
            }
            int n2 = elementIterator.ord_offset;
            double d8 = Double.MAX_VALUE;
            double d9 = Double.MAX_VALUE;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                if (elementIterator.etype != 1 && elementIterator.eitpr == 1) {
                    d = this.ordinates[n2 + i * (this.dim + n)];
                    d7 = this.ordinates[n2 + i * (this.dim + n) + 1];
                    ((Point2D)double_).setLocation(d, d7);
                    affineTransform.transform(double_, double_2);
                    d = ((Point2D)double_2).getX();
                    d7 = ((Point2D)double_2).getY();
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        d8 = d;
                        d9 = d7;
                        generalPath.moveTo((float)d, (float)d7);
                    } else {
                        boolean bl2;
                        double d10 = d - d8;
                        double d11 = d7 - d9;
                        boolean bl3 = bl2 = d10 < -0.25 || d10 > 0.25 || d11 < -0.25 || d11 > 0.25;
                        if (!bl || bl2) {
                            d8 = d;
                            d9 = d7;
                            generalPath.lineTo((float)d, (float)d7);
                        }
                    }
                    if (i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3) continue;
                    generalPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (elementIterator.etype == 1) {
                        return null;
                    }
                    if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n2 + i * this.dim)) / this.dim < 2) continue block0;
                    double[] dArray = new double[]{this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]};
                    affineTransform.transform(dArray, 0, dArray, 0, 3);
                    double[] dArray2 = JGeometry.reFormulateArc(dArray);
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        generalPath.moveTo((float)dArray[0], (float)dArray[1]);
                    } else {
                        generalPath.lineTo((float)dArray[0], (float)dArray[1]);
                    }
                    Arc2D.Double double_4 = new Arc2D.Double(dArray2[0] - dArray2[2], dArray2[1] - dArray2[2], dArray2[2] * 2.0, dArray2[2] * 2.0, dArray2[3] / Math.PI * 180.0, (dArray2[5] - dArray2[3]) / Math.PI * 180.0, 0);
                    generalPath.append(double_4, true);
                    if (++i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3 && elementIterator.top_etype != 5) continue;
                    generalPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 3) {
                    ((Point2D)double_).setLocation(this.ordinates[n2 + 0], this.ordinates[n2 + 1]);
                    affineTransform.transform(double_, double_2);
                    float f = (float)((Point2D)double_2).getX();
                    float f5 = (float)((Point2D)double_2).getY();
                    ((Point2D)double_).setLocation(this.ordinates[n2 + this.dim], this.ordinates[n2 + this.dim + 1]);
                    affineTransform.transform(double_, double_2);
                    float f6 = (float)((Point2D)double_2).getX();
                    float f7 = (float)((Point2D)double_2).getY();
                    if (elementIterator.original_etype < 2000) {
                        generalPath.moveTo(f, f5);
                        generalPath.lineTo(f6, f5);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f, f7);
                        generalPath.closePath();
                    } else {
                        generalPath.moveTo(f, f5);
                        generalPath.lineTo(f, f7);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f6, f5);
                        generalPath.closePath();
                    }
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block0;
                double[] dArray = new double[]{this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]};
                affineTransform.transform(dArray, 0, dArray, 0, 3);
                double[] dArray3 = JGeometry.computeArc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                Ellipse2D.Double double_5 = new Ellipse2D.Double(dArray3[0] - dArray3[2], dArray3[1] - dArray3[2], 2.0 * dArray3[2], 2.0 * dArray3[2]);
                generalPath.append(double_5, false);
                if (elementIterator.original_etype > 2000) {
                    generalPath.setWindingRule(0);
                }
                i += 2;
            }
        }
        return generalPath;
    }

    public final Shape createDoubleShape() {
        SDODoubleGeneralPath sDODoubleGeneralPath = null;
        if (this.isRectangle() || this.isGeodeticMBR()) {
            double d = this.ordinates[0];
            double d2 = this.ordinates[1];
            double d3 = this.ordinates[2];
            double d4 = this.ordinates[3];
            return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }
        if (this.isCircle()) {
            double[] dArray = JGeometry.computeArc(this.ordinates[0], this.ordinates[1], this.ordinates[this.dim], this.ordinates[this.dim + 1], this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            Ellipse2D.Double double_ = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
            return double_;
        }
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        ElementIterator elementIterator = new ElementIterator(this);
        block0: while (elementIterator.next()) {
            if (sDODoubleGeneralPath == null) {
                sDODoubleGeneralPath = new SDODoubleGeneralPath();
            }
            int n2 = elementIterator.ord_offset;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                if (elementIterator.eitpr == 1) {
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        sDODoubleGeneralPath.moveTo(this.ordinates[n2 + i * (this.dim + n)], this.ordinates[n2 + i * (this.dim + n) + 1]);
                    } else {
                        sDODoubleGeneralPath.lineTo(this.ordinates[n2 + i * (this.dim + n)], this.ordinates[n2 + i * (this.dim + n) + 1]);
                    }
                    if (i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3) continue;
                    sDODoubleGeneralPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (elementIterator.etype == 1) {
                        return null;
                    }
                    if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n2 + i * this.dim)) / this.dim < 2) continue block0;
                    double[] dArray = JGeometry.linearizeArc(this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]);
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        sDODoubleGeneralPath.moveTo(dArray[0], dArray[1]);
                    } else {
                        sDODoubleGeneralPath.lineTo(dArray[0], dArray[1]);
                    }
                    for (int j = 1; j < dArray.length / 2; ++j) {
                        sDODoubleGeneralPath.lineTo(dArray[j * 2], dArray[j * 2 + 1]);
                    }
                    if (++i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3 && elementIterator.top_etype != 5) continue;
                    sDODoubleGeneralPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 3) {
                    double d = this.ordinates[n2 + 0];
                    double d5 = this.ordinates[n2 + 1];
                    double d6 = this.ordinates[n2 + this.dim];
                    double d7 = this.ordinates[n2 + this.dim + 1];
                    if (elementIterator.original_etype < 2000) {
                        sDODoubleGeneralPath.moveTo(d, d5);
                        sDODoubleGeneralPath.lineTo(d6, d5);
                        sDODoubleGeneralPath.lineTo(d6, d7);
                        sDODoubleGeneralPath.lineTo(d, d7);
                        sDODoubleGeneralPath.closePath();
                    } else {
                        sDODoubleGeneralPath.moveTo(d, d5);
                        sDODoubleGeneralPath.lineTo(d, d7);
                        sDODoubleGeneralPath.lineTo(d6, d7);
                        sDODoubleGeneralPath.lineTo(d6, d5);
                        sDODoubleGeneralPath.closePath();
                    }
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block0;
                double[] dArray = JGeometry.computeArc(this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]);
                Ellipse2D.Double double_ = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
                sDODoubleGeneralPath.append((Shape)double_, false);
                if (elementIterator.original_etype > 2000) {
                    sDODoubleGeneralPath.setWindingRule(0);
                }
                i += 2;
            }
        }
        return sDODoubleGeneralPath;
    }

    public final Shape createDoubleShape(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return this.createDoubleShape();
        }
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        SDODoubleGeneralPath sDODoubleGeneralPath = null;
        if (this.isRectangle() || this.isGeodeticMBR()) {
            ((Point2D)double_).setLocation(this.ordinates[0], this.ordinates[1]);
            affineTransform.transform(double_, double_2);
            double d = ((Point2D)double_2).getX();
            double d2 = ((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[2], this.ordinates[3]);
            affineTransform.transform(double_, double_2);
            double d3 = ((Point2D)double_2).getX();
            double d4 = ((Point2D)double_2).getY();
            return new Rectangle2D.Double(d, Math.min(d2, d4), d3 - d, Math.abs(d4 - d2));
        }
        if (this.isCircle()) {
            ((Point2D)double_).setLocation(this.ordinates[0], this.ordinates[1]);
            affineTransform.transform(double_, double_2);
            double d = ((Point2D)double_2).getX();
            double d5 = ((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[this.dim], this.ordinates[this.dim + 1]);
            affineTransform.transform(double_, double_2);
            double d6 = ((Point2D)double_2).getX();
            double d7 = ((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            affineTransform.transform(double_, double_2);
            double d8 = ((Point2D)double_2).getX();
            double d9 = ((Point2D)double_2).getY();
            double[] dArray = JGeometry.computeArc(d, d5, d6, d7, d8, d9);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
            return double_3;
        }
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        double d = 0.0;
        double d10 = 0.0;
        ElementIterator elementIterator = new ElementIterator(this);
        block0: while (elementIterator.next()) {
            if (sDODoubleGeneralPath == null) {
                sDODoubleGeneralPath = new SDODoubleGeneralPath();
            }
            int n2 = elementIterator.ord_offset;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                if (elementIterator.eitpr == 1) {
                    d = this.ordinates[n2 + i * (this.dim + n)];
                    d10 = this.ordinates[n2 + i * (this.dim + n) + 1];
                    ((Point2D)double_).setLocation(d, d10);
                    affineTransform.transform(double_, double_2);
                    d = ((Point2D)double_2).getX();
                    d10 = ((Point2D)double_2).getY();
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        sDODoubleGeneralPath.moveTo(d, d10);
                    } else {
                        sDODoubleGeneralPath.lineTo(d, d10);
                    }
                    if (i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3) continue;
                    sDODoubleGeneralPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (elementIterator.etype == 1) {
                        return null;
                    }
                    if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n2 + i * this.dim)) / this.dim < 2) continue block0;
                    double[] dArray = JGeometry.linearizeArc(this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]);
                    affineTransform.transform(dArray, 0, dArray, 0, dArray.length / 2);
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        sDODoubleGeneralPath.moveTo(dArray[0], dArray[1]);
                    } else {
                        sDODoubleGeneralPath.lineTo(dArray[0], dArray[1]);
                    }
                    for (int j = 1; j < dArray.length / 2; ++j) {
                        sDODoubleGeneralPath.lineTo(dArray[j * 2], dArray[j * 2 + 1]);
                    }
                    if (++i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3 && elementIterator.top_etype != 5) continue;
                    sDODoubleGeneralPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 3) {
                    ((Point2D)double_).setLocation(this.ordinates[n2 + 0], this.ordinates[n2 + 1]);
                    affineTransform.transform(double_, double_2);
                    double d11 = ((Point2D)double_2).getX();
                    double d12 = ((Point2D)double_2).getY();
                    ((Point2D)double_).setLocation(this.ordinates[n2 + this.dim], this.ordinates[n2 + this.dim + 1]);
                    affineTransform.transform(double_, double_2);
                    double d13 = ((Point2D)double_2).getX();
                    double d14 = ((Point2D)double_2).getY();
                    sDODoubleGeneralPath.moveTo(d11, d12);
                    sDODoubleGeneralPath.lineTo(d13, d12);
                    sDODoubleGeneralPath.lineTo(d13, d14);
                    sDODoubleGeneralPath.lineTo(d11, d14);
                    sDODoubleGeneralPath.closePath();
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block0;
                double[] dArray = new double[]{this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]};
                affineTransform.transform(dArray, 0, dArray, 0, 3);
                double[] dArray2 = JGeometry.computeArc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                Ellipse2D.Double double_4 = new Ellipse2D.Double(dArray2[0] - dArray2[2], dArray2[1] - dArray2[2], 2.0 * dArray2[2], 2.0 * dArray2[2]);
                sDODoubleGeneralPath.append((Shape)double_4, false);
                i += 2;
            }
        }
        return sDODoubleGeneralPath;
    }

    public static final JGeometry load(STRUCT sTRUCT) throws SQLException {
        Datum[] datumArray;
        Datum[] datumArray2 = sTRUCT.getOracleAttributes();
        int n = datumArray2[0] != null ? datumArray2[0].intValue() : 0;
        int n2 = datumArray2[1] != null ? datumArray2[1].intValue() : 0;
        STRUCT sTRUCT2 = (STRUCT)datumArray2[2];
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        if (sTRUCT2 != null) {
            datumArray = sTRUCT2.getOracleAttributes();
            if (datumArray[0] != null && datumArray[1] != null) {
                d = datumArray[0].doubleValue();
                d2 = datumArray[1].doubleValue();
            }
            if (datumArray[2] != null) {
                d3 = datumArray[2].doubleValue();
            }
        }
        datumArray = datumArray2[3] != null ? ((ARRAY)datumArray2[3]).getIntArray() : null;
        double[] dArray = null;
        if (datumArray2[4] != null) {
            if (n % 1000 / 100 == 0) {
                dArray = ((ARRAY)datumArray2[4]).getDoubleArray();
            } else {
                int n3 = n % 1000 / 100;
                int n4 = n / 1000 > 0 ? n / 1000 : 2;
                Datum[] datumArray3 = ((ARRAY)datumArray2[4]).getOracleArray();
                int n5 = datumArray3.length;
                dArray = new double[n5];
                if (n4 != 2 && (n4 == 3 && n4 == n3 || n4 == 4 && (n3 == 3 || n3 == 4))) {
                    for (int i = 0; i < n5; ++i) {
                        if (datumArray3[i] == null && i % n4 != n3 - 1) {
                            throw new SQLException("An invalid null value is found in LRS sdo_ordinates");
                        }
                        dArray[i] = datumArray3[i] != null ? datumArray3[i].doubleValue() : Double.NaN;
                    }
                } else {
                    throw new SQLException("An invalid sdo_gtype is found");
                }
            }
        }
        if (dArray != null && datumArray != null) {
            return new JGeometry(n, n2, d, d2, d3, (int[])datumArray, dArray);
        }
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            if (!Double.isNaN(d3)) {
                return new JGeometry(d, d2, d3, n2);
            }
            return new JGeometry(d, d2, n2);
        }
        return null;
    }

    private static boolean etype0_exists(int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length / 3; ++i) {
            if (nArray[3 * i + 1] != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean ordOffset0_exists(int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length / 3; ++i) {
            if (nArray[3 * i] >= 1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected static void remove_etype0(int[] nArray, double[] dArray, ArrayList arrayList, ArrayList arrayList2) {
        int n;
        int[] nArray2 = new int[nArray.length];
        double[] dArray2 = new double[dArray.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n2 = 0; n2 < nArray.length / 3; ++n2) {
            if (nArray[3 * n2 + 1] == 0) {
                n7 = nArray[3 * n2] - 1;
                n8 = 3 * (n2 + 1) <= nArray.length - 1 ? nArray[3 * (n2 + 1)] - 2 : dArray.length - 1;
                n6 += n8 - n7 + 1;
                continue;
            }
            n7 = nArray[3 * n2] - 1;
            n8 = 3 * (n2 + 1) <= nArray.length - 1 ? nArray[3 * (n2 + 1)] - 2 : dArray.length - 1;
            for (n3 = n7; n3 <= n8; ++n3) {
                dArray2[n5] = dArray[n3];
                ++n5;
            }
            nArray2[n4] = nArray[3 * n2] - n6;
            ++n4;
            for (n3 = 1; n3 < 3; ++n3) {
                nArray2[n4] = nArray[3 * n2 + n3];
                ++n4;
            }
        }
        for (n = 0; n < n4; ++n) {
            arrayList.add(nArray2[n]);
        }
        for (n = 0; n < n5; ++n) {
            arrayList2.add(dArray2[n]);
        }
    }

    static final JGeometry loadAndReorient(STRUCT sTRUCT) throws SQLException {
        JGeometry jGeometry = JGeometry.load(sTRUCT);
        if (jGeometry == null) {
            return null;
        }
        if (!(jGeometry.gtype != 2 && jGeometry.gtype != 6 && jGeometry.gtype != 4 || jGeometry.hasCircularArcs())) {
            jGeometry.reOrientCurves();
        }
        return jGeometry;
    }

    public static STRUCT store(JGeometry jGeometry, Connection connection) throws SQLException {
        return JGeometry.store(jGeometry, connection, null);
    }

    public static STRUCT store(JGeometry jGeometry, Connection connection, boolean bl) throws SQLException {
        return JGeometry.store(jGeometry, connection, null, bl);
    }

    public static STRUCT store(JGeometry jGeometry, Connection connection, Object[] objectArray) throws SQLException {
        return JGeometry.store(jGeometry, connection, objectArray, false);
    }

    public static STRUCT store(JGeometry jGeometry, Connection connection, Object[] objectArray, boolean bl) throws SQLException {
        ARRAY aRRAY;
        Object[] objectArray2;
        ARRAY aRRAY2;
        StructDescriptor structDescriptor = null;
        StructDescriptor structDescriptor2 = null;
        ArrayDescriptor arrayDescriptor = null;
        ArrayDescriptor arrayDescriptor2 = null;
        if (objectArray != null && objectArray.length >= 4) {
            structDescriptor = (StructDescriptor)objectArray[0];
            structDescriptor2 = (StructDescriptor)objectArray[1];
            arrayDescriptor = (ArrayDescriptor)objectArray[2];
            arrayDescriptor2 = (ArrayDescriptor)objectArray[3];
        } else {
            if (geomDesc == null) {
                JGeometry.createDBDescriptors(connection);
            }
            structDescriptor = geomDesc;
            structDescriptor2 = pointDesc;
            arrayDescriptor = elemInfoDesc;
            arrayDescriptor2 = ordinatesDesc;
        }
        if (structDescriptor == null) {
            throw new SQLException("sdo_geometry descriptor is null.");
        }
        if (structDescriptor2 == null) {
            throw new SQLException("sdo_point descriptor is null.");
        }
        if (arrayDescriptor == null) {
            throw new SQLException("elem_info descriptor is null.");
        }
        if (arrayDescriptor2 == null) {
            throw new SQLException("ordinates descriptor is null.");
        }
        NUMBER nUMBER = new NUMBER(jGeometry.gtype + jGeometry.linfo * 100 + jGeometry.dim * 1000);
        NUMBER nUMBER2 = jGeometry.srid == 0 ? null : new NUMBER(jGeometry.srid);
        STRUCT sTRUCT = null;
        if (bl) {
            ARRAY aRRAY3 = aRRAY2 = Double.isNaN(jGeometry.x) || Double.isNaN(jGeometry.y) ? null : new NUMBER[3];
            if (aRRAY2 != null) {
                aRRAY2[0] = new NUMBER(new BigDecimal(jGeometry.x));
                aRRAY2[1] = new NUMBER(new BigDecimal(jGeometry.y));
                aRRAY2[2] = Double.isNaN(jGeometry.z) ? null : new NUMBER(new BigDecimal(jGeometry.z));
                sTRUCT = new STRUCT(structDescriptor2, connection, (Object[])aRRAY2);
            }
        } else {
            Object object = aRRAY2 = Double.isNaN(jGeometry.x) || Double.isNaN(jGeometry.y) ? null : new NUMBER[3];
            if (aRRAY2 != null) {
                aRRAY2[0] = new NUMBER(jGeometry.x);
                aRRAY2[1] = new NUMBER(jGeometry.y);
                aRRAY2[2] = Double.isNaN(jGeometry.z) ? null : new NUMBER(jGeometry.z);
                sTRUCT = new STRUCT(structDescriptor2, connection, (Object[])aRRAY2);
            }
        }
        ARRAY aRRAY4 = aRRAY2 = jGeometry.elemInfo == null ? null : new ARRAY(arrayDescriptor, connection, (Object)jGeometry.elemInfo);
        if (bl) {
            objectArray2 = null;
            if (jGeometry.ordinates != null) {
                objectArray2 = new BigDecimal[jGeometry.ordinates.length];
                if (jGeometry.linfo == 0) {
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        objectArray2[i] = new BigDecimal(jGeometry.ordinates[i]);
                    }
                } else {
                    if (jGeometry.dim == 2 || jGeometry.dim == 3 && jGeometry.linfo != 3 || jGeometry.dim == 4 && jGeometry.linfo != 3 && jGeometry.linfo != 4) {
                        throw new SQLException("An invalid gtype value for LRS is found");
                    }
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        if (Double.isNaN(jGeometry.ordinates[i]) && i % jGeometry.dim != jGeometry.linfo - 1) {
                            throw new SQLException("An invalid Double.NaN is found in LRS ordinates");
                        }
                        objectArray2[i] = Double.isNaN(jGeometry.ordinates[i]) ? null : new BigDecimal(jGeometry.ordinates[i]);
                    }
                }
            }
            aRRAY = jGeometry.ordinates == null ? null : new ARRAY(arrayDescriptor2, connection, (Object)objectArray2);
        } else {
            objectArray2 = null;
            if (jGeometry.ordinates != null) {
                objectArray2 = new Double[jGeometry.ordinates.length];
                if (jGeometry.linfo == 0) {
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        objectArray2[i] = new Double(jGeometry.ordinates[i]);
                    }
                } else {
                    if (jGeometry.dim == 2 || jGeometry.dim == 3 && jGeometry.linfo != 3 || jGeometry.dim == 4 && jGeometry.linfo != 3 && jGeometry.linfo != 4) {
                        throw new SQLException("An invalid gtype value for LRS is found");
                    }
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        if (Double.isNaN(jGeometry.ordinates[i]) && i % jGeometry.dim != jGeometry.linfo - 1) {
                            throw new SQLException("An invalid Double.NaN is found in LRS ordinates");
                        }
                        objectArray2[i] = Double.isNaN(jGeometry.ordinates[i]) ? null : new Double(jGeometry.ordinates[i]);
                    }
                }
            }
            aRRAY = jGeometry.ordinates == null ? null : new ARRAY(arrayDescriptor2, connection, (Object)objectArray2);
        }
        objectArray2 = new Object[]{nUMBER, nUMBER2, sTRUCT, aRRAY2, aRRAY};
        return new STRUCT(structDescriptor, connection, objectArray2);
    }

    public static Object[] getOracleDescriptors(Connection connection) throws SQLException {
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)connection);
        StructDescriptor structDescriptor2 = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)connection);
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)connection);
        ArrayDescriptor arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)connection);
        return new Object[]{structDescriptor, structDescriptor2, arrayDescriptor, arrayDescriptor2};
    }

    protected final boolean isOptimizedPoint() {
        return this.gtype % 100 == 1 && this.ordinates == null && !Double.isNaN(this.x) && !Double.isNaN(this.y);
    }

    protected static final void createDBDescriptors(Connection connection) throws SQLException {
        geomDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)connection);
        pointDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)connection);
        elemInfoDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)connection);
        ordinatesDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)connection);
    }

    protected final boolean isSimpleElement(int n) {
        return n == 1 || n == 2 || n % 10 == 3;
    }

    protected final boolean isCompoundElement(int n) {
        return n == 4 || n % 10 == 5;
    }

    protected static final void expandMBR(double[] dArray, double d, double d2) {
        if (dArray[0] > d) {
            dArray[0] = d;
        }
        if (dArray[1] > d2) {
            dArray[1] = d2;
        }
        if (dArray[2] < d) {
            dArray[2] = d;
        }
        if (dArray[3] < d2) {
            dArray[3] = d2;
        }
    }

    protected static final void expandMBR(double[] dArray, double d, double d2, double d3) {
        if (dArray[0] > d) {
            dArray[0] = d;
        }
        if (dArray[1] > d2) {
            dArray[1] = d2;
        }
        if (dArray[2] > d3) {
            dArray[2] = d3;
        }
        if (dArray[3] < d) {
            dArray[3] = d;
        }
        if (dArray[4] < d2) {
            dArray[4] = d2;
        }
        if (dArray[5] < d3) {
            dArray[5] = d3;
        }
    }

    protected final void expandMBR(double[] dArray, double[] dArray2, int n) {
        for (int i = 0; i < dArray2.length / n; ++i) {
            int n2 = i * n;
            if (n == 2) {
                JGeometry.expandMBR(dArray, dArray2[n2], dArray2[n2 + 1]);
                continue;
            }
            JGeometry.expandMBR(dArray, dArray2[n2], dArray2[n2 + 1], dArray2[n2 + 2]);
        }
    }

    protected final void expandMBR(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        for (int i = 0; i < n2 / n3; ++i) {
            int n4 = n + i * n3;
            if (n3 == 2) {
                JGeometry.expandMBR(dArray, dArray2[n4], dArray2[n4 + 1]);
                continue;
            }
            JGeometry.expandMBR(dArray, dArray2[n4], dArray2[n4 + 1], dArray2[n4 + 2]);
        }
    }

    protected void reOrientCurves() {
    }

    public static final double[] computeArc(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = d - d3;
        double d10 = d3 - d5;
        double d11 = d4 - d6;
        double d12 = d2 - d4;
        double d13 = d + d3;
        double d14 = d3 + d5;
        double d15 = d2 + d4;
        double d16 = d4 + d6;
        double d17 = d9 * d11 - d10 * d12;
        if (d17 > -4.9E-323 && d17 < 4.9E-323) {
            return null;
        }
        double[] dArray = new double[6];
        double d18 = (d11 * d13 * d9 - d12 * d14 * d10 + d12 * d11 * (d12 + d11)) / d17;
        double d19 = Math.abs(d4 - d6) < 5.0E-8 ? (d15 * d12 + (d13 - d18) * d9) / d12 : (d16 * d11 + (d14 - d18) * d10) / d11;
        double d20 = Math.sqrt(((d18 *= 0.5) - d) * (d18 - d) + ((d19 *= 0.5) - d2) * (d19 - d2));
        double d21 = Math.atan2(d2 - d19, d - d18);
        if (d21 < 0.0) {
            d21 += Math.PI * 2;
        }
        if ((d8 = Math.atan2(d4 - d19, d3 - d18)) < 0.0) {
            d8 += Math.PI * 2;
        }
        if ((d7 = Math.atan2(d6 - d19, d5 - d18)) < 0.0) {
            d7 += Math.PI * 2;
        }
        dArray[0] = d18;
        dArray[1] = d19;
        dArray[2] = d20;
        dArray[3] = d21;
        dArray[4] = d8;
        dArray[5] = d7;
        return dArray;
    }

    protected static final double[] computeArcMBR(double d, double d2, double d3, double d4, double d5, double d6) {
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d7 = dArray[0];
        double d8 = dArray[1];
        double d9 = dArray[2];
        double d10 = dArray[3];
        double d11 = dArray[4];
        double d12 = dArray[5];
        double d13 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        double[] dArray2 = new double[]{Math.min(d, d5), Math.min(d2, d6), Math.max(d, d5), Math.max(d2, d6)};
        if (JGeometry.thetaInArc(0.0, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7 + d9, d8);
        }
        if (JGeometry.thetaInArc(1.5707963267948966, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7, d8 + d9);
        }
        if (JGeometry.thetaInArc(Math.PI, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7 - d9, d8);
        }
        if (JGeometry.thetaInArc(4.71238898038469, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7, d8 - d9);
        }
        dArray = new double[]{dArray2[0], dArray2[1], dArray2[0], dArray2[3], dArray2[2], dArray2[3], dArray2[2], dArray2[1]};
        return dArray;
    }

    protected static final short thetaInArc(double d, double d2, double d3, double d4) {
        if (d == d2 || d == d3 || d == d2 + Math.PI * 2 || d == d3 + Math.PI * 2 || d == d2 - Math.PI * 2 || d == d3 - Math.PI * 2) {
            return -1;
        }
        int n = 0;
        if (d4 > 0.0) {
            n = (short)(n + 1);
        }
        if (d3 > d2) {
            n = (short)(n + 1);
        }
        if (d2 < d && d < d3 || d2 > d && d > d3) {
            n = (short)(n + 1);
        }
        return (short)(n & 1);
    }

    protected static final double orientation(double d, double d2, double d3, double d4, double d5, double d6) {
        return d * d4 + d3 * d6 + d5 * d2 - (d5 * d4 + d3 * d2 + d * d6);
    }

    public static double[] expandCircle(double d, double d2, double d3, double d4, double d5, double d6) {
        int n = 4;
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d7 = dArray[0];
        double d8 = dArray[1];
        double d9 = dArray[2];
        double d10 = dArray[3];
        double d11 = dArray[4];
        double d12 = dArray[3];
        double d13 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        double d14 = d10;
        double d15 = d12;
        if (d13 > 0.0) {
            d15 = 1.0;
        } else if (d13 < 0.0) {
            d15 = -1.0;
        }
        double[] dArray2 = new double[10];
        for (int i = 0; i <= n; ++i) {
            double d16 = d14 + (double)i * 1.5707963267948966 * d15;
            dArray2[i * 2] = d7 + d9 * Math.cos(d16);
            dArray2[i * 2 + 1] = d8 + d9 * Math.sin(d16);
        }
        dArray2[0] = d;
        dArray2[1] = d2;
        dArray2[8] = d;
        dArray2[9] = d2;
        return dArray2;
    }

    public static double[] linearizeArc(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        int n2 = n - 1;
        if (n2 < 1) {
            double[] dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d7 = dArray[0];
        double d8 = dArray[1];
        double d9 = dArray[2];
        double d10 = dArray[3];
        double d11 = dArray[4];
        double d12 = dArray[5];
        double d13 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        double d14 = d10;
        double d15 = d12;
        if (d13 > 0.0 && d15 < d14) {
            d15 += Math.PI * 2;
        } else if (d13 < 0.0 && d15 > d14) {
            d15 -= Math.PI * 2;
        }
        double d16 = d12 - d10;
        if (d13 > 0.0 && d16 < 0.0) {
            d16 += Math.PI * 2;
        } else if (d13 < 0.0 && d16 > 0.0) {
            d16 -= Math.PI * 2;
        }
        double d17 = Math.abs(d16) / (double)n2;
        double d18 = Math.sin(d17);
        double d19 = Math.cos(d17);
        if (d13 > 0.0) {
            d18 = -d18;
        }
        double d20 = d - d7;
        double d21 = d2 - d8;
        double[] dArray2 = new double[(n2 + 1) * 2];
        dArray2[0] = d;
        dArray2[1] = d2;
        double d22 = 0.0;
        for (int i = 1; i < n2; ++i) {
            d22 = d20 * d19 + d21 * d18;
            d21 = -d20 * d18 + d21 * d19;
            d20 = d22;
            dArray2[2 * i] = d7 + d20;
            dArray2[2 * i + 1] = d8 + d21;
        }
        dArray2[(n2 + 1) * 2 - 2] = d5;
        dArray2[(n2 + 1) * 2 - 1] = d6;
        return dArray2;
    }

    private static double[] linearizeArc(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        double d8;
        int n;
        if (d7 <= 0.0) {
            return JGeometry.linearizeArc(d, d2, d3, d4, d5, d6, 0);
        }
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d9 = dArray[0];
        double d10 = dArray[1];
        double d11 = dArray[2];
        double d12 = dArray[3];
        double d13 = dArray[4];
        double d14 = dArray[5];
        double d15 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        if (bl) {
            d7 = d11 * (1.0 - Math.cos(Math.asin(d7 / (2.0 * d11))));
        }
        double d16 = d14 - d12;
        if (d15 > 0.0 && d16 < 0.0) {
            d16 += Math.PI * 2;
        } else if (d15 < 0.0 && d16 > 0.0) {
            d16 -= Math.PI * 2;
        }
        if (d16 < 0.0) {
            d16 = -d16;
        }
        if ((n = (int)Math.ceil(d16 / (d8 = Math.acos(1.0 - d7 / d11) * 2.0))) > 1000) {
            n = 1000;
        }
        if (n < 2) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d17 = Math.abs(d16) / (double)n;
        double d18 = Math.sin(d17);
        double d19 = Math.cos(d17);
        if (d15 > 0.0) {
            d18 = -d18;
        }
        double d20 = d - d9;
        double d21 = d2 - d10;
        double[] dArray2 = new double[(n + 1) * 2];
        dArray2[0] = d;
        dArray2[1] = d2;
        double d22 = 0.0;
        for (int i = 1; i < n; ++i) {
            d22 = d20 * d19 + d21 * d18;
            d21 = -d20 * d18 + d21 * d19;
            d20 = d22;
            dArray2[2 * i] = d9 + d20;
            dArray2[2 * i + 1] = d10 + d21;
        }
        dArray2[(n + 1) * 2 - 2] = d5;
        dArray2[(n + 1) * 2 - 1] = d6;
        return dArray2;
    }

    public static double[] linearizeArc(double d, double d2, double d3, double d4, double d5, double d6) {
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        double d7 = dArray[2] / 250.0;
        return JGeometry.linearizeArc(d, d2, d3, d4, d5, d6, d7, false);
    }

    public static double[] reFormulateArc(double[] dArray) {
        double[] dArray2 = JGeometry.computeArc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        if (dArray2 == null) {
            dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]};
            return dArray2;
        }
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        double d4 = -dArray2[3];
        double d5 = dArray2[4];
        double d6 = -dArray2[5];
        double d7 = -JGeometry.orientation(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        if (d7 > 0.0 && d6 < d4) {
            if ((d6 += Math.PI * 2) > Math.PI * 2) {
                d6 -= Math.PI * 2;
                d4 -= Math.PI * 2;
            }
        } else if (d7 < 0.0 && d6 > d4 && (d6 -= Math.PI * 2) < Math.PI * -2) {
            d6 += Math.PI * 2;
            d4 += Math.PI * 2;
        }
        double[] dArray3 = new double[]{d, d2, d3, d4, d5, d6};
        return dArray3;
    }

    protected static final double[] closeCoords(double[] dArray, int n) {
        int n2 = dArray.length / n - 1;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (dArray[0 + i] == dArray[n2 * n + i]) continue;
            bl = false;
        }
        if (bl) {
            return dArray;
        }
        double[] dArray2 = new double[dArray.length + n];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        ++n2;
        for (int i = 0; i < n; ++i) {
            dArray2[n2 * n + i] = dArray2[i];
        }
        return dArray2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.gtype);
        objectOutputStream.writeInt(this.linfo);
        objectOutputStream.writeInt(this.srid);
        objectOutputStream.writeDouble(this.x);
        objectOutputStream.writeDouble(this.y);
        objectOutputStream.writeDouble(this.z);
        objectOutputStream.writeObject(this.elemInfo);
        objectOutputStream.writeObject(this.ordinates);
        objectOutputStream.writeInt(this.dim);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.gtype = objectInputStream.readInt();
        this.linfo = objectInputStream.readInt();
        this.srid = objectInputStream.readInt();
        this.x = objectInputStream.readDouble();
        this.y = objectInputStream.readDouble();
        this.z = objectInputStream.readDouble();
        this.elemInfo = (int[])objectInputStream.readObject();
        this.ordinates = (double[])objectInputStream.readObject();
        this.dim = objectInputStream.readInt();
    }

    public long getSize() {
        return 40 + (this.elemInfo == null ? 0 : 4 * this.elemInfo.length) + (this.ordinates == null ? 0 : 8 * this.ordinates.length);
    }

    public String toString() {
        String string = "JGeometry (gtype=" + this.gtype + ", dim=" + this.dim + ", srid=" + this.srid;
        return string;
    }

    public String toStringFull() {
        int n;
        if (this == null) {
            return "NULL JGeometry";
        }
        String string = "JGeometry (gtype=" + this.gtype + ", dim=" + this.dim + ", srid=" + this.srid;
        if (this.isOptimizedPoint()) {
            string = string + ", Point=(";
            string = string + this.x + "," + this.y;
            if (this.dim > 2) {
                string = string + "," + this.z;
            }
            string = string + "))";
            return string;
        }
        string = string + ",  \n ElemInfo(";
        for (n = 0; n < this.elemInfo.length - 1; ++n) {
            string = string + this.elemInfo[n] + ",";
        }
        string = string + this.elemInfo[this.elemInfo.length - 1] + ")";
        string = string + ",  \n Ordinates(";
        for (n = 0; n < this.ordinates.length / this.dim; ++n) {
            for (int i = 0; i < this.dim; ++i) {
                string = string + this.ordinates[i + n * this.dim];
                if (i >= this.dim - 1) continue;
                string = string + ",";
            }
            string = string + "\n";
        }
        string = string + "))";
        return string;
    }

    public String toStringFull(int n) {
        int n2;
        if (this == null) {
            return "NULL JGeometry";
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        ((NumberFormat)decimalFormat).setMaximumFractionDigits(n);
        ((NumberFormat)decimalFormat).setMinimumFractionDigits(n);
        ((NumberFormat)decimalFormat).setGroupingUsed(false);
        String string = "JGeometry (gtype=" + this.gtype + ", dim=" + this.dim + ", srid=" + this.srid;
        if (this.isOptimizedPoint()) {
            String string2 = decimalFormat.format(this.x).toString();
            String string3 = decimalFormat.format(this.y).toString();
            string = string + ", Point=(";
            string = string + string2 + "," + string3;
            if (this.dim > 2) {
                string = string + "," + decimalFormat.format(this.z).toString();
            }
            string = string + "))";
            return string;
        }
        string = string + ",  \n ElemInfo(";
        for (n2 = 0; n2 < this.elemInfo.length - 1; ++n2) {
            string = string + this.elemInfo[n2] + ",";
        }
        string = string + this.elemInfo[this.elemInfo.length - 1] + ")";
        string = string + ",  \n Ordinates(";
        for (n2 = 0; n2 < this.ordinates.length / this.dim; ++n2) {
            for (int i = 0; i < this.dim; ++i) {
                double d = this.ordinates[i + n2 * this.dim];
                String string4 = decimalFormat.format(d).toString();
                string = string + string4;
                if (i >= this.dim - 1) continue;
                string = string + ",";
            }
            string = string + "\n";
        }
        string = string + "))";
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof JGeometry)) {
            return false;
        }
        JGeometry jGeometry = (JGeometry)object;
        return this.getType() == jGeometry.getType() && Arrays.equals(this.getPoint(), jGeometry.getPoint()) && Arrays.equals(this.getElemInfo(), jGeometry.getElemInfo()) && Arrays.equals(this.getOrdinatesArray(), jGeometry.getOrdinatesArray());
    }

    public static final JGeometry load(byte[] byArray) throws Exception {
        if (byArray == null || byArray.length < 8) {
            return null;
        }
        return SdoPickler.unpickle(byArray);
    }

    public static byte[] store(JGeometry jGeometry) throws Exception {
        return SdoPickler.pickle(jGeometry);
    }

    public static final STRUCT store(Connection connection, JGeometry jGeometry) throws Exception {
        Object[] objectArray = JGeometry.getOracleDescriptors(connection);
        return JGeometry.store(jGeometry, connection, objectArray);
    }

    public static final STRUCT store(Connection connection, JGeometry jGeometry, StructDescriptor structDescriptor) throws Exception {
        if (structDescriptor == null) {
            geomDesc = JGeometry.getGeomDescriptor(connection);
            return new STRUCT(geomDesc, SdoPickler.pickle(jGeometry), connection);
        }
        return new STRUCT(structDescriptor, SdoPickler.pickle(jGeometry), connection);
    }

    public static StructDescriptor getGeomDescriptor(Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)connection);
    }

    public static String byteArrayToHexString(byte[] byArray) {
        byte by = 0;
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            by = (byte)(byArray[i] & 0xF0);
            by = (byte)(by >>> 4);
            by = (byte)(by & 0xF);
            stringBuffer.append(stringArray[by]);
            by = (byte)(byArray[i] & 0xF);
            stringBuffer.append(stringArray[by]);
        }
        String string = new String(stringBuffer);
        return string;
    }

    public final JGeometry projectToLTP(double d, double d2) throws DataException {
        boolean bl;
        if (this.srid == 0) {
            return null;
        }
        Gc_trans gc_trans = new Gc_trans(d, d2);
        if (this.isOptimizedPoint()) {
            JGeometry jGeometry = new JGeometry(this.x, this.y, 0);
            double[] dArray = new double[3];
            dArray[0] = this.x;
            dArray[1] = this.y;
            boolean bl2 = this.lltogXYZ(dArray, gc_trans);
            double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[0], dArray[1], dArray[2]};
            double[] dArray3 = new double[3];
            bl2 = this.gxyzgmcenter(dArray3, dArray2, gc_trans);
            LT_transform lT_transform = new LT_transform(dArray3[0], dArray3[1], gc_trans);
            bl2 = this.ltxform(dArray, lT_transform);
            jGeometry.x = dArray[0];
            jGeometry.y = dArray[1];
            jGeometry.lttpH = lT_transform;
            jGeometry.gtransH = gc_trans;
            return jGeometry;
        }
        double[] dArray = new double[3 * (this.ordinates.length / 2)];
        double[] dArray4 = new double[3];
        for (int i = 0; i < dArray.length / 3; ++i) {
            dArray4[0] = this.ordinates[2 * i];
            dArray4[1] = this.ordinates[2 * i + 1];
            dArray4[2] = 0.0;
            bl = this.lltogXYZ(dArray4, gc_trans);
            dArray[i * 3] = dArray4[0];
            dArray[i * 3 + 1] = dArray4[1];
            dArray[i * 3 + 2] = dArray4[2];
        }
        double[] dArray5 = new double[6];
        dArray5[0] = dArray5[3] = dArray[0];
        dArray5[1] = dArray5[4] = dArray[1];
        dArray5[2] = dArray5[5] = dArray[2];
        for (int i = 0; i < dArray.length / 3; ++i) {
            if (dArray5[0] > dArray[i * 3]) {
                dArray5[0] = dArray[i * 3];
            }
            if (dArray5[1] > dArray[i * 3 + 1]) {
                dArray5[1] = dArray[i * 3 + 1];
            }
            if (dArray5[2] > dArray[i * 3 + 2]) {
                dArray5[2] = dArray[i * 3 + 2];
            }
            if (dArray5[3] < dArray[i * 3]) {
                dArray5[3] = dArray[i * 3];
            }
            if (dArray5[4] < dArray[i * 3 + 1]) {
                dArray5[4] = dArray[i * 3 + 1];
            }
            if (!(dArray5[5] < dArray[i * 3 + 2])) continue;
            dArray5[5] = dArray[i * 3 + 2];
        }
        double[] dArray6 = new double[3];
        bl = this.gxyzgmcenter(dArray6, dArray5, gc_trans);
        LT_transform lT_transform = new LT_transform(dArray6[0], dArray6[1], gc_trans);
        double[] dArray7 = new double[2 * (dArray.length / 3)];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < dArray.length / 3; ++i) {
            dArray4[0] = dArray[i * 3];
            dArray4[1] = dArray[i * 3 + 1];
            dArray4[2] = dArray[i * 3 + 2];
            bl = this.ltxform(dArray4, lT_transform);
            dArray7[2 * i] = dArray4[0];
            dArray7[2 * i + 1] = dArray4[1];
            if (dArray7[2 * i] < d6) {
                d6 = dArray7[2 * i];
            }
            if (dArray7[2 * i] > d4) {
                d4 = dArray7[2 * i];
            }
            if (dArray7[2 * i + 1] < d5) {
                d5 = dArray7[2 * i + 1];
            }
            if (!(dArray7[2 * i + 1] > d3)) continue;
            d3 = dArray7[2 * i + 1];
        }
        if (d4 - d6 > 1.274E7 || d3 - d5 > 1.274E7) {
            throw new DataException("Buffer Distance Too large for LTP");
        }
        JGeometry jGeometry = new JGeometry(this.gtype, 0, this.elemInfo, dArray7);
        jGeometry.lttpH = lT_transform;
        jGeometry.gtransH = gc_trans;
        return jGeometry;
    }

    public final JGeometry projectFromLTP() throws DataException {
        int n;
        if (this.isOptimizedPoint()) {
            JGeometry jGeometry = new JGeometry(this.x, this.y, this.gtransH.txsrid);
            double[] dArray = new double[]{this.x, this.y, 0.0};
            boolean bl = this.iltxform(dArray, this.lttpH, this.gtransH);
            bl = this.gXYZtoll(dArray, this.gtransH);
            jGeometry.x = dArray[0] / this.gtransH.unitfactor;
            jGeometry.y = dArray[1] / this.gtransH.unitfactor;
            jGeometry.setSRID(this.getSRID());
            return jGeometry;
        }
        double[] dArray = new double[this.ordinates.length];
        double[] dArray2 = new double[3];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.ordinates.length / 2; ++n) {
            if (this.ordinates[2 * n] < d4) {
                d4 = this.ordinates[2 * n];
            }
            if (this.ordinates[2 * n] > d2) {
                d2 = this.ordinates[2 * n];
            }
            if (this.ordinates[2 * n + 1] < d3) {
                d3 = this.ordinates[2 * n + 1];
            }
            if (!(this.ordinates[2 * n + 1] > d)) continue;
            d = this.ordinates[2 * n + 1];
        }
        if (d2 - d4 > 1.274E7 || d - d3 > 1.274E7) {
            throw new DataException("Buffer Distance Too large for LTP");
        }
        for (n = 0; n < this.ordinates.length / 2; ++n) {
            dArray2[0] = this.ordinates[2 * n];
            dArray2[1] = this.ordinates[2 * n + 1];
            dArray2[2] = 0.0;
            boolean bl = this.iltxform(dArray2, this.lttpH, this.gtransH);
            bl = this.gXYZtoll(dArray2, this.gtransH);
            dArray[2 * n] = dArray2[0] / this.gtransH.unitfactor;
            dArray[2 * n + 1] = dArray2[1] / this.gtransH.unitfactor;
        }
        JGeometry jGeometry = new JGeometry(this.gtype, this.getSRID(), this.elemInfo, dArray);
        return jGeometry;
    }

    public final JGeometry projectToGNM_longLat() throws DataException {
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = this.getMBR();
        double[] dArray2 = new double[dArray.length / 2];
        for (int i = 0; i < dArray.length / 2; ++i) {
            dArray2[i] = (dArray[i + dArray.length / 2] + dArray[i]) / 2.0;
        }
        d = Math.PI / 180 * dArray2[0];
        d2 = Math.PI / 180 * dArray2[1];
        if (this.getType() == 1) {
            d /= 2.0;
            d2 /= 2.0;
        }
        return this.projectToGNM_longLat(d, d2);
    }

    public final JGeometry projectToGNM_longLat(double d, double d2) throws DataException {
        double[] dArray;
        double[] dArray2;
        int[] nArray;
        JGeometry jGeometry = null;
        double d3 = 6378000.0;
        if (this.getElemInfo() == null) {
            nArray = new int[]{1, 1, 1};
        } else {
            nArray = new int[this.getElemInfo().length];
            for (int i = 0; i < this.getElemInfo().length; ++i) {
                nArray[i] = this.getElemInfo()[i];
            }
        }
        if (this.getOrdinatesArray() == null) {
            if (this.dim == 2) {
                dArray2 = new double[2];
                dArray = new double[]{this.x, this.y};
            } else {
                dArray2 = new double[3];
                dArray = new double[]{this.x, this.y, this.z};
            }
        } else {
            dArray2 = new double[this.getOrdinatesArray().length];
            dArray = new double[this.getOrdinatesArray().length];
            for (int i = 0; i < this.getOrdinatesArray().length; ++i) {
                dArray[i] = this.getOrdinatesArray()[i];
            }
        }
        int n = 0;
        double[] dArray3 = this.getMBR();
        for (int i = 0; i < dArray.length / (dArray3.length / 2); ++i) {
            double d4 = Math.PI / 180 * dArray[dArray3.length / 2 * i];
            double d5 = Math.PI / 180 * dArray[dArray3.length / 2 * i + 1];
            double d6 = 0.0;
            if (dArray3.length == 6) {
                d6 = dArray[dArray3.length / 2 * i + 2];
            }
            double d7 = Math.sin(d2) * Math.sin(d5) + Math.cos(d2) * Math.cos(d5) * Math.cos(d4 - d);
            double d8 = 0.0;
            double d9 = 0.0;
            if (Math.abs(d2 - 1.5707963267948966) <= 1.0E-16) {
                d8 = 1.0 / Math.tan(d5) * Math.sin(d4 - d);
                d9 = -1.0 / Math.tan(d5) * Math.cos(d4 - d);
            } else if (Math.abs(d2 - -1.5707963267948966) <= 1.0E-16) {
                d8 = -1.0 / Math.tan(d5) * Math.sin(d4 - d);
                d9 = 1.0 / Math.tan(d5) * Math.cos(d4 - d);
            } else if (Math.abs(d2) <= 1.0E-16) {
                d8 = Math.tan(d4 - d);
                d9 = Math.tan(d5) / Math.cos(d4 - d);
            } else {
                d8 = Math.cos(d5) * Math.sin(d4 - d) / d7;
                d9 = (Math.cos(d2) * Math.sin(d5) - Math.sin(d2) * Math.cos(d5) * Math.cos(d4 - d)) / d7;
            }
            dArray2[n] = d3 * d8;
            dArray2[++n] = d3 * d9;
            ++n;
            if (dArray3.length != 6) continue;
            dArray2[n] = d6;
            ++n;
        }
        jGeometry = new JGeometry(this.getType(), 0, nArray, dArray2);
        int n2 = this.dim;
        int n3 = this.linfo;
        jGeometry.dim = n2;
        jGeometry.linfo = n3;
        return jGeometry;
    }

    public final JGeometry projectFromGNM_longLat(double d, double d2) throws DataException {
        double[] dArray;
        double[] dArray2;
        int[] nArray;
        JGeometry jGeometry = null;
        double d3 = 6378000.0;
        if (this.getElemInfo() == null) {
            nArray = new int[]{1, 1, 1};
        } else {
            nArray = new int[this.getElemInfo().length];
            for (int i = 0; i < this.getElemInfo().length; ++i) {
                nArray[i] = this.getElemInfo()[i];
            }
        }
        if (this.getOrdinatesArray() == null) {
            if (this.dim == 2) {
                dArray2 = new double[2];
                dArray = new double[]{this.x, this.y};
            } else {
                dArray2 = new double[3];
                dArray = new double[]{this.x, this.y, this.z};
            }
        } else {
            dArray2 = new double[this.getOrdinatesArray().length];
            dArray = new double[this.getOrdinatesArray().length];
            for (int i = 0; i < this.getOrdinatesArray().length; ++i) {
                dArray[i] = this.getOrdinatesArray()[i];
            }
        }
        int n = 0;
        double[] dArray3 = this.getMBR();
        for (int i = 0; i < dArray.length / (dArray3.length / 2); ++i) {
            double d4 = dArray[dArray3.length / 2 * i] / d3;
            double d5 = dArray[dArray3.length / 2 * i + 1] / d3;
            double d6 = 0.0;
            if (dArray3.length == 6) {
                d6 = dArray[dArray3.length / 2 * i + 2];
            }
            double d7 = Math.sqrt(d4 * d4 + d5 * d5);
            double d8 = Math.atan2(d7, 1.0);
            double d9 = 0.0;
            d9 = d7 <= 1.0E-16 ? d2 : Math.asin(Math.cos(d8) * Math.sin(d2) + d5 * Math.sin(d8) * Math.cos(d2) / d7);
            double d10 = 0.0;
            d10 = Math.abs(d2 - 1.5707963267948966) <= 1.0E-16 ? d + Math.atan2(d4, -d5) : (Math.abs(d2 - -1.5707963267948966) <= 1.0E-16 ? d + Math.atan2(d4, d5) : d + Math.atan2(d4 * Math.sin(d8), d7 * Math.cos(d2) * Math.cos(d8) - d5 * Math.sin(d2) * Math.sin(d8)));
            dArray2[n] = 57.29577951308232 * d10;
            dArray2[++n] = 57.29577951308232 * d9;
            ++n;
            if (dArray3.length != 6) continue;
            dArray2[n] = d6;
            ++n;
        }
        jGeometry = new JGeometry(this.getType(), this.getSRID(), nArray, dArray2);
        int n2 = this.dim;
        int n3 = this.linfo;
        jGeometry.dim = n2;
        jGeometry.linfo = n3;
        return jGeometry;
    }

    public final JGeometry densifyArcs(double d) {
        return this.densifyArcs(d, false);
    }

    public JGeometry densifyArcs(double d, boolean bl) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        int n2 = this.dim * 1000 + this.linfo * 100 + this.gtype;
        if (this.isOptimizedPoint()) {
            return new JGeometry(this.x, this.y, this.srid);
        }
        if (this.isPoint() || this.isMultiPoint()) {
            return new JGeometry(this.gtype, this.srid, this.elemInfo, this.ordinates);
        }
        if (this.isCircle()) {
            double[] dArray = JGeometry.expandCircle(this.ordinates[0], this.ordinates[1], this.ordinates[this.dim], this.ordinates[this.dim + 1], this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            int[] nArray = new int[]{1, 1003, 1};
            double[] dArray2 = JGeometry.linearizeArc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], d, bl);
            for (int i = 0; i < dArray2.length; ++i) {
                arrayList2.add(new Double(dArray2[i]));
            }
            double[] dArray3 = JGeometry.linearizeArc(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9], d, bl);
            for (int i = 2; i < dArray3.length; ++i) {
                arrayList2.add(new Double(dArray3[i]));
            }
            double[] dArray4 = new double[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                dArray4[i] = (Double)arrayList2.get(i);
            }
            return new JGeometry(this.gtype, this.srid, nArray, dArray4);
        }
        ElementIterator elementIterator = new ElementIterator(this);
        block3: while (elementIterator.next()) {
            int n3 = elementIterator.ord_offset;
            if (elementIterator.isCompound && elementIterator.isFirstElemOfCompound || !elementIterator.isCompound) {
                arrayList.add(new Integer(arrayList2.size() + 1));
                n = elementIterator.original_etype;
                if (n == 4) {
                    n = 2;
                } else if (n == 1005) {
                    n = 1003;
                } else if (n == 2005) {
                    n = 2003;
                }
                arrayList.add(new Integer(n));
                if (elementIterator.eitpr == 3) {
                    arrayList.add(new Integer(1));
                } else {
                    arrayList.add(new Integer(1));
                }
            }
            for (n = 0; n < elementIterator.nCoord - 1; ++n) {
                if (elementIterator.eitpr == 1) {
                    arrayList2.add(new Double(this.ordinates[n3 + n * this.dim]));
                    arrayList2.add(new Double(this.ordinates[n3 + n * this.dim + 1]));
                    if (!(elementIterator.lastElem && n == elementIterator.nCoord - 2 || !elementIterator.isCompound && n == elementIterator.nCoord - 2) && (!elementIterator.isCompound || n != elementIterator.nCoord - 2 || elementIterator.nSubElement != 1)) continue;
                    arrayList2.add(new Double(this.ordinates[n3 + n * this.dim + 2]));
                    arrayList2.add(new Double(this.ordinates[n3 + n * this.dim + 3]));
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (n3 + n * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n3 + n * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n3 + n * this.dim)) / this.dim < 2) continue block3;
                    double[] dArray = JGeometry.linearizeArc(this.ordinates[n3 + n * this.dim], this.ordinates[n3 + n * this.dim + 1], this.ordinates[n3 + (n + 1) * this.dim], this.ordinates[n3 + (n + 1) * this.dim + 1], this.ordinates[n3 + (n + 2) * this.dim], this.ordinates[n3 + (n + 2) * this.dim + 1], d, bl);
                    for (int i = 0; i < dArray.length - 2; ++i) {
                        arrayList2.add(new Double(dArray[i]));
                    }
                    if (elementIterator.lastElem && n == elementIterator.nCoord - 3 || !elementIterator.isCompound && n == elementIterator.nCoord - 3 || elementIterator.isCompound && n == elementIterator.nCoord - 3 && elementIterator.nSubElement == 1) {
                        arrayList2.add(new Double(dArray[dArray.length - 2]));
                        arrayList2.add(new Double(dArray[dArray.length - 1]));
                    }
                    if (++n >= elementIterator.nCoord - 1 && elementIterator.top_etype != 3 && elementIterator.top_etype != 5) continue;
                }
                if (elementIterator.eitpr == 3) {
                    double d2 = this.ordinates[n3 + 0];
                    double d3 = this.ordinates[n3 + 1];
                    double d4 = this.ordinates[n3 + this.dim];
                    double d5 = this.ordinates[n3 + this.dim + 1];
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d3));
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d3));
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d3));
                    ++n;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n3 + n * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n3 + n * this.dim >= elementIterator.next_ord_offset - this.dim) continue block3;
                double[] dArray = JGeometry.expandCircle(this.ordinates[n3 + n * this.dim], this.ordinates[n3 + n * this.dim + 1], this.ordinates[n3 + (n + 1) * this.dim], this.ordinates[n3 + (n + 1) * this.dim + 1], this.ordinates[n3 + (n + 2) * this.dim], this.ordinates[n3 + (n + 2) * this.dim + 1]);
                int[] nArray = new int[]{1, 1003, 1};
                double[] dArray5 = JGeometry.linearizeArc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], d, bl);
                for (int i = 0; i < dArray5.length; ++i) {
                    arrayList2.add(new Double(dArray5[i]));
                }
                double[] dArray6 = JGeometry.linearizeArc(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9], d, bl);
                for (int i = 2; i < dArray6.length; ++i) {
                    arrayList2.add(new Double(dArray6[i]));
                }
                n += 2;
            }
        }
        double[] dArray = new double[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            dArray[n] = (Double)arrayList2.get(n);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return new JGeometry(this.gtype, this.srid, nArray, dArray);
    }

    private double[] simplify(double[] dArray, double d) {
        int n = dArray.length / this.dim;
        int[] nArray = new int[n];
        if (d <= 0.0 || dArray.length < 4) {
            double[] dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = dArray[i];
            }
            return dArray2;
        }
        int n2 = 0;
        int n3 = 0;
        nArray[n3++] = 0;
        int n4 = n - 1;
        nArray[n4] = n - 1;
        int n5 = 0;
        do {
            double d2;
            int n6;
            int n7;
            int n8 = nArray[n4];
            int n9 = 2 * n2;
            int n10 = 2 * n8;
            double d3 = dArray[n10] - dArray[n9];
            double d4 = dArray[n10 + 1] - dArray[n9 + 1];
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            double d6 = 0.0;
            if (d5 <= d) {
                for (n7 = n2 + 1; n7 < n8; ++n7) {
                    n6 = 2 * n7;
                    d3 = dArray[n6] - dArray[n9];
                    d4 = dArray[n6 + 1] - dArray[n9 + 1];
                    d2 = Math.sqrt(d3 * d3 + d4 * d4);
                    if (!(d2 >= d6)) continue;
                    d6 = d2;
                    n5 = n7;
                }
            } else if (Math.abs(d3) <= Math.abs(d4)) {
                double d7 = d3 / d4;
                double d8 = d7 * dArray[n9 + 1];
                for (n7 = n2 + 1; n7 < n8; ++n7) {
                    n6 = 2 * n7;
                    d2 = Math.abs(dArray[n6] - dArray[n9] + d8 - d7 * dArray[n6 + 1]);
                    if (!(d2 >= d6)) continue;
                    d6 = d2;
                    n5 = n7;
                }
                d6 = Math.abs(d6 * d4 / d5);
            } else {
                double d9 = d4 / d3;
                double d10 = d9 * dArray[n9];
                for (n7 = n2 + 1; n7 < n8; ++n7) {
                    n6 = 2 * n7;
                    d2 = Math.abs(dArray[n6 + 1] - dArray[n9 + 1] + d10 - d9 * dArray[n6]);
                    if (!(d2 >= d6)) continue;
                    d6 = d2;
                    n5 = n7;
                }
                d6 = Math.abs(d6 * d3 / d5);
            }
            if (d6 > d) {
                nArray[--n4] = n5;
                continue;
            }
            nArray[n3++] = n8;
            ++n4;
            n2 = n8;
        } while (n4 < n);
        double[] dArray3 = new double[n3 * 2];
        for (n4 = 0; n4 < n3; ++n4) {
            n2 = nArray[n4];
            dArray3[n4 * 2] = dArray[2 * n2];
            dArray3[n4 * 2 + 1] = dArray[2 * n2 + 1];
        }
        return dArray3;
    }

    public JGeometry simplify(double d, double d2, double d3) throws Exception, SQLException {
        if (d2 == 0.0 || d3 == 0.0) {
            return this.simplify(d);
        }
        JGeometry jGeometry = this.projectToLTP(d2, 1.0 / d3);
        JGeometry jGeometry2 = jGeometry.simplify(d);
        jGeometry2.lttpH = jGeometry.lttpH;
        jGeometry2.gtransH = jGeometry.gtransH;
        jGeometry2.setSRID(this.getSRID());
        return jGeometry2.projectFromLTP();
    }

    public final JGeometry simplify(double d) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.elemInfo.length / 3;
        double[][] dArrayArray = new double[n6][];
        for (n5 = 0; n5 < n6; ++n5) {
            int n7 = n5 == n6 - 1 ? this.ordinates.length - 2 : this.elemInfo[3 * (n5 + 1)] - 3;
            int n8 = this.elemInfo[3 * n5] - 1;
            double[] dArray = new double[n7 - n8 + 2];
            int n9 = 0;
            n4 = this.elemInfo[3 * n5] - 1;
            while (n4 <= n7) {
                dArray[2 * n9] = this.ordinates[n4];
                dArray[2 * n9 + 1] = this.ordinates[n4 + 1];
                n4 += 2;
                ++n9;
            }
            dArrayArray[n5] = this.simplify(dArray, d);
        }
        n5 = 0;
        for (int i = 0; i < n6; ++i) {
            if (this.elemInfo[3 * i + 1] == 1003 || this.elemInfo[3 * i + 1] == 2003) {
                if (dArrayArray[i].length == 4) {
                    n5 += 4;
                    continue;
                }
                if (dArrayArray[i].length == 6) {
                    n5 += 4;
                    continue;
                }
                n5 += dArrayArray[i].length;
                continue;
            }
            n5 += dArrayArray[i].length;
        }
        double[] dArray = new double[n5];
        int[] nArray = new int[3 * n6];
        n4 = 1;
        for (n3 = 0; n3 < n6; ++n3) {
            if (this.elemInfo[3 * n3 + 1] == 1003 || this.elemInfo[3 * n3 + 1] == 2003) {
                if (dArrayArray[n3].length == 4) {
                    nArray[3 * n3] = n4;
                    nArray[3 * n3 + 1] = 2;
                    nArray[3 * n3 + 2] = 1;
                    for (n2 = 0; n2 < 2; ++n2) {
                        dArray[n2 + n4 - 1] = dArrayArray[n3][n2];
                    }
                    dArray[(n4 += 2) - 1] = this.ordinates[this.elemInfo[3 * n3] + 1];
                    dArray[n4] = this.ordinates[this.elemInfo[3 * n3] + 2];
                    n4 += 2;
                    continue;
                }
                if (dArrayArray[n3].length == 6) {
                    nArray[3 * n3] = n4;
                    nArray[3 * n3 + 1] = 2;
                    nArray[3 * n3 + 2] = 1;
                    for (n2 = 0; n2 < 4; ++n2) {
                        dArray[n2 + n4 - 1] = dArrayArray[n3][n2];
                    }
                    n4 += 4;
                    continue;
                }
                nArray[3 * n3] = n4;
                nArray[3 * n3 + 1] = this.elemInfo[3 * n3 + 1];
                nArray[3 * n3 + 2] = 1;
                for (n2 = 0; n2 < dArrayArray[n3].length; ++n2) {
                    dArray[n2 + n4 - 1] = dArrayArray[n3][n2];
                }
                n4 += dArrayArray[n3].length;
                continue;
            }
            nArray[3 * n3] = n4;
            nArray[3 * n3 + 1] = this.elemInfo[3 * n3 + 1];
            nArray[3 * n3 + 2] = 1;
            for (n2 = 0; n2 < dArrayArray[n3].length; ++n2) {
                dArray[n2 + n4 - 1] = dArrayArray[n3][n2];
            }
            n4 += dArrayArray[n3].length;
        }
        n3 = 0;
        n2 = 0;
        int n10 = 0;
        for (n = 0; n < n6; ++n) {
            if (nArray[3 * n + 1] == 1003) {
                ++n2;
                continue;
            }
            if (nArray[3 * n + 1] == 2) {
                ++n10;
                continue;
            }
            ++n3;
        }
        n = 0;
        if (n2 > 0) {
            ++n;
        }
        if (n10 > 0) {
            ++n;
        }
        if (n3 > 0) {
            ++n;
        }
        int n11 = 2004;
        if (n > 1) {
            n11 = 2004;
        } else if (n2 == 1) {
            n11 = 2003;
        } else if (n2 > 1) {
            n11 = 2007;
        } else if (n10 == 1) {
            n11 = 2002;
        } else if (n10 > 1) {
            n11 = 2006;
        } else if (n3 == 1) {
            n11 = 2001;
        } else if (n3 > 1) {
            n11 = 2005;
        }
        return new JGeometry(n11, this.srid, nArray, dArray);
    }

    public JGeometry buffer(double d, double d2, double d3, double d4) throws Exception, SQLException {
        if (d2 == 0.0 || d3 == 0.0) {
            return this.buffer(d);
        }
        JGeometry jGeometry = this.projectToLTP(d2, 1.0 / d3);
        JGeometry jGeometry2 = jGeometry.buffer(d);
        JGeometry jGeometry3 = jGeometry2.densifyArcs(d4);
        jGeometry3.lttpH = jGeometry.lttpH;
        jGeometry3.gtransH = jGeometry.gtransH;
        jGeometry3.setSRID(this.getSRID());
        return jGeometry3.projectFromLTP();
    }

    public JGeometry buffer(double d) throws Exception, SQLException, DataException {
        int n;
        RTree rTree = null;
        RTree rTree2 = null;
        Sausage sausage3 = null;
        JGeometry jGeometry = null;
        boolean bl = false;
        if (d < 0.0) {
            throw new DataException("Invalid Buffer Size");
        }
        if (this.gtype == 4 || this.gtype == 5) {
            return null;
        }
        jGeometry = this.densifyArcs(d / 10.0, true);
        if (jGeometry.gtype == 1) {
            double[] dArray = jGeometry.getPoint();
            return JGeometry.createCircle(dArray[0], dArray[1], d, this.getSRID());
        }
        double d2 = 0.0;
        int n2 = jGeometry.elemInfo.length / 3;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = i == n2 - 1 ? jGeometry.ordinates.length - 2 : jGeometry.elemInfo[3 * (i + 1)] - 3;
            for (int j = jGeometry.elemInfo[3 * i] - 1; j < n; j += 2) {
                d2 += (jGeometry.ordinates[j + 2] - jGeometry.ordinates[j]) * (jGeometry.ordinates[j + 2] - jGeometry.ordinates[j]) + (jGeometry.ordinates[j + 3] - jGeometry.ordinates[j + 1]) * (jGeometry.ordinates[j + 3] - jGeometry.ordinates[j + 1]);
                ++n3;
            }
        }
        if (d < 0.001 * (d2 = Math.sqrt(d2 / (double)n3)) && jGeometry.ordinates.length > 50) {
            jGeometry = new JGeometry(this.gtype, this.srid, this.elemInfo, this.ordinates);
            return jGeometry;
        }
        Random random = new Random(13L);
        double d3 = d / 100.0;
        for (int i = 0; i < 10; ++i) {
            block51: {
                int n4;
                int n5;
                Object object;
                int n6;
                int n7;
                Object object2;
                Object object3;
                int n8;
                int n9;
                if (i == 1 && d > 10.0 * d2) {
                    jGeometry = jGeometry.simplify(d / 100.0);
                }
                ArrayList<Sausage> arrayList = null;
                ArrayList<Integer> arrayList2 = null;
                boolean bl2 = false;
                n3 = jGeometry.ordinates.length / 2 - 1;
                arrayList = new ArrayList<Sausage>(n3);
                arrayList2 = new ArrayList<Integer>();
                n2 = jGeometry.elemInfo.length / 3;
                boolean bl3 = false;
                int n10 = 0;
                for (n9 = 0; n9 < n2; ++n9) {
                    int n11 = n = n9 == n2 - 1 ? jGeometry.ordinates.length - 2 : jGeometry.elemInfo[3 * (n9 + 1)] - 3;
                    if (jGeometry.elemInfo[3 * n9 + 1] % 1000 == 3) {
                        bl3 = true;
                        bl2 = true;
                        arrayList2.ensureCapacity(arrayList2.size() + (n - jGeometry.elemInfo[3 * n9] + 1) / 2);
                    }
                    if (i > 1) {
                        int n12 = jGeometry.elemInfo[3 * n9] - 1;
                        jGeometry.ordinates[n12] = jGeometry.ordinates[n12] + d3 * (random.nextDouble() - 0.5);
                        int n13 = jGeometry.elemInfo[3 * n9];
                        jGeometry.ordinates[n13] = jGeometry.ordinates[n13] + d3 * (random.nextDouble() - 0.5);
                    }
                    for (int j = jGeometry.elemInfo[3 * n9] - 1; j < n; j += 2) {
                        if (i > 1) {
                            if (!bl3 || j + 2 < n) {
                                int n14 = j + 2;
                                jGeometry.ordinates[n14] = jGeometry.ordinates[n14] + d3 * (random.nextDouble() - 0.5);
                                int n15 = j + 3;
                                jGeometry.ordinates[n15] = jGeometry.ordinates[n15] + d3 * (random.nextDouble() - 0.5);
                            } else {
                                jGeometry.ordinates[j + 2] = jGeometry.ordinates[jGeometry.elemInfo[3 * n9] - 1];
                                jGeometry.ordinates[j + 3] = jGeometry.ordinates[jGeometry.elemInfo[3 * n9]];
                            }
                        }
                        arrayList.add(new Sausage(n10++, jGeometry.ordinates[j], jGeometry.ordinates[j + 1], jGeometry.ordinates[j + 2], jGeometry.ordinates[j + 3], d));
                        if (!bl3) continue;
                        arrayList2.add(new Integer(j));
                    }
                    bl3 = false;
                }
                if (arrayList == null) {
                    return null;
                }
                n9 = arrayList.size();
                double[][][] dArrayArray = new double[n9][][];
                Object[] objectArray = new Object[n9];
                Iterator iterator = arrayList.iterator();
                rTree = new RTree(2, 6, 1);
                int n16 = 0;
                while (iterator.hasNext()) {
                    sausage3 = (Sausage)iterator.next();
                    objectArray[n16] = sausage3;
                    dArrayArray[n16] = new double[2][2];
                    for (n8 = 0; n8 < 2; ++n8) {
                        for (int j = 0; j < 2; ++j) {
                            dArrayArray[n16][n8][j] = sausage3.mbr[n8][j];
                        }
                    }
                    ++n16;
                }
                rTree.packTree((double[][][])dArrayArray, objectArray);
                if (bl2) {
                    rTree2 = new RTree(1, 6, 1);
                    iterator = arrayList2.iterator();
                    n16 = 0;
                    Object var28_32 = null;
                    n9 = arrayList2.size();
                    dArrayArray = new double[n9][][];
                    objectArray = new Object[n9];
                    while (iterator.hasNext()) {
                        var28_32 = iterator.next();
                        n8 = var28_32;
                        dArrayArray[n16] = new double[1][2];
                        dArrayArray[n16][0][0] = Math.min(jGeometry.ordinates[n8], jGeometry.ordinates[n8 + 2]);
                        dArrayArray[n16][0][1] = Math.max(jGeometry.ordinates[n8], jGeometry.ordinates[n8 + 2]);
                        ++n16;
                    }
                    rTree2.packTree((double[][][])dArrayArray, objectArray);
                }
                ArrayList arrayList3 = new ArrayList(10);
                double[][] dArray = new double[2][2];
                Sausage sausage22 = null;
                Vertex vertex = null;
                Iterator iterator2 = null;
                JPoint2DD jPoint2DD = null;
                for (Sausage sausage3 : arrayList) {
                    for (int j = 0; j < 4; ++j) {
                        vertex = sausage3.skel[j];
                        JPoint2DD jPoint2DD2 = jPoint2DD = j == 0 || j == 3 ? sausage3.startPoint : sausage3.endPoint;
                        if (!this.insideSausagesOrPolys(vertex.x, vertex.y, sausage3, null, rTree2, rTree, jGeometry)) continue;
                        vertex.isInside = true;
                    }
                }
                if (bl) {
                    System.out.println("sausages at start");
                    this.printSausages(arrayList);
                }
                for (Sausage sausage3 : arrayList) {
                    arrayList3.clear();
                    rTree.search(sausage3.mbr, arrayList3);
                    for (Sausage sausage22 : arrayList3) {
                        if (sausage22.id <= sausage3.id || !sausage22.startPoint.equals(sausage3.startPoint) && !sausage22.startPoint.equals(sausage3.endPoint) && !sausage22.endPoint.equals(sausage3.endPoint) && !sausage22.endPoint.equals(sausage3.startPoint)) continue;
                        this.sausageJoinedIntersect(sausage3, sausage22, rTree2, rTree, jGeometry);
                    }
                }
                if (bl) {
                    System.out.println("sausages after joined intersect");
                    this.printSausages(arrayList);
                }
                for (Sausage sausage3 : arrayList) {
                    arrayList3.clear();
                    rTree.search(sausage3.mbr, arrayList3);
                    for (Sausage sausage22 : arrayList3) {
                        if (sausage22.id <= sausage3.id) continue;
                        this.sausageGeneralIntersect(sausage3, sausage22, rTree2, rTree, jGeometry);
                    }
                }
                if (bl) {
                    System.out.println("sausages after general intersect");
                    this.printSausages(arrayList);
                }
                Vertex vertex2 = null;
                Vertex vertex3 = null;
                ArrayList<Ring> arrayList4 = new ArrayList<Ring>(10);
                ArrayList<Ring> arrayList5 = new ArrayList<Ring>(10);
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                for (Sausage sausage3 : arrayList) {
                    vertex2 = sausage3.skel[0];
                    do {
                        if (vertex2.isUsed || vertex2.isInside && !vertex2.isStarterIntersection) continue;
                        if (vertex2.isStarterIntersection) {
                            vertex2.matchIntersection.isUsed = true;
                        }
                        vertex3 = vertex2;
                        boolean bl4 = true;
                        object3 = null;
                        object2 = null;
                        n7 = 0;
                        n6 = 0;
                        object = null;
                        int n20 = 0;
                        n5 = 0;
                        n4 = 0;
                        double d4 = 0.0;
                        do {
                            ++n20;
                            if (vertex3.isIntersection && !vertex3.isStarterIntersection) {
                                vertex3.isUsed = true;
                                vertex3 = vertex3.matchIntersection;
                            }
                            if (vertex3.isUsed) break block51;
                            n6 = vertex3 instanceof ArcVertex;
                            if (n6 != 0) {
                                ++n5;
                            }
                            if (!bl4 && n6 != n7) {
                                ++n4;
                            }
                            Object object4 = object3 = n6 != 0 ? new ArcVertex(vertex3.x, vertex3.y, ((ArcVertex)vertex3).center.x, ((ArcVertex)vertex3).center.y) : new Vertex(vertex3.x, vertex3.y);
                            if (bl4) {
                                object = object3;
                                bl4 = false;
                            } else {
                                ((Vertex)object2).next = object3;
                                d4 += ((Vertex)object2).x * ((Vertex)object3).y - ((Vertex)object2).y * ((Vertex)object3).x;
                            }
                            object2 = object3;
                            n7 = n6;
                            vertex3.isUsed = true;
                            vertex3 = vertex3.next;
                        } while (vertex3.x != vertex2.x || vertex3.y != vertex2.y);
                        ((Vertex)object2).next = object;
                        d4 += ((Vertex)object2).x * object.y - ((Vertex)object2).y * object.x;
                        Ring ring = new Ring((Vertex)object);
                        ring.numVertices = n20;
                        n17 += n20 + 1;
                        ring.numArcs = n5;
                        n18 += n5;
                        if (n4 > 0) {
                            // empty if block
                        }
                        ring.numSubElements = ++n4;
                        n19 += n4 + 1;
                        if (d4 > 0.0) {
                            arrayList4.add(ring);
                            continue;
                        }
                        arrayList5.add(ring);
                    } while ((vertex2 = vertex2.next) != sausage3.skel[0]);
                }
                Iterator iterator3 = arrayList5.iterator();
                object3 = null;
                object2 = (Ring)arrayList4.get(0);
                n7 = arrayList4.size();
                while (iterator3.hasNext()) {
                    object3 = (Ring)iterator3.next();
                    if (n7 > 1) {
                        for (n6 = 0; n6 < n7 && !((Ring)(object2 = (Ring)arrayList4.get(n6))).pointInside(((Ring)object3).startVertex.x, ((Ring)object3).startVertex.y); ++n6) {
                        }
                    }
                    ((Ring)object2).addHole((Ring)object3);
                }
                double[] dArray2 = new double[2 * (n17 + n18)];
                object = new int[3 * n19];
                Ring ring = null;
                n5 = -1;
                n4 = -1;
                for (int j = 0; j < n7; ++j) {
                    object2 = (Ring)arrayList4.get(j);
                    for (int k = -1; k < ((Ring)object2).holeList.size(); ++k) {
                        ring = k == -1 ? object2 : (Ring)((Ring)object2).holeList.get(k);
                        boolean bl5 = ring.numVertices != ring.numArcs && ring.numArcs != 0;
                        object[++n5] = n4 + 2;
                        object[++n5] = k == -1 ? (bl5 ? 1005 : 1003) : (bl5 ? 2005 : 2003);
                        object[++n5] = bl5 ? ring.numSubElements : 1;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        vertex2 = ring.startVertex;
                        do {
                            bl7 = vertex2 instanceof ArcVertex;
                            if (bl5 && (vertex2 == ring.startVertex || bl6 != bl7)) {
                                object[++n5] = n4 + 2;
                                object[++n5] = 2;
                                object[++n5] = bl7 ? 2 : 1;
                            }
                            dArray2[++n4] = vertex2.x;
                            dArray2[++n4] = vertex2.y;
                            if (bl7) {
                                ArcVertex arcVertex = (ArcVertex)vertex2;
                                double d5 = Math.abs(-Math.atan2(vertex2.y - arcVertex.center.y, vertex2.x - arcVertex.center.x) + Math.atan2(vertex2.next.y - arcVertex.center.y, vertex2.next.x - arcVertex.center.x));
                                if (d5 > Math.PI) {
                                    d5 = Math.PI * 2 - d5;
                                }
                                double d6 = Math.sin(d5 /= 2.0);
                                double d7 = Math.cos(d5);
                                double d8 = arcVertex.x - arcVertex.center.x;
                                double d9 = arcVertex.y - arcVertex.center.y;
                                dArray2[++n4] = arcVertex.center.x + d8 * d7 - d9 * d6;
                                dArray2[++n4] = arcVertex.center.y + d8 * d6 + d9 * d7;
                            }
                            bl6 = bl7;
                        } while ((vertex2 = vertex2.next) != ring.startVertex);
                        dArray2[++n4] = vertex2.x;
                        dArray2[++n4] = vertex2.y;
                    }
                }
                return new JGeometry(n7 > 1 ? 7 : 3, this.getSRID(), (int[])object, dArray2);
            }
            d = 1.01 * d;
        }
        return null;
    }

    protected void finalize() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JGeometry affineTransforms(boolean bl, double d, double d2, double d3, boolean bl2, JGeometry jGeometry, double d4, double d5, double d6, boolean bl3, JGeometry jGeometry2, JGeometry jGeometry3, double d7, int n, boolean bl4, double d8, double d9, double d10, double d11, double d12, double d13, boolean bl5, JGeometry jGeometry4, JGeometry jGeometry5, int n2, boolean bl6, double[] dArray, double[] dArray2) throws Exception {
        double[][] dArray3;
        double d14;
        double[] dArray4;
        double[] dArray5;
        int n3;
        int n4;
        int n5;
        double d15 = 1.0E-16;
        JGeometry jGeometry6 = null;
        int n6 = 0;
        JGeometry jGeometry7 = null;
        JGeometry jGeometry8 = null;
        JGeometry jGeometry9 = null;
        if (this.dim == 4) {
            n5 = 3;
            if (!this.isLRSGeometry()) throw new Exception("Affinetransform cannot be performed for this gtype");
            n6 = this.isOrientedMultiPoint() || this.isOrientedPoint() ? 4 : 1;
        } else if (this.dim == 3) {
            n5 = 3;
            if (this.isLRSGeometry()) {
                n5 = 2;
                n6 = this.isOrientedMultiPoint() || this.isOrientedPoint() ? 3 : 1;
            } else {
                n6 = this.isOrientedMultiPoint() || this.isOrientedPoint() ? 3 : 0;
            }
        } else {
            if (this.dim != 2) throw new Exception("Affinetransform cannot be performed for this gtype");
            n5 = 2;
            n6 = this.isOrientedMultiPoint() || this.isOrientedPoint() ? 2 : 0;
        }
        int[] nArray = new int[]{1, 1, 1};
        double[] dArray6 = null;
        if (jGeometry != null) {
            if (n5 == 2) {
                if (jGeometry.dim == 3) throw new Exception("Invalid parameter for affine transform");
            }
            if (n5 == 3 && jGeometry.dim == 2) {
                throw new Exception("Invalid parameter for affine transform");
            }
            if (jGeometry.elemInfo == null && jGeometry.ordinates == null) {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry.x, jGeometry.y};
                } else if (n5 == 3) {
                    dArray6 = new double[]{jGeometry.x, jGeometry.y, jGeometry.z};
                }
                jGeometry7 = new JGeometry(jGeometry.getType(), jGeometry.getSRID(), nArray, dArray6);
                jGeometry7.dim = jGeometry.dim;
            } else {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry.ordinates[0], jGeometry.ordinates[1]};
                }
                if (n5 == 3) {
                    dArray6 = new double[]{jGeometry.ordinates[0], jGeometry.ordinates[1], jGeometry.ordinates[2]};
                }
                jGeometry7 = new JGeometry(jGeometry.getType(), jGeometry.getSRID(), nArray, dArray6);
                jGeometry7.dim = jGeometry.dim;
            }
        }
        if (jGeometry2 != null) {
            if (jGeometry2.getType() != 1) throw new Exception("Invalid parameter for affine transform");
            if (jGeometry3 != null) {
                throw new Exception("Invalid parameter for affine transform");
            }
            if (jGeometry2.elemInfo == null && jGeometry2.ordinates == null) {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry2.x, jGeometry2.y};
                } else if (n5 == 3) {
                    return this.affineTransforms(false, 0.0, 0.0, 0.0, false, null, 0.0, 0.0, 0.0, true, null, new JGeometry(3002, 0, new int[]{1, 2, 1}, new double[]{jGeometry2.x, jGeometry2.y, 1.0, jGeometry2.x, jGeometry2.y, 0.0}), d7, -1, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, null, null, 0, false, null, null);
                }
                jGeometry8 = new JGeometry(jGeometry2.getType(), jGeometry2.getSRID(), nArray, dArray6);
                jGeometry8.dim = jGeometry2.dim;
            } else {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry2.ordinates[0], jGeometry2.ordinates[1]};
                }
                if (n5 == 3) {
                    return this.affineTransforms(false, 0.0, 0.0, 0.0, false, null, 0.0, 0.0, 0.0, true, null, new JGeometry(3002, 0, new int[]{1, 2, 1}, new double[]{jGeometry2.ordinates[0], jGeometry2.ordinates[1], 1.0, jGeometry2.ordinates[0], jGeometry2.ordinates[1], 0.0}), d7, -1, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, null, null, 0, false, null, null);
                }
                jGeometry8 = new JGeometry(jGeometry2.getType(), jGeometry2.getSRID(), nArray, dArray6);
                jGeometry8.dim = jGeometry2.dim;
            }
        }
        if (jGeometry4 != null) {
            if (n5 == 2) {
                if (jGeometry4.dim == 3) throw new Exception("Invalid parameter for affine transform");
            }
            if (n5 == 3 && jGeometry4.dim == 2) {
                throw new Exception("Invalid parameter for affine transform");
            }
            if (jGeometry4.elemInfo == null && jGeometry4.ordinates == null) {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry4.x, jGeometry4.y};
                } else if (n5 == 3) {
                    dArray6 = new double[]{jGeometry4.x, jGeometry4.y, jGeometry4.z};
                }
                jGeometry9 = new JGeometry(jGeometry4.getType(), jGeometry4.getSRID(), nArray, dArray6);
                jGeometry9.dim = jGeometry4.dim;
            } else {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry4.ordinates[0], jGeometry4.ordinates[1]};
                }
                if (n5 == 3) {
                    dArray6 = new double[]{jGeometry4.ordinates[0], jGeometry4.ordinates[1], jGeometry4.ordinates[2]};
                }
                jGeometry9 = new JGeometry(jGeometry4.getType(), jGeometry4.getSRID(), nArray, dArray6);
                jGeometry9.dim = jGeometry4.dim;
            }
        }
        double[][] dArray7 = new double[n5 + 1][n5 + 1];
        double[][] dArray8 = new double[n5 + 1][n5 + 1];
        double[][] dArray9 = new double[n5 + 1][n5 + 1];
        double[][] dArray10 = new double[n5 + 1][n5 + 1];
        double[][] dArray11 = new double[n5 + 1][n5 + 1];
        double[][] dArray12 = new double[n5 + 1][n5 + 1];
        for (n4 = 0; n4 < n5 + 1; ++n4) {
            for (n3 = 0; n3 < n5 + 1; ++n3) {
                if (n4 == n3) {
                    dArray7[n4][n3] = 1.0;
                    dArray8[n4][n3] = 1.0;
                    dArray9[n4][n3] = 1.0;
                    dArray10[n4][n3] = 1.0;
                    dArray11[n4][n3] = 1.0;
                    dArray12[n4][n3] = 1.0;
                    continue;
                }
                dArray7[n4][n3] = 0.0;
                dArray8[n4][n3] = 0.0;
                dArray9[n4][n3] = 0.0;
                dArray10[n4][n3] = 0.0;
                dArray11[n4][n3] = 0.0;
                dArray12[n4][n3] = 0.0;
            }
        }
        if (n5 == 3) {
            double d16;
            if (bl) {
                dArray7 = JGeometry.translation(n5, d, d2, d3);
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray7);
            if (bl2) {
                if (jGeometry == null) throw new Exception("Invalid parameter for affine transform");
                if (jGeometry.dim != 3) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                dArray8 = JGeometry.translation(n5, jGeometry7.ordinates[0], jGeometry7.ordinates[1], jGeometry7.ordinates[2]);
                double[][] dArray13 = new double[n5 + 1][n5 + 1];
                for (n4 = 0; n4 < n5 + 1; ++n4) {
                    for (n3 = 0; n3 < n5 + 1; ++n3) {
                        dArray13[n4][n3] = n4 == n3 ? 1.0 : 0.0;
                    }
                }
                dArray13[0][0] = d4;
                dArray13[1][1] = d5;
                dArray13[2][2] = d6;
                dArray8 = JGeometry.matrixMatrixMult(dArray8, dArray13);
                dArray8 = JGeometry.matrixMatrixMult(dArray8, JGeometry.translation(n5, -jGeometry7.ordinates[0], -jGeometry7.ordinates[1], -jGeometry7.ordinates[2]));
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray8);
            if (bl3) {
                if (jGeometry2 != null) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                if (jGeometry3 == null) {
                    if (n == 0) {
                        dArray9[1][1] = Math.cos(d7);
                        dArray9[1][2] = -Math.sin(d7);
                        dArray9[2][1] = Math.sin(d7);
                        dArray9[2][2] = Math.cos(d7);
                    } else if (n == 1) {
                        dArray9[0][0] = Math.cos(d7);
                        dArray9[0][2] = Math.sin(d7);
                        dArray9[2][0] = -Math.sin(d7);
                        dArray9[2][2] = Math.cos(d7);
                    } else if (n == 2) {
                        dArray9[0][0] = Math.cos(d7);
                        dArray9[0][1] = -Math.sin(d7);
                        dArray9[1][0] = Math.sin(d7);
                        dArray9[1][1] = Math.cos(d7);
                    } else {
                        System.out.println("Error: Rotation variable dir has to be 0,1 or 2");
                    }
                } else {
                    if (jGeometry3.dim != 3) throw new Exception("Invalid parameter for affine transform");
                    if (jGeometry3.getType() != 2) throw new Exception("Invalid parameter for affine transform");
                    if (n == 0) throw new Exception("Invalid parameter for affine transform");
                    if (n == 1) throw new Exception("Invalid parameter for affine transform");
                    if (n == 2) {
                        throw new Exception("Invalid parameter for affine transform");
                    }
                    double[][] dArray14 = new double[n5 + 1][n5 + 1];
                    dArray5 = new double[n5];
                    dArray4 = new double[n5];
                    dArray5[0] = jGeometry3.ordinates[3] - jGeometry3.ordinates[0];
                    dArray5[1] = jGeometry3.ordinates[4] - jGeometry3.ordinates[1];
                    dArray5[2] = jGeometry3.ordinates[5] - jGeometry3.ordinates[2];
                    d14 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2]);
                    dArray4[0] = dArray5[0] / d14;
                    dArray4[1] = dArray5[1] / d14;
                    dArray4[2] = dArray5[2] / d14;
                    dArray9 = JGeometry.matrixMatrixMult(dArray9, JGeometry.translation(n5, -jGeometry3.ordinates[0], -jGeometry3.ordinates[1], -jGeometry3.ordinates[2]));
                    d16 = Math.sqrt(dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]);
                    double[][] dArray15 = new double[n5 + 1][n5 + 1];
                    double[][] dArray16 = new double[n5 + 1][n5 + 1];
                    double[][] dArray17 = new double[n5 + 1][n5 + 1];
                    double[][] dArray18 = new double[n5 + 1][n5 + 1];
                    double[][] dArray19 = new double[n5 + 1][n5 + 1];
                    double[][] dArray20 = new double[n5 + 1][n5 + 1];
                    for (n4 = 0; n4 < n5 + 1; ++n4) {
                        for (n3 = 0; n3 < n5 + 1; ++n3) {
                            if (n4 == n3) {
                                dArray15[n4][n3] = 1.0;
                                dArray16[n4][n3] = 1.0;
                                dArray17[n4][n3] = 1.0;
                                dArray18[n4][n3] = 1.0;
                                dArray19[n4][n3] = 1.0;
                                dArray20[n4][n3] = 1.0;
                                continue;
                            }
                            dArray15[n4][n3] = 0.0;
                            dArray16[n4][n3] = 0.0;
                            dArray17[n4][n3] = 0.0;
                            dArray18[n4][n3] = 0.0;
                            dArray19[n4][n3] = 0.0;
                            dArray20[n4][n3] = 0.0;
                        }
                    }
                    if (Math.abs(d16) > d15) {
                        dArray15[1][1] = dArray4[2] / d16;
                        dArray15[2][1] = dArray4[1] / d16;
                        dArray15[1][2] = -dArray4[1] / d16;
                        dArray15[2][2] = dArray4[2] / d16;
                    }
                    dArray9 = JGeometry.matrixMatrixMult(dArray15, dArray9);
                    dArray16[0][0] = d16;
                    dArray16[0][2] = -dArray4[0];
                    dArray16[2][0] = dArray4[0];
                    dArray16[2][2] = d16;
                    dArray9 = JGeometry.matrixMatrixMult(dArray16, dArray9);
                    dArray17[0][0] = Math.cos(d7);
                    dArray17[0][1] = Math.sin(d7);
                    dArray17[1][0] = -Math.sin(d7);
                    dArray17[1][1] = Math.cos(d7);
                    dArray9 = JGeometry.matrixMatrixMult(dArray17, dArray9);
                    dArray19[0][0] = d16;
                    dArray19[0][2] = dArray4[0];
                    dArray19[2][0] = -dArray4[0];
                    dArray19[2][2] = d16;
                    dArray9 = JGeometry.matrixMatrixMult(dArray19, dArray9);
                    if (Math.abs(d16) > d15) {
                        dArray18[1][1] = dArray4[2] / d16;
                        dArray18[2][1] = -dArray4[1] / d16;
                        dArray18[1][2] = dArray4[1] / d16;
                        dArray18[2][2] = dArray4[2] / d16;
                    }
                    dArray9 = JGeometry.matrixMatrixMult(dArray18, dArray9);
                    double[][] dArray21 = JGeometry.translation(n5, jGeometry3.ordinates[0], jGeometry3.ordinates[1], jGeometry3.ordinates[2]);
                    dArray9 = JGeometry.matrixMatrixMult(dArray21, dArray9);
                }
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray9);
            if (bl4) {
                dArray10[0][1] = d8;
                dArray10[0][2] = d10;
                dArray10[1][0] = d9;
                dArray10[1][2] = d12;
                dArray10[2][0] = d11;
                dArray10[2][1] = d13;
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray10);
            if (bl5) {
                if (jGeometry5 == null) {
                    if (n2 == 0) {
                        dArray11[0][0] = -1.0;
                        if (bl6) throw new Exception("Invalid parameter for affine transform");
                        if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray2 != null) throw new Exception("Invalid parameter for affine transform");
                        if (jGeometry4 != null) {
                            throw new Exception("Invalid parameter for affine transform");
                        }
                    } else if (n2 == 1) {
                        dArray11[1][1] = -1.0;
                        if (bl6) throw new Exception("Invalid parameter for affine transform");
                        if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray2 != null) throw new Exception("Invalid parameter for affine transform");
                        if (jGeometry4 != null) {
                            throw new Exception("Invalid parameter for affine transform");
                        }
                    } else if (n2 == 2) {
                        dArray11[2][2] = -1.0;
                        if (bl6) throw new Exception("Invalid parameter for affine transform");
                        if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray2 != null) throw new Exception("Invalid parameter for affine transform");
                        if (jGeometry4 != null) {
                            throw new Exception("Invalid parameter for affine transform");
                        }
                    } else if (bl6) {
                        if (jGeometry4 != null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray == null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray2 == null) {
                            throw new Exception("Invalid parameter for affine transform");
                        }
                        double[] dArray22 = new double[n5];
                        dArray5 = new double[n5];
                        dArray4 = new double[n5];
                        dArray5[0] = 0.0;
                        dArray5[1] = 0.0;
                        dArray5[2] = 1.0;
                        dArray4[0] = 1.0;
                        dArray4[1] = 0.0;
                        dArray4[2] = 0.0;
                        d14 = dArray5[0] * dArray[0] + dArray5[1] * dArray[1] + dArray5[2] * dArray[2];
                        if (d14 < d15) {
                            d16 = dArray4[0] * dArray[0] + dArray4[1] * dArray[1] + dArray4[2] * dArray[2];
                            if (d16 < d15) {
                                dArray22[0] = 0.0;
                                dArray22[1] = -dArray2[0] / dArray[1];
                                dArray22[2] = 0.0;
                            } else {
                                dArray22[0] = -dArray2[0] / dArray[0];
                                dArray22[1] = 0.0;
                                dArray22[2] = 0.0;
                            }
                        } else {
                            dArray22[0] = 0.0;
                            dArray22[1] = 0.0;
                            dArray22[2] = -dArray2[0] / dArray[2];
                        }
                        double[][] dArray23 = new double[n5][n5];
                        for (n4 = 0; n4 < n5; ++n4) {
                            for (n3 = 0; n3 < n5; ++n3) {
                                dArray23[n4][n3] = dArray[n4] * dArray[n3];
                            }
                        }
                        dArray3 = new double[n5][n5];
                        for (n4 = 0; n4 < n5; ++n4) {
                            for (n3 = 0; n3 < n5; ++n3) {
                                dArray3[n4][n3] = n4 == n3 ? 1.0 - 2.0 * dArray23[n4][n3] : -2.0 * dArray23[n4][n3];
                            }
                        }
                        double[] dArray25 = new double[n5];
                        dArray25 = JGeometry.matvecMult(dArray23, dArray22);
                        for (n4 = 0; n4 < n5; ++n4) {
                            dArray25[n4] = 2.0 * dArray25[n4];
                        }
                        for (n4 = 0; n4 < n5; ++n4) {
                            for (n3 = 0; n3 < n5; ++n3) {
                                dArray11[n4][n3] = dArray3[n4][n3];
                            }
                        }
                        for (n4 = 0; n4 < n5; ++n4) {
                            dArray11[n4][n5] = dArray25[n4];
                        }
                    } else {
                        if (jGeometry4 == null) throw new Exception("Invalid parameter for affine transform");
                        if (jGeometry4.dim != 3) throw new Exception("Invalid parameter for affine transform");
                        if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray2 != null) {
                            throw new Exception("Invalid parameter for affine transform");
                        }
                        dArray11 = JGeometry.translation(n5, -jGeometry9.ordinates[0], -jGeometry9.ordinates[1], -jGeometry9.ordinates[2]);
                        double[][] dArray26 = new double[n5 + 1][n5 + 1];
                        for (n4 = 0; n4 < n5 + 1; ++n4) {
                            for (n3 = 0; n3 < n5 + 1; ++n3) {
                                dArray26[n4][n3] = n4 == n3 ? -1.0 : 0.0;
                            }
                        }
                        dArray26[n5][n5] = 1.0;
                        dArray11 = JGeometry.matrixMatrixMult(dArray26, dArray11);
                        dArray11 = JGeometry.matrixMatrixMult(JGeometry.translation(n5, jGeometry9.ordinates[0], jGeometry9.ordinates[1], jGeometry9.ordinates[2]), dArray11);
                    }
                } else {
                    if (jGeometry5.dim != 3) throw new Exception("Invalid parameter for affine transform");
                    if (n2 == 0) throw new Exception("Invalid parameter for affine transform");
                    if (n2 == 1) throw new Exception("Invalid parameter for affine transform");
                    if (n2 == 2) throw new Exception("Invalid parameter for affine transform");
                    if (bl6) throw new Exception("Invalid parameter for affine transform");
                    if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                    if (dArray2 != null) throw new Exception("Invalid parameter for affine transform");
                    if (jGeometry4 != null) {
                        throw new Exception("Invalid parameter for affine transform");
                    }
                    double[] dArray27 = new double[n5];
                    dArray27[0] = jGeometry5.ordinates[0];
                    dArray27[1] = jGeometry5.ordinates[1];
                    dArray27[2] = jGeometry5.ordinates[2];
                    dArray5 = new double[n5];
                    dArray4 = new double[n5];
                    dArray5[0] = jGeometry5.ordinates[3] - jGeometry5.ordinates[0];
                    dArray5[1] = jGeometry5.ordinates[4] - jGeometry5.ordinates[1];
                    dArray5[2] = jGeometry5.ordinates[5] - jGeometry5.ordinates[2];
                    d14 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2]);
                    dArray4[0] = dArray5[0] / d14;
                    dArray4[1] = dArray5[1] / d14;
                    dArray4[2] = dArray5[2] / d14;
                    double[][] dArray28 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray28[n4][n3] = dArray4[n4] * dArray4[n3];
                        }
                    }
                    dArray3 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray3[n4][n3] = n4 == n3 ? -1.0 + 2.0 * dArray28[n4][n3] : 2.0 * dArray28[n4][n3];
                        }
                    }
                    double[][] dArray29 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray29[n4][n3] = n4 == n3 ? 2.0 - 2.0 * dArray28[n4][n3] : -2.0 * dArray28[n4][n3];
                        }
                    }
                    double[] dArray31 = new double[n5];
                    dArray31 = JGeometry.matvecMult(dArray29, dArray27);
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray11[n4][n3] = dArray3[n4][n3];
                        }
                    }
                    for (n4 = 0; n4 < n5; ++n4) {
                        dArray11[n4][n5] = dArray31[n4];
                    }
                }
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray11);
        } else {
            if (bl) {
                if (Math.abs(d3) > d15) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                dArray7 = JGeometry.translation(n5, d, d2, 0.0);
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray7);
            if (bl2) {
                if (jGeometry == null) throw new Exception("Invalid parameter for affine transform");
                if (jGeometry7.dim != 2) throw new Exception("Invalid parameter for affine transform");
                if (Math.abs(d6) > d15) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                dArray8 = JGeometry.translation(n5, jGeometry7.ordinates[0], jGeometry7.ordinates[1], 0.0);
                double[][] dArray32 = new double[n5 + 1][n5 + 1];
                for (n4 = 0; n4 < n5 + 1; ++n4) {
                    for (n3 = 0; n3 < n5 + 1; ++n3) {
                        dArray32[n4][n3] = n4 == n3 ? 1.0 : 0.0;
                    }
                }
                dArray32[0][0] = d4;
                dArray32[1][1] = d5;
                dArray8 = JGeometry.matrixMatrixMult(dArray8, dArray32);
                dArray8 = JGeometry.matrixMatrixMult(dArray8, JGeometry.translation(n5, -jGeometry7.ordinates[0], -jGeometry7.ordinates[1], 0.0));
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray8);
            if (bl3) {
                if (jGeometry2 == null) throw new Exception("Invalid parameter for affine transform");
                if (jGeometry3 != null) throw new Exception("Invalid parameter for affine transform");
                if (n == 0) throw new Exception("Invalid parameter for affine transform");
                if (n == 1) throw new Exception("Invalid parameter for affine transform");
                if (n == 2) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                dArray9 = JGeometry.translation(n5, jGeometry8.ordinates[0], jGeometry8.ordinates[1], 0.0);
                double[][] dArray33 = new double[n5 + 1][n5 + 1];
                for (n4 = 0; n4 < n5 + 1; ++n4) {
                    for (n3 = 0; n3 < n5 + 1; ++n3) {
                        dArray33[n4][n3] = n4 == n3 ? 1.0 : 0.0;
                    }
                }
                dArray33[0][0] = Math.cos(d7);
                dArray33[0][1] = -Math.sin(d7);
                dArray33[1][0] = Math.sin(d7);
                dArray33[1][1] = Math.cos(d7);
                dArray9 = JGeometry.matrixMatrixMult(dArray9, dArray33);
                dArray9 = JGeometry.matrixMatrixMult(dArray9, JGeometry.translation(n5, -jGeometry8.ordinates[0], -jGeometry8.ordinates[1], 0.0));
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray9);
            if (bl4) {
                if (Math.abs(d10) > d15) throw new Exception("Invalid parameter for affine transform");
                if (Math.abs(d11) > d15) throw new Exception("Invalid parameter for affine transform");
                if (Math.abs(d12) > d15) throw new Exception("Invalid parameter for affine transform");
                if (Math.abs(d13) > d15) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                dArray10[0][1] = d8;
                dArray10[1][0] = d9;
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray10);
            if (bl5) {
                if (n2 == 0) throw new Exception("Invalid parameter for affine transform");
                if (n2 == 1) throw new Exception("Invalid parameter for affine transform");
                if (n2 == 2) throw new Exception("Invalid parameter for affine transform");
                if (bl6) throw new Exception("Invalid parameter for affine transform");
                if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                if (dArray2 != null) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                if (jGeometry5 == null) {
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray11[n4][n3] = n4 == n3 ? -1.0 : 0.0;
                        }
                    }
                    dArray11[0][2] = 2.0 * jGeometry9.ordinates[0];
                    dArray11[1][2] = 2.0 * jGeometry9.ordinates[1];
                    dArray11[2][2] = 1.0;
                } else {
                    if (jGeometry5.dim == 3) throw new Exception("Invalid parameter for affine transform");
                    if (jGeometry4 != null) {
                        throw new Exception("Invalid parameter for affine transform");
                    }
                    double[] dArray34 = new double[n5];
                    dArray34[0] = jGeometry5.ordinates[0];
                    dArray34[1] = jGeometry5.ordinates[1];
                    dArray5 = new double[n5];
                    dArray4 = new double[n5];
                    dArray5[0] = jGeometry5.ordinates[2] - jGeometry5.ordinates[0];
                    dArray5[1] = jGeometry5.ordinates[3] - jGeometry5.ordinates[1];
                    d14 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1]);
                    dArray4[0] = dArray5[0] / d14;
                    dArray4[1] = dArray5[1] / d14;
                    double[][] dArray35 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray35[n4][n3] = dArray4[n4] * dArray4[n3];
                        }
                    }
                    dArray3 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray3[n4][n3] = n4 == n3 ? -1.0 + 2.0 * dArray35[n4][n3] : 2.0 * dArray35[n4][n3];
                        }
                    }
                    double[][] dArray36 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray36[n4][n3] = n4 == n3 ? 2.0 - 2.0 * dArray35[n4][n3] : -2.0 * dArray35[n4][n3];
                        }
                    }
                    double[] dArray38 = new double[n5];
                    dArray38 = JGeometry.matvecMult(dArray36, dArray34);
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray11[n4][n3] = dArray3[n4][n3];
                        }
                    }
                    for (n4 = 0; n4 < n5; ++n4) {
                        dArray11[n4][n5] = dArray38[n4];
                    }
                }
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray11);
        }
        if (this.elemInfo != null && this.ordinates != null) {
            int n7 = this.getType();
            int n8 = this.getSRID();
            int n9 = this.dim;
            int n10 = this.linfo;
            int[] nArray2 = new int[this.elemInfo.length];
            System.arraycopy(this.elemInfo, 0, nArray2, 0, this.elemInfo.length);
            double[] dArray39 = new double[this.ordinates.length];
            System.arraycopy(this.ordinates, 0, dArray39, 0, this.ordinates.length);
            jGeometry6 = new JGeometry(n7, n8, nArray2, dArray39);
            jGeometry6.dim = n9;
            jGeometry6.linfo = n10;
            n4 = 0;
            while (n4 < this.ordinates.length / (n5 + n6)) {
                double[] dArray40 = new double[n5 + 1];
                double[] dArray41 = new double[n5 + 1];
                for (n3 = 0; n3 < n5; ++n3) {
                    dArray40[n3] = this.ordinates[(n5 + n6) * n4 + n3];
                }
                dArray40[n5] = 1.0;
                dArray41 = JGeometry.matvecMult(dArray12, dArray40);
                for (n3 = 0; n3 < n5; ++n3) {
                    jGeometry6.ordinates[(n5 + n6) * n4 + n3] = dArray41[n3];
                }
                ++n4;
            }
            return jGeometry6;
        }
        double[] dArray42 = new double[n5 + 1];
        dArray5 = new double[n5 + 1];
        dArray42[0] = this.x;
        dArray42[1] = this.y;
        if (n5 == 3) {
            dArray42[2] = this.z;
        }
        dArray42[n5] = 1.0;
        dArray5 = JGeometry.matvecMult(dArray12, dArray42);
        if (n5 == 2) {
            return new JGeometry(dArray5[0], dArray5[1], this.getSRID());
        }
        if (n5 != 3) return jGeometry6;
        return new JGeometry(dArray5[0], dArray5[1], dArray5[2], this.getSRID());
    }

    private static double[][] translation(int n, double d, double d2, double d3) {
        double[][] dArray = new double[n + 1][n + 1];
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                dArray[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        dArray[0][n] = d;
        dArray[1][n] = d2;
        if (n == 3) {
            dArray[2][n] = d3;
        }
        return dArray;
    }

    private static double[][] matrixMatrixMult(double[][] dArray, double[][] dArray2) {
        int n;
        int n2;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        int n5 = dArray2[0].length;
        double[][] dArray3 = new double[n3][n5];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                dArray3[n2][n] = 0.0;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                for (int i = 0; i < n4; ++i) {
                    double[] dArray4 = dArray3[n2];
                    int n6 = n;
                    dArray4[n6] = dArray4[n6] + dArray[n2][i] * dArray2[i][n];
                }
            }
        }
        return dArray3;
    }

    private static double[] matvecMult(double[][] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = dArray2.length;
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                int n5 = n;
                dArray3[n5] = dArray3[n5] + dArray[n][i] * dArray2[i];
            }
        }
        return dArray3;
    }

    private void sausageJoinedIntersect(Sausage sausage, Sausage sausage2, RTree rTree, RTree rTree2, JGeometry jGeometry) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = sausage.startPoint.equals(sausage2.startPoint);
        boolean bl2 = sausage.startPoint.equals(sausage2.endPoint);
        boolean bl3 = sausage.endPoint.equals(sausage2.startPoint);
        boolean bl4 = sausage.endPoint.equals(sausage2.endPoint);
        boolean bl5 = bl || bl2;
        boolean bl6 = bl3 || bl;
        Sausage sausage3 = null;
        Sausage sausage4 = null;
        JPoint2DD jPoint2DD = bl || bl2 ? sausage.startPoint : sausage.endPoint;
        double d = CompGeom.crossProduct((double)sausage.vx, (double)sausage.vy, (double)sausage2.vx, (double)sausage2.vy);
        int n5 = bl5 ? 0 : 2;
        int n6 = bl5 ? 3 : 1;
        int n7 = bl6 ? 0 : 2;
        int n8 = bl6 ? 3 : 1;
        double d2 = sausage2.skel[n8].x;
        double d3 = sausage.skel[n5].x;
        double d4 = sausage2.skel[n8].y;
        double d5 = sausage.skel[n5].y;
        if ((d2 - d3) * (d2 - d3) + (d4 - d5) * (d4 - d5) < 1.0E-4 * sausage.dist2) {
            ((ArcVertex)sausage.skel[n6]).blackout = true;
            ((ArcVertex)sausage2.skel[n8]).blackout = true;
            Sausage sausage5 = sausage;
            Sausage sausage6 = sausage2;
            for (int i = 0; i < 2; ++i) {
                int n9 = sausage5 == sausage ? n5 : n7;
                int n10 = sausage5 == sausage ? n8 : n6;
                double d6 = (sausage5.skel[n9].x + sausage6.skel[n10].x) / 2.0;
                double d7 = (sausage5.skel[n9].y + sausage6.skel[n10].y) / 2.0;
                if (this.insideSausagesOrPolys(d6, d7, sausage, sausage2, rTree, rTree2, jGeometry)) {
                    sausage5.skel[n9].isInside = true;
                    sausage6.skel[n10].isInside = true;
                } else {
                    sausage5.skel[n9].x = sausage6.skel[n10].x = d6;
                    sausage5.skel[n9].y = sausage6.skel[n10].y = d7;
                    sausage5.skel[n9].isIntersection = true;
                    sausage6.skel[n10].isIntersection = true;
                    sausage5.skel[n9].isInside = false;
                    sausage6.skel[n10].isInside = false;
                    sausage5.skel[n9].isStarterIntersection = true;
                    sausage5.skel[n9].matchIntersection = sausage6.skel[n10];
                    sausage6.skel[n10].matchIntersection = sausage5.skel[n9];
                }
                sausage5 = sausage2;
                sausage6 = sausage;
            }
            return;
        }
        if (d > 0.0) {
            if (bl || bl4) {
                sausage3 = sausage;
                sausage4 = sausage2;
                n4 = bl ? 0 : 2;
                n3 = bl ? 3 : 1;
                n2 = bl ? 0 : 2;
                n = bl ? 2 : 0;
            } else {
                sausage3 = sausage2;
                sausage4 = sausage;
                n4 = bl2 ? 2 : 0;
                n3 = bl2 ? 3 : 1;
                n2 = bl2 ? 0 : 2;
                n = n2;
            }
        } else if (bl || bl4) {
            sausage3 = sausage2;
            sausage4 = sausage;
            n4 = bl ? 0 : 2;
            n3 = bl ? 3 : 1;
            n2 = bl ? 0 : 2;
            n = bl ? 2 : 0;
        } else {
            sausage3 = sausage;
            sausage4 = sausage2;
            n4 = bl2 ? 0 : 2;
            n3 = bl2 ? 1 : 3;
            n2 = bl2 ? 2 : 0;
            n = n2;
        }
        int n11 = (n2 + 1) % 4;
        int n12 = (n + 3) % 4;
        int n13 = (n4 + 3) % 4;
        ((ArcVertex)sausage3.skel[n13]).blackout = true;
        sausage3.skel[n13].isInside = true;
        sausage4.skel[(n3 + 1) % 4].isInside = true;
        if (!this.insideSausagesOrPolys(sausage3.skel[n4].x, sausage3.skel[n4].y, sausage, sausage2, rTree, rTree2, jGeometry)) {
            Vertex vertex = this.insertVertex(sausage3.skel[n4].x, sausage3.skel[n4].y, sausage4.skel[n3]);
            vertex.isIntersection = true;
            vertex.isInside = false;
            vertex.matchIntersection = sausage3.skel[n4];
            sausage3.skel[n4].matchIntersection = vertex;
            sausage3.skel[n4].isIntersection = true;
            sausage3.skel[n4].isStarterIntersection = true;
            sausage3.skel[n4].isInside = false;
        }
    }

    private void sausageGeneralIntersect(Sausage sausage, Sausage sausage2, RTree rTree, RTree rTree2, JGeometry jGeometry) {
        Vertex vertex = null;
        ArcVertex arcVertex = null;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < 4; ++i) {
            Vertex vertex2 = sausage.skel[i];
            if (!bl2 || !((ArcVertex)vertex2).blackout) {
                Vertex vertex3 = sausage.skel[(i + 1) % 4];
                boolean bl3 = false;
                for (int j = 0; j < 4; ++j) {
                    Vertex vertex4 = sausage2.skel[j];
                    if (!bl3 || !((ArcVertex)vertex4).blackout) {
                        int n;
                        double d;
                        Vertex vertex5;
                        Vertex vertex6;
                        Vertex vertex7 = sausage2.skel[(j + 1) % 4];
                        if (!bl2 && !bl3) {
                            if (CompGeom.lineLineIntersect((double)vertex2.x, (double)vertex2.y, (double)vertex3.x, (double)vertex3.y, (double)vertex4.x, (double)vertex4.y, (double)vertex7.x, (double)vertex7.y, (double[])dArray) && !this.insideSausagesOrPolys(dArray[0], dArray[1], sausage, sausage2, rTree, rTree2, jGeometry)) {
                                vertex = vertex2;
                                while (vertex != vertex3 && !((dArray[0] - vertex.x) * (dArray[0] - vertex.x) + (dArray[1] - vertex.y) * (dArray[1] - vertex.y) < (vertex.next.x - vertex.x) * (vertex.next.x - vertex.x) + (vertex.next.y - vertex.y) * (vertex.next.y - vertex.y))) {
                                    vertex = vertex.next;
                                }
                                vertex6 = this.insertVertex(dArray[0], dArray[1], vertex);
                                vertex = vertex4;
                                while (vertex != vertex7 && !((dArray[0] - vertex.x) * (dArray[0] - vertex.x) + (dArray[1] - vertex.y) * (dArray[1] - vertex.y) < (vertex.next.x - vertex.x) * (vertex.next.x - vertex.x) + (vertex.next.y - vertex.y) * (vertex.next.y - vertex.y))) {
                                    vertex = vertex.next;
                                }
                                vertex5 = this.insertVertex(dArray[0], dArray[1], vertex);
                                vertex6.isIntersection = true;
                                vertex5.isIntersection = true;
                                vertex6.matchIntersection = vertex5;
                                vertex5.matchIntersection = vertex6;
                                d = CompGeom.crossProduct((double)(vertex3.x - vertex2.x), (double)(vertex3.y - vertex2.y), (double)(vertex7.x - vertex4.x), (double)(vertex7.y - vertex4.y));
                                vertex = d > 0.0 ? vertex6 : vertex5;
                                vertex.isStarterIntersection = true;
                                vertex = null;
                            }
                        } else if (bl2 && bl3) {
                            n = CompGeom.arcArcIntersect((double)vertex2.x, (double)vertex2.y, (double)vertex3.x, (double)vertex3.y, (double)((ArcVertex)vertex2).center.x, (double)((ArcVertex)vertex2).center.y, (double)sausage.dist, (double)vertex4.x, (double)vertex4.y, (double)vertex7.x, (double)vertex7.y, (double)((ArcVertex)vertex4).center.x, (double)((ArcVertex)vertex4).center.y, (double)sausage.dist, (double[])dArray, (double[])dArray2);
                            if (n != 0) {
                                if (Math.abs(n) == 2 && !this.insideSausagesOrPolys(dArray2[0], dArray2[1], sausage, sausage2, rTree, rTree2, jGeometry)) {
                                    vertex = vertex2;
                                    while (vertex != vertex3) {
                                        arcVertex = (ArcVertex)vertex;
                                        if (CompGeom.inSector((double)dArray2[0], (double)dArray2[1], (double)arcVertex.next.x, (double)arcVertex.next.y, (double)arcVertex.center.x, (double)arcVertex.center.y, (double)arcVertex.x, (double)arcVertex.y)) break;
                                        vertex = vertex.next;
                                    }
                                    vertex6 = this.insertVertex(dArray2[0], dArray2[1], arcVertex);
                                    vertex = vertex4;
                                    while (vertex != vertex7) {
                                        arcVertex = (ArcVertex)vertex;
                                        if (CompGeom.inSector((double)dArray2[0], (double)dArray2[1], (double)arcVertex.next.x, (double)arcVertex.next.y, (double)arcVertex.center.x, (double)arcVertex.center.y, (double)arcVertex.x, (double)arcVertex.y)) break;
                                        vertex = vertex.next;
                                    }
                                    vertex5 = this.insertVertex(dArray2[0], dArray2[1], arcVertex);
                                    vertex6.isIntersection = true;
                                    vertex5.isIntersection = true;
                                    vertex6.matchIntersection = vertex5;
                                    vertex5.matchIntersection = vertex6;
                                    vertex6.isStarterIntersection = true;
                                }
                                if (n != -1 && !this.insideSausagesOrPolys(dArray[0], dArray[1], sausage, sausage2, rTree, rTree2, jGeometry)) {
                                    vertex = vertex2;
                                    while (vertex != vertex3) {
                                        arcVertex = (ArcVertex)vertex;
                                        if (CompGeom.inSector((double)dArray[0], (double)dArray[1], (double)arcVertex.next.x, (double)arcVertex.next.y, (double)arcVertex.center.x, (double)arcVertex.center.y, (double)arcVertex.x, (double)arcVertex.y)) break;
                                        vertex = vertex.next;
                                    }
                                    vertex6 = this.insertVertex(dArray[0], dArray[1], arcVertex);
                                    vertex = vertex4;
                                    while (vertex != vertex7) {
                                        arcVertex = (ArcVertex)vertex;
                                        if (CompGeom.inSector((double)dArray[0], (double)dArray[1], (double)arcVertex.next.x, (double)arcVertex.next.y, (double)arcVertex.center.x, (double)arcVertex.center.y, (double)arcVertex.x, (double)arcVertex.y)) break;
                                        vertex = vertex.next;
                                    }
                                    vertex5 = this.insertVertex(dArray[0], dArray[1], arcVertex);
                                    vertex6.isIntersection = true;
                                    vertex5.isIntersection = true;
                                    vertex6.matchIntersection = vertex5;
                                    vertex5.matchIntersection = vertex6;
                                    if (n != 1) {
                                        vertex5.isStarterIntersection = true;
                                    } else {
                                        d = CompGeom.crossProduct((double)(dArray[0] - ((ArcVertex)vertex2).center.x), (double)(dArray[1] - ((ArcVertex)vertex2).center.y), (double)(dArray[0] - ((ArcVertex)vertex4).center.x), (double)(dArray[1] - ((ArcVertex)vertex4).center.y));
                                        vertex = d > 0.0 ? vertex6 : vertex5;
                                        vertex.isStarterIntersection = true;
                                        vertex = null;
                                    }
                                }
                            }
                        } else {
                            Vertex vertex8;
                            Vertex vertex9 = bl2 ? vertex4 : vertex2;
                            Vertex vertex10 = bl2 ? vertex7 : vertex3;
                            Vertex vertex11 = bl2 ? vertex2 : vertex4;
                            Vertex vertex12 = vertex8 = bl2 ? vertex3 : vertex7;
                            if (!(((ArcVertex)vertex9.prev).center.x == ((ArcVertex)vertex11).center.x && ((ArcVertex)vertex9.prev).center.y == ((ArcVertex)vertex11).center.y || ((ArcVertex)vertex10).center.x == ((ArcVertex)vertex11).center.x && ((ArcVertex)vertex10).center.y == ((ArcVertex)vertex11).center.y || (n = CompGeom.lineArcIntersect((double)vertex9.x, (double)vertex9.y, (double)vertex10.x, (double)vertex10.y, (double)vertex11.x, (double)vertex11.y, (double)vertex8.x, (double)vertex8.y, (double)((ArcVertex)vertex11).center.x, (double)((ArcVertex)vertex11).center.y, (double)sausage.dist, (double[])dArray, (double[])dArray2)) == 0)) {
                                if (Math.abs(n) == 2 && !this.insideSausagesOrPolys(dArray2[0], dArray2[1], sausage, sausage2, rTree, rTree2, jGeometry)) {
                                    vertex = vertex9;
                                    while (vertex != vertex10 && !((dArray2[0] - vertex.x) * (dArray2[0] - vertex.x) + (dArray2[1] - vertex.y) * (dArray2[1] - vertex.y) < (vertex.next.x - vertex.x) * (vertex.next.x - vertex.x) + (vertex.next.y - vertex.y) * (vertex.next.y - vertex.y))) {
                                        vertex = vertex.next;
                                    }
                                    vertex6 = this.insertVertex(dArray2[0], dArray2[1], vertex);
                                    vertex = vertex11;
                                    while (vertex != vertex8) {
                                        arcVertex = (ArcVertex)vertex;
                                        if (CompGeom.inSector((double)dArray2[0], (double)dArray2[1], (double)arcVertex.next.x, (double)arcVertex.next.y, (double)arcVertex.center.x, (double)arcVertex.center.y, (double)arcVertex.x, (double)arcVertex.y)) break;
                                        vertex = vertex.next;
                                    }
                                    vertex5 = this.insertVertex(dArray2[0], dArray2[1], arcVertex);
                                    vertex6.isIntersection = true;
                                    vertex5.isIntersection = true;
                                    vertex6.matchIntersection = vertex5;
                                    vertex5.matchIntersection = vertex6;
                                    vertex6.isStarterIntersection = true;
                                }
                                if (n != -1 && !this.insideSausagesOrPolys(dArray[0], dArray[1], sausage, sausage2, rTree, rTree2, jGeometry)) {
                                    vertex = vertex9;
                                    while (vertex != vertex10 && !((dArray[0] - vertex.x) * (dArray[0] - vertex.x) + (dArray[1] - vertex.y) * (dArray[1] - vertex.y) < (vertex.next.x - vertex.x) * (vertex.next.x - vertex.x) + (vertex.next.y - vertex.y) * (vertex.next.y - vertex.y))) {
                                        vertex = vertex.next;
                                    }
                                    vertex6 = this.insertVertex(dArray[0], dArray[1], vertex);
                                    vertex = vertex11;
                                    while (vertex != vertex8) {
                                        arcVertex = (ArcVertex)vertex;
                                        if (CompGeom.inSector((double)dArray[0], (double)dArray[1], (double)arcVertex.next.x, (double)arcVertex.next.y, (double)arcVertex.center.x, (double)arcVertex.center.y, (double)arcVertex.x, (double)arcVertex.y)) break;
                                        vertex = vertex.next;
                                    }
                                    vertex5 = this.insertVertex(dArray[0], dArray[1], arcVertex);
                                    vertex6.isIntersection = true;
                                    vertex5.isIntersection = true;
                                    vertex6.matchIntersection = vertex5;
                                    vertex5.matchIntersection = vertex6;
                                    if (n != 1) {
                                        vertex5.isStarterIntersection = true;
                                    } else if (CompGeom.dotProduct((double)(dArray[0] - ((ArcVertex)vertex11).center.x), (double)(dArray[1] - ((ArcVertex)vertex11).center.y), (double)(vertex10.x - vertex9.x), (double)(vertex10.y - vertex9.y)) > 0.0) {
                                        vertex6.isStarterIntersection = true;
                                    } else {
                                        vertex5.isStarterIntersection = true;
                                    }
                                }
                            }
                        }
                    }
                    bl3 = !bl3;
                }
            }
            bl2 = !bl2;
        }
    }

    void printSausages(ArrayList arrayList) {
        for (Sausage sausage : arrayList) {
            sausage.print();
        }
    }

    private Vertex insertVertex(double d, double d2, Vertex vertex) {
        Vertex vertex2 = vertex instanceof ArcVertex ? new ArcVertex(d, d2, ((ArcVertex)vertex).center.x, ((ArcVertex)vertex).center.y) : new Vertex(d, d2);
        vertex.next.prev = vertex2;
        vertex2.next = vertex.next;
        vertex2.prev = vertex;
        vertex.next = vertex2;
        return vertex2;
    }

    private boolean insideSausagesOrPolys(double d, double d2, Sausage sausage, Sausage sausage2, RTree rTree, RTree rTree2, JGeometry jGeometry) {
        double[][] dArray = new double[2][2];
        double d3 = d;
        dArray[0][1] = d3;
        dArray[0][0] = d3;
        double d4 = d2;
        dArray[1][1] = d4;
        dArray[1][0] = d4;
        ArrayList arrayList = new ArrayList(10);
        rTree2.search(dArray, arrayList);
        Iterator iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Sausage sausage3 = (Sausage)iterator.next();
            if (sausage3 == sausage || sausage3 == sausage2 || !sausage3.pointInside(d, d2, sausage, sausage2)) continue;
            bl = true;
            break;
        }
        if (!bl && rTree != null) {
            bl = false;
            arrayList.clear();
            rTree.search(dArray, arrayList);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                int n = (Integer)iterator2.next();
                if (jGeometry.ordinates[n] < d == jGeometry.ordinates[n + 2] < d || !(jGeometry.ordinates[n + 1] >= d2) && !(jGeometry.ordinates[n + 3] >= d2) || !(jGeometry.ordinates[n + 1] >= d2 && jGeometry.ordinates[n + 3] >= d2) && !(jGeometry.ordinates[n + 1] + (d - jGeometry.ordinates[n]) * (jGeometry.ordinates[n + 3] - jGeometry.ordinates[n + 1]) / (jGeometry.ordinates[n + 2] - jGeometry.ordinates[n]) >= d2)) continue;
                bl = !bl;
            }
        }
        return bl;
    }

    private void convertOrientedPointsFw(int[] nArray, double[] dArray) {
        for (int i = 0; i < nArray.length; i += 3) {
            int n;
            if (nArray[i + 1] != 1 || nArray[i + 2] != 0) continue;
            int n2 = nArray[i + 0];
            if (this.getSRID() == 8307) {
                for (n = 0; n < this.getDimensions(); ++n) {
                    int n3 = n2 + n;
                    dArray[n3] = dArray[n3] / 100000.0;
                }
            }
            for (n = 0; n < this.getDimensions(); ++n) {
                int n4 = n2 + n;
                dArray[n4] = dArray[n4] + dArray[n2 + n - 3];
            }
        }
    }

    private void convertOrientedPointsRv(int[] nArray, double[] dArray) {
        for (int i = 0; i < nArray.length; i += 3) {
            if (nArray[i + 1] != 1 || nArray[i + 2] != 0) continue;
            int n = nArray[i + 0];
            for (int j = 0; j < this.getDimensions(); ++j) {
                int n2 = n + j;
                dArray[n2] = dArray[n2] - dArray[n + j - 3];
            }
            double d = Math.sqrt(dArray[n + 0] * dArray[n + 0] + dArray[n + 1] * dArray[n + 1]);
            for (int j = 0; j < this.getDimensions(); ++j) {
                int n3 = n + j;
                dArray[n3] = dArray[n3] / d;
            }
        }
    }

    private double tfm_8307_to_PopularMercator_x(double d) {
        return 0.0 + 6378137.0 * (d - 0.0);
    }

    private double tfm_8307_to_PopularMercator_y(double d, boolean bl) {
        double d2 = bl ? MERCATOR_e54004 : MERCATOR_e3785;
        return 0.0 + 6378137.0 * Math.log(Math.tan(0.7853981633974483 + d / 2.0) * Math.pow((1.0 - d2 * Math.sin(d)) / (1.0 + d2 * Math.sin(d)), d2 / 2.0));
    }

    public void tfm_8307_to_PopularMercator(int[] nArray, double[] dArray, boolean bl) {
        if (nArray != null) {
            this.convertOrientedPointsFw(nArray, dArray);
        }
        if (dArray != null) {
            for (int i = 0; i < dArray.length; i += this.getDimensions()) {
                dArray[i + 0] = this.tfm_8307_to_PopularMercator_x(dArray[i + 0] * Math.PI / 180.0);
                dArray[i + 1] = this.tfm_8307_to_PopularMercator_y(dArray[i + 1] * Math.PI / 180.0, bl);
            }
        }
        if (nArray != null) {
            this.convertOrientedPointsRv(nArray, dArray);
        }
    }

    public void tfm_8307_to_PopularMercator(boolean bl) {
        if (this.getSRID() != 8307) {
            throw new RuntimeException("Source geometry must be SRID 8307, when transforming to 3785/54004.");
        }
        if (this.hasCircularArcs()) {
            throw new RuntimeException("Circular Arcs not allowed in 8307.");
        }
        double[] dArray = this.getPoint();
        this.tfm_8307_to_PopularMercator(null, dArray, bl);
        this.x = dArray[0];
        this.y = dArray[1];
        this.tfm_8307_to_PopularMercator(this.getElemInfo(), this.getOrdinatesArray(), bl);
        this.setSRID(bl ? 54004 : 3785);
    }

    private double tfm_PopularMercator_to_8307_lon(double d) {
        return (d - 0.0) / 6378137.0 + 0.0;
    }

    private double tfm_PopularMercator_to_8307_lat(double d, boolean bl) {
        double d2 = bl ? MERCATOR_e54004 : MERCATOR_e3785;
        return d + (d2 * d2 / 2.0 + Math.pow(d2, 6.0) / 12.0 + 5.0 * Math.pow(d2, 4.0) / 24.0 + 13.0 * Math.pow(d2, 8.0) / 360.0) * Math.sin(2.0 * d) + (7.0 * Math.pow(d2, 4.0) / 48.0 + 29.0 * Math.pow(d2, 6.0) / 240.0 + 811.0 * Math.pow(d2, 8.0) / 11520.0) * Math.sin(4.0 * d) + (7.0 * Math.pow(d2, 6.0) / 120.0 + 81.0 * Math.pow(d2, 8.0) / 1120.0) * Math.sin(6.0 * d) + 4279.0 * Math.pow(d2, 8.0) / 161280.0 * Math.sin(8.0 * d);
    }

    public void tfm_PopularMercator_to_8307(int[] nArray, double[] dArray, boolean bl) {
        if (nArray != null) {
            this.convertOrientedPointsFw(nArray, dArray);
        }
        if (dArray != null) {
            for (int i = 0; i < dArray.length; i += this.getDimensions()) {
                double d = dArray[i + 0];
                double d2 = dArray[i + 1];
                double d3 = Math.pow(MERCATOR_B, (0.0 - d2) / 6378137.0);
                double d4 = 1.5707963267948966 - 2.0 * Math.atan2(d3, 1.0);
                dArray[i + 1] = this.tfm_PopularMercator_to_8307_lat(d4, bl) * 180.0 / Math.PI;
                dArray[i + 0] = this.tfm_PopularMercator_to_8307_lon(d) * 180.0 / Math.PI;
            }
        }
        if (nArray != null) {
            this.convertOrientedPointsRv(nArray, dArray);
        }
    }

    public void tfm_PopularMercator_to_8307(boolean bl) {
        if (this.getSRID() != (bl ? 54004 : 3785)) {
            throw new RuntimeException("Source geometry must be SRID 3785/54004, when transforming to 8307.");
        }
        if (this.hasCircularArcs()) {
            throw new RuntimeException("Circular Arcs not allowed in 8307.");
        }
        double[] dArray = this.getPoint();
        this.tfm_PopularMercator_to_8307(null, dArray, bl);
        this.x = dArray[0];
        this.y = dArray[1];
        this.tfm_PopularMercator_to_8307(this.getElemInfo(), this.getOrdinatesArray(), bl);
        this.setSRID(8307);
    }

    private class Ring {
        Vertex startVertex;
        int numVertices;
        int numArcs;
        int numSubElements;
        ArrayList holeList = new ArrayList();

        Ring(Vertex vertex) {
            this.startVertex = vertex;
        }

        boolean pointInside(double d, double d2) {
            boolean bl = false;
            Vertex vertex = this.startVertex;
            do {
                if (vertex.x < d == vertex.next.x < d || !(vertex.y >= d2) && !(vertex.next.y >= d2) || !(vertex.y >= d2 && vertex.next.y >= d2) && !(vertex.y + (d - vertex.x) * (vertex.next.y - vertex.y) / (vertex.next.x - vertex.x) >= d2)) continue;
                boolean bl2 = bl = !bl;
            } while ((vertex = vertex.next) != this.startVertex);
            return bl;
        }

        void addHole(Ring ring) {
            this.holeList.add(ring);
        }
    }

    private class ArcVertex
    extends Vertex {
        JPoint2DD center;
        boolean blackout;

        ArcVertex(double d, double d2, double d3, double d4) {
            super(d, d2);
            this.center = new JPoint2DD(d3, d4);
        }
    }

    private class Vertex {
        public double x;
        public double y;
        boolean isInside = false;
        boolean isIntersection = false;
        boolean isStarterIntersection = false;
        boolean isUsed = false;
        Vertex matchIntersection = null;
        Vertex prev = null;
        Vertex next = null;

        Vertex(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        void print() {
            System.out.print(this.toString());
            if (!(this instanceof ArcVertex)) {
                System.out.print("   ");
            }
            System.out.print(" x " + this.x + " y " + this.y + " inside " + (this.isInside ? (char)'t' : 'f') + " intscn " + (this.isIntersection ? (char)'t' : 'f') + " starter " + (this.isStarterIntersection ? (char)'t' : 'f') + " used " + (this.isUsed ? (char)'t' : 'f'));
            if (this instanceof ArcVertex) {
                System.out.print(" blackout " + (((ArcVertex)this).blackout ? (char)'t' : 'f'));
            }
            System.out.println();
            if (!this.isStarterIntersection && this.isIntersection) {
                System.out.println("match " + this.matchIntersection.toString());
            }
        }
    }

    private class Sausage {
        int id;
        public JPoint2DD startPoint;
        public JPoint2DD endPoint;
        double vx;
        double vy;
        double magv;
        double magv2;
        public double dist;
        double dist2;
        double[][] mbr;
        public Vertex[] skel = new Vertex[4];

        void print() {
            System.out.println("Sausage id " + this.id + "  start " + this.startPoint + " end " + this.endPoint);
            Vertex vertex = this.skel[0];
            do {
                vertex.print();
            } while ((vertex = vertex.next) != this.skel[0]);
            System.out.println();
        }

        public Sausage(int n, double d, double d2, double d3, double d4, double d5) {
            Vertex vertex;
            double d6;
            double d7;
            this.startPoint = new JPoint2DD(d, d2);
            this.endPoint = new JPoint2DD(d3, d4);
            this.dist = d5;
            this.dist2 = d5 * d5;
            this.id = n;
            this.mbr = new double[2][2];
            this.mbr[0][0] = Math.min(d, d3) - d5;
            this.mbr[0][1] = Math.max(d, d3) + d5;
            this.mbr[1][0] = Math.min(d2, d4) - d5;
            this.mbr[1][1] = Math.max(d2, d4) + d5;
            this.vx = this.endPoint.x - this.startPoint.x;
            this.vy = this.endPoint.y - this.startPoint.y;
            this.magv2 = this.vx * this.vx + this.vy * this.vy;
            this.magv = Math.sqrt(this.magv2);
            if (this.vx == 0.0) {
                d7 = 0.0;
                d6 = d5;
            } else if (this.vy == 0.0) {
                d6 = 0.0;
                d7 = d5;
            } else {
                double d8 = this.vy / this.vx;
                d7 = d5 / Math.sqrt(1.0 + d8 * d8);
                d6 = -d8 * d7;
            }
            if (CompGeom.crossProduct((double)d6, (double)d7, (double)this.vx, (double)this.vy) < 0.0) {
                d6 = -d6;
                d7 = -d7;
            }
            this.skel[0] = vertex = new Vertex(this.startPoint.x + d6, this.startPoint.y + d7);
            ArcVertex arcVertex = new ArcVertex(this.endPoint.x + d6, this.endPoint.y + d7, this.endPoint.x, this.endPoint.y);
            this.skel[1] = arcVertex;
            vertex.next = arcVertex;
            arcVertex.prev = vertex;
            this.skel[2] = vertex = new Vertex(this.endPoint.x - d6, this.endPoint.y - d7);
            arcVertex.next = vertex;
            vertex.prev = arcVertex;
            arcVertex = new ArcVertex(this.startPoint.x - d6, this.startPoint.y - d7, this.startPoint.x, this.startPoint.y);
            this.skel[3] = arcVertex;
            vertex.next = arcVertex;
            arcVertex.prev = vertex;
            arcVertex.next = this.skel[0];
            this.skel[0].prev = arcVertex;
        }

        boolean pointInside(double d, double d2, Sausage sausage) {
            return this.pointInside(d, d2, sausage, null);
        }

        boolean pointInside(double d, double d2) {
            return this.pointInside(d, d2, null, null);
        }

        boolean pointInside(double d, double d2, Sausage sausage, Sausage sausage2) {
            double d3;
            double d4 = 0.99999999999999 * this.dist2;
            double d5 = d - this.startPoint.x;
            double d6 = d2 - this.startPoint.y;
            double d7 = d - this.endPoint.x;
            double d8 = d2 - this.endPoint.y;
            boolean bl = false;
            boolean bl2 = false;
            if (sausage != null) {
                if (sausage.startPoint.equals(this.startPoint) || sausage.endPoint.equals(this.startPoint)) {
                    bl = true;
                } else if (sausage.startPoint.equals(this.endPoint) || sausage.endPoint.equals(this.endPoint)) {
                    bl2 = true;
                }
            }
            if (sausage2 != null) {
                if (sausage2.startPoint.equals(this.startPoint) || sausage2.endPoint.equals(this.startPoint)) {
                    bl = true;
                } else if (sausage2.startPoint.equals(this.endPoint) || sausage2.endPoint.equals(this.endPoint)) {
                    bl2 = true;
                }
            }
            if (!bl && d5 * d5 + d6 * d6 < d4) {
                return true;
            }
            if (!bl2 && d7 * d7 + d8 * d8 < d4) {
                return true;
            }
            return d5 * this.vx + d6 * this.vy > 0.0 && d7 * this.vx + d8 * this.vy < 0.0 && (d3 = CompGeom.crossProduct((double)d5, (double)d6, (double)this.vx, (double)this.vy)) * d3 / this.magv2 < d4;
        }
    }

    protected static class ElementIterator {
        public int ei = 0;
        public int nextei = 0;
        public int dim = 2;
        public int gtype = 0;
        public int[] elemInfo = null;
        public double[] ordinates = null;
        public int ord_offset = 0;
        public int etype = 0;
        public int original_etype = 0;
        public int top_etype = 0;
        public int eitpr = 0;
        public int next_ord_offset = 0;
        public int nCoord = 0;
        public int nSubElement = 0;
        public boolean lastElem = false;
        public boolean isFirstElemOfCompound = false;
        public boolean isCompound = false;
        public boolean isOrientedPoint = false;
        public int orient_offset = 2;

        public ElementIterator(JGeometry jGeometry) {
            this.gtype = jGeometry.gtype;
            this.elemInfo = jGeometry.elemInfo;
            this.ordinates = jGeometry.ordinates;
            if (jGeometry.dim > 0) {
                this.dim = jGeometry.dim;
            }
            if (jGeometry.isOrientedPoint() || jGeometry.isOrientedMultiPoint()) {
                this.isOrientedPoint = true;
                if (jGeometry.isOrientedMultiPoint()) {
                    this.orient_offset = jGeometry.getOrientMultiPointOffset();
                }
            }
        }

        public boolean next() {
            if (this.elemInfo == null) {
                return false;
            }
            if (this.isFirstElemOfCompound && this.nSubElement > 0) {
                this.isFirstElemOfCompound = false;
            }
            if (this.nSubElement > 0) {
                --this.nSubElement;
            }
            if (this.nSubElement == 0) {
                this.isCompound = false;
            }
            while (true) {
                if (this.ei > this.elemInfo.length - 3 || this.ei == 3 && this.isOrientedPoint) {
                    return false;
                }
                this.etype = this.elemInfo[this.ei + 1] % 10;
                this.original_etype = this.elemInfo[this.ei + 1];
                if (!this.isCompound) {
                    this.top_etype = this.etype;
                }
                this.eitpr = this.etype == 1 ? 1 : this.elemInfo[this.ei + 2];
                if (this.etype != 0) break;
                this.ei += 3;
            }
            if (this.etype >= 4) {
                this.isFirstElemOfCompound = true;
                this.isCompound = true;
                this.nSubElement = this.eitpr;
                this.ei += 3;
                this.etype = this.elemInfo[this.ei + 1] % 10;
                this.eitpr = this.elemInfo[this.ei + 2];
            }
            this.nextei = this.ei + 3;
            this.ord_offset = this.elemInfo[this.ei] - 1;
            this.etype = this.elemInfo[this.ei + 1];
            this.eitpr = this.etype == 1 ? 1 : this.elemInfo[this.ei + 2];
            boolean bl = this.lastElem = this.nextei > this.elemInfo.length - 3 || this.nextei == 3 && this.isOrientedPoint;
            if (this.isOrientedPoint) {
                this.nCoord = this.ordinates.length / (this.dim + this.orient_offset);
            } else {
                this.next_ord_offset = this.lastElem ? this.ordinates.length : this.elemInfo[this.nextei] - 1;
                this.nCoord = (this.next_ord_offset - this.ord_offset) / this.dim;
            }
            if (this.nSubElement > 1) {
                ++this.nCoord;
            }
            this.ei += 3;
            return true;
        }
    }

    public static class Point {
        double x;
        double y;
        double z;
        double m;

        public Point() {
            this.x = 0.0;
            this.y = 0.0;
        }

        public Point(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public final boolean equals(Point point) {
            return this.x == point.x && this.y == point.y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void set(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }

    private class LT_transform {
        double ne;
        double xc;
        double yc;
        double zc;
        double[] xrow;
        double[] yrow;
        double[] zrow;

        public LT_transform(double d, double d2, Gc_trans gc_trans) {
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            double d5 = Math.cos(d);
            double d6 = Math.sin(d);
            this.ne = gc_trans.smax / Math.sqrt(1.0 - gc_trans.esq * d4 * d4);
            this.xc = d3 * d5 * this.ne;
            this.yc = d3 * d6 * this.ne;
            this.zc = d4 * (1.0 - gc_trans.esq) * this.ne;
            this.xrow = new double[3];
            this.yrow = new double[3];
            this.zrow = new double[3];
            this.xrow[0] = -d6;
            this.xrow[1] = d5;
            this.xrow[2] = 0.0;
            this.yrow[0] = -d5 * d4;
            this.yrow[1] = -d6 * d4;
            this.yrow[2] = d3;
            this.zrow[0] = d3 * d5;
            this.zrow[1] = d3 * d6;
            this.zrow[2] = d4;
        }
    }

    private class Gc_trans {
        double smax;
        double smin;
        double flat;
        double esq;
        double e;
        double t;
        double radius;
        double area;
        double unitfactor;
        int txsrid;

        public Gc_trans(double d, double d2) {
            this.txsrid = JGeometry.this.srid;
            this.smax = d;
            this.flat = d2;
            this.smin = this.smax * (1.0 - this.flat);
            this.esq = this.flat * (-this.flat + 2.0);
            this.e = Math.sqrt(this.esq);
            this.radius = this.e < 1.0E-8 ? this.smax * (1.0 - this.e / 4.0) : this.smax * Math.sqrt((2.0 * this.e + (1.0 - this.esq) * (Math.log(1.0 + this.e) - Math.log(1.0 - this.e))) / (4.0 * this.e));
            this.t = Math.sqrt(1.0 - this.esq);
            this.unitfactor = Math.PI / 180;
            this.area = Math.PI * 4 * this.radius * this.radius;
        }
    }
}

